/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.Dialogs.EditListItemDialog;
import edu.cmu.pact.Utilities.ComponentDescription;
import edu.cmu.pact.Utilities.StringTokenizerItemValues;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.UniversalToolProxy;
import pact.CommWidgets.event.StudentActionEvent;

public class JCommComboBox
extends JCommWidget
implements ActionListener,
MouseListener {
    protected JComboBox comboBox = new JComboBox();
    protected String previousValue = "";
    protected String resetValue = "";
    protected String values = "";
    protected String initialValues = "";
    protected Vector comboBoxStrings;
    protected Vector comboBoxStringColors;
    protected int sizeOfComboBoxStrings;
    protected Font startFont;
    protected JPanel container;
    protected boolean actionFromBR;
    protected Color currentColor;
    protected boolean locked;
    protected boolean setValuesDone = true;
    protected boolean isFirstCallSetValues = true;
    protected int maxRowItemsView = 40;

    public JCommComboBox() {
        this.comboBox.setMaximumRowCount(this.maxRowItemsView);
        this.add(this.comboBox);
        GridLayout g = new GridLayout(1, 1);
        this.setLayout(g);
        this.actionName = "UpdateComboBox";
        this.comboBox.addActionListener(this);
        this.addMouseListener(this);
        this.backgroundNormalColor = this.comboBox.getBackground();
        this.actionFromBR = false;
        this.locked = false;
        this.comboBox.addFocusListener(this);
        this.comboBox.setEditable(true);
        this.currentColor = this.startColor;
        this.comboBoxStrings = new Vector();
        this.comboBoxStringColors = new Vector();
        this.sizeOfComboBoxStrings = 0;
        this.originalBorder = this.comboBox.getBorder();
    }

    @Override
    public void highlight(String subElement, Border highlightBorder) {
        this.comboBox.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.comboBox.setBorder(this.originalBorder);
    }

    public void setMaxRowItemsView(int maxRowItemsView) {
        this.maxRowItemsView = maxRowItemsView;
        if (this.comboBox != null) {
            this.comboBox.setMaximumRowCount(maxRowItemsView);
        }
    }

    public int getMaxRowItemsView() {
        return this.maxRowItemsView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "JCommComboBox.actionPerformed(" + e + ") actionFromBR " + this.actionFromBR + ", locked " + this.locked + ", initialized " + this.initialized);
        }
        this.removeHighlight(this.commName);
        String selectedItem = (String)this.comboBox.getSelectedItem();
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "JCComboBox.actionPerformed(" + e.paramString() + "): ctlr.isDefiningStartState() " + this.getController().isDefiningStartState());
        }
        if (this.setValuesDone && this.getController().isDefiningStartState()) {
            this.addItem(selectedItem);
            this.previousValue = selectedItem;
            return;
        }
        if (this.actionFromBR) {
            return;
        }
        if (this.locked) {
            this.comboBox.setSelectedItem(this.previousValue);
            return;
        }
        if (this.initialized) {
            this.dirty = true;
            this.previousValue = selectedItem;
            if (!e.getActionCommand().equalsIgnoreCase("don't send")) {
                this.sendValue();
            }
            this.comboBox.setActionCommand("send");
        }
    }

    void addItem(String addedItem) {
        if (addedItem == null) {
            return;
        }
        if (addedItem.equals(this.resetValue)) {
            return;
        }
        if (this.testInValues(addedItem)) {
            return;
        }
        this.comboBox.addItem(addedItem);
        this.comboBoxStrings.addElement(addedItem);
        this.comboBoxStringColors.addElement(this.startColor);
        ++this.sizeOfComboBoxStrings;
        if (this.values.equals(this.resetValue)) {
            this.values = addedItem;
        } else {
            this.values = this.values + "," + addedItem;
            this.comboBox.setSelectedIndex(0);
        }
    }

    boolean testInValues(String testString) {
        if (this.values.equals(this.resetValue)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(this.values, ",");
        while (st.hasMoreElements()) {
            String tempItem = (String)st.nextElement();
            if (!testString.equals(tempItem = tempItem.trim())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setEditable(boolean setFlag) {
        this.comboBox.setEditable(setFlag);
    }

    public void setInitialValues() {
        this.setValues(this.initialValues);
    }

    public void setValues(String values) {
        if (this.isFirstCallSetValues) {
            this.initialValues = values;
            this.isFirstCallSetValues = false;
        }
        this.setValuesDone = false;
        this.comboBox.removeActionListener(this);
        this.values = values;
        if (this.comboBox.getItemCount() != 0) {
            this.comboBox.removeAllItems();
        }
        this.comboBoxStrings = new Vector();
        this.comboBoxStringColors = new Vector();
        this.sizeOfComboBoxStrings = 0;
        StringTokenizerItemValues st = new StringTokenizerItemValues(values, ',', '/');
        while (st.hasMoreElements()) {
            String tempItem = (String)st.nextElement();
            if ((tempItem = tempItem.trim()).equals("")) continue;
            this.comboBox.addItem(tempItem);
            this.comboBoxStrings.addElement(tempItem);
            this.comboBoxStringColors.addElement(this.startColor);
            ++this.sizeOfComboBoxStrings;
        }
        this.setValuesDone = true;
        this.comboBox.addActionListener(this);
    }

    @Override
    public void setFont(Font f) {
        this.startFont = f != null ? f : super.getFont();
        super.setFont(this.startFont);
        if (this.comboBox != null) {
            this.comboBox.setFont(this.startFont);
        }
    }

    @Override
    public MessageObject getDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        if (!this.initialize(this.getController())) {
            trace.out("ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        mo.setProperty("WidgetType", "JCommComboBox");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        Vector v = new Vector();
        int size = this.comboBox.getItemCount();
        for (int i = 0; i < size; ++i) {
            v.addElement(this.comboBox.getItemAt(i));
        }
        if (v.size() > 0) {
            mo.setProperty("ComboBoxItems", v);
        }
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate comboBox (slot name) (slot value) (multislot values))";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String valuesStr = "";
        int size = this.comboBox.getItemCount();
        for (int i = 0; i < size; ++i) {
            valuesStr = valuesStr + " \"" + this.comboBox.getItemAt(i) + "\"";
        }
        String instanceStr = "(assert (comboBox (name " + this.commName + ") (values " + valuesStr + ")))";
        instances.add(instanceStr);
        return instances;
    }

    public String getValues() {
        return this.values;
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            this.actionFromBR = true;
            this.previousValue = input;
            if (this.getController().getUniversalToolProxy().lockWidget()) {
                this.locked = true;
            }
            this.currentColor = this.correctColor;
            this.comboBox.setForeground(this.correctColor);
            this.comboBox.repaint();
            this.comboBox.setSelectedItem(input);
            this.moveFocus();
            this.actionFromBR = false;
            this.fireStudentAction(new StudentActionEvent(this));
        }
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        this.actionFromBR = true;
        this.previousValue = input;
        if (this.getController().getUniversalToolProxy().lockWidget()) {
            this.locked = true;
        }
        this.comboBox.setSelectedItem(input);
        this.moveFocus();
        this.comboBox.repaint();
        this.actionFromBR = false;
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        this.actionFromBR = true;
        this.previousValue = input;
        this.locked = false;
        this.currentColor = this.incorrectColor;
        this.comboBox.setForeground(this.incorrectColor);
        this.comboBox.repaint();
        this.comboBox.setSelectedItem(input);
        this.moveFocus();
        this.actionFromBR = false;
    }

    @Override
    public void doInterfaceDescription(MessageObject messageObject) {
        ComponentDescription cd = new ComponentDescription(this);
        cd.executeGraphicalProperties(messageObject);
        Object items = messageObject.getProperty("ComboBoxItems");
        if (items instanceof String) {
            this.setEditable(false);
            return;
        }
        Vector comboBoxItems = (Vector)items;
        if (comboBoxItems != null && comboBoxItems.size() > 0) {
            String resetValues = (String)comboBoxItems.elementAt(0);
            for (int i = 1; i < comboBoxItems.size(); ++i) {
                resetValues = resetValues + "," + Utils.cleanup((String)comboBoxItems.elementAt(i));
            }
            this.setValues(resetValues);
        }
        this.setEditable(false);
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        if (action.equalsIgnoreCase("UpdateInVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
            return;
        }
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
            return;
        }
        this.actionFromBR = true;
        this.previousValue = input;
        this.locked = false;
        this.currentColor = this.startColor;
        this.comboBox.setForeground(this.startColor);
        this.comboBox.setSelectedItem(input);
        this.moveFocus();
        this.comboBox.repaint();
        if (this.getController().isStartStateInterface()) {
            this.locked = true;
        }
        this.actionFromBR = false;
    }

    public void setProperty(MessageObject o) {
    }

    @Override
    public Object getValue() {
        if (this.getActionName().equalsIgnoreCase("SetVisible")) {
            return this.isVisible();
        }
        return this.previousValue;
    }

    public String getText() {
        return "";
    }

    public void setText(String text) {
    }

    @Override
    public boolean isChangedFromResetState() {
        if (this.comboBox.getSelectedIndex() == 0) {
            return false;
        }
        this.locked = true;
        return true;
    }

    @Override
    public void reset(TutorController controller) {
        this.initialize(controller);
        for (int i = 0; i < this.sizeOfComboBoxStrings; ++i) {
            this.comboBoxStringColors.setElementAt(this.startColor, i);
        }
        this.comboBox.removeActionListener(this);
        if (this.comboBox.getItemCount() > 0) {
            this.comboBox.setSelectedIndex(0);
            this.previousValue = "";
        }
        this.actionFromBR = false;
        this.locked = false;
        this.currentColor = this.startColor;
        this.comboBox.setForeground(this.startColor);
        this.comboBox.addActionListener(this);
    }

    @Override
    public void moveFocus() {
        this.comboBox.transferFocus();
    }

    @Override
    public void setBackground(Color c) {
        if (this.comboBox != null) {
            this.comboBox.setBackground(c);
        }
    }

    @Override
    public void setToolTipText(String text) {
        if (this.comboBox != null) {
            this.comboBox.setToolTipText(text);
        }
    }

    @Override
    public String getToolTipText() {
        return this.comboBox.getToolTipText();
    }

    @Override
    public void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        if (this.comboBox != null) {
            this.comboBox.addFocusListener(l);
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        if (this.comboBox != null) {
            this.comboBox.addMouseListener(l);
            this.comboBox.getComponent(0).addMouseListener(l);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "Enter ModifyListsListener for " + this.getCommName() + " mousePressed " + e.getSource() + ", " + e.paramString());
        }
        if (e.isControlDown() && this.getController().isDefiningStartState()) {
            int i;
            this.setValuesDone = false;
            JFrame frame = new JFrame("Modify List Items");
            String[] items = new String[this.comboBox.getItemCount()];
            for (int i2 = 0; i2 < this.comboBox.getItemCount(); ++i2) {
                items[i2] = (String)this.comboBox.getItemAt(i2);
                if (!trace.getDebugCode("dw")) continue;
                trace.out("dw", "items[" + i2 + "] =" + items[i2]);
            }
            String title = "Please set the Values for widget " + this.commName + " : ";
            EditListItemDialog t = new EditListItemDialog(frame, title, true, items, this.isInvisible());
            this.values = "";
            for (i = 0; i < t.getList().getModel().getSize(); ++i) {
                String tempItem = (String)t.getList().getModel().getElementAt(i);
                if ((tempItem = tempItem.trim()).equals("")) continue;
                this.values = this.values.equals(this.resetValue) ? tempItem : this.values + "," + tempItem;
            }
            this.setValues(this.values);
            for (i = 0; i < this.comboBox.getItemCount(); ++i) {
                if (!trace.getDebugCode("dw")) continue;
                trace.out("dw", "AfterModified --- comboBox[" + i + "] =" + this.comboBox.getItemAt(i));
            }
            this.comboBox.setEditable(false);
            this.setValuesDone = true;
            if (this.isInvisible() != t.isInvisible()) {
                this.setInvisible(t.isInvisible());
                this.setVisible(!this.isInvisible());
            }
            if (this.getUniversalToolProxy() instanceof UniversalToolProxy) {
                UniversalToolProxy utp = (UniversalToolProxy)this.getUniversalToolProxy();
                utp.chooseSISettingsInStartState(this.getDescriptionMessage(), utp.getController().getProblemModel());
            }
            this.setActionName("UpdateComboBox");
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.getController().isDefiningStartState()) {
            this.comboBox.setEditable(true);
        } else {
            this.comboBox.setEditable(false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public Vector getCurrentState() {
        System.err.println("JCommComboBox getCurrentState");
        Vector<MessageObject> v = new Vector<MessageObject>();
        if (this.isInvisible()) {
            this.setActionName("SetVisible");
            v.addElement(this.getCurrentStateMessage());
        }
        return v;
    }
}

