/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.Dialogs.EditLabelNameDialog;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import pact.CommWidgets.JCommPicture;
import pact.CommWidgets.JCommWidget;

public class JCommLabel
extends JCommWidget {
    protected JLabel label;
    protected int labelsCreated;
    protected String imageName;

    public JCommLabel() {
        this.setLayout(new GridLayout(1, 1));
        this.label = new JLabel("JCommLabel");
        this.add(this.label);
        this.addMouseListener(this);
        this.setActionName("UpdateText");
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (this.label != null) {
            this.label.addMouseListener(l);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
        if (this.label != null) {
            this.label.addMouseMotionListener(l);
        }
    }

    @Override
    public MouseListener[] getMouseListeners() {
        if (this.label != null) {
            return this.label.getMouseListeners();
        }
        return null;
    }

    @Override
    public MouseMotionListener[] getMouseMotionListeners() {
        if (this.label != null) {
            return this.label.getMouseMotionListeners();
        }
        return null;
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener l) {
        if (this.label != null) {
            this.label.removeMouseMotionListener(l);
        }
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        if (this.label != null) {
            this.label.removeMouseListener(l);
        }
    }

    @Override
    public MessageObject getDescriptionMessage() {
        if (!this.initialize(this.getController())) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        mo.setProperty("WidgetType", "JCommLabel");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate label (slot name) (slot value))";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String instanceStr = "(assert (label (name " + this.commName + ")))";
        instances.add(instanceStr);
        return instances;
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        if (action.equalsIgnoreCase("UpdateIcon")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Load icon: " + input);
            }
            this.setImageName(input);
        } else if (action.equalsIgnoreCase("UpdateText")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "UpdateText: " + input);
            }
            this.setText(input);
        } else if (action.equalsIgnoreCase("UpdateInVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
        } else if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        }
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "doCorrectAction(" + input + ") for action " + this.getActionName());
        }
        if (action.equalsIgnoreCase("UpdateIcon")) {
            this.setImageName(input);
        } else if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            this.setText(input);
        }
    }

    @Override
    public boolean isChangedFromResetState() {
        if (this.getImageName() != null) {
            return true;
        }
        return this.getText() != null && this.getText().length() > 0;
    }

    @Override
    public Object getValue() {
        if (this.getActionName().equalsIgnoreCase("UpdateIcon") && this.getImageName() != null) {
            return this.imageName;
        }
        if (this.getActionName().equalsIgnoreCase("UpdateText") && this.getText() != null && this.getText().length() > 0) {
            return this.getText();
        }
        if (this.getActionName().equalsIgnoreCase("UpdateInVisible")) {
            return this.isInvisible();
        }
        return null;
    }

    public Vector getCurrentState() {
        if (trace.getDebugCode("label")) {
            trace.out("label", "JCLabel.getCurrentState() image " + this.imageName + ", text " + this.getText() + ", invisible " + this.isInvisible());
        }
        Vector<MessageObject> v = new Vector<MessageObject>();
        if (this.imageName != null) {
            this.setActionName("UpdateIcon");
            v.addElement(this.getCurrentStateMessage());
        }
        if (this.getText() != null && this.getText().length() > 0) {
            this.setActionName("UpdateText");
            v.addElement(this.getCurrentStateMessage());
        }
        if (this.isInvisible()) {
            this.setActionName("UpdateInVisible");
            v.addElement(this.getCurrentStateMessage());
        }
        return v;
    }

    public void setText(String text) {
        if (this.label != null) {
            this.label.setText(text);
        }
        this.setActionName("UpdateText");
    }

    public String getText() {
        if (this.label != null) {
            return this.label.getText();
        }
        return null;
    }

    @Override
    public void setToolTipText(String text) {
        this.label.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        return this.label.getToolTipText();
    }

    @Override
    public void setBackground(Color c) {
        if (this.label != null) {
            this.label.setBackground(c);
        }
    }

    public void setImageName(String imageName) {
        ImageIcon imageIcon;
        String errMsg;
        block10: {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "0. setImageName : " + imageName);
            }
            if (imageName == null || imageName.length() < 1) {
                return;
            }
            errMsg = null;
            imageIcon = null;
            try {
                if (imageName.startsWith("file:")) {
                    imageIcon = this.getIconFromURL(imageName);
                    break block10;
                }
                try {
                    imageIcon = this.getIconFromFile(imageName);
                }
                catch (Exception e) {
                    errMsg = e.getMessage();
                }
                if (imageIcon == null) {
                    imageIcon = this.getIconFromResource(imageName);
                }
            }
            catch (Exception e) {
                if (errMsg != null) break block10;
                errMsg = e.getMessage();
            }
        }
        if (imageIcon == null) {
            JOptionPane.showMessageDialog(this, errMsg, this.getCommName() + ": Image Error", 0);
            trace.err("JCommLabel[" + this.getCommName() + "].setImageName(" + imageName + ") cannot load image: " + errMsg);
            return;
        }
        if (this.label != null) {
            this.label.setIcon(imageIcon);
            this.setActionName("UpdateIcon");
        }
    }

    private ImageIcon getIconFromURL(String imageName) throws Exception {
        String errMsg = null;
        URL imageURL = null;
        try {
            imageURL = new URL(imageName);
            return new ImageIcon(imageURL);
        }
        catch (MalformedURLException mal) {
            errMsg = "Cannot form image address from \"" + imageName + "\":\n" + mal;
            trace.err("JCommLabel.setImageName() " + errMsg);
            throw new Exception(errMsg);
        }
        catch (Exception e) {
            errMsg = "Error getting image \"" + imageName + "\"\nfrom address " + imageURL + ":\n" + e;
            trace.err("JCommLabel.setImageName() " + errMsg);
            throw new Exception(errMsg);
        }
    }

    private ImageIcon getIconFromFile(String imageName) throws Exception {
        String errMsg = null;
        File imgFile = null;
        try {
            imgFile = new File(imageName);
            if (!imgFile.exists()) {
                String parent = this.getController().getPreferencesModel().getStringValue("workspace");
                imgFile = new File(parent.length() < 1 ? null : parent, imageName);
            }
        }
        catch (Exception e) {
            errMsg = "Error converting image name \"" + imageName + "\" into filename:\n" + e;
            trace.errStack("JCommLabel.getIconFromFile() " + errMsg, e);
            throw new Exception(errMsg);
        }
        if (!imgFile.exists()) {
            errMsg = "Cannot find file for image \"" + imageName + "\"\nin filename " + imgFile.getAbsolutePath();
            trace.err("JCommLabel.getIconFromFile() " + errMsg);
            throw new Exception(errMsg);
        }
        try {
            String absPath = imgFile.getCanonicalPath().replace('\\', '/');
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "setImageName(" + imageName + ") absPath=" + absPath);
            }
            return new ImageIcon(absPath);
        }
        catch (Exception e) {
            errMsg = "Error getting image \"" + imageName + "\"\nfrom file " + imgFile.getAbsolutePath() + ":\n" + e;
            trace.err("JCommLabel.getIconFromFile() " + errMsg);
            throw new Exception(errMsg);
        }
    }

    private ImageIcon getIconFromResource(String imageName) throws Exception {
        String errMsg = null;
        URL imageURL = null;
        for (int i = 0; i < 3; ++i) {
            try {
                switch (i) {
                    case 0: {
                        imageURL = Utils.getURL(imageName, this);
                        break;
                    }
                    case 1: {
                        imageURL = JCommPicture.class.getResource(imageName);
                        break;
                    }
                    case 2: {
                        imageURL = this.getClass().getClassLoader().getResource(imageName);
                    }
                }
                if (trace.getDebugCode("inter")) {
                    trace.out("inter", "getIconFromResource" + i + "(" + imageName + ") imageURL: " + imageURL);
                }
            }
            catch (Exception e) {
                errMsg = "Cannot form image address from \"" + imageName + "\":\n" + e;
                trace.err("JCommLabel.getIconFromResource(" + imageName + ") " + errMsg);
            }
            if (imageURL == null) continue;
            try {
                Image image = Toolkit.getDefaultToolkit().getImage(imageURL);
                return new ImageIcon(image, imageName);
            }
            catch (Exception e) {
                errMsg = "Error getting image \"" + imageName + "\"\nfrom address " + imageURL + ":\n" + e;
                trace.err("JCommLabel.getIconFromFile() " + errMsg);
            }
        }
        throw new Exception(errMsg);
    }

    public String getImageName() {
        return this.imageName;
    }

    @Override
    public void setFont(Font f) {
        if (this.label != null) {
            this.label.setFont(f);
        }
    }

    @Override
    public Font getFont() {
        if (this.label != null) {
            return this.label.getFont();
        }
        return super.getFont();
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        if (this.label != null) {
            this.label.setSize(d);
        }
    }

    @Override
    public void reset(TutorController controller) {
    }

    public void setIcon(Icon icon) {
        if (this.label != null) {
            this.label.setIcon(icon);
        }
    }

    public Icon getIcon() {
        if (this.label != null) {
            return this.label.getIcon();
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isControlDown() && this.getController().isDefiningStartState()) {
            String title;
            EditLabelNameDialog t;
            JFrame frame = new JFrame("Modify Label Text");
            String currentDir = System.getProperty("user.dir");
            String text = this.getText();
            Vector<String> selection = new Vector<String>();
            Vector action = new Vector();
            Vector originalInput = null;
            selection.addElement(this.commSelection.trim());
            selection.addElement(this.getActionName().trim());
            MessageObject mo = this.getController().getOriginalStartStateNodeMessage(selection, action);
            if (mo != null) {
                originalInput = (Vector)mo.getProperty("Input");
            }
            if (originalInput != null) {
                text = originalInput.firstElement().toString();
            }
            if (!(t = new EditLabelNameDialog(frame, title = "Please set the Label for widget " + this.commName + " : ", text, this.getImageName(), currentDir, this.isInvisible(), true)).getNewLabel().equals(text)) {
                this.setText(t.getNewLabel());
                this.dirty = true;
                this.setActionName("UpdateText");
                this.sendValue();
            }
            if (t.getIcon() != null) {
                this.setIcon(t.getIcon());
                this.imageName = t.getImageName();
                this.dirty = true;
                this.setActionName("UpdateIcon");
                this.sendValue();
            }
            if (this.isInvisible() != t.isInvisible()) {
                this.setInvisible(t.isInvisible());
                this.dirty = true;
                this.setActionName("UpdateInVisible");
                this.sendValue();
            }
        }
    }
}

