/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;
import pact.CommWidgets.JCommQuestion;
import pact.CommWidgets.StudentInterfaceWrapper;
import pact.CommWidgets.event.IncorrectActionEvent;
import pact.CommWidgets.event.IncorrectActionListener;
import pact.CommWidgets.event.StudentActionEvent;
import pact.CommWidgets.event.StudentActionListener;

public class JCommMultipleChoiceCheckBox
extends JCommQuestion
implements ActionListener,
ItemListener {
    private static final String UPDATE_INVISIBLE = "UpdateInVisible";
    boolean choicesCreated;
    boolean choicesInitialized;
    private static int HORIZONTAL_LAYOUT = 1;
    private static int VERTICAL_LAYOUT = 2;
    private int nChoices = 4;
    private int choiceLayout = 2;
    JCheckBox[] choices;
    JPanel choicesPanel = new JPanel();
    JPanel submitBtnPanel = new JPanel();
    JButton submitButton;
    String previousValue = "";
    int currentChoice = -1;
    ArrayList choiceTexts = new ArrayList();
    private int dialogOrder = 1;
    JCheckBox dummyButton;
    private static int counter = 0;
    private boolean alreadyDone = false;

    public JCommMultipleChoiceCheckBox() {
        this.setActionName("UpdateMultipleChoiceCheckBox");
        this.locked = false;
        for (int i = 0; i < this.nChoices; ++i) {
            this.choiceTexts.add(i, "Option" + i);
        }
        this.questionText = "Question?";
        this.createChoices();
    }

    public void createChoices() {
        this.removeAll();
        this.choicesPanel.removeAll();
        this.choices = null;
        this.choices = new JCheckBox[this.nChoices];
        this.setLayout(new BorderLayout());
        this.questionLbl.setText(this.questionText);
        this.questionLbl.setFocusable(false);
        this.add(this.questionLbl);
        if (this.choiceLayout == HORIZONTAL_LAYOUT) {
            this.choicesPanel.setLayout(new FlowLayout());
        } else {
            this.choicesPanel.setLayout(new GridLayout(0, 1));
        }
        for (int i = 0; i < this.nChoices; ++i) {
            this.choices[i] = new JCheckBox();
            if (this.startFont != null) {
                this.choices[i].setFont(this.startFont);
            }
            this.choices[i].addItemListener(this);
            if (this.currentChoice == i) {
                this.choices[i].setSelected(true);
            }
            this.choicesPanel.add(this.choices[i]);
        }
        this.setChoiceText();
        this.add((Component)this.questionLbl, "North");
        this.add(this.choicesPanel);
        this.add((Component)this.submitBtnPanel, "South");
        if (this.submitButton == null) {
            this.submitButton = new JButton("Submit");
            this.submitButton.addActionListener(this);
            this.submitButton.setEnabled(false);
            this.submitBtnPanel.add(this.submitButton);
        } else {
            this.submitBtnPanel.add(this.submitButton);
        }
        this.choicesCreated = true;
        this.choicesPanel.validate();
        this.validate();
    }

    @Override
    protected boolean initialize() {
        if (!super.initialize()) {
            return false;
        }
        if (this.choicesInitialized) {
            return true;
        }
        StudentInterfaceWrapper studentInterface = this.getController().getStudentInterface();
        if (studentInterface != null) {
            this.addStudentActionListener((StudentActionListener)((Object)studentInterface.getHintInterface()));
            this.addIncorrectActionListener((IncorrectActionListener)((Object)studentInterface.getHintInterface()));
        }
        this.addCommListener();
        if (this.getController().isShowWidgetInfo()) {
            this.setToolTipWidgetInfo();
        }
        this.choicesInitialized = true;
        return true;
    }

    @Override
    public MessageObject getDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        if (!this.initialize()) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        mo.setProperty("WidgetType", "JCommMultipleChoiceCheckBox");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        mo.setProperty("nChoices", new Integer(this.nChoices));
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    private void setChoiceColor(String input, Color color, Font font) {
        this.resetChoiceColors();
        String[] selectedChoices = input.split(",");
        for (int i = 0; i < selectedChoices.length; ++i) {
            for (int j = 0; j < this.choices.length; ++j) {
                if (!selectedChoices[i].equals(this.choices[j].getText())) continue;
                this.choices[j].setSelected(true);
                this.choices[j].setForeground(color);
                if (font == null) continue;
                this.choices[j].setFont(font);
            }
        }
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            this.setChoiceColor(input, this.correctColor, this.correctFont);
            if (this.getUniversalToolProxy().lockWidget()) {
                this.locked = true;
                for (int i = 0; i < this.choices.length; ++i) {
                    if (this.choices[i].isSelected()) continue;
                    this.choices[i].setEnabled(false);
                }
            }
            if (!this.alreadyDone) {
                this.fireStudentAction(new StudentActionEvent(this));
                this.alreadyDone = true;
            }
        }
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        this.setChoiceColor(input, this.LISPCheckColor, this.correctFont);
        if (this.getUniversalToolProxy().lockWidget()) {
            this.locked = true;
            for (int i = 0; i < this.choices.length; ++i) {
                if (this.choices[i].isSelected()) continue;
                this.choices[i].setEnabled(false);
            }
        }
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        this.resetChoices();
        this.setChoiceColor(input, this.incorrectColor, this.incorrectFont);
        this.locked = false;
        this.alreadyDone = false;
        this.fireIncorrectAction(new IncorrectActionEvent(this));
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        if (action.equalsIgnoreCase(UPDATE_INVISIBLE)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
        } else if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        }
    }

    public JCheckBox getSelectedChoice() {
        for (int i = 0; i < this.choices.length; ++i) {
            if (!this.choices[i].isSelected()) continue;
            return this.choices[i];
        }
        return null;
    }

    public void resetChoiceColors() {
        for (int i = 0; i < this.choices.length; ++i) {
            this.choices[i].setForeground(this.startColor);
            if (this.startFont == null) continue;
            this.choices[i].setFont(this.startFont);
        }
    }

    public void resetChoices() {
        for (int i = 0; i < this.choices.length; ++i) {
            this.choices[i].setSelected(false);
        }
    }

    @Override
    public Object getValue() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.choices.length; ++i) {
            if (!this.choices[i].isSelected()) continue;
            String choice = this.choices[i].getText();
            sb.append(choice);
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.choicesPanel != null) {
            this.choicesPanel.setBackground(c);
        }
        if (this.submitBtnPanel != null) {
            this.submitBtnPanel.setBackground(c);
        }
        if (this.choices == null) {
            return;
        }
        for (int i = 0; i < this.nChoices; ++i) {
            this.choices[i].setBackground(c);
        }
    }

    @Override
    public void highlight(String subElement, Border highlightBorder) {
        this.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.setBorder(this.originalBorder);
    }

    @Override
    public boolean isChangedFromResetState() {
        JCheckBox btn = this.getSelectedChoice();
        return this.currentChoice != -1 && btn != null && !this.choices[this.currentChoice].equals(btn);
    }

    @Override
    public void reset(TutorController controller) {
        this.alreadyDone = false;
        this.initialize();
        this.resetChoiceColors();
        this.previousValue = "";
        this.setEnabled(true);
        for (int i = 0; i < this.choices.length; ++i) {
            this.choices[i].setEnabled(true);
            this.choices[i].setSelected(false);
        }
        JCheckBox btn = this.getSelectedChoice();
        if (btn != null) {
            btn.setSelected(false);
            btn.setForeground(this.startColor);
        }
        if (this.currentChoice != -1 && this.currentChoice < this.choices.length) {
            this.choices[this.currentChoice].setSelected(true);
        }
        this.locked = false;
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        if (this.nChoices > 0) {
            this.createChoices();
        }
    }

    public void setNChoices(int n) {
        if (n <= 0) {
            return;
        }
        this.nChoices = n;
        this.createChoices();
    }

    public int getNChoices() {
        return this.nChoices;
    }

    public String getChoiceTexts() {
        String str = "";
        for (int i = 0; i < this.choiceTexts.size(); ++i) {
            str = str + this.choiceTexts.get(i) + ",";
        }
        return str;
    }

    public void setChoiceTexts(String texts) {
        StringTokenizer st = new StringTokenizer(texts, ",");
        this.choiceTexts.clear();
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            this.choiceTexts.add(str);
        }
        this.setChoiceText();
    }

    public void setChoiceText() {
        Iterator it = this.choiceTexts.iterator();
        for (int i = 0; i < this.choices.length && it.hasNext(); ++i) {
            this.choices[i].setText((String)it.next());
            this.choices[i].setFont(this.correctFont);
        }
        this.choicesPanel.validate();
    }

    @Override
    public void setFont(Font f) {
        this.startFont = f != null ? f : super.getFont();
        super.setFont(this.startFont);
        for (int i = 0; i < this.nChoices; ++i) {
            this.choices[i].setFont(this.startFont);
        }
    }

    @Override
    public String getCommNameToSend() {
        String s = this.commName;
        return s;
    }

    @Override
    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String choiceTemplate = "(deftemplate multipleChoice  (slot name) (multislot choices) (slot value) (slot question))";
        deftemplates.add(choiceTemplate);
        return deftemplates;
    }

    @Override
    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String choicesStr = "";
        for (int j = 0; j < this.getNChoices(); ++j) {
            choicesStr = choicesStr + "\"" + this.choices[j].getText() + "\" ";
        }
        String value = "nil";
        JCheckBox btn = this.getSelectedChoice();
        if (btn != null) {
            value = btn.getText();
        }
        String str = "(bind ?" + this.getCommName() + " (assert (multipleChoice (name " + this.getCommName() + ") (choices " + choicesStr + ") (question \"" + this.questionText + "\") (value \"" + value + "\"))))";
        instances.add(str);
        return instances;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JCommMultipleChoiceCheckBox multipleChoice = new JCommMultipleChoiceCheckBox();
        frame.getContentPane().add(multipleChoice);
        frame.pack();
        frame.show();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        this.submitButton.setEnabled(false);
        for (int i = 0; i < this.choices.length; ++i) {
            if (!this.choices[i].isSelected()) continue;
            this.submitButton.setEnabled(true);
            break;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.submitButton) {
            String selectedValue = this.getValue().toString();
            if (!this.locked && this.initialized) {
                if (!this.previousValue.equals(selectedValue)) {
                    this.previousValue = this.getValue().toString();
                    this.dirty = true;
                    this.sendValue();
                    return;
                }
            } else if (this.locked) {
                // empty if block
            }
        }
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }

    public synchronized int getCurrentChoice() {
        return this.currentChoice;
    }

    public synchronized void setCurrentChoice(int currentChoice) {
        this.currentChoice = currentChoice;
    }

    public synchronized int getChoiceLayout() {
        return this.choiceLayout;
    }

    public synchronized void setChoiceLayout(int layout) {
        this.choiceLayout = layout;
        this.choicesPanel.removeAll();
        if (this.choiceLayout == HORIZONTAL_LAYOUT) {
            this.choicesPanel.setLayout(new FlowLayout());
        } else {
            this.choicesPanel.setLayout(new GridLayout(0, 1));
        }
        for (int i = 0; i < this.choices.length; ++i) {
            this.choicesPanel.add(this.choices[i]);
        }
        this.choicesPanel.validate();
    }

    public synchronized int getDialogOrder() {
        return this.dialogOrder;
    }

    public synchronized void setDialogOrder(int dialogOrder) {
        this.dialogOrder = dialogOrder;
    }

    @Override
    public void hideAllComponents(boolean b) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setVisible(!b);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.questionLbl.setEnabled(b);
        for (int i = 0; i < this.nChoices; ++i) {
            this.choices[i].setEnabled(b);
        }
    }
}

