/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.Dialogs.EditLabelNameDialog;
import edu.cmu.pact.Utilities.PictureTransferHandler;
import edu.cmu.pact.Utilities.StringTransferable;
import edu.cmu.pact.Utilities.TransferActionListener;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Highlighter;
import pact.CommWidgets.JCommWidget;

public class JCommPicture
extends JCommWidget
implements FocusListener,
MouseListener,
MouseMotionListener,
Accessible {
    protected JScrollPane textAreaScrollPane;
    protected String previousValue;
    protected String resetValue = "";
    protected Highlighter defaultHighlighter;
    protected JLabel label;
    public ImageIcon image;
    private ImageIcon initImage = null;
    public String imageFile = "NoImage.gif";
    public String initImageFile = "NoImage.gif";
    private int preferredWidth;
    private int preferredHeight;
    private MouseEvent firstMouseEvent = null;
    private DropTargetDragEvent dragMouseEvent = null;
    private static boolean installInputMapBindings = true;
    private boolean correct = false;
    private boolean incorrect = false;
    PictureTransferHandler picHandler;
    private DragSource dragSource;
    private DropTargetListener dtListener;
    private DropTarget dropTarget;
    private int acceptableActions = 1;
    private DragGestureListener dgListener;
    private DragSourceListener dsListener;
    public String Data;
    private boolean imageLock = false;
    private static String currentDir = System.getProperty("user.dir");

    public JCommPicture() {
        this.setPreferredSize(new Dimension(180, 180));
        this.label = new JLabel("");
        this.add(this.label);
        this.picHandler = new PictureTransferHandler(this);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dtListener = new DTListener();
        this.dgListener = new DGListener();
        this.dsListener = new DSListener();
        this.dropTarget = new DropTarget(this, this.acceptableActions, this.dtListener, true);
        this.dragSource.createDefaultDragGestureRecognizer(this, this.acceptableActions, this.dgListener);
        JCommPicture.setInstallInputMapBindings(false);
        this.preferredWidth = (int)this.getPreferredSize().getWidth();
        this.preferredHeight = (int)this.getPreferredSize().getHeight();
        this.imageFile = this.initImageFile;
        this.actionName = "DragInto";
        this.setImage(this.loadImage(this.imageFile));
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addMouseMotionListener(this);
        this.locked = false;
        this.setTransferHandler(this.picHandler);
    }

    public void setCommPicture(ImageIcon image) {
        this.image = image;
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addMouseMotionListener(this);
        if (installInputMapBindings) {
            InputMap imap = this.getInputMap();
            imap.put(KeyStroke.getKeyStroke("ctrl X"), TransferHandler.getCutAction().getValue("Name"));
            imap.put(KeyStroke.getKeyStroke("ctrl C"), TransferHandler.getCopyAction().getValue("Name"));
            imap.put(KeyStroke.getKeyStroke("ctrl V"), TransferHandler.getPasteAction().getValue("Name"));
        }
        ActionMap map = this.getActionMap();
        map.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        map.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        map.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        System.err.println("doInterfaceAction  " + action + "  " + input + " --> " + selection);
        if (action.equalsIgnoreCase("UpdateIcon")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "update Image: " + input);
            }
            this.setImageFile(input);
        } else if (action.equalsIgnoreCase("DragInto")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Drag Image: " + input);
            }
            this.setImageFile(input);
        } else if (action.equalsIgnoreCase("UpdateInVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
        } else if (action.equalsIgnoreCase("SetVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set Visible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(false);
            } else {
                this.setInvisible(true);
            }
            this.setVisible(!this.isInvisible());
        } else if (action.equalsIgnoreCase("UpdateText")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "UpdateText: " + input);
            }
            this.setText(input);
        }
        this.repaint();
        trace.out("**Error**: don't know interface action " + action);
    }

    @Override
    public MessageObject getDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        if (!this.initialize(this.getController())) {
            trace.out("ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return mo;
        }
        mo.setProperty("WidgetType", "JCommPicture");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate textArea (slot name) (slot value))";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String instanceStr = "(assert (textArea (name " + this.commName + ")))";
        instances.add(instanceStr);
        return instances;
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if (action.equalsIgnoreCase("UpdateInVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
        } else if (action.equalsIgnoreCase("SetVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set Visible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(false);
            } else {
                this.setInvisible(true);
            }
            this.setVisible(!this.isInvisible());
        } else if (this.getCommName().equals(selection)) {
            this.setImageFile(input);
            this.correct = true;
            this.repaint();
        }
        if (this.getController().getUniversalToolProxy().lockWidget()) {
            this.locked = true;
            this.removeHighlight("");
            this.setFocusable(false);
        }
    }

    @Override
    public boolean getLock(String selection) {
        return false;
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        if (this.getController().getUniversalToolProxy().lockWidget()) {
            this.setFocusable(false);
        }
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        if (this.getCommName().equals(selection)) {
            this.setImageFile(input);
            this.incorrect = true;
            this.setIncorrectColor(this.incorrectColor);
            this.repaint();
        }
        this.locked = false;
        this.setFocusable(true);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void highlight(String commComponentName, Border highlightBorder) {
        this.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.setBorder(this.originalBorder);
    }

    @Override
    public void setFocus(String subWidgetName) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    @Override
    public Object getValue() {
        if (this.getActionName().equalsIgnoreCase("UpdateIcon")) {
            return this.getImageFile();
        }
        if (this.getActionName().equalsIgnoreCase("UpdateText") && this.getText() != null && this.getText().length() > 0) {
            return this.getText();
        }
        if (this.getActionName().equalsIgnoreCase("UpdateInVisible")) {
            return this.isInvisible();
        }
        if (this.getActionName().equalsIgnoreCase("DragInto")) {
            return this.Data;
        }
        return null;
    }

    public Vector getCurrentState() {
        Vector<MessageObject> v = new Vector<MessageObject>();
        if (this.image != null) {
            this.setActionName("UpdateIcon");
            v.addElement(this.getCurrentStateMessage());
        } else {
            this.setActionName("DragInto");
            v.addElement(this.getCurrentStateMessage());
        }
        if (this.getText() != null && this.getText().length() > 0) {
            this.setActionName("UpdateText");
            v.addElement(this.getCurrentStateMessage());
        }
        if (this.isInvisible()) {
            this.setActionName("UpdateInVisible");
            v.addElement(this.getCurrentStateMessage());
        }
        this.setActionName("DragInto");
        return v;
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
    }

    @Override
    public boolean isChangedFromResetState() {
        return true;
    }

    public boolean resetStartStateLock(boolean startStateLock) {
        return false;
    }

    @Override
    public void setFocusable(boolean focusFlag) {
        super.setFocusable(focusFlag);
    }

    @Override
    public void reset(TutorController controller) {
        this.initialize(controller);
        this.locked = false;
        this.image = this.initImage;
        this.imageFile = this.initImageFile;
        this.repaint();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.dirty = true;
    }

    public void removeUpdate(DocumentEvent e) {
        this.dirty = true;
    }

    @Override
    public void setBackground(Color c) {
    }

    @Override
    public void setToolTipText(String text) {
    }

    @Override
    public String getToolTipText() {
        return "temp";
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        if (arg0.isControlDown() && this.getController().isDefiningStartState()) {
            String title;
            EditLabelNameDialog t;
            JFrame frame = new JFrame("Modify Label Text");
            String text = this.getText();
            Vector<String> selection = new Vector<String>();
            Vector action = new Vector();
            Vector originalInput = null;
            selection.addElement(this.commSelection.trim());
            selection.addElement(this.getActionName().trim());
            MessageObject mo = this.getController().getOriginalStartStateNodeMessage(selection, action);
            if (mo != null) {
                originalInput = (Vector)mo.getProperty("Input");
            }
            if (originalInput != null) {
                text = originalInput.firstElement().toString();
            }
            if (!(t = new EditLabelNameDialog(frame, title = "Please set the Label for widget " + this.commName + " : ", text, this.imageFile, currentDir, this.isInvisible(), true)).getNewLabel().equals(this.getText())) {
                this.setText(t.getNewLabel());
                this.dirty = true;
                this.setActionName("UpdateText");
                this.sendValue();
            }
            if (t.getIcon() != null) {
                this.setImage(t.getIcon());
                this.imageFile = t.getImageName();
                System.err.println("imageFile = " + this.imageFile);
                this.dirty = true;
                this.setActionName("UpdateIcon");
                this.sendValue();
            }
            if (this.isInvisible() != t.isInvisible()) {
                this.setInvisible(t.isInvisible());
                this.dirty = true;
                this.setActionName("UpdateInVisible");
                this.sendValue();
            }
        }
        this.requestFocusInWindow();
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        if (trace.getDebugCode("log")) {
            trace.out("log", "mouseEntered");
        }
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        if (trace.getDebugCode("log")) {
            trace.out("log", "mouseExited");
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics g = graphics.create();
        if (this.imageFile.contains("NoImage.gif")) {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.preferredWidth, this.preferredHeight);
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, this.preferredWidth, this.preferredHeight);
            g.setColor(Color.GREEN);
            if (this.commName != null) {
                g.drawString(this.commName, 45, 90);
            } else {
                g.drawString("No Image", 45, 90);
            }
        } else {
            if (this.image != null) {
                this.image.paintIcon(this, g, 0, 0);
            }
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, this.preferredWidth, this.preferredHeight);
        }
        if (this.isFocusOwner()) {
            g.setColor(Color.RED);
        } else if (this.correct) {
            System.err.println(" --> GREEN");
            g.setColor(this.correctColor);
            g.drawRect(0, 0, this.preferredWidth, this.preferredHeight);
            this.correct = false;
        } else if (this.incorrect) {
            System.err.println(" --> RED");
            g.setColor(this.incorrectColor);
            g.drawRect(0, 0, this.preferredWidth, this.preferredHeight);
            this.incorrect = false;
        } else {
            g.setColor(Color.BLACK);
        }
        g.dispose();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.image == null) {
            return;
        }
        this.firstMouseEvent = e;
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.image == null) {
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public static void setInstallInputMapBindings(boolean flag) {
        installInputMapBindings = flag;
    }

    public static boolean getInstallInputMapBindingds() {
        return installInputMapBindings;
    }

    private ImageIcon getImage() {
        return this.image;
    }

    public void setImage(ImageIcon image) {
        this.image = image;
    }

    protected static ImageIcon createImageIcon(String path, String description) {
        URL imageURL = JCommPicture.class.getResource(path);
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL, description);
    }

    public JMenuBar createMenuBar() {
        JMenuItem menuItem = null;
        JMenuBar menuBar = new JMenuBar();
        JMenu mainMenu = new JMenu("Edit");
        mainMenu.setMnemonic(69);
        TransferActionListener actionListener = new TransferActionListener();
        menuItem = new JMenuItem("Cut");
        menuItem.setActionCommand((String)TransferHandler.getCutAction().getValue("Name"));
        menuItem.addActionListener(actionListener);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menuItem.setMnemonic(84);
        mainMenu.add(menuItem);
        menuItem = new JMenuItem("Copy");
        menuItem.setActionCommand((String)TransferHandler.getCopyAction().getValue("Name"));
        menuItem.addActionListener(actionListener);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menuItem.setMnemonic(67);
        mainMenu.add(menuItem);
        menuItem = new JMenuItem("Paste");
        menuItem.setActionCommand((String)TransferHandler.getPasteAction().getValue("Name"));
        menuItem.addActionListener(actionListener);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menuItem.setMnemonic(80);
        mainMenu.add(menuItem);
        menuBar.add(mainMenu);
        return menuBar;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(String imageFile) {
        this.imageFile = imageFile != null ? imageFile : "NoImage.gif";
        System.out.println("imageFile = " + imageFile);
        this.setImage(this.loadImage(imageFile));
    }

    public static void waitForImage(Component component, Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected ImageIcon loadImage(String imageName) {
        URL imageURL;
        block9: {
            if (imageName == null || imageName.length() < 1) {
                return null;
            }
            File imgFile = null;
            imageURL = null;
            try {
                if (!imageName.startsWith("file:") && (imgFile = new File(imageName)).exists()) {
                    System.err.println("Creat icon from physical/relative address");
                    return new ImageIcon(imageName);
                }
            }
            catch (Exception e) {
                trace.err("Can't find file " + imageName);
            }
            try {
                imageURL = new URL(imageName);
            }
            catch (MalformedURLException mal) {
                if (!trace.getDebugCode("log")) break block9;
                trace.out("log", "MalformedURLException message = " + mal.getMessage());
            }
        }
        if (imageURL == null) {
            imageURL = Utils.getURL(imageName, this);
        }
        if (imageURL == null) {
            imageURL = JCommPicture.class.getResource(imageName);
        }
        if (imageURL == null) {
            trace.err("Error: cannot find image " + new File(imageName).getAbsolutePath());
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(imageURL);
        ImageIcon imageIcon = new ImageIcon(image, imageName);
        return imageIcon;
    }

    @Override
    public String getCommNameToSend() {
        return this.commName;
    }

    public PictureTransferHandler getPicHandler() {
        return this.picHandler;
    }

    public void setPicHandler(PictureTransferHandler picHandler) {
        this.picHandler = picHandler;
    }

    public boolean isimageLock() {
        return this.imageLock;
    }

    public void setimageLock(boolean imageLock) {
        this.imageLock = imageLock;
    }

    public void setText(String text) {
        if (this.label != null) {
            this.label.setText(text);
        }
        this.setActionName("UpdateText");
    }

    public String getText() {
        if (this.label != null) {
            return this.label.getText();
        }
        return null;
    }

    class DSListener
    implements DragSourceListener {
        DSListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent e) {
            if (!e.getDropSuccess()) {
                System.out.println("not successful");
                return;
            }
            if (e.getDropAction() == 2) {
                JCommPicture.this.setImage(null);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            int myaction = e.getDropAction();
            if ((myaction & JCommPicture.this.acceptableActions) != 0) {
                context.setCursor(DragSource.DefaultCopyDrop);
            } else {
                context.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        @Override
        public void dragOver(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            int sa = context.getSourceActions();
            int ua = e.getUserAction();
            int da = e.getDropAction();
            int ta = e.getTargetActions();
        }

        @Override
        public void dragExit(DragSourceEvent e) {
            DragSourceContext context = e.getDragSourceContext();
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    class DGListener
    implements DragGestureListener {
        DGListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            if ((e.getDragAction() & JCommPicture.this.acceptableActions) == 0) {
                return;
            }
            StringTransferable transferable = new StringTransferable(JCommPicture.this.getImageFile().toString());
            try {
                e.startDrag(DragSource.DefaultCopyNoDrop, transferable, JCommPicture.this.dsListener);
            }
            catch (InvalidDnDOperationException idoe) {
                System.err.println(idoe);
            }
        }
    }

    class DTListener
    implements DropTargetListener {
        DTListener() {
        }

        private DataFlavor chooseDropFlavor(DropTargetDropEvent e) {
            if (e.isLocalTransfer() && e.isDataFlavorSupported(StringTransferable.localStringFlavor)) {
                return StringTransferable.localStringFlavor;
            }
            DataFlavor chosen = null;
            if (e.isDataFlavorSupported(StringTransferable.plainTextFlavor)) {
                chosen = StringTransferable.plainTextFlavor;
            } else if (e.isDataFlavorSupported(StringTransferable.localStringFlavor)) {
                chosen = StringTransferable.localStringFlavor;
            } else if (e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                chosen = DataFlavor.stringFlavor;
            } else if (e.isDataFlavorSupported(DataFlavor.plainTextFlavor)) {
                chosen = DataFlavor.plainTextFlavor;
            }
            return chosen;
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
            if (JCommPicture.this.imageLock || JCommPicture.this.locked) {
                return;
            }
            JCommPicture.this.dragMouseEvent = e;
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            if (JCommPicture.this.imageLock || JCommPicture.this.locked) {
                return;
            }
            System.out.println("dtlistener drop [ " + JCommPicture.this.getImageFile() + " ]");
            if (JCommPicture.this.dragMouseEvent != null) {
                int ctrlMask = 128;
                int action = (e.getSourceActions() & ctrlMask) == ctrlMask ? 1 : 2;
                int dx = (int)Math.abs(e.getLocation().getX() - JCommPicture.this.dragMouseEvent.getLocation().getX());
                int dy = (int)Math.abs(e.getLocation().getY() - JCommPicture.this.dragMouseEvent.getLocation().getY());
                if (dx > 5 || dy > 5) {
                    DataFlavor chosen = this.chooseDropFlavor(e);
                    if (chosen == null) {
                        e.rejectDrop();
                        return;
                    }
                    try {
                        JCommPicture.this.Data = (String)e.getTransferable().getTransferData(chosen);
                        JCommPicture.this.image = new ImageIcon(JCommPicture.this.Data);
                        JCommPicture.this.repaint();
                    }
                    catch (Throwable tw) {
                        System.err.println("Couldn't get transfer data: " + tw.getMessage());
                        tw.printStackTrace();
                        e.dropComplete(false);
                        return;
                    }
                    DropTarget t = (DropTarget)e.getSource();
                    JCommPicture c = (JCommPicture)t.getComponent();
                    c.getPicHandler().exportAsDrag(c, JCommPicture.this.firstMouseEvent, action);
                    JCommPicture.this.dragMouseEvent = null;
                    e.dropComplete(true);
                    JCommPicture.this.dirty = true;
                    JCommPicture.this.sendValue();
                }
            }
        }
    }
}

