/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Highlighter;
import pact.CommWidgets.JCommDocument;
import pact.CommWidgets.JCommQuestion;
import pact.CommWidgets.event.IncorrectActionEvent;
import pact.CommWidgets.event.IncorrectActionListener;
import pact.CommWidgets.event.StudentActionEvent;
import pact.CommWidgets.event.StudentActionListener;

public class JCommQuestionTextField
extends JCommQuestion
implements ActionListener,
FocusListener,
KeyListener {
    private JTextField answerTxt = new JTextField();
    private int nCharacters;
    private int answerLayout;
    private static int counter = 0;
    private boolean alreadyDone;
    protected Highlighter defaultHighlighter;
    String previousValue;
    private boolean isAlgebraWidget;
    private int roundTo;
    protected String resetValue;

    public JCommQuestionTextField() {
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.answerTxt);
        this.nCharacters = 5;
        this.answerLayout = 1;
        this.alreadyDone = false;
        this.isAlgebraWidget = true;
        this.roundTo = 2;
        this.resetValue = "";
        this.setActionName("UpdateQuestionTextField");
        this.answerTxt.setDocument(new JCommDocument());
        this.locked = false;
        ((JCommDocument)this.answerTxt.getDocument()).locked = false;
        this.answerTxt.setColumns(this.nCharacters);
        this.answerTxt.addActionListener(this);
        this.answerTxt.addFocusListener(this);
        this.answerTxt.addKeyListener(this);
        this.defaultHighlighter = this.answerTxt.getHighlighter();
        this.createQuestionPanel();
    }

    private void createQuestionPanel() {
        this.removeAll();
        if (this.answerLayout == 1) {
            this.setLayout(new FlowLayout(0));
            this.add(this.questionLbl);
            this.add(this.answerTxt);
        } else {
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            this.setLayout(gb);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 3;
            gb.setConstraints(this.questionLbl, gbc);
            this.add(this.questionLbl);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gb.setConstraints(this.answerTxt, gbc);
            this.add(this.answerTxt);
        }
        this.backColor = this.getBackground();
        this.questionLbl.setFocusable(false);
        this.answerTxt.setFont(JCommQuestionTextField.getDefaultFont());
        this.validate();
    }

    @Override
    protected boolean initialize() {
        this.alreadyDone = false;
        if (!super.initialize()) {
            return false;
        }
        this.addStudentActionListener((StudentActionListener)((Object)this.getController().getStudentInterface().getHintInterface()));
        this.addIncorrectActionListener((IncorrectActionListener)((Object)this.getController().getStudentInterface().getHintInterface()));
        this.addCommListener();
        if (this.getController().isShowWidgetInfo()) {
            this.setToolTipWidgetInfo();
        }
        return true;
    }

    @Override
    public Object getValue() {
        return this.answerTxt.getText().trim();
    }

    @Override
    public MessageObject getDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        if (!this.initialize()) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        mo.setVerb("SendNoteProperty");
        mo.setProperty("WidgetType", "JCommQuestionTextField");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            this.answerTxt.setForeground(this.correctColor);
            this.answerTxt.setFont(this.correctFont);
            ((JCommDocument)this.answerTxt.getDocument()).locked = false;
            this.answerTxt.setText(input);
            if (this.getController().getUniversalToolProxy().lockWidget()) {
                ((JCommDocument)this.answerTxt.getDocument()).locked = true;
                this.locked = true;
                this.answerTxt.setFocusable(false);
            }
            if (!this.alreadyDone) {
                if (trace.getDebugCode("inter")) {
                    trace.out("inter", "firing studentAction in JCommQuestionTextField: " + this.alreadyDone + "- JCommQuestionTextField.java ");
                }
                this.fireStudentAction(new StudentActionEvent(this));
                this.alreadyDone = true;
            }
            this.answerTxt.setBackground(this.backgroundNormalColor);
            this.questionLbl.setBackground(this.backColor);
            this.setBackground(this.backColor);
        }
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        this.answerTxt.setForeground(this.LISPCheckColor);
        this.answerTxt.setFont(this.correctFont);
        this.answerTxt.setText(input);
        if (this.getController().getUniversalToolProxy().lockWidget()) {
            ((JCommDocument)this.answerTxt.getDocument()).locked = true;
            this.locked = true;
            this.answerTxt.setFocusable(false);
        }
        this.alreadyDone = false;
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        this.answerTxt.setForeground(this.incorrectColor);
        this.answerTxt.setFont(this.incorrectFont);
        this.answerTxt.setText(input);
        ((JCommDocument)this.answerTxt.getDocument()).locked = false;
        this.locked = false;
        this.alreadyDone = false;
        this.answerTxt.setHighlighter(this.defaultHighlighter);
        this.setEnabled(true);
        this.answerTxt.setFocusable(true);
        this.fireIncorrectAction(new IncorrectActionEvent(this));
        int index = input.indexOf(36);
        if (index < 0) {
            index = input.indexOf(37);
        }
        if (index >= 0) {
            this.getController().getStudentInterface().getHintInterface().displayBuggyMessage("Do not include '$' or '%' symbols in your answer.");
        }
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        if (action.equalsIgnoreCase("UpdateQuestionTextField")) {
            this.answerTxt.setText(input);
            if (this.getController().isStartStateInterface()) {
                ((JCommDocument)this.answerTxt.getDocument()).locked = true;
            }
            return;
        }
        if (action.equalsIgnoreCase("UpdateInVisible")) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "Set InVisible: " + input);
            }
            if (input.equalsIgnoreCase("true")) {
                this.setInvisible(true);
            } else {
                this.setInvisible(false);
            }
            this.setVisible(!this.isInvisible());
        } else if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        }
    }

    @Override
    public void highlight(String subElement, Border highlightBorder) {
        this.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        trace.out("mps", "REMOVE HIGHLIGHT");
        this.setBorder(this.originalBorder);
    }

    @Override
    public boolean isChangedFromResetState() {
        if (!this.answerTxt.getText().equals(this.resetValue)) {
            ((JCommDocument)this.answerTxt.getDocument()).locked = true;
            this.answerTxt.setHighlighter(null);
            this.setFocusable(false);
            return true;
        }
        return false;
    }

    @Override
    public void reset(TutorController controller) {
        this.initialize();
        this.setEnabled(true);
        ((JCommDocument)this.answerTxt.getDocument()).locked = false;
        this.answerTxt.setText(this.resetValue);
        this.previousValue = "";
        this.answerTxt.setForeground(this.startColor);
        this.locked = false;
        this.alreadyDone = false;
        this.answerTxt.setFocusable(true);
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
    }

    @Override
    public String getCommNameToSend() {
        String s = this.commName;
        return s;
    }

    @Override
    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String choiceTemplate = "(deftemplate questionTextField (slot name) (slot value) (slot question))";
        deftemplates.add(choiceTemplate);
        return deftemplates;
    }

    @Override
    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String str = "(bind ?" + this.getCommName() + " (assert (questionTextField (name " + this.getCommName() + ")(question \"" + this.questionLbl.getText() + "\"))))";
        instances.add(str);
        return instances;
    }

    public static void main(String[] args) {
    }

    public synchronized int getAnswerLayout() {
        return this.answerLayout;
    }

    public synchronized void setAnswerLayout(int answerLayout) {
        this.answerLayout = answerLayout;
        this.createQuestionPanel();
    }

    public synchronized int getNCharacters() {
        return this.nCharacters;
    }

    public synchronized void setNCharacters(int characters) {
        this.nCharacters = characters;
        this.answerTxt.setColumns(characters);
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        trace.out("mps", "ACTION PERFORMED");
        this.removeHighlight(this.commName);
        if (((JCommDocument)this.answerTxt.getDocument()).locked) {
            return;
        }
        if (!(this.locked || this.answerTxt.getText().trim().equals("") || this.answerTxt.getText().equals(this.previousValue))) {
            this.dirty = true;
            this.previousValue = this.answerTxt.getText();
            this.sendValue();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        trace.out("mps", "FOCUS GAINED");
        this.removeHighlight(this.commName);
        if (!(((JCommDocument)this.answerTxt.getDocument()).locked || this.answerTxt.getText().trim().equals("") || this.answerTxt.getText().equals(this.previousValue))) {
            this.previousValue = this.answerTxt.getText();
            this.answerTxt.setForeground(this.startColor);
            this.answerTxt.setBackground(this.backgroundNormalColor);
            super.focusGained(e);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!this.locked) {
            if (this.getController().getUniversalToolProxy().getAutoCapitalize() || this.getAutoCapitalize()) {
                this.answerTxt.setText(this.answerTxt.getText().toUpperCase());
            }
            if (((JCommDocument)this.answerTxt.getDocument()).locked) {
                return;
            }
            if (!this.answerTxt.getText().trim().equals("") && !this.answerTxt.getText().equals(this.previousValue)) {
                this.dirty = true;
                this.previousValue = this.answerTxt.getText();
                this.sendValue();
                super.focusLost(e);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.answerTxt.setForeground(this.startColor);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public synchronized boolean isAlgebraWidget() {
        return this.isAlgebraWidget;
    }

    public synchronized void setAlgebraWidget(boolean isAlgebraWidget) {
        this.isAlgebraWidget = isAlgebraWidget;
    }

    public synchronized int getRoundTo() {
        return this.roundTo;
    }

    public synchronized void setRoundTo(int roundTo) {
        this.roundTo = roundTo;
    }
}

