/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Highlighter;
import pact.CommWidgets.InputMethodFramework.ActiveClient;
import pact.CommWidgets.JCommDocument;
import pact.CommWidgets.JCommWidget;

public class JCommTextArea
extends JCommWidget
implements FocusListener,
MouseListener,
KeyListener {
    protected JTextArea textArea = new JTextArea(5, 5);
    protected JScrollPane textAreaScrollPane;
    protected String previousValue;
    protected String resetValue = "";
    protected Highlighter defaultHighlighter;
    private Font previousFont;
    private Color previousColor;

    public JCommTextArea() {
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.textArea);
        this.textArea.addKeyListener(this);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setDocument(new JCommDocument());
        this.textAreaScrollPane = new JScrollPane(this.textArea);
        this.textAreaScrollPane.setHorizontalScrollBarPolicy(30);
        this.textAreaScrollPane.setVerticalScrollBarPolicy(20);
        this.add(this.textAreaScrollPane);
        GridLayout g = new GridLayout(1, 1);
        this.setLayout(g);
        try {
            this.textArea.addFocusListener(this);
            this.initialized = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.actionName = "UpdateTextArea";
        this.defaultHighlighter = this.textArea.getHighlighter();
        this.originalBorder = this.textArea.getBorder();
        this.textArea.addMouseListener(this);
        this.textArea.add(new ActiveClient(this.textArea.getHeight(), this.textArea.getWidth()));
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        if (action.equalsIgnoreCase("UpdateTextArea")) {
            ((JCommDocument)this.textArea.getDocument()).locked = false;
            this.setText(input);
            if (this.getController().isStartStateInterface() && input != null && input.length() > 0) {
                ((JCommDocument)this.textArea.getDocument()).locked = true;
                this.textArea.setHighlighter(null);
                this.setFocusable(false);
            }
            return;
        }
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        }
        trace.out("**Error**: don't know interface action " + action);
    }

    @Override
    public MessageObject getDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        if (!this.initialize(this.getController())) {
            trace.out("ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return mo;
        }
        mo.setVerb("SendNoteProperty");
        mo.setProperty("WidgetType", "JCommTextArea");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate textArea (slot name) (slot value))";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String instanceStr = "(assert (textArea (name " + this.commName + ")))";
        instances.add(instanceStr);
        return instances;
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            ((JCommDocument)this.textArea.getDocument()).locked = false;
            this.textArea.setText(input);
            this.textArea.setForeground(this.correctColor);
            if (this.getController().getUniversalToolProxy().lockWidget()) {
                ((JCommDocument)this.textArea.getDocument()).locked = true;
                this.textArea.setHighlighter(null);
                this.removeHighlight("");
                this.setFocusable(false);
            }
            if (this.correctFont != null) {
                this.textArea.setFont(this.correctFont);
            }
        }
    }

    @Override
    public boolean getLock(String selection) {
        return ((JCommDocument)this.textArea.getDocument()).locked;
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        this.textArea.setText(input);
        this.textArea.setForeground(this.LISPCheckColor);
        if (this.getController().getUniversalToolProxy().lockWidget()) {
            ((JCommDocument)this.textArea.getDocument()).locked = true;
        }
        this.textArea.setHighlighter(null);
        this.setFocusable(false);
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        this.textArea.setText(input);
        this.textArea.setForeground(this.incorrectColor);
        ((JCommDocument)this.textArea.getDocument()).locked = false;
        this.textArea.setHighlighter(this.defaultHighlighter);
        this.setFocusable(true);
        if (this.incorrectFont != null) {
            this.textArea.setFont(this.incorrectFont);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!((JCommDocument)this.textArea.getDocument()).locked) {
            this.previousValue = this.textArea.getText();
            this.previousFont = this.textArea.getFont();
            this.previousColor = this.textArea.getForeground();
        }
        super.focusGained(e);
    }

    @Override
    public void highlight(String commComponentName, Border highlightBorder) {
        this.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.setBorder(this.originalBorder);
    }

    @Override
    public void setFocus(String subWidgetName) {
        this.textArea.requestFocus();
    }

    @Override
    public void focusLost(FocusEvent e) {
        Component oppComponent = e.getOppositeComponent();
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "JCommTextArea: focusLost oppComponent " + (oppComponent instanceof JCommWidget ? ((JCommWidget)oppComponent).getCommName() : oppComponent) + "\n locked " + ((JCommDocument)this.textArea.getDocument()).locked + ", definingStartState " + this.getController().isDefiningStartState() + ", previousValue " + this.previousValue + ", getText() " + this.getText());
        }
        if (!((JCommDocument)this.textArea.getDocument()).locked) {
            if (this.getController().isDefiningStartState() && !this.previousValue.equals(this.getText())) {
                this.setText(this.getText());
                this.dirty = true;
                this.setActionName("UpdateTextArea");
                this.getController().setStartStateModified(true);
                this.sendValue();
                return;
            }
            if (e.isTemporary()) {
                return;
            }
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "JCommTextArea: focusLost oppComponent " + (oppComponent instanceof JCommWidget ? ((JCommWidget)oppComponent).getCommName() : oppComponent));
            }
            if (!this.focusTriggersBackGrading(oppComponent)) {
                return;
            }
            if (this.getController().getUniversalToolProxy().getAutoCapitalize() || this.getAutoCapitalize()) {
                this.textArea.setText(this.textArea.getText().toUpperCase());
            }
            this.dirty = true;
            if (!this.textArea.getText().equals(this.previousValue)) {
                if (this.getController().isDefiningStartState()) {
                    this.getController().setStartStateModified(true);
                }
            } else if (this.textArea.getText().equals("")) {
                this.dirty = false;
            }
            if (this.dirty) {
                this.sendValue();
            }
            this.dirty = false;
        }
        super.focusLost(e);
    }

    @Override
    public Object getValue() {
        this.textArea.setForeground(this.startColor);
        return this.textArea.getText().trim();
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String text) {
        this.textArea.setText(text);
        this.previousValue = text;
    }

    @Override
    public void setFont(Font f) {
        if (this.textArea != null) {
            this.textArea.setFont(f);
        }
        super.setFont(f);
    }

    @Override
    public boolean isChangedFromResetState() {
        if (!this.textArea.getText().equals(this.resetValue)) {
            ((JCommDocument)this.textArea.getDocument()).locked = true;
            this.textArea.setHighlighter(null);
            this.setFocusable(false);
            return true;
        }
        return false;
    }

    public boolean resetStartStateLock(boolean startStateLock) {
        if (!this.textArea.getText().equals(this.resetValue)) {
            ((JCommDocument)this.textArea.getDocument()).locked = startStateLock;
            this.textArea.setHighlighter(null);
            this.setFocusable(!startStateLock);
            return true;
        }
        return false;
    }

    @Override
    public void setFocusable(boolean focusFlag) {
        super.setFocusable(focusFlag);
        this.textArea.setFocusable(focusFlag);
    }

    @Override
    public void reset(TutorController controller) {
        this.initialize(controller);
        ((JCommDocument)this.textArea.getDocument()).locked = false;
        this.textArea.setHighlighter(this.defaultHighlighter);
        this.setFocusable(true);
        this.textArea.setText(this.resetValue);
        this.previousValue = this.resetValue;
        this.textArea.setForeground(this.startColor);
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.dirty = true;
    }

    public void removeUpdate(DocumentEvent e) {
        this.dirty = true;
    }

    @Override
    public void setBackground(Color c) {
        if (this.textArea != null) {
            this.textArea.setBackground(c);
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.textArea.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        return this.textArea.getToolTipText();
    }

    @Override
    public void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        if (this.textArea != null) {
            this.textArea.addFocusListener(l);
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        if (this.textArea != null) {
            this.textArea.addMouseListener(l);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
        if (this.textArea != null) {
            this.textArea.addMouseMotionListener(l);
        }
    }

    @Override
    public MouseListener[] getMouseListeners() {
        if (this.textArea != null) {
            return this.textArea.getMouseListeners();
        }
        return null;
    }

    @Override
    public MouseMotionListener[] getMouseMotionListeners() {
        if (this.textArea != null) {
            return this.textArea.getMouseMotionListeners();
        }
        return null;
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener l) {
        if (this.textArea != null) {
            this.textArea.removeMouseMotionListener(l);
        }
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        if (this.textArea != null) {
            this.textArea.removeMouseListener(l);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.removeHighlight("");
        if (me.isControlDown() && this.getController().isDefiningStartState()) {
            ((JCommDocument)this.textArea.getDocument()).locked = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public boolean getWordWrap() {
        return this.textArea.getLineWrap() && this.textArea.getWrapStyleWord();
    }

    public void setWordWrap(boolean b) {
        if (b) {
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
        } else {
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (!((JCommDocument)this.textArea.getDocument()).locked) {
            this.textArea.setForeground(this.startColor);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }
}

