/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.CommManager.CommManager;
import edu.cmu.pact.CommManager.CommMessageHandler;
import edu.cmu.pact.CommManager.CommMessageReceiver;
import edu.cmu.pact.Utilities.ComponentDescription;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.client.HintMessagesManagerForClient;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import edu.cmu.pact.ctat.view.AvoidsBackGrading;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import pact.CommWidgets.FocusModel;
import pact.CommWidgets.HighlightThread;
import pact.CommWidgets.JCommButton;
import pact.CommWidgets.StudentInterfaceWrapper;
import pact.CommWidgets.UniversalToolProxy;
import pact.CommWidgets.event.HelpEvent;
import pact.CommWidgets.event.HelpEventListener;
import pact.CommWidgets.event.IncorrectActionEvent;
import pact.CommWidgets.event.IncorrectActionListener;
import pact.CommWidgets.event.ProblemDoneEvent;
import pact.CommWidgets.event.ProblemDoneListener;
import pact.CommWidgets.event.StudentActionEvent;
import pact.CommWidgets.event.StudentActionListener;

public abstract class JCommWidget
extends JPanel
implements FocusListener,
MouseListener,
CommMessageReceiver {
    private static TutorController controller;
    private CommMessageHandler universalToolProxy;
    protected static Font defaultFont;
    public static final String RESET = "reset";
    public String actionName = "";
    private Vector commSelectionVector = new Vector();
    protected String commName;
    protected String commSelection = "";
    protected String applicationName;
    protected boolean initialized;
    protected boolean dirty;
    protected boolean locked;
    protected boolean warningShown;
    protected Color startColor = Color.black;
    protected Color correctColor = Color.green.darker();
    protected Color incorrectColor = Color.red;
    protected Color LISPCheckColor = Color.yellow.darker();
    protected Color backgroundHighlightColor = Color.gray;
    protected Color backgroundMouseColor = Color.gray;
    protected Color backgroundNormalColor = Color.white;
    protected Font correctFont;
    protected Font incorrectFont;
    protected boolean updateEachCycle;
    protected boolean isHighlighted;
    protected boolean startStatelocked;
    private EventListenerList studentActionListeners;
    protected Border originalBorder;
    protected boolean isHintBtn = false;
    protected boolean autoCapitalize = false;
    protected boolean invisible = false;
    protected int delayTime = 0;
    public static final String DRAG_INTO = "DragInto";
    public static final String PLAY_AUDIO = "PlayAudio";
    public static final String UPDATE_CHOOSER = "UpdateChooser";
    public static final String UPDATE_COMBO_BOX = "UpdateComboBox";
    public static final String UPDATE_COMPOSER = "UpdateComposer";
    public static final String UPDATE_ICON = "UpdateIcon";
    public static final String UPDATE_MULTIPLE_CHOICE = "UpdateMultipleChoice";
    public static final String UPDATE_MULTIPLE_CHOICE_CHECK_BOX = "UpdateMultipleChoiceCheckBox";
    public static final String UPDATE_QUESTION_COMBO_BOX = "UpdateQuestionComboBox";
    public static final String UPDATE_QUESTION_TEXT_FIELD = "UpdateQuestionTextField";
    public static final String UPDATE_TABLE = "UpdateTable";
    public static final String UPDATE_TEXT = "UpdateText";
    public static final String UPDATE_TEXT_AREA = "UpdateTextArea";
    public static final String UPDATE_TEXT_FIELD = "UpdateTextField";
    public static final String UPDATE_AUDIO = "UpdateAudio";
    public static final String UPDATE_LIST = "UpdateList";
    public static final String UPDATE_INVISIBLE = "UpdateInVisible";
    public static final String UPDATE_BACKGROUNDCOLOR = "UpdateBackgroundColor";
    public static final String UPDATE_RADIO_BUTTON = "UpdateRadioButton";
    public static final String BUTTON_PRESSED = "ButtonPressed";
    public static final String SET_VISIBLE = "SetVisible";
    private static List<String> JavaActionNames;
    private static final List<String> JavaFixedSelectionNames;
    boolean highlighted = false;

    public static List<String> listActionNames() {
        return JavaActionNames;
    }

    protected static List<String> listFixedSelectionNames() {
        return JavaFixedSelectionNames;
    }

    public boolean getAutoCapitalize() {
        return this.autoCapitalize;
    }

    public void setAutoCapitalize(boolean autoCapitalize) {
        this.autoCapitalize = autoCapitalize;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public JCommWidget() {
        this.setCommSelectionVector(new Vector());
        this.studentActionListeners = new EventListenerList();
    }

    public boolean initialize(TutorController controller) {
        if (this.commName == null) {
            throw new NullPointerException();
        }
        JCommWidget.controller = controller;
        this.addCommWidgetName(this.commName);
        if (this.initialized) {
            return true;
        }
        this.commSelection = this.commName + " " + this.commSelection;
        this.setCommSelectionVector(this.getCommWidgets(this.commSelection));
        if (this.getUniversalToolProxy() != null && this.getUniversalToolProxy().getShowWidgetInfo()) {
            this.setToolTipWidgetInfo();
        }
        this.addCommListener(controller);
        this.setVisible(!this.isInvisible());
        this.initialized = true;
        return this.initialized;
    }

    public void setCommName(String commName) {
        this.setCommName(commName, this.getController());
    }

    public void setCommName(String commName, TutorController controller) {
        if (trace.getDebugCode("inter")) {
            trace.outNT("inter", this.getClass().getSimpleName() + ".setCommName(" + commName + ")");
        }
        JCommWidget.setController(controller);
        if (controller != null) {
            this.setUniversalToolProxy(controller.getUniversalToolProxy());
        }
        if (commName.equals("")) {
            return;
        }
        if (this.commName != null) {
            this.removeCommWidgetName(this.commName);
        }
        this.commName = commName;
        this.addCommWidgetName(commName);
        if (this.commName.equalsIgnoreCase("hint") || this.commName.equalsIgnoreCase("help")) {
            this.setHintBtn(true);
        }
    }

    public void setToolTipWidgetInfo() {
        this.setToolTipText("Comm name: " + this.commName + " Class: " + this.getClass().getName());
    }

    public String retrieveName() {
        if (this.commName == null) {
            return this.getClass().getName();
        }
        return this.commName;
    }

    @Override
    public void receiveMessage(MessageObject o) {
        String commComponentName = CommManager.extractComponentName(o);
        String showHighlight = (String)o.getProperty("Highlight");
        trace.out("--- showHighlight = " + showHighlight);
        if (showHighlight == null) {
            return;
        }
        if (showHighlight.equalsIgnoreCase("True")) {
            this.highlight(commComponentName, HintMessagesManagerForClient.defaultBorder);
        } else {
            this.removeHighlight(commComponentName);
        }
    }

    protected void addCommListener(TutorController controller2) {
        this.addCommListener(this.commName, controller2);
    }

    protected void addCommListener(String componentName, TutorController controller2) {
        if (VersionInformation.includesCL()) {
            CommManager.addCommListener(componentName, this, controller2);
        }
    }

    public Vector getCommWidgets(String commNames) {
        if (!this.hasController()) {
            return null;
        }
        Vector<JCommWidget> v = new Vector<JCommWidget>();
        StringTokenizer st = new StringTokenizer(commNames);
        while (st.hasMoreElements()) {
            JCommWidget t = this.getController().getCommWidget((String)st.nextElement());
            if (t == null) {
                return null;
            }
            v.addElement(t);
        }
        return v;
    }

    public void sendValue() {
        if (!this.dirty) {
            return;
        }
        MessageObject mo = this.getCurrentStateMessage();
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "JCommWidget.sendValue(" + mo + ")");
        }
        this.getUniversalToolProxy().sendMessage(mo);
        this.dirty = false;
    }

    public Vector<MessageObject> getCurrentState() {
        Vector<MessageObject> v = new Vector<MessageObject>();
        v.addElement(this.getCurrentStateMessage());
        return v;
    }

    public MessageObject getDescriptionMessage(String widgetName) {
        return this.getDescriptionMessage();
    }

    public MessageObject getDescriptionMessage() {
        return null;
    }

    protected void serializeGraphicalProperties(MessageObject messageObject) {
        ComponentDescription cd = new ComponentDescription(this);
        cd.serializeGraphicalProperties(messageObject);
    }

    public boolean getLock(String selection) {
        return false;
    }

    public MessageObject getCurrentStateMessage() {
        MessageObject mo = MessageObject.create("InterfaceAction");
        mo.setVerb("NotePropertySet");
        if (!this.initialize(this.getController())) {
            trace.err("error: initialization failed.  Returning empty comm message");
            return mo;
        }
        Vector<String> selection = new Vector<String>();
        Vector<String> action = new Vector<String>();
        Vector<String> input = new Vector<String>();
        String currentAction = "";
        for (int i = 0; i < this.getCommSelectionVector().size(); ++i) {
            JCommWidget dw = (JCommWidget)this.getCommSelectionVector().elementAt(i);
            if (dw == null) {
                return null;
            }
            selection.addElement(dw.getCommNameToSend());
            currentAction = dw.getActionName();
            action.addElement(currentAction);
            input.addElement((String)dw.getValue());
        }
        if (trace.getDebugCode("hint")) {
            trace.out("hint", "JCWidget.getCurrentStateMessage() s=" + selection + ", a=" + action + ", i=" + input + ", lastFocus " + FocusModel.getLastFocus());
        }
        if (!(currentAction.equalsIgnoreCase(UPDATE_ICON) || currentAction.equalsIgnoreCase(UPDATE_AUDIO) || currentAction.equalsIgnoreCase(UPDATE_TEXT) || currentAction.equalsIgnoreCase(UPDATE_BACKGROUNDCOLOR) || currentAction.equalsIgnoreCase(UPDATE_LIST) || !this.commName.equalsIgnoreCase("Hint") && !this.commName.equalsIgnoreCase("Help"))) {
            String previous = "";
            if (FocusModel.getLastFocus() != null) {
                JCommWidget d;
                previous = FocusModel.getLastFocus();
                JCommWidget jCommWidget = d = this.hasController() ? this.getController().getCommWidget(previous) : null;
                if (d == null || d.getLock(previous)) {
                    previous = "";
                }
            }
            if (previous.equals("")) {
                previous = "Hint";
            }
            selection.addElement(previous);
            action.addElement("PreviousFocus");
        }
        mo.setSelection(selection);
        mo.setAction(action);
        mo.setInput(input);
        mo.setTransactionId(mo.makeTransactionId());
        return mo;
    }

    public void setUpdateEachCycle(boolean update) {
        this.updateEachCycle = update;
    }

    public boolean getUpdateEachCycle() {
        return this.updateEachCycle;
    }

    public boolean isChangedFromResetState() {
        return false;
    }

    protected Component getNativeComponent() {
        Component result = null;
        try {
            result = this.getComponent(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (trace.getDebugCode("dw")) {
            trace.out("getNativeComponent() => " + (result == null ? null : result.getClass().getSimpleName() + " " + result.getName()));
        }
        return result;
    }

    @Override
    public void setForeground(Color fg) {
        Component nc = this.getNativeComponent();
        if (nc != null) {
            nc.setForeground(fg);
        }
    }

    @Override
    public Color getForeground() {
        Component nc = this.getNativeComponent();
        return nc != null ? nc.getForeground() : null;
    }

    public void startHighlight(String subElement) {
        HighlightThread t = new HighlightThread(this, subElement);
        t.start();
    }

    @Override
    public void setFocusable(boolean focuseFlag) {
        super.setFocusable(focuseFlag);
        Component[] allComponents = this.getComponents();
        for (int i = 0; i < allComponents.length; ++i) {
            Component tempComponent = allComponents[i];
            tempComponent.setFocusable(focuseFlag);
        }
    }

    void toggleHighlight() {
        if (this.isHighlighted()) {
            this.removeHighlight();
        } else {
            this.highlight();
        }
    }

    public void highlight(String subElement, Border border) {
    }

    public void highlight() {
        this.setOriginalBorder(this.getBorder());
        this.setBorder(HintMessagesManagerForClient.defaultBorder);
        this.setHighlighted(true);
    }

    public void removeHighlight(String subElement) {
        if (trace.getDebugCode("mps")) {
            trace.out("mps", this.getClass().getSimpleName() + ".removeHighlight(" + subElement + ") is called");
        }
        this.setBackground(this.backgroundNormalColor);
        this.repaint();
    }

    public void removeHighlight() {
        this.setBorder(this.originalBorder);
        this.repaint();
        this.setHighlighted(false);
    }

    public abstract void reset(TutorController var1);

    public void unlockWidget() {
    }

    public void doCorrectAction(String selection, String input) {
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "doCorrectAction: selection = " + selection + " input = " + input);
        }
        this.fireStudentAction(new StudentActionEvent(this));
    }

    public void doCorrectAction(String selection, String action, String input) {
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "doCorrectAction: selection = " + selection + " action = " + action + " input = " + input);
        }
        if (SET_VISIBLE.equalsIgnoreCase(action)) {
            this.setVisible(input);
        } else if (RESET.equalsIgnoreCase(action)) {
            this.reset(this.getController());
        } else {
            this.doCorrectAction(selection, input);
        }
    }

    protected void setVisible(String input) {
        boolean v = Boolean.valueOf(input);
        this.setVisible(v);
    }

    public boolean getVisible() {
        return this.isVisible();
    }

    public void doLISPCheckAction(String selection, String input) {
    }

    public void doLISPCheckAction(String selection, String action, String input) {
        this.doLISPCheckAction(selection, input);
    }

    public void doIncorrectAction(String selection, String input) {
    }

    public void doIncorrectAction(String selection, String action, String input) {
        this.doIncorrectAction(selection, input);
    }

    public String getCommName() {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", this.getClass().getSimpleName() + ".getCommName() returns " + this.commName + ";");
        }
        return this.commName;
    }

    public void removeCommWidgetName(String commName) {
        if (!this.hasController()) {
            return;
        }
        this.getController().getCommWidgetTable().remove(commName);
    }

    public boolean addCommWidgetName(String commName) {
        if (!this.hasController()) {
            return false;
        }
        this.getController().getCommWidgetTable().put(commName, this);
        return true;
    }

    public String getCommNameToSend() {
        return this.commName;
    }

    public Object getValue() {
        return null;
    }

    public void doInterfaceAction(String selection, String action, String input) {
    }

    public void doInterfaceDescription(MessageObject messageObject) {
        ComponentDescription cd = new ComponentDescription(this);
        cd.executeGraphicalProperties(messageObject);
    }

    public void setCommSelection(String commSelection) {
        this.commSelection = commSelection;
    }

    public String getCommSelection() {
        return this.commSelection;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setCorrectColor(Color correctColor) {
        this.correctColor = correctColor;
    }

    public Color getCorrectColor() {
        return this.correctColor;
    }

    public void setIncorrectColor(Color incorrectColor) {
        this.incorrectColor = incorrectColor;
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setStartColor(Color startColor) {
        this.startColor = startColor;
    }

    public void setLISPCheckColor(Color lispColor) {
        this.LISPCheckColor = lispColor;
    }

    public Color getLISPCheckColor() {
        return this.LISPCheckColor;
    }

    public Color getIncorrectColor() {
        return this.incorrectColor;
    }

    public void setCorrectFont(Font correctFont) {
        this.correctFont = correctFont;
    }

    public Font getCorrectFont() {
        return this.correctFont;
    }

    public void setIncorrectFont(Font incorrectFont) {
        this.incorrectFont = incorrectFont;
    }

    public Font getIncorrectFont() {
        return this.incorrectFont;
    }

    public void setFocus(String subWidgetName) {
        this.requestFocus();
    }

    public void moveFocus() {
    }

    @Override
    public void focusGained(FocusEvent e) {
        FocusModel.tookFocus(this);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void setEditable(boolean setFlag) {
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultFont(Font font) {
        defaultFont = font;
    }

    public void addStudentActionListener(StudentActionListener l) {
        this.studentActionListeners.add(StudentActionListener.class, l);
    }

    public void removeStudentActionListener(StudentActionListener l) {
        this.studentActionListeners.remove(StudentActionListener.class, l);
    }

    public EventListener[] getStudentActionListener() {
        return this.studentActionListeners.getListeners(StudentActionListener.class);
    }

    public void fireStudentAction(StudentActionEvent e) {
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "Inside fireStudentAction: " + e);
        }
        Object[] listeners = this.studentActionListeners.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != StudentActionListener.class) continue;
            ((StudentActionListener)listeners[i + 1]).studentActionPerformed(e);
        }
    }

    public void addIncorrectActionListener(IncorrectActionListener l) {
        this.studentActionListeners.add(IncorrectActionListener.class, l);
    }

    public void removeIncorrectActionListener(IncorrectActionListener l) {
        this.studentActionListeners.remove(IncorrectActionListener.class, l);
    }

    public void fireIncorrectAction(IncorrectActionEvent e) {
        Object[] listeners = this.studentActionListeners.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != IncorrectActionListener.class) continue;
            ((IncorrectActionListener)listeners[i + 1]).incorrectActionPerformed(e);
        }
    }

    public boolean isHintBtn() {
        return this.isHintBtn;
    }

    public void setHintBtn(boolean isHintBtn) {
        this.isHintBtn = isHintBtn;
    }

    public void addProblemDoneListener(ProblemDoneListener l) {
        EventListener[] obj = this.studentActionListeners.getListeners(ProblemDoneListener.class);
        if (obj == null || obj.length == 0) {
            this.studentActionListeners.add(ProblemDoneListener.class, l);
            return;
        }
        for (int i = 0; i < obj.length; ++i) {
            if (!obj[i].equals(l)) continue;
            return;
        }
        this.studentActionListeners.add(ProblemDoneListener.class, l);
    }

    public void removeProblemDoneListener(ProblemDoneListener l) {
        this.studentActionListeners.remove(ProblemDoneListener.class, l);
    }

    public void removeAllProblemDoneListeners() {
        EventListener[] obj = this.studentActionListeners.getListeners(ProblemDoneListener.class);
        for (int i = 0; i < obj.length; ++i) {
            this.studentActionListeners.remove(ProblemDoneListener.class, (ProblemDoneListener)obj[i]);
        }
    }

    public void fireProblemDoneEvent(ProblemDoneEvent e) {
        Object[] listeners = this.studentActionListeners.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != ProblemDoneListener.class) continue;
            ((ProblemDoneListener)listeners[i + 1]).problemDone(e);
        }
    }

    public void addHelpEventListener(HelpEventListener listener) {
        EventListener[] obj = this.studentActionListeners.getListeners(HelpEventListener.class);
        if (obj == null || obj.length == 0) {
            this.studentActionListeners.add(HelpEventListener.class, listener);
            return;
        }
        for (int i = 0; i < obj.length; ++i) {
            if (!obj[i].equals(listener)) continue;
            return;
        }
        this.studentActionListeners.add(HelpEventListener.class, listener);
    }

    public void removeHelpEventListener(HelpEventListener listener) {
        this.studentActionListeners.remove(HelpEventListener.class, listener);
    }

    public void removeAllHelpListeners() {
        EventListener[] obj = this.studentActionListeners.getListeners(HelpEventListener.class);
        for (int i = 0; i < obj.length; ++i) {
            this.studentActionListeners.remove(HelpEventListener.class, (HelpEventListener)obj[i]);
        }
    }

    public void fireHelpEvent(HelpEvent event) {
        Object[] listeners = this.studentActionListeners.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != HelpEventListener.class) continue;
            ((HelpEventListener)listeners[i + 1]).helpSeeked(event);
        }
    }

    protected void setCommSelectionVector(Vector commSelectionVector) {
        if (trace.getDebugCode("dw")) {
            trace.out("dw", " set comm selection vector: " + commSelectionVector);
        }
        this.commSelectionVector = commSelectionVector;
    }

    protected Vector getCommSelectionVector() {
        if (this.commSelectionVector == null) {
            this.commSelectionVector = new Vector();
        }
        return this.commSelectionVector;
    }

    public static void setController(TutorController _controller) {
        controller = _controller;
    }

    public TutorController getController() {
        return controller;
    }

    private boolean hasController() {
        return this.getController() != null;
    }

    public void setUniversalToolProxy(CommMessageHandler universalToolProxy) {
        this.universalToolProxy = universalToolProxy;
    }

    public CommMessageHandler getUniversalToolProxy() {
        if (this.universalToolProxy != null) {
            return this.universalToolProxy;
        }
        return controller == null ? null : this.getController().getUniversalToolProxy();
    }

    public void mouseDoubleClickedWhenMissActive(MouseEvent me) {
        JCommWidget widget = (JCommWidget)me.getComponent();
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "JCommWidget.mouseDoubleClickedWhenMissActive(" + widget + ")");
        }
        widget.toggleHighlight();
        if (this.hasController()) {
            this.getController().toggleWidgetFocusForSimSt(widget);
        }
    }

    public Border getOriginalBorder() {
        return this.originalBorder;
    }

    public void setOriginalBorder(Border originalBorder) {
        this.originalBorder = originalBorder;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    public static MessageObject createUntutoredActionMessage(Vector<String> s, Vector<String> a, Vector<String> in, UniversalToolProxy utp) {
        MessageObject mo = MessageObject.create("UntutoredAction");
        mo.setVerb("NotePropertySet");
        mo.setSelection(s);
        mo.setAction(a);
        mo.setInput(in);
        return mo;
    }

    public boolean focusTriggersBackGrading(Component gainedFocus) {
        return !(gainedFocus instanceof AvoidsBackGrading);
    }

    public Component getStudentInterfaceFrame() {
        StudentInterfaceWrapper siw;
        if (controller == null || (siw = controller.getStudentInterface()) == null) {
            return null;
        }
        return siw.getActiveWindow();
    }

    public boolean isDoneButton() {
        return this instanceof JCommButton && "Done".equalsIgnoreCase(this.getCommNameToSend());
    }

    public static Boolean clientSupports(String msgType) {
        if ("StartStateMessages".equalsIgnoreCase(msgType)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    static {
        defaultFont = new Font("Verdana", 0, 10);
        JavaActionNames = null;
        String[] arr = new String[]{DRAG_INTO, UPDATE_MULTIPLE_CHOICE_CHECK_BOX, UPDATE_AUDIO, PLAY_AUDIO, UPDATE_QUESTION_COMBO_BOX, UPDATE_LIST, UPDATE_CHOOSER, UPDATE_QUESTION_TEXT_FIELD, UPDATE_INVISIBLE, UPDATE_COMBO_BOX, UPDATE_TABLE, UPDATE_BACKGROUNDCOLOR, UPDATE_COMPOSER, UPDATE_TEXT, UPDATE_RADIO_BUTTON, UPDATE_ICON, UPDATE_TEXT_AREA, BUTTON_PRESSED, UPDATE_MULTIPLE_CHOICE, UPDATE_TEXT_FIELD, SET_VISIBLE};
        Arrays.sort(arr, String.CASE_INSENSITIVE_ORDER);
        JavaActionNames = Arrays.asList(arr);
        JavaFixedSelectionNames = Arrays.asList(new String[0]);
    }

    static enum C {
        lightGray(Color.LIGHT_GRAY),
        lightGreen(new Color(153, 255, 153)),
        lightBlue(new Color(153, 153, 255)),
        lightRed(new Color(255, 153, 153)),
        lightPurple(new Color(255, 153, 255)),
        lightCyan(new Color(153, 255, 255)),
        lightYellow(new Color(255, 255, 153)),
        red(Color.RED),
        blue(Color.BLUE),
        green(Color.GREEN),
        cyan(Color.CYAN),
        gray(new Color(170, 170, 170)),
        orange(Color.ORANGE),
        black(Color.BLACK),
        yellow(Color.YELLOW),
        pink(Color.PINK),
        white(new Color(255, 255, 255));

        private final Color color;

        private C(Color color) {
            this.color = color;
        }

        public static Color get(String name) {
            for (C a : C.values()) {
                if (!a.toString().equals(name)) continue;
                return a.color;
            }
            return null;
        }
    }
}

