/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.oli.log.client.CurriculumLog;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.TutorController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import pact.CommWidgets.JCommDrawingPad;

class Scribble
extends Component
implements ActionListener {
    private static final Color colorArray = null;
    protected short last_x;
    protected short last_y;
    protected Vector lines = new Vector(256, 256);
    protected Color current_color = Color.black;
    protected int width;
    protected int height;
    protected PopupMenu popup;
    protected Frame frame;
    protected JCommDrawingPad drawingPad;
    CurriculumLog CurriculumLog = new CurriculumLog();
    protected String imageFileName = this.CurriculumLog.getUserGuid();
    protected int imageFileNameIndex = 0;
    Graphics g;
    final Color[] colorList = new Color[]{Color.BLACK, Color.RED, Color.ORANGE, Color.GREEN, Color.BLUE, Color.MAGENTA, Color.PINK, Color.GRAY};
    TutorController controller;
    private String fileSavingDirectory = ".";
    boolean directoryCreated = false;
    boolean imageSaved = false;
    private static Properties printprefs = new Properties();
    public static final DataFlavor dataFlavor = new DataFlavor(Vector.class, "ScribbleVectorOfLines");

    public Scribble(Frame frame, int width, int height, JCommDrawingPad drawingPad) {
        this.frame = frame;
        this.width = width;
        this.height = height;
        this.drawingPad = drawingPad;
        if (this.imageFileName == null) {
            this.imageFileName = "test";
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
        String[] labels = new String[]{"Clear", "Submit"};
        String[] commands = new String[]{"clear", "save"};
        this.popup = new PopupMenu();
        for (int i = 0; i < labels.length; ++i) {
            MenuItem mi = new MenuItem(labels[i]);
            mi.setActionCommand(commands[i]);
            mi.addActionListener(this);
            this.popup.add(mi);
        }
        Menu colors = new Menu("Color");
        String[] colornames = new String[]{"Black", "Red", "Green", "Blue"};
        for (int i = 0; i < colornames.length; ++i) {
            MenuItem mi = new MenuItem(colornames[i]);
            mi.setActionCommand(colornames[i]);
            mi.addActionListener(this);
            colors.add(mi);
        }
        this.add(this.popup);
    }

    protected void paintComponent(Graphics graphics) {
        Graphics g = graphics.create();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, this.width, this.height);
        g.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("clear")) {
            this.clear();
        } else if (command.equals("print")) {
            this.print();
        } else if (command.equals("save")) {
            this.autoSave();
        } else if (command.equals("load")) {
            this.load();
        } else if (command.equals("cut")) {
            this.cut();
        } else if (command.equals("copy")) {
            this.copy();
        } else if (command.equals("paste")) {
            this.paste();
        } else if (command.equals("Black")) {
            this.current_color = Color.black;
        } else if (command.equals("Red")) {
            this.current_color = Color.red;
        } else if (command.equals("Green")) {
            this.current_color = Color.green;
        } else if (command.equals("Blue")) {
            this.current_color = Color.blue;
        }
    }

    @Override
    public void paint(Graphics g) {
        for (int i = 0; i < this.lines.size(); ++i) {
            Line l = (Line)this.lines.elementAt(i);
            g.setColor(l.color);
            g.drawLine(l.x1, l.y1, l.x2, l.y2);
        }
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show(this, e.getX(), e.getY());
        } else if (e.getID() == 501) {
            this.current_color = this.colorList[this.getImageFileNameIndex() % this.colorList.length];
            this.last_x = (short)e.getX();
            this.last_y = (short)e.getY();
            this.imageSaved = false;
        } else {
            super.processMouseEvent(e);
        }
    }

    @Override
    public void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506) {
            this.g = this.getGraphics();
            this.g.setColor(Color.BLACK);
            this.g.drawLine(this.last_x, this.last_y, e.getX(), e.getY());
            this.lines.addElement(new Line(this.last_x, this.last_y, (short)e.getX(), (short)e.getY(), this.current_color));
            this.last_x = (short)e.getX();
            this.last_y = (short)e.getY();
        } else {
            super.processMouseMotionEvent(e);
        }
    }

    public void clear() {
        this.lines.removeAllElements();
        this.imageSaved = true;
        this.imageFileNameIndex = 0;
        this.repaint();
    }

    void print() {
        Toolkit toolkit = this.getToolkit();
        PrintJob job = toolkit.getPrintJob(this.frame, "Scribble", printprefs);
        if (job == null) {
            return;
        }
        Graphics page = job.getGraphics();
        Dimension size = this.getSize();
        Dimension pagesize = job.getPageDimension();
        page.translate((pagesize.width - size.width) / 2, (pagesize.height - size.height) / 2);
        page.drawRect(-1, -1, size.width + 1, size.height + 1);
        page.setClip(0, 0, size.width, size.height);
        this.print(page);
        page.dispose();
        job.end();
    }

    public void copy() {
        Clipboard c = this.getToolkit().getSystemClipboard();
        SimpleSelection s = new SimpleSelection(this.lines.clone(), dataFlavor);
        c.setContents(s, s);
    }

    public void cut() {
        this.copy();
        this.clear();
    }

    public void paste() {
        Clipboard c = this.getToolkit().getSystemClipboard();
        Transferable t = c.getContents(this);
        if (t == null) {
            this.getToolkit().beep();
            return;
        }
        try {
            Vector newlines = (Vector)t.getTransferData(dataFlavor);
            for (int i = 0; i < newlines.size(); ++i) {
                this.lines.addElement(newlines.elementAt(i));
            }
            this.repaint();
        }
        catch (UnsupportedFlavorException e) {
            this.getToolkit().beep();
        }
        catch (Exception e) {
            this.getToolkit().beep();
        }
    }

    public void save() {
        File file = DialogUtilities.chooseFile(null, null, "Save Scribble", "Save", (BR_Controller)this.controller);
        if (file != null) {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                GZIPOutputStream gzos = new GZIPOutputStream(fos);
                ObjectOutputStream out = new ObjectOutputStream(gzos);
                out.writeObject(this.lines);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }

    public void autoSave() {
        this.controller = this.drawingPad.getController();
        this.saveImage(this.getFileSavingDirectory() + "/" + this.getImageFileName() + ".jpeg");
        this.clear();
    }

    public void load() {
        File file = DialogUtilities.chooseFile(null, null, "Load Scribble", "Load", (BR_Controller)this.controller);
        if (file != null) {
            try {
                FileInputStream fis = new FileInputStream(file);
                GZIPInputStream gzis = new GZIPInputStream(fis);
                ObjectInputStream in = new ObjectInputStream(gzis);
                Vector newlines = (Vector)in.readObject();
                in.close();
                this.lines = newlines;
                this.repaint();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public void saveImage(String fileName) {
        if (this.imageSaved) {
            return;
        }
        if (fileName == null) {
            return;
        }
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "saveImage filename = " + fileName);
        }
        try {
            int width = this.getWidth();
            int height = this.getHeight();
            Image image = this.createImage(width, height);
            this.paint(image.getGraphics());
            int thumbWidth = this.getWidth();
            int thumbHeight = this.getHeight();
            BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
            Graphics2D graphics2D = thumbImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(image, 0, 0, width, height, null);
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpeg");
            if (writers == null || !writers.hasNext()) {
                trace.err("JCommDrawingPad.saveImage(\"" + fileName + "\"): no image writers for jpeg");
                return;
            }
            ImageWriter writer = writers.next();
            File f = new File(fileName);
            ImageOutputStream ios = ImageIO.createImageOutputStream(f);
            writer.setOutput(ios);
            ImageWriteParam iwp = new ImageWriteParam(){
                {
                    this.compressionQuality = 1.0f;
                }
            };
            writer.write(null, new IIOImage(thumbImage, null, null), iwp);
            ios.flush();
            ios.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public String getImageFileName() {
        String problemFile = this.controller.getLogger().getProblemName();
        String FileNameHeader = problemFile.length() == 0 ? Character.toString((char)((this.getImageFileNameIndex() + 65) % 90)) : problemFile;
        Date lastEvaluationTime = new Date();
        System.out.println("FileNameHeader =" + FileNameHeader);
        String FileNameIndex = FileNameHeader + "_" + Integer.toString(lastEvaluationTime.getDate()) + "_" + Integer.toString(lastEvaluationTime.getHours()) + "_" + Integer.toString(lastEvaluationTime.getMinutes()) + "_" + Integer.toString(lastEvaluationTime.getSeconds());
        System.out.println("FileNameIndex =" + FileNameIndex);
        return FileNameIndex;
    }

    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
    }

    public int getImageFileNameIndex() {
        return this.imageFileNameIndex++;
    }

    public void setImageFileNameIndex(int imageFileNameIndex) {
        this.imageFileNameIndex = imageFileNameIndex;
    }

    public String getScribbleSavingFolder() {
        boolean success;
        String defaultMappingDiskName = "L:";
        String studentFolderName = "CCWTemp";
        String problemFile = "test";
        if (this.controller.getLogger() != null) {
            studentFolderName = this.controller.getLogger().getStudentName();
            problemFile = this.controller.getLogger().getProblemName();
        }
        System.out.println("studentFolderName =" + studentFolderName);
        System.out.println("problemFile =" + problemFile);
        String currentDir = defaultMappingDiskName + "/" + studentFolderName;
        File file = new File(currentDir);
        if (!file.exists() && (success = new File(currentDir).mkdirs())) {
            System.out.println("Remote Disk Directories: " + this.fileSavingDirectory + " created");
        }
        return currentDir;
    }

    public String getFileSavingDirectory() {
        if (!this.directoryCreated) {
            this.fileSavingDirectory = this.getScribbleSavingFolder();
        }
        return this.fileSavingDirectory;
    }

    public void setFileSavingDirectory(String fileSavingDirectory) {
        this.fileSavingDirectory = fileSavingDirectory;
    }

    static class Line
    implements Serializable {
        public short x1;
        public short y1;
        public short x2;
        public Color color;
        public short y2;

        public Line(short x1, short y1, short x2, short y2, Color c) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.color = c;
        }
    }

    static class SimpleSelection
    implements Transferable,
    ClipboardOwner {
        protected Object selection;
        protected DataFlavor flavor;

        public SimpleSelection(Object selection, DataFlavor flavor) {
            this.selection = selection;
            this.flavor = flavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor f) {
            return f.equals(this.flavor);
        }

        @Override
        public Object getTransferData(DataFlavor f) throws UnsupportedFlavorException {
            if (f.equals(this.flavor)) {
                return this.selection;
            }
            throw new UnsupportedFlavorException(f);
        }

        @Override
        public void lostOwnership(Clipboard c, Transferable t) {
            this.selection = null;
        }
    }
}

