/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.client.HintMessagesManagerForClient;
import edu.cmu.pact.ctat.CtatLMSClient;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import edu.cmu.pact.ctat.view.AbstractCtatWindow;
import edu.cmu.pact.miss.SimStWrapperSupport;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import pact.CommWidgets.Login;
import pact.CommWidgets.UniversalToolProxy;
import pact.CommWidgets.WrapperSupport;

public class TutorWindow
extends AbstractCtatWindow
implements MouseListener {
    public static final String LOGOUT_TEXT = "Save and Log Out";
    public static final String LOGIN_TEXT = "Log In";
    private JMenuItem retractOneStepMenu;
    JMenu authorMenu;
    JMenu fileMenu;
    JMenuItem advanceProblemMenuItem;
    JMenuItem logoutMenuItem;
    JMenuItem lmsLoginMenuItem;
    Container contentPane;
    Login loginWindow;
    boolean showLoginWindow = false;
    String fileName;
    String userName;
    private UniversalToolProxy utp;
    private JMenuBar menuBar;
    protected final WrapperSupport wrapperSupport = VersionInformation.isRunningSimSt() && !Utils.isRuntime() ? new SimStWrapperSupport(this.getContentPane()) : new WrapperSupport(this.getContentPane());
    protected String studentConfirmQuitQuestion = "Do you want to save your work and log out?";

    protected TutorController getBRController() {
        return this.wrapperSupport.getController();
    }

    public TutorWindow(TutorController controller) {
        super(controller.getServer());
        this.setTitle("Student Interface");
        this.setName("Student Interface");
        this.wrapperSupport.setController(controller);
        this.utp = this.wrapperSupport.getController().getUniversalToolProxy();
        this.setDockable(false);
    }

    @Override
    public void setVisible(boolean visible) {
        if (trace.getDebugCode("wh")) {
            trace.printStack("wh", "tutorWindow");
        }
        super.setVisible(visible);
    }

    public void initTutorWindow() {
        this.addMenus();
        this.setCloseOperation();
        this.applyPreferences();
        this.studentConfirmQuitQuestion = this.wrapperSupport.getController().getPreferencesModel().getStringValue("Student Confirm Quit Question");
        Boolean loginWindowValue = this.wrapperSupport.getController().getPreferencesModel().getBooleanValue("Login Window");
        if (loginWindowValue != null) {
            this.showLoginWindow(loginWindowValue);
        }
    }

    private void setCloseOperation() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (trace.getDebugCode("close")) {
                    trace.out("close", "windowClosing event " + e);
                }
                TutorWindow.this.doLogout();
            }
        });
    }

    protected void showLoginWindow(boolean loginWindowValue) {
        this.showLoginWindow = loginWindowValue;
        if (this.showLoginWindow) {
            this.utp.showLogin();
            if (trace.getDebugCode("log")) {
                trace.out("log", this.wrapperSupport.getController().getLogger().getStudentName());
            }
        } else {
            this.userName = this.wrapperSupport.getController().getLogger().getStudentName();
            if (trace.getDebugCode("log")) {
                trace.out("log", "TutorWindow.userName from logger " + this.userName);
            }
        }
    }

    protected void addMenus() {
        if (trace.getDebugCode("options")) {
            trace.out("options", "TUTOR WINDOW: ADD MENUS NOW");
        }
        this.fileMenu = new JMenu("Student");
        this.logoutMenuItem = new JMenuItem(LOGOUT_TEXT);
        this.lmsLoginMenuItem = new JMenuItem(LOGIN_TEXT);
        this.authorMenu = new JMenu("Teacher");
        this.advanceProblemMenuItem = new JMenuItem("Advance Problem");
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.menuBar.add(this.fileMenu);
        this.fileMenu.add(this.lmsLoginMenuItem);
        this.lmsLoginMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TutorWindow.this.doLMSLogin();
            }
        });
        this.fileMenu.add(this.logoutMenuItem);
        this.logoutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TutorWindow.this.doLogout();
            }
        });
        this.retractOneStepMenu = new JMenuItem("Retract Last Step");
        this.retractOneStepMenu.setMnemonic(82);
        this.fileMenu.add(this.retractOneStepMenu);
        this.retractOneStepMenu.addActionListener(this.wrapperSupport);
        this.retractOneStepMenu.setEnabled(true);
        this.retractOneStepMenu.setVisible(false);
        this.retractOneStepMenu.setAccelerator(KeyStroke.getKeyStroke(37, 8));
    }

    protected void doLMSLogin() {
    }

    public void showAdvanceProblemMenuItem() {
        trace.out("options", "DISPLAY ADVANCE PROBLEM MENU NOW");
        this.menuBar.add(this.authorMenu);
        this.authorMenu.add(this.advanceProblemMenuItem);
        this.advanceProblemMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TutorWindow.this.doAdvanceProblemConfirm();
            }
        });
    }

    void doAdvanceProblemConfirm() {
        JPasswordField passwordField = new JPasswordField(20);
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(new Object[]{"Please enter your password:", passwordField});
        optionPane.setMessageType(3);
        optionPane.setOptionType(2);
        JDialog dialog = optionPane.createDialog(this.getActiveWindow(), "Password");
        for (int tryTimes = 0; tryTimes < 4; ++tryTimes) {
            dialog.show();
            Integer value = (Integer)optionPane.getValue();
            dialog.dispose();
            if (value == null || value == 2) {
                return;
            }
            String password = String.valueOf(passwordField.getPassword());
            if (password.equals("pact123")) {
                CtatLMSClient ctatLms = this.utp.getController().getCTAT_LMS();
                if (ctatLms != null) {
                    trace.out("inter", "doAdvanceProblemConfirm =>  doneActionPerformed");
                    this.wrapperSupport.doneActionPerformed();
                } else {
                    MessageObject newMessage = MessageObject.create("AdvanceProblem");
                    newMessage.setVerb("NotePropertySet");
                    newMessage.addPropertyElement("Object", (Object)this.utp.getToolProxy());
                    this.utp.sendProperty(newMessage);
                    trace.out(5, this, "send message 'AdvanceProblem' to Lisp Tutor: " + newMessage.toString());
                }
                return;
            }
            optionPane.setMessage(new Object[]{"Wrong password. Please enter your password:", passwordField});
            dialog = optionPane.createDialog(this, "Password");
            passwordField.setText("");
        }
    }

    public void setLogoutMenu(String newOption) {
        this.logoutMenuItem.setText(newOption);
    }

    public void doLogout() {
        this.doLogout(true, true);
    }

    public void doLogout(boolean confirm, boolean saveBrdFile) {
        int result = 0;
        if (confirm) {
            result = this.studentConfirmQuitQuestion != null && this.studentConfirmQuitQuestion.length() > 0 ? JOptionPane.showConfirmDialog(this, this.studentConfirmQuitQuestion, "Log out", 0) : 0;
        }
        if (result != 0) {
            return;
        }
        TutorController controller = this.wrapperSupport.getController();
        if (controller == null) {
            trace.err("TutorWindow.doLogout(): null controller from WrapperSupport " + this.wrapperSupport);
            return;
        }
        controller.closeStudentInterface();
        TutorWindow.doLogout(saveBrdFile, controller);
    }

    private static void doLogout(boolean saveBrdFile, TutorController controller) {
        if (controller.getUniversalToolProxy() != null) {
            MessageObject mo = MessageObject.create("doLogout");
            mo.setVerb("NotePropertySet");
            controller.getUniversalToolProxy().sendProperty(mo);
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (controller.getCtatModeModel().isTDKMode() && controller.getProblemModel().isProblemLoadedFromLispTutor()) {
            if (trace.getDebugCode("lisp")) {
                trace.out("lisp", "start saving traversed path.");
            }
            controller.saveTraversedPathFile();
        }
        if (controller != null && controller.getCtatModeModel() != null && controller.getCtatModeModel().isSimStudentMode() && controller.getServer().getMissController() != null && controller.getMissController().getSimSt() != null && controller.getServer().getMissController().getSimSt().isWebStartMode()) {
            controller.getServer().getMissController().getSimSt().archiveAndSaveFilesOnLogout();
        }
        controller.closeApplication(saveBrdFile);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        ((HintMessagesManagerForClient)this.wrapperSupport.getHintMessagesManager()).tutorWindowClicked(arg0);
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public WrapperSupport getWrapperSupport() {
        return this.wrapperSupport;
    }
}

