/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import cl.ui.tools.tutorable.CTATTool;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Options;
import edu.cmu.pact.BehaviorRecorder.View.HintWindow.HintPanel;
import edu.cmu.pact.BehaviorRecorder.View.HintWindow.HintWindow;
import edu.cmu.pact.BehaviorRecorder.View.HintWindow.HintWindowInterface;
import edu.cmu.pact.BehaviorRecorder.View.HintWindow.Hints;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.client.HintMessagesManager;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import edu.cmu.pslc.logging.LogContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import pact.CommWidgets.JCommButton;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.SendsDone;
import pact.CommWidgets.event.StudentActionEvent;

public class WrapperSupport
implements ActionListener,
MouseListener,
ComponentListener,
AncestorListener,
SendsDone {
    protected TutorController controller = null;
    protected JComponent tutorPanel;
    protected final Container container;
    private JSplitPane verticalSplitPane;
    private JSplitPane horizontalSplitPane;
    private JScrollPane skillsPane;
    private HintWindowInterface hintPanel;
    private HintMessagesManager hintMessagesManager;
    private boolean runningSimStPLE = false;
    private boolean runningSimStGameShow = false;
    private boolean useSeparateHintWindow;
    List<ActionListener> doneListeners = new LinkedList<ActionListener>();
    private List<Object> hintComponents = new LinkedList<Object>();
    private List<JCommButton> doneButtons = new LinkedList<JCommButton>();
    private Map<String, Integer> nameGenerator = new LinkedHashMap<String, Integer>();
    static final String RETRACT_LAST_STEP = "Retract Last Step";

    public boolean isRunningSimStPLE() {
        return this.runningSimStPLE;
    }

    public void setRunningSimStPLE(boolean diableHintWindow) {
        this.runningSimStPLE = diableHintWindow;
    }

    public boolean isRunningSimStGameShow() {
        return this.runningSimStGameShow;
    }

    public void setRunningSimStGameShow(boolean diableHintWindow) {
        this.runningSimStGameShow = diableHintWindow;
    }

    public WrapperSupport(Container container) {
        this.container = container;
        this.nameGenerator.clear();
    }

    @Override
    public void studentActionPerformed(StudentActionEvent sae) {
        JCommButton doneBtn;
        Object source = sae.getSource();
        if (source instanceof JCommButton && "done".equalsIgnoreCase((doneBtn = (JCommButton)source).getCommName())) {
            this.fireDoneActionPerformed(doneBtn);
        }
    }

    @Override
    public synchronized void addActionListener(ActionListener doneListener) {
        this.doneListeners.add(doneListener);
    }

    @Override
    public synchronized void removeActionListener(ActionListener doneListener) {
        this.doneListeners.remove(doneListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CTAT_Options examineInterface(Container container, TutorController controller) {
        CTAT_Options options = null;
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] components = container.getComponents();
            for (int j = 0; j < components.length; ++j) {
                Component component = components[j];
                try {
                    CTAT_Options opts = null;
                    String name = component.getName();
                    if (name == null || name.length() < 1) {
                        name = component.getClass().getSimpleName();
                    }
                    if (trace.getDebugCode("inter")) {
                        trace.out("inter", "examineInterface(): obj = " + name + " " + component);
                    }
                    if (component instanceof JTabbedPane) {
                        opts = this.examineTabbedPane((JTabbedPane)component);
                    } else if (component instanceof JCommWidget) {
                        JCommWidget dw = (JCommWidget)component;
                        if (trace.getDebugCode("inter")) {
                            trace.out("inter", "JCommWidget " + name + ", getCommName() " + dw.getCommName() + ", isHintBtn() " + dw.isHintBtn());
                        }
                        if (dw.getCommName() != null && dw.getCommName().length() > 0) {
                            name = dw.getCommName();
                        }
                        name = this.checkForUniqueName(name);
                        dw.setCommName(name, controller);
                        if ("done".equalsIgnoreCase(name)) {
                            dw.addStudentActionListener(this);
                            this.doneButtons.add((JCommButton)dw);
                        } else if (dw.isDoneButton()) {
                            this.doneButtons.add((JCommButton)dw);
                        }
                        if (dw.isHintBtn()) {
                            this.hintComponents.add(dw);
                        }
                    } else if (component instanceof JScrollPane) {
                        JViewport viewport = ((JScrollPane)component).getViewport();
                        if (viewport != null && viewport.getView() instanceof Container) {
                            opts = this.examineInterface((Container)viewport.getView(), controller);
                        }
                    } else if (component instanceof JLayeredPane) {
                        opts = this.examineInterface((JLayeredPane)component, controller);
                    } else if (component instanceof CTAT_Options) {
                        if (trace.getDebugCode("inter")) {
                            trace.out("inter", "OPTIONS FOUND");
                        }
                        opts = (CTAT_Options)component;
                    } else if (component instanceof JPanel) {
                        opts = this.examineInterface((JPanel)component, controller);
                    }
                    if (options == null && opts != null) {
                        options = opts;
                    }
                    if (!(component instanceof Component) || component instanceof JCommWidget) continue;
                    if (trace.getDebugCode("inter")) {
                        trace.out("inter", "hintComponent " + Hints.isHintComponent(component));
                    }
                    if (!Hints.isHintComponent(component)) continue;
                    this.hintComponents.add(component);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "examineInterface() widget keys " + controller.getCommWidgetTable().keySet());
        }
        return options;
    }

    private String checkForUniqueName(String name) {
        Integer nextSerialNo = this.nameGenerator.get(name);
        nextSerialNo = nextSerialNo == null ? new Integer(1) : new Integer(nextSerialNo + 1);
        this.nameGenerator.put(name.toString(), nextSerialNo);
        if (nextSerialNo > 1) {
            return name + nextSerialNo;
        }
        return name;
    }

    public CTAT_Options setTutorPanel(JComponent tutorPanel) {
        trace.out("inter", "set tutor panel: " + tutorPanel);
        this.tutorPanel = tutorPanel;
        CTAT_Options options = null;
        this.doneButtons.clear();
        this.hintComponents.clear();
        options = tutorPanel instanceof JTabbedPane ? this.examineTabbedPane((JTabbedPane)tutorPanel) : this.examineInterface(tutorPanel, this.controller);
        if (options == null) {
            options = new CTAT_Options();
        }
        this.useSeparateHintWindow = options.getSeparateHintWindow();
        this.controller.initAllWidgets_movedFromCommWidget();
        tutorPanel.addMouseListener(this);
        Dimension tutorPanelPreferredSize = this.getTutorPanelPreferredSize();
        tutorPanel.setPreferredSize(tutorPanelPreferredSize);
        this.setupHintWindow(tutorPanel, tutorPanelPreferredSize);
        return options;
    }

    private CTAT_Options examineTabbedPane(JTabbedPane tabbedPane) {
        CTAT_Options options = null;
        int tabCount = tabbedPane.getTabCount();
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "examineTabbedPane tabCount" + tabCount);
        }
        for (int i = 0; i < tabCount; ++i) {
            Component c = tabbedPane.getComponentAt(i);
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "examineTabbedPane c[" + i + "] " + c);
            }
            if (c instanceof JScrollPane) {
                JViewport viewport = ((JScrollPane)c).getViewport();
                if (viewport == null || !(viewport.getView() instanceof Container)) continue;
                options = this.examineInterface((Container)viewport.getView(), this.controller);
                continue;
            }
            if (!(c instanceof Container)) continue;
            options = this.examineInterface((Container)c, this.controller);
        }
        return options;
    }

    public void loadPreferences() {
        if (trace.getDebugCode("br")) {
            trace.out("br", "WrapperSupport.loadPreferences() now a no-op");
        }
    }

    public boolean hasHintButton() {
        Component[] allComponents = this.tutorPanel.getComponents();
        for (int i = 0; i < allComponents.length; ++i) {
            Component tempComponent = allComponents[i];
            if (!(tempComponent instanceof JCommButton) || !((JCommButton)tempComponent).getText().equalsIgnoreCase("Hint")) continue;
            return true;
        }
        return false;
    }

    private Dimension getTutorPanelPreferredSize() {
        Dimension result = this.getComponentPreferredSize(this.tutorPanel);
        return new Dimension(result.width + 15, result.height + 15);
    }

    private Dimension getComponentPreferredSize(JComponent panel) {
        Component[] allComponents = panel.getComponents();
        int maxWidth = 0;
        int maxHeight = 0;
        if (trace.getDebugCode("wh")) {
            trace.out("wh", "start getComponentPreferredSize() for " + panel.getClass().getName());
        }
        for (int i = 0; i < allComponents.length; ++i) {
            Component tempComponent = allComponents[i];
            if (tempComponent instanceof JCommWidget) {
                if (trace.getDebugCode("wh")) {
                    trace.out("wh", "ui component " + tempComponent.getName() + ":" + tempComponent.getClass().getName() + " x " + tempComponent.getLocation().x + ", width " + tempComponent.getSize().width + ", y " + tempComponent.getLocation().y + ", height " + tempComponent.getSize().height);
                }
                maxWidth = Math.max(maxWidth, tempComponent.getLocation().x + tempComponent.getSize().width);
                maxHeight = Math.max(maxHeight, tempComponent.getLocation().y + tempComponent.getSize().height);
                continue;
            }
            Dimension tempSize = this.getComponentPreferredSize((JComponent)tempComponent);
            if (tempComponent instanceof JTabbedPane) {
                int tabWidth = 128;
                for (int j = 0; j < ((JTabbedPane)tempComponent).getTabCount(); ++j) {
                    if (trace.getDebugCode("wh")) {
                        trace.out("wh", "tab: " + j + " bounds: " + ((JTabbedPane)tempComponent).getBoundsAt(j));
                    }
                    tabWidth += ((JTabbedPane)tempComponent).getBoundsAt((int)j).width;
                }
                tempSize.width = Math.max(tempSize.width, tabWidth);
                tempSize.width += 20;
                tempSize.height += 20;
            }
            tempComponent.setPreferredSize(tempSize);
            if (trace.getDebugCode("wh")) {
                trace.out("wh", "ui component " + tempComponent.getName() + ":" + tempComponent.getClass().getName() + " x " + tempComponent.getLocation().x + ", width " + tempComponent.getPreferredSize().width + ", y " + tempComponent.getLocation().y + ", height " + tempComponent.getPreferredSize().height);
            }
            maxWidth = Math.max(maxWidth, tempComponent.getLocation().x + tempComponent.getPreferredSize().width);
            maxHeight = Math.max(maxHeight, tempComponent.getLocation().y + tempComponent.getPreferredSize().height);
        }
        Dimension result = new Dimension(maxWidth, maxHeight);
        if (trace.getDebugCode("wh")) {
            trace.out("wh", "getComponentPreferredSize() for " + panel.getClass().getName() + " returns " + result);
        }
        return result;
    }

    protected void setupHintWindow(JComponent tutorPanel, Dimension tutorPanelPreferredSize) {
        JScrollPane sp = new JScrollPane(tutorPanel);
        sp.setMinimumSize(tutorPanelPreferredSize);
        if (trace.getDebugCode("wh")) {
            trace.out("wh", "setupHintWindow(" + tutorPanel + ") min " + this.container.getMinimumSize() + ", pref " + this.container.getPreferredSize() + ", max " + this.container.getMaximumSize());
        }
        if (this.getUseSeparateHintWindow()) {
            Frame parentFrame = WrapperSupport.getOwnerFrame(this.container);
            this.hintPanel = new HintWindow(parentFrame, this.getHintMessagesManager());
            if (this.container instanceof JComponent) {
                ((JComponent)this.container).addAncestorListener(this);
            }
            if (VersionInformation.includesCL() && this.container instanceof CTATTool) {
                ((CTATTool)this.container).setMinimumSize(tutorPanelPreferredSize);
                ((CTATTool)this.container).setPreferredSize(tutorPanelPreferredSize);
                this.container.add(tutorPanel);
                if (trace.getDebugCode("wh")) {
                    trace.out("wh", "setupHintWindow() called container " + this.container + "(" + this.container.getClass().getName() + ").add(" + tutorPanel + ")");
                }
            } else {
                this.container.add(sp);
                if (trace.getDebugCode("wh")) {
                    trace.out("wh", "setupHintWindow() called container " + this.container + "(" + this.container.getClass().getName() + ").add(" + sp + ")");
                }
            }
        } else {
            JCommButton hintBtn;
            this.hintPanel = new HintPanel(this.controller, this.getHintMessagesManager());
            JCommButton doneBtn = (JCommButton)this.hintPanel.getDoneButton();
            if (doneBtn != null) {
                doneBtn.addStudentActionListener(this);
                this.doneButtons.add(doneBtn);
            }
            if ((hintBtn = (JCommButton)this.hintPanel.getHintButton()) != null) {
                this.hintComponents.add(hintBtn);
            }
            this.buildIntegratedHintPanel(sp);
        }
        if (trace.getDebugCode("wh")) {
            trace.out("wh", "setTutorPanel() post setupHintWindow min " + this.container.getMinimumSize() + ", pref " + this.container.getPreferredSize() + ", max " + this.container.getMaximumSize());
        }
    }

    public HintMessagesManager getHintMessagesManager() {
        if (this.hintMessagesManager == null) {
            this.hintMessagesManager = this.controller.getHintMessagesManager();
        }
        return this.hintMessagesManager;
    }

    public static Frame getOwnerFrame(Container container) {
        Container owner = null;
        if (container == null) {
            return null;
        }
        if (container instanceof Window) {
            owner = ((Window)container).getOwner();
        }
        if (owner == null) {
            owner = container.getParent();
        }
        if (trace.getDebugCode("wh")) {
            trace.out("wh", "getOwnerFrame() container " + (container == null ? "null" : container.getClass().getName()) + ", owner " + (owner == null ? "null" : owner.getClass().getName()));
        }
        if (owner == null && container instanceof Frame) {
            return (Frame)container;
        }
        if (owner == container && container instanceof Frame) {
            return (Frame)container;
        }
        return WrapperSupport.getOwnerFrame(owner);
    }

    private void buildIntegratedHintPanel(JScrollPane sp) {
        String opSystem = System.getProperty("os.name");
        boolean winSystem = true;
        if (opSystem.indexOf("Windows") < 0) {
            winSystem = false;
        }
        int hintWinMiniLength = 250;
        if (!winSystem) {
            hintWinMiniLength = 340;
        }
        JComponent hintFrame = (JComponent)((Object)this.getHintInterface());
        hintFrame.setPreferredSize(new Dimension(hintWinMiniLength, 300));
        hintFrame.setMinimumSize(new Dimension(hintWinMiniLength, 150));
        hintFrame.addComponentListener(this);
        this.skillsPane = new JScrollPane(new JPanel());
        this.skillsPane.setMinimumSize(new Dimension(hintWinMiniLength, 150));
        this.skillsPane.setPreferredSize(new Dimension(hintWinMiniLength, 300));
        this.verticalSplitPane = new JSplitPane(0, hintFrame, this.skillsPane);
        this.verticalSplitPane.setDividerLocation(300);
        this.verticalSplitPane.setMinimumSize(new Dimension(hintWinMiniLength, 400));
        this.verticalSplitPane.setPreferredSize(new Dimension(hintWinMiniLength, 600));
        this.verticalSplitPane.setResizeWeight(0.5);
        this.horizontalSplitPane = new JSplitPane(1, sp, this.verticalSplitPane);
        this.horizontalSplitPane.setDividerLocation(500);
        this.horizontalSplitPane.setPreferredSize(new Dimension(800, 600));
        this.horizontalSplitPane.setResizeWeight(0.7);
        this.horizontalSplitPane.setMinimumSize(new Dimension(500, 500));
        this.container.add(this.horizontalSplitPane);
        Integer verticalDividerLocation = this.getController().getPreferencesModel().getIntegerValue("Tutor Wrapper Vertical Divider Location");
        Integer horizontalDividerLocation = this.getController().getPreferencesModel().getIntegerValue("Tutor Wrapper Horizontal Divider Location");
        if (verticalDividerLocation != null) {
            this.verticalSplitPane.setDividerLocation(verticalDividerLocation);
        }
        if (horizontalDividerLocation != null) {
            this.horizontalSplitPane.setDividerLocation(horizontalDividerLocation);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.horizontalSplitPane != null && this.verticalSplitPane != null) {
            this.getController().getPreferencesModel().setIntegerValue("Tutor Wrapper Vertical Divider Location", this.verticalSplitPane.getDividerLocation());
            this.getController().getPreferencesModel().setIntegerValue("Tutor Wrapper Horizontal Divider Location", this.horizontalSplitPane.getDividerLocation());
            this.getController().getPreferencesModel().saveToDisk();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public HintWindowInterface getHintInterface() {
        return this.hintPanel;
    }

    public JComponent getTutorPanel() {
        return this.tutorPanel;
    }

    public boolean getUseSeparateHintWindow() {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "getUseSeparateHintWindow() rtns " + this.useSeparateHintWindow);
        }
        return this.useSeparateHintWindow;
    }

    public TutorController getController() {
        return this.controller;
    }

    public void setController(TutorController controller) {
        this.controller = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (trace.getDebugCode("br")) {
            trace.out("br", "WrapperSupport.actionPerformed(): " + e);
        }
        if (RETRACT_LAST_STEP.equalsIgnoreCase(e.getActionCommand())) {
            MessageObject mo = MessageObject.create("RetractSteps", "SendNoteProperty");
            mo.setProperty("NumberOfSteps", "1");
            this.getController().getUniversalToolProxy().sendMessage(mo);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    Component getHorizontalSplitPane() {
        return this.horizontalSplitPane;
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "ancestorAdded() ancestor " + event.getAncestor() + ", parent " + event.getAncestorParent());
        }
        Frame parentFrame = WrapperSupport.getOwnerFrame(this.container);
        this.hintPanel = new HintWindow(parentFrame, this.getHintMessagesManager());
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "new HintPanel parent " + parentFrame);
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "ancestorRemoved(" + event + ")");
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "ancestorMoved(" + event + ")");
        }
    }

    public LogContext getLogger() {
        if (this.controller != null) {
            return this.controller.getLogger();
        }
        return null;
    }

    public void doneActionPerformed() {
        this.fireDoneActionPerformed(this);
    }

    private void fireDoneActionPerformed(Object source) {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "WrapperSupport.fireDoneActionPerformed() listeners " + this.doneListeners);
        }
        Iterator<ActionListener> it = this.doneListeners.iterator();
        while (it.hasNext()) {
            ActionEvent ae = new ActionEvent(source, 1001, "Complete all items");
            it.next().actionPerformed(ae);
        }
    }

    public void suppressFeedback(boolean suppressStudentFeedback) {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "WrapperSupport.suppressFeedback(" + suppressStudentFeedback + ") hintComponents " + this.hintComponents + ", doneButtons " + this.doneButtons);
        }
        for (Object obj : this.hintComponents) {
            if (obj instanceof HintWindowInterface) {
                ((HintWindowInterface)obj).setSuppressFeedback(suppressStudentFeedback);
                continue;
            }
            if (obj instanceof JCommWidget) {
                ((JCommWidget)obj).setEnabled(!suppressStudentFeedback);
                continue;
            }
            if (obj instanceof Component) {
                ((Component)obj).setEnabled(!suppressStudentFeedback);
                continue;
            }
            trace.err("Unexpected type in hintComponents: " + (obj == null ? "null" : obj.getClass().getName()));
        }
        HintWindowInterface hwi = this.getHintInterface();
        if (hwi != null) {
            hwi.setSuppressFeedback(suppressStudentFeedback);
        }
        for (JCommButton butn : this.doneButtons) {
            butn.setChangeButtonColor(!suppressStudentFeedback);
        }
    }
}

