/*
 * Decompiled with CFR 0.152.
 */
package pact.EconGraph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;
import pact.EconGraph.Line;
import pact.EconGraph.Point;

public class Grid {
    int ymin = 0;
    int ymax = 10;
    int yinc = 2;
    String ylabel = "y-axis";
    int xmin = 0;
    int xmax = 10;
    int xinc = 2;
    String xlabel = "x-axis";
    Color tempColor = new Color(0, 0, 0);
    Graphics ag;
    int counter = 0;
    boolean printed = false;
    int xcorner = 50;
    int ycorner = 50;
    int xsizepixels = 300;
    int ysizepixels = 300;
    int pixperx;
    int pixpery;
    int boxsize;
    Font smallestFont = new Font("Monospaced", 1, 8);
    Font smallFont = new Font("Monospaced", 1, 12);
    Font bigFont = new Font("Monospaced", 1, 18);

    Grid(int txc, int tyc, int txsp, int tysp, int txmin, int txinc, int txmax, String txlabel, int tymin, int tyinc, int tymax, String tylabel) {
        this.ymin = tymin;
        this.ymax = tymax;
        this.yinc = tyinc;
        this.ylabel = tylabel;
        this.xmin = txmin;
        this.xmax = txmax;
        this.xinc = txinc;
        this.xlabel = txlabel;
        this.xcorner = txc;
        this.ycorner = tyc;
        this.xsizepixels = txsp;
        this.ysizepixels = tysp;
        this.finalizepixelsizes();
    }

    void finalizepixelsizes() {
        double boxscale = 0.4;
        this.pixperx = 1 * this.xsizepixels / (this.xmax - this.xmin);
        this.pixpery = 1 * this.ysizepixels / (this.ymax - this.ymin);
        this.boxsize = (int)Math.min(boxscale * (double)this.pixperx, boxscale * (double)this.pixpery);
        this.xsizepixels = this.pixperx * (this.xmax - this.xmin);
        this.ysizepixels = this.pixpery * (this.ymax - this.ymin);
    }

    void maximizeGrid(Graphics g, int width, int height) {
        if (this.boxsize < 5) {
            this.boxsize = 5;
        }
        g.setFont(this.bigFont);
        FontMetrics fm = g.getFontMetrics(this.bigFont);
        this.xsizepixels = width;
        this.ysizepixels = height;
        this.finalizepixelsizes();
        if (this.boxsize < 5) {
            this.boxsize = 5;
        }
    }

    boolean pixelInGraphPlusBorder(Point p) {
        return p.getx() >= this.xcorner - this.boxsize && p.getx() <= this.xcorner + this.xsizepixels + this.boxsize && p.gety() >= this.ycorner - this.boxsize && p.gety() <= this.ycorner + this.ysizepixels + this.boxsize;
    }

    boolean pixelInGraph(Point p) {
        return p.getx() >= this.xcorner && p.getx() <= this.xcorner + this.xsizepixels && p.gety() >= this.ycorner && p.gety() <= this.ycorner + this.ysizepixels;
    }

    boolean relativeInGraph(Point p) {
        return p.getx() >= this.xmin && p.getx() <= this.xmax && p.gety() >= this.ymin && p.gety() <= this.ymax;
    }

    boolean near(Point pixelpt, Point relativept) {
        int x = this.xcorner + (relativept.getx() - this.xmin) * this.pixperx;
        int y = this.ycorner + this.ysizepixels - (relativept.gety() - this.ymin) * this.pixpery;
        return Math.abs(pixelpt.getx() - x) <= this.boxsize && Math.abs(pixelpt.gety() - y) <= this.boxsize;
    }

    Point closeMoveablePoint(Point pixelpt, Line line) {
        if (!line.getMoving()) {
            return null;
        }
        for (int p = 0; p < line.point.length; ++p) {
            if (!line.point[p].getMoveable() || !this.near(pixelpt, line.point[p])) continue;
            return line.point[p];
        }
        return null;
    }

    Point convertPixel(Point pixelpt) {
        return new Point((pixelpt.getx() - this.xcorner + this.pixperx / 2) / this.pixperx + this.xmin, this.ymin - (pixelpt.gety() - this.ycorner - this.ysizepixels - this.pixpery / 2) / this.pixpery);
    }

    Point convertPixelBack(Point locpt) {
        return new Point((locpt.getx() - this.xmin) * this.pixperx + this.xcorner + this.pixperx / 2, this.ycorner + this.ysizepixels + this.pixpery / 2 - (locpt.gety() - this.ymin) * this.pixpery);
    }

    void drawGraphPaper(Graphics g) {
        int b;
        int b2;
        Color labelColor = Color.black;
        Color interiorColor = Color.white;
        Color borderColor = Color.black;
        int borderThickness = 1;
        Color mainlineColor = Color.black;
        int mainlineThickness = 0;
        Color sublineColor = Color.lightGray;
        int sublineThickness = 0;
        int ticksize = this.boxsize / 2;
        g.setColor(interiorColor);
        g.fillRect(this.xcorner, this.ycorner, this.xsizepixels, this.ysizepixels);
        g.setColor(borderColor);
        for (int b3 = 0; b3 < borderThickness; ++b3) {
            g.drawRect(this.xcorner - b3, this.ycorner - b3, this.xsizepixels + 2 * b3, this.ysizepixels + 2 * b3);
        }
        g.setColor(sublineColor);
        for (int x = this.xmin; x <= this.xmax; ++x) {
            for (b2 = -sublineThickness; b2 <= sublineThickness; ++b2) {
                g.drawLine(this.xcorner + (x - this.xmin) * this.pixperx + b2, this.ycorner, this.xcorner + (x - this.xmin) * this.pixperx + b2, this.ycorner + this.ysizepixels);
            }
        }
        for (int y = this.ymin; y <= this.ymax; ++y) {
            for (b2 = -sublineThickness; b2 <= sublineThickness; ++b2) {
                g.drawLine(this.xcorner, this.ycorner + this.ysizepixels - (y - this.ymin) * this.pixpery + b2, this.xcorner + this.xsizepixels, this.ycorner + this.ysizepixels - (y - this.ymin) * this.pixpery + b2);
            }
        }
        g.setColor(mainlineColor);
        g.setFont(this.smallFont);
        FontMetrics fm = g.getFontMetrics(this.smallFont);
        for (int x = this.xmin; x <= this.xmax; ++x) {
            if (x % this.xinc != 0 && x != this.xmin && x != this.xmax) continue;
            for (b = -mainlineThickness; b <= mainlineThickness; ++b) {
                g.drawLine(this.xcorner + (x - this.xmin) * this.pixperx + b, this.ycorner, this.xcorner + (x - this.xmin) * this.pixperx + b, this.ycorner + this.ysizepixels + ticksize);
            }
            g.drawString("" + x, this.xcorner + (x - this.xmin) * this.pixperx - fm.stringWidth("" + x) / 2, this.ycorner + this.ysizepixels + fm.getAscent() + ticksize);
        }
        for (int y = this.ymin; y <= this.ymax; ++y) {
            if (y % this.yinc != 0 && y != this.ymin && y != this.ymax) continue;
            for (b = -mainlineThickness; b <= mainlineThickness; ++b) {
                g.drawLine(this.xcorner - ticksize, this.ycorner + this.ysizepixels - (y - this.ymin) * this.pixpery + b, this.xcorner + this.xsizepixels, this.ycorner + this.ysizepixels - (y - this.ymin) * this.pixpery + b);
            }
            g.drawString("" + y, this.xcorner - 2 * ticksize - fm.stringWidth("" + y), this.ycorner + this.ysizepixels - (y - this.ymin) * this.pixpery + fm.getAscent() / 2);
        }
        int widthmaxy = fm.stringWidth("" + this.ymax);
        g.setFont(this.bigFont);
        fm = g.getFontMetrics(this.bigFont);
        g.setColor(labelColor);
        g.drawString(this.xlabel, this.xcorner + this.xsizepixels / 2 - fm.stringWidth(this.xlabel) / 2, this.ycorner + this.ysizepixels + 2 * fm.getAscent() + ticksize);
        for (int y = 0; y < this.ylabel.length(); ++y) {
            g.drawString("" + this.ylabel.charAt(y), this.xcorner - 2 * ticksize - 2 * widthmaxy - fm.stringWidth("" + this.ylabel.charAt(y)) / 2, this.ycorner + (this.ysizepixels - this.ylabel.length() * fm.getAscent()) / 2 + (y + 1) * fm.getAscent());
        }
    }

    boolean inBounds(Point p) {
        return p.getx() >= this.xmin && p.getx() <= this.xmax && p.gety() >= this.ymin && p.gety() <= this.ymax;
    }

    int absoluteXLoc(Point p) {
        return this.xcorner + (p.getx() - this.xmin) * this.pixperx;
    }

    int absoluteYLoc(Point p) {
        return this.ycorner + this.ysizepixels - (p.gety() - this.ymin) * this.pixpery;
    }

    int absoluteXLoc(int x) {
        return this.xcorner + (x - this.xmin) * this.pixperx;
    }

    int absoluteYLoc(int y) {
        return this.ycorner + this.ysizepixels - (y - this.ymin) * this.pixpery;
    }

    void plotPoint(Graphics g, Point p) {
        Color labelColor = Color.black;
        if (this.inBounds(p)) {
            int x = this.absoluteXLoc(p);
            int y = this.absoluteYLoc(p);
            int box = (int)(p.getMoveable() ? (double)this.boxsize : (double)this.boxsize * 0.5);
            if (p.useTempColor()) {
                g.setColor(p.tempColor);
            } else {
                g.setColor(p.getColor());
            }
            g.drawRect(x - box, y - box, 2 * box, 2 * box);
            g.drawRect(x - box + 1, y - box + 1, 2 * box - 2, 2 * box - 2);
            g.drawLine(x - box, y - box, x + box, y + box);
            g.drawLine(x - box, y + box, x + box, y - box);
        }
    }

    void labelPoint(Graphics g, Point p) {
        Color labelColor = Color.black;
        int pointOffset = 2 * this.boxsize;
        if (this.inBounds(p)) {
            int x = this.absoluteXLoc(p);
            int y = this.absoluteYLoc(p);
            g.setFont(this.bigFont);
            FontMetrics fm = g.getFontMetrics(this.bigFont);
            int textheight = fm.getAscent() + fm.getDescent();
            g.setColor(Color.white);
            g.fillRect(x + pointOffset, y - pointOffset - textheight, fm.stringWidth(p.showLabel()), textheight);
            g.setColor(Color.black);
            g.drawRect(x + pointOffset, y - pointOffset - textheight, fm.stringWidth(p.showLabel()), textheight);
            g.drawLine(x, y, x + pointOffset, y - pointOffset);
            g.drawLine(x - 1, y, x + pointOffset, y - pointOffset - 1);
            g.drawLine(x, y + 1, x + pointOffset + 1, y - pointOffset);
            g.drawString(p.showLabel(), x + pointOffset, y - pointOffset - fm.getDescent());
        }
    }

    public Vector clipLine(Point start, Point end) {
        int x1 = start.x;
        int y1 = start.y;
        int x2 = end.x;
        int y2 = end.y;
        if (start.getx() == end.getx()) {
            if (start.getx() < 0 || start.getx() > this.xmax) {
                return null;
            }
            if (start.gety() < 0 && end.gety() < 0 || start.gety() > this.ymax && end.gety() > this.ymax) {
                return null;
            }
            if (start.gety() < end.gety()) {
                if (start.gety() < 0) {
                    y1 = 0;
                }
                if (end.gety() > this.ymax) {
                    y2 = this.ymax;
                }
            } else {
                if (end.gety() < 0) {
                    y2 = 0;
                }
                if (start.gety() > this.ymax) {
                    y1 = this.ymax;
                }
            }
        } else {
            if (start.gety() < 0 || start.gety() > this.ymax) {
                return null;
            }
            if (start.getx() < 0 && end.getx() < 0 || start.getx() > this.xmax && end.getx() > this.xmax) {
                return null;
            }
            if (start.getx() < end.getx()) {
                if (start.getx() < 0) {
                    x1 = 0;
                }
                if (end.getx() > this.xmax) {
                    x2 = this.xmax;
                }
            } else {
                if (end.getx() < 0) {
                    x2 = 0;
                }
                if (start.getx() > this.xmax) {
                    x1 = this.xmax;
                }
            }
        }
        Vector<Integer> v = new Vector<Integer>();
        v.addElement(new Integer(x1));
        v.addElement(new Integer(y1));
        v.addElement(new Integer(x2));
        v.addElement(new Integer(y2));
        return v;
    }

    public void drawLine(Graphics2D g2, Point start, Point end) {
        Vector v = this.clipLine(start, end);
        if (v == null) {
            this.printed = false;
            return;
        }
        ++this.counter;
        this.printed = true;
        int x1 = (Integer)v.elementAt(0);
        int y1 = (Integer)v.elementAt(1);
        int x2 = (Integer)v.elementAt(2);
        int y2 = (Integer)v.elementAt(3);
        g2.drawLine(this.absoluteXLoc(x1), this.absoluteYLoc(y1), this.absoluteXLoc(x2), this.absoluteYLoc(y2));
    }

    void plotLine(Graphics g, Line ln) {
        boolean linewidth = true;
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(ln.color);
        g2.setStroke(ln.stroke);
        this.counter = 0;
        for (int i = 1; i < ln.point.length; ++i) {
            this.drawLine(g2, ln.point[i - 1], ln.point[i]);
        }
        if (this.printed) {
            g2.setFont(this.bigFont);
            FontMetrics fm = g2.getFontMetrics(this.bigFont);
            g.drawString(ln.name, this.absoluteXLoc(ln.point[0]) + 2 * this.boxsize + 4, this.absoluteYLoc(ln.point[0]) + fm.getAscent() / 2 - 5);
        }
        g2.setStroke(new BasicStroke(1.0f));
    }

    void showCopyright(Graphics g, String cr) {
        g.setColor(Color.black);
        g.setFont(this.smallestFont);
        FontMetrics fm = g.getFontMetrics(this.smallestFont);
        g.drawString(cr, 1, fm.getAscent());
    }
}

