/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATURLFetch;
import edu.cmu.hcii.ctat.CTATXMLDriver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class CTATAssetManager
extends CTATBase {
    public CTATAssetManager() {
        this.setClassName("CTATAssetManager");
        this.debug("CTATAssetManager ()");
    }

    public ArrayList<String> downloadGlobalAssets(ArrayList<String> toCache, String assetPath, String server) {
        this.debug("downloadGlobalAssets (" + assetPath + "," + server + ")");
        ArrayList<String> copyCache = toCache;
        ArrayList<String> newCache = this.downloadAssets(assetPath, server);
        if (newCache.size() == 0) {
            return toCache;
        }
        for (int i = 0; i < newCache.size(); ++i) {
            copyCache.add(newCache.get(i));
        }
        return copyCache;
    }

    public ArrayList<String> downloadAssets(String assetPath, String server) {
        this.debug("downloadAssets (" + assetPath + "," + server + ")");
        String assetXML = "";
        ArrayList<String> toCache = new ArrayList<String>();
        CTATURLFetch fetcher = new CTATURLFetch();
        try {
            assetXML = fetcher.fetchURL(server + assetPath);
        }
        catch (MalformedURLException e) {
            CTATLink.lastError = "MalformedURLException Error getting: " + fetcher.getObtainedURL();
            this.debug(CTATLink.lastError);
            return toCache;
        }
        catch (IOException e) {
            CTATLink.lastError = "IOException Error getting: " + fetcher.getObtainedURL();
            this.debug(CTATLink.lastError);
            return toCache;
        }
        if (assetXML.isEmpty()) {
            return toCache;
        }
        this.debug(assetXML);
        CTATXMLDriver driver = new CTATXMLDriver();
        Element root = driver.loadXMLFromString(assetXML);
        if (root == null) {
            CTATLink.lastError = "Error: unable to parse incoming XML";
            this.debug(CTATLink.lastError);
            return toCache;
        }
        if (!root.getName().equalsIgnoreCase("Directory")) {
            CTATLink.lastError = "Error: element name is not Directory, instead it is: " + root.getName();
            this.debug(CTATLink.lastError);
            return toCache;
        }
        String basePath = root.getAttributeValue("path");
        this.debug("Loading assets from path: " + basePath);
        Element entries = root.getChild("Entries");
        if (entries == null) {
            CTATLink.lastError = "Error obtaining Entries field from XML";
            this.debug(CTATLink.lastError);
            return toCache;
        }
        List list = entries.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            Element node = (Element)list.get(i);
            if (!node.getName().equalsIgnoreCase("Entry")) continue;
            if (node.getAttributeValue("type").equalsIgnoreCase("file")) {
                toCache.add("/" + basePath + "/" + node.getValue());
            }
            if (!node.getAttributeValue("type").equalsIgnoreCase("directory")) continue;
            this.debug("Processing directory: /" + basePath + "/" + node.getValue() + ".xml from server: " + server);
            ArrayList<String> tempCache = this.downloadAssets("/" + basePath + "/" + node.getValue() + ".xml", server);
            for (int t = 0; t < tempCache.size(); ++t) {
                toCache.add(tempCache.get(t));
            }
        }
        this.debug("Add done");
        return toCache;
    }
}

