/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATAssetManager;
import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATContentCache;
import edu.cmu.hcii.ctat.CTATCurriculum;
import edu.cmu.hcii.ctat.CTATDataShop;
import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATURLFetch;
import edu.cmu.hcii.ctat.CTATURLParamEncoder;
import edu.cmu.hcii.ctat.CTATWebTools;
import edu.cmu.hcii.ctat.LocalTSSystemTray;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CTATTutorUpdater
extends CTATBase {
    private CTATURLFetch fetcher = null;
    private CTATDesktopFileManager fManager = null;
    private String rollBack = "";
    private JFrame mainPanel = null;
    public String curriculumXML = "";
    private String updatedContentList = "";
    private JTextArea console = null;
    private JProgressBar progressBar = null;
    private boolean updateSuccess;

    public CTATTutorUpdater(JFrame aMainPanel, JTextArea aConsole, JProgressBar aProgress) {
        this.setClassName("CTATTutorUpdater");
        this.debug("CTATTutorUpdater ()");
        this.mainPanel = aMainPanel;
        this.console = aConsole;
        this.progressBar = aProgress;
        this.fManager = new CTATDesktopFileManager();
        this.fetcher = new CTATURLFetch();
    }

    @Override
    public void debug(String aMessage) {
        super.debug(aMessage);
        final String theMessage = aMessage;
        if (this.console != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CTATTutorUpdater.this.console.append(theMessage + "\n");
                }
            });
        }
    }

    public String getUpdatedContentList() {
        return this.updatedContentList;
    }

    public String getCurriculumXML() {
        return this.curriculumXML;
    }

    public boolean updateStudentData() {
        String indexFile = "null";
        try {
            indexFile = this.fetcher.fetchURL("http://digger.pslc.cs.cmu.edu/tsupdate.xml");
        }
        catch (MalformedURLException e) {
            this.debug("Update file is corrupted or malformed. Please notify the system administrator");
            e.printStackTrace();
            CTATLink.appState = "normal";
            return false;
        }
        catch (IOException e) {
            this.debug("Unable to obtain update file from server. Please notify the system administrator");
            e.printStackTrace();
            CTATLink.appState = "normal";
            return false;
        }
        this.debug(indexFile);
        return true;
    }

    public boolean updateDataShop() {
        this.debug("updateStudentData ()");
        CTATDataShop dataLogger = new CTATDataShop();
        return dataLogger.migrateData();
    }

    public Boolean backupJar() {
        BufferedOutputStream out;
        BufferedInputStream in;
        this.debug("backupJar ()");
        File renamer = new File("download/ctat.jar");
        if (!renamer.exists()) {
            this.debug("File doesn't exist yet, clean install");
            return true;
        }
        this.rollBack = "download/ctat-rollback-" + renamer.lastModified() + ".jar";
        File rollBackFile = new File(this.rollBack);
        try {
            rollBackFile.createNewFile();
        }
        catch (IOException e) {
            this.debug("IOException when creating backup");
            return false;
        }
        try {
            in = new BufferedInputStream(new FileInputStream(renamer));
        }
        catch (FileNotFoundException e) {
            this.debug("could not find download/ctat.jar");
            return false;
        }
        try {
            out = new BufferedOutputStream(new FileOutputStream(this.rollBack));
        }
        catch (FileNotFoundException e) {
            this.debug("could not find rollback file " + this.rollBack);
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        try {
            int b;
            while ((b = ((InputStream)in).read()) != -1) {
                ((OutputStream)out).write(b);
            }
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            ((InputStream)in).close();
        }
        catch (IOException e) {
            this.debug("IOException while trying to create backup. Deleting what was written to backup, if any.");
            try {
                ((OutputStream)out).close();
                ((InputStream)in).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!rollBackFile.delete()) {
                this.debug("Delete failed.");
            }
            return false;
        }
        File[] downloadFiles = new File("download").listFiles();
        HashSet<File> backups = new HashSet<File>();
        File mostRecentBackup = new File("");
        File secondMostRecentBackup = new File("");
        for (File f : downloadFiles) {
            String name = f.getName();
            if (!name.startsWith("ctat-rollback-")) continue;
            backups.add(f);
            if (name.compareTo(mostRecentBackup.getName()) > 0) {
                secondMostRecentBackup = mostRecentBackup;
                mostRecentBackup = f;
                continue;
            }
            if (name.compareTo(secondMostRecentBackup.getName()) <= 0) continue;
            secondMostRecentBackup = f;
        }
        for (File g : backups) {
            if (g.equals(mostRecentBackup) || g.equals(secondMostRecentBackup) || g.getName().equalsIgnoreCase(this.rollBack)) continue;
            g.delete();
        }
        return true;
    }

    private Boolean rollBackJar() {
        this.debug("rollBackJar ()");
        File renamer = new File(this.rollBack);
        if (!renamer.exists()) {
            this.debug("Error: rollback doesn't exist, fatal error");
            return false;
        }
        if (!renamer.renameTo(new File("download/ctat.jar"))) {
            this.debug("Unable to rollback " + this.rollBack + " to download/ctat.jar");
            return false;
        }
        return true;
    }

    public boolean updateContent() {
        boolean success;
        CTATContentCache cache;
        if (!CTATLink.initialized) {
            new CTATLink(new CTATDesktopFileManager());
            CTATLink.fManager.configureCTATLink();
        }
        if (CTATLink.remoteHost.equals("") || CTATLink.remoteHost.equals("local")) {
            JOptionPane.showMessageDialog(null, "Refreshing the cache is unnecessary when running in local or offline mode.");
            LocalTSSystemTray.getInstance().doneRefreshing();
            return true;
        }
        if (CTATLink.cache == null) {
            File cacheDirectory = new File(CTATLink.htdocs + "/cache/");
            if (!cacheDirectory.exists()) {
                cacheDirectory.mkdir();
            }
            CTATLink.cache = cache = new CTATContentCache(cacheDirectory, CTATLink.allowWriting);
        } else {
            cache = CTATLink.cache;
        }
        try {
            URL url = new URL("http", CTATLink.remoteHost, "/filesToDownload.php");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            if (conn.getResponseCode() >= 400) {
                File requiredEntries = new File(CTATLink.htdocs, "cache/required.txt");
                if (requiredEntries.exists()) {
                    String thisLine;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(requiredEntries)));
                    ArrayList<String> lines = new ArrayList<String>();
                    while ((thisLine = reader.readLine()) != null) {
                        if (thisLine.length() <= 0) continue;
                        lines.add(thisLine);
                    }
                    reader.close();
                    success = cache.refreshCertainFiles(CTATLink.remoteHost, lines.toArray(new String[0]), false, true);
                } else {
                    success = cache.refreshCache(CTATLink.remoteHost);
                }
            } else {
                String thisLine;
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                ArrayList<String> lines = new ArrayList<String>();
                while ((thisLine = reader.readLine()) != null) {
                    if (thisLine.length() <= 0) continue;
                    lines.add("/" + thisLine);
                }
                success = cache.refreshCertainFiles(CTATLink.remoteHost, lines.toArray(new String[0]), true, true);
            }
        }
        catch (MalformedURLException e) {
            this.debug(e.toString());
            success = false;
        }
        catch (IOException e) {
            this.debug(e.toString());
            success = false;
        }
        if (!success) {
            JOptionPane.showMessageDialog(null, "An exception occurred which prevented some of the data from being transferred. You may want to try refreshing the cache at a later date.");
        }
        return success;
    }

    private CTATCurriculum buildCurriculumFromXML(String aCurr) {
        this.debug("buildCurriculumFromXML ()");
        CTATCurriculum newCurriculum = null;
        try {
            newCurriculum = new CTATCurriculum(aCurr);
        }
        catch (SAXException e) {
            CTATLink.lastError = e.getMessage();
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            CTATLink.lastError = e.getMessage();
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            CTATLink.lastError = e.getMessage();
            e.printStackTrace();
            return null;
        }
        catch (FactoryConfigurationError e) {
            CTATLink.lastError = e.getMessage();
            e.printStackTrace();
            return null;
        }
        return newCurriculum;
    }

    public CTATCurriculum getCourse(String aCourse) {
        this.debug("getCourse (" + aCourse + ")");
        String cleanedCourse = CTATURLParamEncoder.encode(aCourse);
        CTATURLFetch fetcher = new CTATURLFetch();
        this.curriculumXML = null;
        try {
            this.curriculumXML = fetcher.fetchURL(CTATLink.remoteHost, "/courses/" + cleanedCourse + "/course.xml");
        }
        catch (MalformedURLException e) {
            this.debug("MalformedURLException Error getting: " + fetcher.getObtainedURL());
            return null;
        }
        catch (IOException e) {
            this.debug("IOException Error getting: " + fetcher.getObtainedURL());
            return null;
        }
        CTATCurriculum currResult = this.buildCurriculumFromXML(this.curriculumXML);
        if (currResult == null) {
            this.debug("buildCurriculumFromXML returned null");
            return null;
        }
        currResult.setAssignedClass(cleanedCourse);
        currResult.loadAllProblemSets();
        return currResult;
    }

    public void updateContentFromCurriculum(CTATCurriculum curriculum, CTATContentCache cache, File BRDdirectory, String server, boolean skipGlobalAssets, boolean useSwingWorker, Runnable doWhenDone) {
        this.debug("updateContentFromCurriculum ()");
        final CTATCurriculum aCurriculum = curriculum;
        final CTATContentCache aCache = cache;
        final File aBRDdirectory = BRDdirectory;
        final String aServer = server;
        final boolean aSkipGlobalAssets = skipGlobalAssets;
        final Runnable aDoWhenDone = doWhenDone;
        final CTATTutorUpdater tutorUpdater = this;
        if (useSwingWorker) {
            SwingWorker<Void, Void> sw = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    class UpdateWorker
                    implements Runnable {
                        final /* synthetic */ boolean val$aSkipGlobalAssets;
                        final /* synthetic */ String val$aServer;
                        final /* synthetic */ CTATTutorUpdater val$tutorUpdater;
                        final /* synthetic */ CTATCurriculum val$aCurriculum;
                        final /* synthetic */ File val$aBRDdirectory;
                        final /* synthetic */ CTATContentCache val$aCache;
                        final /* synthetic */ Runnable val$aDoWhenDone;

                        UpdateWorker() {
                            this.val$aSkipGlobalAssets = bl;
                            this.val$aServer = string;
                            this.val$tutorUpdater = cTATTutorUpdater;
                            this.val$aCurriculum = cTATCurriculum;
                            this.val$aBRDdirectory = file;
                            this.val$aCache = cTATContentCache;
                            this.val$aDoWhenDone = runnable;
                        }

                        @Override
                        public void run() {
                            CTATTutorUpdater.this.debug("updateContentFromCurriculum.UpdateWorker (" + (this.val$aSkipGlobalAssets ? "skipGlobalAssets" : "") + ")");
                            boolean success = true;
                            String[] pathList = null;
                            if (!this.val$aSkipGlobalAssets) {
                                CTATAssetManager assetManager = new CTATAssetManager();
                                ArrayList<String> toCache = new ArrayList<String>();
                                toCache = assetManager.downloadGlobalAssets(toCache, "/tutors/problem_sets/Assets.xml", this.val$aServer);
                                toCache = assetManager.downloadGlobalAssets(toCache, "/assets.xml", this.val$aServer);
                                toCache = assetManager.downloadGlobalAssets(toCache, "/images.xml", this.val$aServer);
                                if ((toCache = assetManager.downloadGlobalAssets(toCache, "/navigation.xml", this.val$aServer)).size() == 0) {
                                    JOptionPane.showMessageDialog(null, "Error downloading global assets.\n" + CTATLink.lastError);
                                    this.val$tutorUpdater.updateSuccess = false;
                                    return;
                                }
                                CTATTutorUpdater.this.debug("Processing " + toCache.size() + " files ...");
                                CTATTutorUpdater.this.progressBar.setMaximum(toCache.size());
                                CTATTutorUpdater.this.progressBar.setString("0 out of " + toCache.size());
                                pathList = toCache.toArray(new String[toCache.size()]);
                                if (pathList == null) {
                                    CTATTutorUpdater.this.debug("Unable to transform file list to file array!");
                                    this.val$tutorUpdater.updateSuccess = false;
                                    return;
                                }
                                CTATTutorUpdater.this.debug("All set for cache transfer");
                            }
                            CTATTutorUpdater.this.debug("Getting eligible problem sets; 1st assignment " + this.val$aCurriculum.getFirstAssignment());
                            Collection<String> probsets = this.val$aCurriculum.getRequiredProblemSets();
                            CTATTutorUpdater.this.debug("Found " + probsets.size() + " eligible problem sets");
                            for (String probset : probsets) {
                                try {
                                    int b;
                                    if (probset.equals("/tutors/problem_sets/166/propspeed-rate/problem_set.xml")) continue;
                                    URL url = new URL("http", this.val$aServer, probset);
                                    BufferedInputStream in = new BufferedInputStream(url.openStream());
                                    CTATTutorUpdater.this.debug("Writing: " + this.val$aBRDdirectory + " / " + probset);
                                    File f = new File(this.val$aBRDdirectory, probset);
                                    f.getParentFile().mkdirs();
                                    f.createNewFile();
                                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
                                    while ((b = ((InputStream)in).read()) != -1) {
                                        ((OutputStream)out).write((byte)b);
                                    }
                                    ((InputStream)in).close();
                                    ((OutputStream)out).close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    success = false;
                                }
                            }
                            success = true;
                            String[] newList = null;
                            Collection<String> Assets = this.val$aCurriculum.getRequiredAssets(this.val$aServer);
                            newList = Assets != null ? CTATTutorUpdater.this.appendList(pathList, Assets) : pathList;
                            Collection<String> SWFs = this.val$aCurriculum.getRequiredSWFs();
                            if (SWFs != null) {
                                newList = CTATTutorUpdater.this.appendList(newList, SWFs);
                            }
                            Collection<String> BRDs = this.val$aCurriculum.getRequiredBRDs();
                            success = this.val$aCache.refreshCertainFiles(this.val$aServer, newList, false, true, 0, newList.length + BRDs.size());
                            int BRDDownloaded = 0;
                            for (String BRD : BRDs) {
                                CTATTutorUpdater.this.debug("Downloading BRD: " + BRD);
                                success = true;
                                File f = new File(this.val$aBRDdirectory, BRD);
                                f.getParentFile().mkdirs();
                                if (!f.exists()) {
                                    try {
                                        f.createNewFile();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        success = false;
                                    }
                                }
                                if (success) {
                                    success = this.val$aCache.refreshRemoteBRDs("http://" + this.val$aServer + BRD, f, true);
                                } else {
                                    CTATTutorUpdater.this.debug("Unable to prepare empty BRD file");
                                }
                                if (success) {
                                    CTATTutorUpdater.this.debug("BRD downloaded, marking on progress bar ...");
                                    CTATTutorUpdater.this.progressBar.setValue(newList.length + BRDDownloaded + 1);
                                    CTATTutorUpdater.this.progressBar.setString(newList.length + BRDDownloaded + 1 + " out of " + (newList.length + BRDs.size()));
                                    ++BRDDownloaded;
                                    continue;
                                }
                                CTATTutorUpdater.this.debug("Error downloading BRD");
                            }
                            StringBuffer formatter = new StringBuffer();
                            for (int i = 0; i < newList.length; ++i) {
                                formatter.append(newList[i]);
                                formatter.append("\n");
                            }
                            CTATTutorUpdater.this.updatedContentList = formatter.toString();
                            CTATDesktopFileManager fManager = (CTATDesktopFileManager)CTATLink.fManager;
                            fManager.appendContents(CTATLink.logdir + "downloadlist.txt", CTATTutorUpdater.this.updatedContentList);
                            CTATTutorUpdater.this.debug("Going into immediate write ...");
                            this.val$aCache.immediateWrite();
                            CTATTutorUpdater.this.debug("Done with immediate write");
                            if (this.val$aDoWhenDone != null) {
                                try {
                                    SwingUtilities.invokeAndWait(this.val$aDoWhenDone);
                                }
                                catch (Exception e) {
                                    success = false;
                                }
                            }
                            this.val$tutorUpdater.updateSuccess = success;
                            CTATTutorUpdater.this.debug("Success: " + success);
                            if (this.val$tutorUpdater.updateSuccess && CTATLink.generateHTMLIndex.booleanValue()) {
                                this.val$tutorUpdater.updateSuccess = CTATTutorUpdater.this.generateIndexFromTemplate(this.val$aCurriculum);
                            }
                            CTATTutorUpdater.this.debug("Showing result message box ...");
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (val$tutorUpdater.updateSuccess) {
                                            JOptionPane.showMessageDialog(null, "Content downloaded successfully.");
                                        } else {
                                            JOptionPane.showMessageDialog(null, "Content download was not completely successful.");
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                CTATTutorUpdater.this.debug(e.toString());
                            }
                        }
                    }
                    new UpdateWorker(CTATTutorUpdater.this, aSkipGlobalAssets, aServer, tutorUpdater, aCurriculum, aBRDdirectory, aCache, aDoWhenDone).run();
                    return null;
                }
            };
            sw.execute();
            this.debug("Just after SwingWorker.execute(): isDone() " + sw.isDone());
        } else {
            Thread tw = new Thread((Runnable)new UpdateWorker(), "UpdateWorker");
            tw.start();
            this.debug("Just after UpdateWorker.start(); to call join()");
            try {
                tw.join();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    private String[] appendList(String[] existingAssets, Collection<String> newAssets) {
        this.debug("appendList ()");
        String[] temp = newAssets.toArray(new String[0]);
        this.debug("Appending " + temp.length + " entries to " + (existingAssets == null ? "null" : Integer.toString(existingAssets.length)) + " existing entries");
        if (existingAssets == null) {
            return temp;
        }
        String[] total = new String[existingAssets.length + newAssets.size()];
        for (int i = 0; i < existingAssets.length; ++i) {
            total[i] = existingAssets[i];
        }
        for (int j = 0; j < temp.length; ++j) {
            total[j + existingAssets.length] = temp[j];
        }
        return total;
    }

    public Boolean shouldUpdateCode(Boolean aVisual) {
        this.debug("shouldUpdateCode ()");
        if (aVisual.booleanValue()) {
            boolean updateExists;
            try {
                updateExists = this.newCodeExists();
            }
            catch (Exception e) {
                updateExists = true;
            }
            if (updateExists) {
                Object[] options = new Object[]{"Yes", "No"};
                int n = JOptionPane.showOptionDialog(this.mainPanel, "A new update is available for your software, would you like to download\n and install this update?", "Info Panel", 0, 3, null, options, options[1]);
                this.debug("N: " + n);
                if (n != 0) {
                    this.debug("We don't want to run the updater right now");
                    return false;
                }
            } else {
                this.debug("Already up to date");
                return false;
            }
        }
        return true;
    }

    private boolean shouldUpdateContent() {
        URL url;
        if (!CTATLink.initialized) {
            new CTATLink(new CTATDesktopFileManager());
            CTATLink.fManager.configureCTATLink();
        }
        try {
            url = new URL("http", CTATLink.remoteHost, "");
        }
        catch (MalformedURLException e) {
            url = null;
        }
        long howfast = this.fetcher.checkConnectivity(url);
        if (howfast < 0L || howfast > 2000L) {
            JOptionPane.showMessageDialog(this.mainPanel, "Connection to the FIRE server is very slow. This may affect this program's performance.");
            return false;
        }
        int selection = JOptionPane.showConfirmDialog(this.mainPanel, "Would you like to refresh the local cache? Note that this should be done only with a fast and reliable internet connection.", "Refresh cached content?", 0, 3);
        return selection == 0;
    }

    private boolean newCodeExists() throws MalformedURLException, IOException {
        File downloadedjar = new File("download/ctat.jar");
        if (!downloadedjar.exists()) {
            return true;
        }
        URL url = new URL(CTATLink.updateURL + "/ctat.jar");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("HEAD");
        conn.setRequestProperty("If-Modified-Since", CTATWebTools.headerDateFmt.format(new Date(downloadedjar.lastModified())));
        conn.connect();
        return conn.getResponseCode() != 304;
    }

    private Boolean getNewJar(Boolean isVisual) {
        this.debug("getNewJar ()");
        this.backupJar();
        String crc = null;
        try {
            crc = this.fetcher.fetchURL(CTATLink.updateURL + "/ctat.jar.crc");
        }
        catch (Exception e) {
            this.debug("Error getting the crc file for the latest version of the ctat.jar file");
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "The update could not be downloaded.");
            return this.rollBackJar();
        }
        this.debug("Obtained CRC: " + crc);
        try {
            this.fetcher.getHTTPBinaryFile(CTATLink.updateURL + "/ctat.jar", "download/ctat.jar");
        }
        catch (Exception e) {
            this.debug("Error getting the latest version of the ctat.jar file");
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "The update could not be downloaded.");
            return this.rollBackJar();
        }
        String checkCRC = null;
        try {
            checkCRC = this.fManager.getMD5Checksum("download/ctat.jar");
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "The update could not be downloaded.");
            return this.rollBackJar();
        }
        if (checkCRC == null) {
            this.debug("Error: Unable to calculate CRC downloaded release file");
            JOptionPane.showMessageDialog(null, "The update could not be downloaded.");
            return this.rollBackJar();
        }
        if (!crc.equals(checkCRC)) {
            this.debug("Error: CRC check failed for downloaded release file (" + crc + " compared to: " + checkCRC + ")");
            JOptionPane.showMessageDialog(null, "The update could not be downloaded.");
            return this.rollBackJar();
        }
        this.debug("Verified CRC, continuing ...");
        this.fManager.getFileProperties("download/ctat.jar");
        return true;
    }

    public boolean runUpdate() {
        this.debug("runUpdate ()");
        CTATLink.appState = "updating";
        boolean success = true;
        if (this.shouldUpdateCode(true).booleanValue()) {
            success = this.getNewJar(true);
        }
        if (this.shouldUpdateContent()) {
            success = this.updateContent() && success;
        }
        CTATLink.appState = "normal";
        return success;
    }

    private boolean generateIndexFromTemplate(CTATCurriculum curriculum) {
        this.debug("generateIndexFromTemplate ()");
        String filename = "index.html";
        String template = CTATLink.htdocs + "templates/start_page.html";
        if (CTATLink.deployType == CTATLink.DEPLOYFLASH) {
            filename = CTATLink.htdocs + "index-flash.html";
        }
        if (CTATLink.deployType == CTATLink.DEPLOYHTML5) {
            filename = CTATLink.htdocs + "index-html5.html";
        }
        this.debug("Generating: " + filename + ", from: " + template);
        CTATDesktopFileManager copyist = new CTATDesktopFileManager();
        if (!copyist.copyfile(template, filename).booleanValue()) {
            return false;
        }
        String indexTemplate = CTATLink.fManager.getContents(filename);
        if (indexTemplate == null) {
            this.debug("Error: can't load index template");
            return false;
        }
        this.debug("Setting first assignment to: " + curriculum.getFirstAssignment());
        String composite = indexTemplate.replaceFirst("FIRSTPROBLEM", CTATURLParamEncoder.encode(curriculum.getFirstAssignment()));
        return CTATLink.fManager.setContents(filename, composite);
    }
}

