/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATCharsetFunctions;
import edu.cmu.hcii.ctat.CTATWSFrameData;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class CTATWSFrameProcessor {
    public ByteBuffer createBinaryFrame(CTATWSFrameData frameData) {
        byte[] mes = frameData.getPayloadData();
        boolean mask = frameData.getMasked();
        int sizebytes = mes.length <= 125 ? 1 : (mes.length <= 65535 ? 2 : 8);
        ByteBuffer buf = ByteBuffer.allocate(1 + (sizebytes > 1 ? sizebytes + 1 : sizebytes) + (mask ? 4 : 0) + mes.length);
        byte optcode = CTATWSFrameData.fromOpcode(frameData.getOpcode());
        byte one = (byte)(frameData.isFin() ? -128 : 0);
        one = (byte)(one | optcode);
        buf.put(one);
        byte[] payloadlengthbytes = this.toByteArray(mes.length, sizebytes);
        assert (payloadlengthbytes.length == sizebytes);
        if (sizebytes == 1) {
            buf.put((byte)(payloadlengthbytes[0] | (mask ? -128 : 0)));
        } else if (sizebytes == 2) {
            buf.put((byte)(0x7E | (mask ? -128 : 0)));
            buf.put(payloadlengthbytes);
        } else if (sizebytes == 8) {
            buf.put((byte)(0x7F | (mask ? -128 : 0)));
            buf.put(payloadlengthbytes);
        } else {
            throw new RuntimeException("Size representation not supported/specified");
        }
        if (mask) {
            ByteBuffer maskkey = ByteBuffer.allocate(4);
            maskkey.putInt(new Random().nextInt());
            buf.put(maskkey.array());
            for (int i = 0; i < mes.length; ++i) {
                buf.put((byte)(mes[i] ^ maskkey.get(i % 4)));
            }
        } else {
            buf.put(mes);
        }
        assert (buf.remaining() == 0) : buf.remaining();
        buf.flip();
        return buf;
    }

    public List<CTATWSFrameData> createFrames(byte[] binary) {
        CTATWSFrameData curframe = new CTATWSFrameData();
        curframe.setPayload(binary);
        curframe.setFin(true);
        curframe.setOpcode(CTATWSFrameData.Opcode.BINARY);
        return Collections.singletonList(curframe);
    }

    public List<CTATWSFrameData> createFrames(String text) {
        CTATWSFrameData curframe = new CTATWSFrameData();
        byte[] pay = CTATCharsetFunctions.utf8Bytes(text);
        curframe.setPayload(pay);
        curframe.setFin(true);
        curframe.setOpcode(CTATWSFrameData.Opcode.TEXT);
        return Collections.singletonList(curframe);
    }

    private byte[] toByteArray(long val, int bytecount) {
        byte[] buffer = new byte[bytecount];
        int highest = 8 * bytecount - 8;
        for (int i = 0; i < bytecount; ++i) {
            buffer[i] = (byte)(val >>> highest - 8 * i);
        }
        return buffer;
    }
}

