/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.monitor.CTATAlert;
import edu.cmu.hcii.ctat.monitor.CTATClientEntry;
import edu.cmu.hcii.ctat.monitor.CTATMachineEntry;
import edu.cmu.hcii.ctat.monitor.CTATMonitorEntry;
import edu.cmu.hcii.ctat.monitor.CTATServiceRegistry;
import edu.cmu.hcii.ctat.monitor.CTATSocketServerBase;
import edu.cmu.hcii.ctat.monitor.CTATStreamedSocket;
import edu.cmu.hcii.ctat.monitor.CTATStreamedTableDiskLogger;
import edu.cmu.hcii.ctat.monitor.CTATTSEntry;
import edu.cmu.hcii.ctat.monitor.CTATWSEntry;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.TimerTask;

public class CTATServiceChecker
extends TimerTask {
    private CTATServiceRegistry sRegistry = null;
    private ArrayList<CTATMonitorEntry> monitors = null;
    private CTATSocketServerBase server = null;
    private Boolean checking = false;
    private CTATStreamedSocket socketHelper = null;
    private CTATAlert alert = null;
    private StringBuffer reporter = null;
    private int monitorUpdateInterval = 5;
    private int monitorUpdateIndex = 0;
    private int tcpCheckInterval = 5;
    private int tcpCheckIndex = 0;
    private int httpCheckInterval = 10;
    private int httpCheckIndex = 0;
    private int msCheckInterval = 10;
    private int msCheckIndex = 0;

    public CTATServiceChecker(CTATSocketServerBase aServer, CTATAlert anAlerter) {
        this.debug("CTATServiceChecker ()");
        this.setServer(aServer);
        this.socketHelper = new CTATStreamedSocket();
        this.alert = anAlerter;
        this.reporter = new StringBuffer();
    }

    protected void debug(String aMessage) {
        CTATBase.debug("CTATServiceChecker", aMessage);
    }

    public void setTCPCheckInterval(int aValue) {
        this.tcpCheckInterval = aValue;
    }

    public void setHTTPCheckInterval(int aValue) {
        this.httpCheckInterval = aValue;
    }

    public void setMSCheckInterval(int aValue) {
        this.msCheckInterval = aValue;
    }

    private void resetReport() {
        this.reporter = new StringBuffer();
        this.reporter.append("");
    }

    private void appendReport(String aMessage) {
        if (this.reporter == null) {
            this.resetReport();
        }
        this.reporter.append(aMessage + ". \n");
    }

    private Boolean shouldReport() {
        if (this.reporter == null) {
            return false;
        }
        if (!this.reporter.toString().isEmpty()) {
            return true;
        }
        return false;
    }

    private String getReport() {
        if (this.reporter == null) {
            return "";
        }
        return this.reporter.toString();
    }

    public CTATServiceRegistry getsRegistry() {
        return this.sRegistry;
    }

    public void setsRegistry(CTATServiceRegistry sRegistry) {
        this.sRegistry = sRegistry;
    }

    public ArrayList<CTATMonitorEntry> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(ArrayList<CTATMonitorEntry> monitors) {
        this.monitors = monitors;
    }

    public CTATSocketServerBase getServer() {
        return this.server;
    }

    public void setServer(CTATSocketServerBase server) {
        this.server = server;
    }

    private Boolean executeTSCheck(CTATTSEntry ts) {
        ts.setUpdateDelta(this.tcpCheckInterval);
        if (ts.isUpdating().booleanValue()) {
            this.debug("This TS is currently updating, leaving alone for now ...");
            return false;
        }
        ++this.tcpCheckIndex;
        if (this.tcpCheckIndex < this.tcpCheckInterval) {
            return false;
        }
        this.tcpCheckIndex = 0;
        this.resetReport();
        Boolean result = ts.checkService();
        if (result.booleanValue()) {
            ts.setUpdated(true);
            if (ts.getReport() != null && !ts.getReport().isEmpty()) {
                this.debug("appending report with \"" + ts.getReport() + "\"");
                this.appendReport(ts.getReport());
            }
        }
        return result;
    }

    private Boolean executeHTTPCheck(CTATWSEntry ws) {
        ws.setUpdateDelta(this.httpCheckInterval);
        ++this.httpCheckIndex;
        if (this.httpCheckIndex < this.httpCheckInterval) {
            return false;
        }
        this.httpCheckIndex = 0;
        String oldStatus = ws.getStatus();
        try {
            URL url = new URL("http://" + ws.getHostname() + ":" + ws.getPort());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.connect();
            InputStream in = conn.getInputStream();
            String text = this.socketHelper.convertStreamToString(in);
            conn.disconnect();
            if (text.isEmpty()) {
                ws.setLastAmountReceived(0);
                if (!oldStatus.equals("DOWN")) {
                    ws.setStatus("DOWN");
                }
                if (!oldStatus.equals(ws.getStatus())) {
                    this.appendReport("Empty text received, marking web service at " + ws.getHostname() + ":" + ws.getPort() + " as down");
                }
            } else {
                Integer oldReceived = ws.getLastAmountReceived();
                ws.setLastAmountReceived(text.length());
                if (!oldStatus.equals("UP") || !oldReceived.equals(ws.getLastAmountReceived())) {
                    ws.setStatus("UP");
                }
                this.debug("Received " + text.length() + " characters");
            }
        }
        catch (IOException ex) {
            ws.setLastAmountReceived(0);
            if (!oldStatus.equals("DOWN")) {
                ws.setStatus("DOWN");
            }
            if (!oldStatus.equals(ws.getStatus())) {
                this.appendReport("IO exception while connecting to webserver at: " + ws.getHostname() + ":" + ws.getPort());
            }
            return true;
        }
        return false;
    }

    private Boolean executeMSCheck(CTATMachineEntry ms) {
        ms.setUpdateDelta(this.msCheckInterval);
        ++this.msCheckIndex;
        if (this.msCheckIndex < this.msCheckInterval) {
            return false;
        }
        this.msCheckIndex = 0;
        if (ms.getAutoPS().booleanValue()) {
            int ID = ms.getID();
            this.server.sendClient(ID, "<request command=\"ps\" />");
        }
        return false;
    }

    private void checkLogging() {
        ArrayList<CTATClientEntry> services = this.sRegistry.getEntries();
        if (services == null) {
            this.debug("null services in checklogging()");
            return;
        }
        for (int i = 0; i < services.size(); ++i) {
            CTATClientEntry entry = services.get(i);
            CTATStreamedTableDiskLogger logger = entry.getLogger();
            if (logger == null || !entry.getShouldLog().booleanValue()) continue;
            logger.checkLogging();
        }
    }

    public void sendAllMonitors(String aMessage) {
        if (this.monitors.size() == 0) {
            return;
        }
        if (this.server == null) {
            this.debug("Internal error: no server object available to send message to all monitors");
            return;
        }
        for (int i = 0; i < this.monitors.size(); ++i) {
            CTATMonitorEntry entry = this.monitors.get(i);
            if (!entry.getMonitorType().equals("MONITOR")) continue;
            this.server.sendClient(entry.getSocketID(), aMessage);
        }
    }

    public void updateMonitors() {
        ++this.monitorUpdateIndex;
        if (this.monitorUpdateIndex > this.monitorUpdateInterval) {
            this.monitorUpdateIndex = 0;
            Long memTotal = Runtime.getRuntime().totalMemory();
            Long memMax = Runtime.getRuntime().maxMemory();
            Long memFree = Runtime.getRuntime().freeMemory();
            this.sendAllMonitors("<status memtotal=\"" + memTotal + "\" memmax=\"" + memMax + "\" memfree=\"" + memFree + "\" />");
        }
    }

    @Override
    public void run() {
        if (this.checking.booleanValue()) {
            return;
        }
        this.checking = true;
        this.checkLogging();
        this.updateMonitors();
        ArrayList<CTATClientEntry> services = this.sRegistry.getEntries();
        if (this.server != null) {
            Boolean shouldUpdate = false;
            for (int i = 0; i < services.size(); ++i) {
                CTATMachineEntry ms;
                CTATTSEntry ts;
                CTATWSEntry ws;
                CTATClientEntry entry = services.get(i);
                if (entry.getClientType().equals("webservice") && this.executeHTTPCheck(ws = (CTATWSEntry)entry).booleanValue() && !shouldUpdate.booleanValue()) {
                    shouldUpdate = true;
                }
                if (entry.getClientType().equals("tutoringservice") && this.executeTSCheck(ts = (CTATTSEntry)entry).booleanValue() && !shouldUpdate.booleanValue()) {
                    shouldUpdate = true;
                }
                if (!entry.getClientType().equals("machine") || !this.executeMSCheck(ms = (CTATMachineEntry)entry).booleanValue() || shouldUpdate.booleanValue()) continue;
                shouldUpdate = true;
            }
            if (shouldUpdate.booleanValue()) {
                if (this.shouldReport().booleanValue() && this.alert != null) {
                    this.alert.setAlertSubject("Monitor Report!");
                    this.alert.setAlertMessage(this.getReport());
                    this.alert.report();
                }
                this.server.sendAllMonitors(this.sRegistry.toXMLUpdated());
                this.sRegistry.resetUpdates();
            }
        }
        this.checking = false;
    }
}

