/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.wizard;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.env.CTATFileEntry;
import edu.cmu.hcii.ctat.env.CTATURLRetriever;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.DefaultListModel;

public class CTATLMSConfiguration
extends CTATBase {
    public static final String jQueryLibName = "jquery.min.js";
    public static final String jQueryURL = "https://cdn.ctat.cs.cmu.edu/releases/latest/jquery.min.js";
    private DefaultListModel<File> assetValues = null;
    private ArrayList<CTATFileEntry> fileList = null;
    private LinkedHashSet<String> interfaceFiles = null;
    private LinkedHashSet<String> brdFiles = null;
    private Boolean useLogging = false;
    private File assetBasePathFile = null;
    private String assetBasePath = "";
    private String description = "CTAT Tutor";
    public String ctatcssContent = "";
    public String jquerylibContent = "";
    public String ctatlibContent = "";
    public String ctatloaderContent = "";
    private String engineTarget = "javascript";

    public CTATLMSConfiguration() {
        this.setClassName("CTATLMSConfiguration");
        this.debug("CTATLMSConfiguration ()");
        this.reset();
    }

    public void reset() {
        this.setAssetValues(new DefaultListModel<File>());
        this.setFileList(new ArrayList<CTATFileEntry>());
        this.interfaceFiles = new LinkedHashSet();
        this.brdFiles = new LinkedHashSet();
        this.jquerylibContent = CTATURLRetriever.retrieveDataFromURL(jQueryURL);
        this.ctatcssContent = CTATURLRetriever.retrieveDataFromURL("https://cdn.ctat.cs.cmu.edu/releases/latest/CTAT.css");
        this.ctatlibContent = CTATURLRetriever.retrieveDataFromURL("https://cdn.ctat.cs.cmu.edu/releases/latest/ctat.min.js");
        this.ctatloaderContent = CTATURLRetriever.retrieveDataFromURL("https://cdn.ctat.cs.cmu.edu/releases/latest/ctatloader.js");
    }

    public DefaultListModel<File> getAssetValues() {
        return this.assetValues;
    }

    public void setAssetValues(DefaultListModel<File> assetValues) {
        this.assetValues = assetValues;
    }

    public ArrayList<CTATFileEntry> getFileList() {
        return this.fileList;
    }

    public void setFileList(ArrayList<CTATFileEntry> fileList) {
        this.fileList = fileList;
    }

    public String getSwfLocationString() {
        String[] strArr = new String[this.interfaceFiles.size()];
        this.interfaceFiles.toArray(strArr);
        return strArr[0];
    }

    public void setSwfLocationString(String aLocationString) {
        this.interfaceFiles.add(aLocationString);
    }

    public String getInterfaceLocationString() {
        String[] strArr = new String[this.interfaceFiles.size()];
        this.interfaceFiles.toArray(strArr);
        return strArr[0];
    }

    public void setInterfaceLocationString(String aLocationString) {
        this.interfaceFiles.add(aLocationString);
    }

    public String getBrdLocationString() {
        String[] strArr = new String[this.brdFiles.size()];
        this.brdFiles.toArray(strArr);
        return strArr[0];
    }

    public void setBrdLocationString(String brdLocationString) {
        this.brdFiles.add(brdLocationString);
    }

    public String[] getInterfaceFiles() {
        String[] strArr = new String[this.interfaceFiles.size()];
        this.interfaceFiles.toArray(strArr);
        return strArr;
    }

    public String[] getBrdFiles() {
        String[] strArr = new String[this.brdFiles.size()];
        this.brdFiles.toArray(strArr);
        return strArr;
    }

    public File getAssetBasePathFile() {
        return this.assetBasePathFile;
    }

    public void setAssetBasePathFile(File assetBasePathFile) {
        this.assetBasePathFile = assetBasePathFile;
    }

    public String getAssetBasePath() {
        return this.assetBasePath;
    }

    public void setAssetBasePath(String assetBasePath) {
        this.assetBasePath = assetBasePath;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEngineTarget() {
        return this.engineTarget;
    }

    public void setEngineTarget(String engineTarget) {
        this.engineTarget = engineTarget;
    }

    public Boolean getUseLogging() {
        return this.useLogging;
    }

    public void setUseLogging(Boolean useLogging) {
        this.useLogging = useLogging;
    }
}

