/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorException;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorPanel;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels.LI_Subpanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.View.ActionLabel;
import edu.cmu.pact.Utilities.trace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LI_ActionTypeSubpanel
extends LI_Subpanel {
    private ActionLabel CurrActionLabel = null;
    private static final String INCORRECT_ACTION_NOT_IN_MODEL = "Incorrect Action not in Model";
    private static final String SUBOPTIMAL_ACTION = "Suboptimal Action";
    private static final String INCORRECT_ACTION = "Incorrect Action";
    private static final String CORRECT_ACTION = "Correct Action";
    private static final int MAX_WIDTH = 300;
    private static final int MAX_HEIGHT = 60;
    private static final int SUBPANEL_HEIGHT = 25;
    protected int PrefHeight = 0;
    private JLabel PanelLabel = null;
    private JComboBox TypeComboBox = null;
    private int TypeComboLastSelected = -1;
    private boolean HandleSelChanges = false;
    private JPanel TypeSubpanel = null;
    private JLabel ButtonLabel = null;
    private JLabel PrefLabel = null;
    private JLabel PrefStatus = null;
    private JButton PrefSetButton = null;
    private JButton DeleteLinkButton = null;
    private JPanel PrefSubpanel = null;
    private JPanel ButtonSubpanel = null;
    private JButton DemonstrateLinkButton;
    private JButton CancelDemonstrateLinkButton;
    private JButton InsertNodeAboveButton;
    private JButton InsertNodeBelowButton;

    public LI_ActionTypeSubpanel(BR_Controller Controller, ProblemEdge Edge, int CurrWidth, LinkInspectorPanel Panel2) throws LinkInspectorException {
        if (trace.getDebugCode("LI_ActionTypeSubpanel")) {
            trace.outNT("LI_ActionTypeSubpanel", "Generating Panel");
        }
        this.Panel = Panel2;
        this.setEdge(Edge);
        this.setController(Controller);
        this.CurrActionLabel = this.CurrEdgeData.getActionLabel();
        if (trace.getDebugCode("LI_ActionTypeSubpanel")) {
            trace.outNT("LI_ActionTypeSubpanel", "Setting Edge ActionLabel");
        }
        this.setName("LI_ActionTypeSubpanel");
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.generateTypeSubpanel(LinkInspectorPanel.PreferredWidth);
        this.generatePrefSubpanel(LinkInspectorPanel.PreferredWidth);
        this.generateButtonPanel(LinkInspectorPanel.PreferredWidth);
        this.setPreferredSize(new Dimension(CurrWidth, this.PrefHeight));
        this.addMouseListener(this);
        this.repaint();
        this.updateDimensions(LinkInspectorPanel.PreferredWidth);
        if (trace.getDebugCode("LI_ActionTypeSubpanel")) {
            trace.outNT("LI_ActionTypeSubpanel", "Loc:" + this.getLocation());
        }
    }

    @Override
    public void refreshData(EdgeEvent Ev) {
        if (trace.getDebugCode("LI_ActionTypeSubpanel")) {
            trace.outNT("LI_ActionTypeSubpanel", "Update Edge ActionLabel.");
        }
        this.setTypeComboBoxSelected();
        if (this.PrefSubpanel == null) {
            this.generatePrefSubpanel(this.getWidth());
        } else {
            this.testClearPrefSubPanel();
        }
    }

    private void generateTypeSubpanel(int CurrWidth) {
        if (trace.getDebugCode("LI_ActionTypeSubpanel")) {
            trace.outNT("LI_ActionTypeSubpanel", "Generating TypeSubpanel:" + CurrWidth);
        }
        JPanel TPanel = new JPanel();
        Dimension Pref = new Dimension(CurrWidth, 25);
        if (trace.getDebugCode("LI_ActionTypeSubpanel")) {
            trace.outNT("LI_ActionTypeSubpanel", "" + Pref);
        }
        this.updateHeightPref(this.PrefHeight + 25 + 5);
        TPanel.setPreferredSize(new Dimension(CurrWidth, 25));
        TPanel.setMinimumSize(new Dimension(0, 25));
        TPanel.setLayout(new BoxLayout(TPanel, 0));
        TPanel.setBackground(Color.WHITE);
        this.add(TPanel);
        if (trace.getDebugCode("LI_ActionTypeSubpanel")) {
            trace.outNT("LI_ActionTypeSubpanel", "A" + TPanel.getSize());
        }
        JLabel PanelLabel = new JLabel("Action Type: ");
        TPanel.add(PanelLabel);
        if (trace.getDebugCode("LI_ActionTypeSubpanel")) {
            trace.outNT("LI_ActionTypeSubpanel", "B" + TPanel.getSize());
        }
        String[] Types = new String[]{CORRECT_ACTION, INCORRECT_ACTION, SUBOPTIMAL_ACTION, INCORRECT_ACTION_NOT_IN_MODEL};
        this.TypeComboBox = new JComboBox<String>(Types);
        this.TypeComboBox.setName("LI_ActionTypeComboBox");
        int W = CurrWidth - PanelLabel.getWidth();
        if (trace.getDebugCode("LI_ActionTypeSubpanel")) {
            trace.outNT("LI_ActionTypeSubpanel", "Setting ComboWidth:" + W + " " + PanelLabel.getSize());
        }
        this.TypeComboBox.setMaximumSize(new Dimension(1000, 25));
        TPanel.add(this.TypeComboBox);
        if (trace.getDebugCode("LI_ActionTypeSubpanel")) {
            trace.outNT("LI_ActionTypeSubpanel", "C" + TPanel.getSize());
        }
        this.TypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent E) {
                LI_ActionTypeSubpanel.this.handleTypeChangeEvent();
            }
        });
        this.setTypeComboBoxSelected();
    }

    private void setTypeComboBoxSelected() {
        String ActionType = this.CurrEdgeData.getActionType();
        if (ActionType.equalsIgnoreCase(CORRECT_ACTION)) {
            this.TypeComboLastSelected = 0;
            this.TypeComboBox.setSelectedIndex(0);
        } else if (ActionType.equalsIgnoreCase("Buggy Action")) {
            this.TypeComboLastSelected = 1;
            this.TypeComboBox.setSelectedIndex(1);
        } else if (ActionType.equalsIgnoreCase("Fireable Buggy Action")) {
            this.TypeComboLastSelected = 2;
            this.TypeComboBox.setSelectedIndex(2);
        } else if (ActionType.equalsIgnoreCase("Untraceable Error")) {
            this.TypeComboLastSelected = 3;
            this.TypeComboBox.setSelectedIndex(3);
        }
        this.HandleSelChanges = true;
    }

    private void generatePrefSubpanel(int CurrWidth) {
        if (this.CurrEdge.isBuggy()) {
            return;
        }
        if (this.hasNeighbors()) {
            if (trace.getDebugCode("LI_ActionTypeSubpanel")) {
                trace.outNT("LI_ActionTypeSubpanel", "Generating Pref Subpanel.");
            }
            this.updateHeightPref(this.PrefHeight + 25 + 5);
            JPanel PPanel = new JPanel();
            PPanel.setLayout(new BoxLayout(PPanel, 0));
            PPanel.setBackground(Color.WHITE);
            Dimension Pref = new Dimension(CurrWidth, 25);
            PPanel.setPreferredSize(Pref);
            PPanel.setMinimumSize(new Dimension(0, 25));
            this.PrefSubpanel = PPanel;
            this.PrefLabel = new JLabel("");
            this.PrefLabel.setName("LI_PrefLabel");
            PPanel.add(this.PrefLabel);
            JButton NewButton = new JButton("Set");
            int TmpWidth = CurrWidth - this.PrefLabel.getWidth();
            Pref = new Dimension(TmpWidth, 20);
            NewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent E) {
                    LI_ActionTypeSubpanel.this.CurrEdge.getLinkEditFunctions().setPreferredArc(LI_ActionTypeSubpanel.this.Panel.getDefaultColor());
                }
            });
            this.PrefSetButton = NewButton;
            PPanel.add(NewButton);
            this.updatePrefPanel();
            this.add(PPanel);
        }
    }

    private void demonstrateButtonPressed() {
        if (this.CurrEdge.getController().getCtatModeModel().isDemonstrateThisLinkMode()) {
            this.CurrEdge.getLinkEditFunctions().processCancelDemonstrateLink();
            this.DemonstrateLinkButton.setText("Demonstrate");
        } else {
            boolean result = this.CurrEdge.getLinkEditFunctions().processDemonstrateLink();
            if (result) {
                this.DemonstrateLinkButton.setText("Cancel");
            }
        }
    }

    private void generateButtonPanel(int preferredWidth) {
        this.updateHeightPref(this.PrefHeight + 25 + 5);
        JPanel PPanel = new JPanel();
        PPanel.setLayout(new BoxLayout(PPanel, 0));
        PPanel.setBackground(Color.WHITE);
        Dimension Pref = new Dimension(preferredWidth, 25);
        this.ButtonSubpanel = PPanel;
        this.add(PPanel);
        this.ButtonLabel = new JLabel("");
        PPanel.add(this.ButtonLabel);
        JButton NewButton = new JButton("Delete");
        NewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent E) {
                LI_ActionTypeSubpanel.this.CurrEdge.getLinkEditFunctions().processDeleteSingleEdge(false);
            }
        });
        this.DeleteLinkButton = NewButton;
        PPanel.add(NewButton);
        NewButton = new JButton("Demonstrate");
        NewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent E) {
                LI_ActionTypeSubpanel.this.demonstrateButtonPressed();
            }
        });
        this.DemonstrateLinkButton = NewButton;
        PPanel.add(NewButton);
    }

    private void testClearPrefSubPanel() {
        if (!this.hasNeighbors()) {
            this.remove(this.PrefSubpanel);
            this.updateHeightPref(25);
            this.PrefSubpanel = null;
        } else {
            this.updatePrefPanel();
        }
    }

    private void updatePrefPanel() {
        if (trace.getDebugCode("LI_ActionTypeSubpanel")) {
            trace.outNT("LI_ActionTypeSubpanel", "Updating Pref Subpanel.");
        }
        if (this.CurrEdgeData.isPreferredEdge()) {
            this.PrefLabel.setText("Preferred Link");
            this.PrefLabel.setForeground(Color.GREEN.darker().darker());
        } else {
            this.PrefLabel.setText("Not Preferred  ");
            this.PrefLabel.setForeground(Color.BLACK);
        }
        if (this.Controller.isChangePreferredPath() && this.CurrEdgeData.getActionType().equalsIgnoreCase(CORRECT_ACTION) && !this.CurrEdgeData.isPreferredEdge()) {
            this.PrefSetButton.setVisible(true);
            this.PrefSetButton.setEnabled(true);
        } else {
            this.PrefSetButton.setVisible(false);
            this.PrefSetButton.setEnabled(false);
        }
    }

    private ProblemNode getParentNode() {
        return this.CurrEdge.getSource();
    }

    private ProblemNode getChildNode() {
        return this.CurrEdge.getDest();
    }

    private boolean hasNeighbors() {
        ProblemEdge TempEdge = null;
        ProblemNode Src = this.CurrEdge.getSource();
        Enumeration<ProblemEdge> EdgeList = this.Controller.getProblemModel().getProblemGraph().getOutgoingEdges(Src);
        while (EdgeList.hasMoreElements()) {
            TempEdge = EdgeList.nextElement();
            if (TempEdge == this.CurrEdge) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int getMinHeight(int WidthLimit) {
        return this.PrefHeight;
    }

    private void updateHeightPref(int NewHeightPref) {
        this.PrefHeight = NewHeightPref;
        this.updateDimensions(LinkInspectorPanel.PreferredWidth);
    }

    public void handleTypeChangeEvent() {
        if (trace.getDebugCode("LI_ActionTypeSubpanel")) {
            trace.outNT("LI_ActionTypeSubpanel", "Action Signalled.");
        }
        int CurrSel = this.TypeComboBox.getSelectedIndex();
        if (this.HandleSelChanges && this.TypeComboLastSelected != CurrSel) {
            switch (CurrSel) {
                case 0: {
                    this.CurrEdge.getLinkEditFunctions().changeActionType(CORRECT_ACTION);
                    break;
                }
                case 1: {
                    this.CurrEdge.getLinkEditFunctions().changeActionType("Buggy Action");
                    break;
                }
                case 2: {
                    this.CurrEdge.getLinkEditFunctions().changeActionType("Fireable Buggy Action");
                    break;
                }
                case 3: {
                    this.CurrEdge.getLinkEditFunctions().changeActionType("Untraceable Error");
                }
            }
            this.TypeComboLastSelected = CurrSel;
            this.fireUpdateEvent(false, true);
        }
    }
}

