/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.MatcherPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.RangeMatcher;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.trace;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RangeMatcherPanel
extends MatcherPanel {
    JTextField maximumField;
    JTextField minimumField;

    public RangeMatcherPanel(EdgeData edgeData, boolean allow, int max_students) {
        this(edgeData, allow, max_students, 0);
    }

    public RangeMatcherPanel(EdgeData edgeData, boolean allow, int max_students, int selectionIndex) {
        super(edgeData, allow, max_students, "<html>Range Match will match numeric values for the student's input <br>against a minimum and maximum value for the given selection and action.<br><br>Example: minimum 0 maximum 150 would match 0, 10, 22.3213232, and 150, <br>but not -1, 150.001, or 100,000", new Box(0));
        if (trace.getDebugCode("range")) {
            trace.out("range", "RangeMatcherPanel(" + edgeData.getMatcher() + ", " + edgeData.getInput() + ")");
        }
        JLabel minimumLabel = new JLabel("Minimum input value: ");
        minimumLabel.setFont(new Font(null, 0, 11));
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.SAIPane.add((Component)minimumLabel, this.c);
        this.minimumField = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.minimumField);
        this.minimumField.setName("minimumField");
        this.minimumField.setColumns(30);
        this.minimumField.setFont(new Font(null, 0, 11));
        this.c.gridx = 1;
        this.SAIPane.add((Component)this.minimumField, this.c);
        JLabel maximumLabel = new JLabel("Maximum input value: ");
        maximumLabel.setFont(new Font(null, 0, 11));
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.SAIPane.add((Component)maximumLabel, this.c);
        this.maximumField = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket2 = JUndo.makeTextUndoable(this.maximumField);
        this.maximumField.setName("maximumField");
        this.maximumField.setColumns(30);
        this.minimumField.setFont(new Font(null, 0, 11));
        this.c.gridx = 1;
        this.SAIPane.add((Component)this.maximumField, this.c);
        if (edgeData.getMatcher() instanceof RangeMatcher) {
            RangeMatcher r = (RangeMatcher)edgeData.getMatcher();
            this.actionField.setText(r.getAction());
            this.selectionField.setText(r.getSelection());
            this.minimumField.setText(r.getMinimumStr());
            this.maximumField.setText(r.getMaximumStr());
        } else {
            this.actionField.setText(edgeData.getAction().get(0).toString());
            this.selectionField.setText(edgeData.getSelection().get(selectionIndex).toString());
            if (edgeData.getInput() != null && edgeData.getInput().size() > 0) {
                String inputStr = edgeData.getInput().get(0).toString();
                this.minimumField.setText(inputStr);
                this.maximumField.setText(inputStr);
            } else {
                this.minimumField.setText(Double.toString(0.0));
                this.maximumField.setText(Double.toString(100.0));
            }
        }
    }

    public RangeMatcherPanel(String text) {
        super(1);
        int maxIndex;
        int commaIndex;
        if (trace.getDebugCode("range")) {
            trace.out("range", "RangeMatcherPanel(" + text + ")");
        }
        String minText = text == null || text.length() == 0 ? Double.toString(0.0) : text;
        String maxText = null;
        int minIndex = text.indexOf("[");
        if (minIndex >= 0 && (commaIndex = text.indexOf(",", minIndex + 1)) >= 0 && (maxIndex = text.indexOf("]", commaIndex + 1)) >= 0) {
            minText = text.substring(minIndex + 1, commaIndex);
            maxText = text.substring(commaIndex + 1, maxIndex);
        }
        if (maxText == null) {
            maxText = minText;
        }
        this.SAIPane = new JPanel(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.ipadx = 0;
        this.c.ipady = 0;
        JLabel minimumLabel = new JLabel("Min:");
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 0;
        this.c.weightx = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.SAIPane.add((Component)minimumLabel, this.c);
        this.minimumField = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.minimumField);
        this.minimumField.setName("minimumField");
        this.minimumField.setColumns(17);
        this.minimumField.setText(minText);
        this.minimumField.setSelectionStart(0);
        this.minimumField.setSelectionEnd(0);
        this.c.insets = new Insets(5, 0, 5, 5);
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.c.gridx = 1;
        this.SAIPane.add((Component)this.minimumField, this.c);
        JLabel maximumLabel = new JLabel("Max:");
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 0;
        this.c.weightx = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.SAIPane.add((Component)maximumLabel, this.c);
        this.maximumField = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket2 = JUndo.makeTextUndoable(this.maximumField);
        this.maximumField.setName("maximumField");
        this.maximumField.setColumns(17);
        this.maximumField.setText(maxText);
        this.maximumField.setSelectionStart(0);
        this.maximumField.setSelectionEnd(0);
        this.c.insets = new Insets(5, 0, 5, 5);
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.c.gridx = 1;
        this.SAIPane.add((Component)this.maximumField, this.c);
        this.add(this.SAIPane);
    }

    @Override
    public Matcher createMatcher() {
        RangeMatcher rm = new RangeMatcher();
        rm.setAction(this.actionField.getText());
        rm.setSelection(this.selectionField.getText());
        rm.setMinimum(this.minimumField.getText());
        rm.setMaximum(this.maximumField.getText());
        rm.setActor("Student");
        Matcher m = this.edgeData.getMatcher();
        if (m != null) {
            rm.setDefaultInput(m.getDefaultInput());
            rm.setDefaultAction(m.getDefaultAction());
            rm.setDefaultSelection(m.getDefaultSelection());
            rm.setDefaultActor(m.getDefaultActor());
        }
        return rm;
    }

    @Override
    public String getMatcherType() {
        return "Range Match";
    }
}

