/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View.HintWindow;

import edu.cmu.pact.BehaviorRecorder.Controller.HintMessagesManagerImpl;
import edu.cmu.pact.BehaviorRecorder.View.HintWindow.HintWindowInterface;
import edu.cmu.pact.BehaviorRecorder.View.HintWindow.Hints;
import edu.cmu.pact.CommManager.RemoteCommMessageHandler;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.client.HintMessagesManager;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.MsgType;
import edu.cmu.pact.ctat.TutorController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pact.CommWidgets.JCommButton;
import pact.CommWidgets.JCommQuestion;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.event.IncorrectActionEvent;
import pact.CommWidgets.event.IncorrectActionListener;
import pact.CommWidgets.event.ProblemDoneEvent;
import pact.CommWidgets.event.ProblemDoneListener;
import pact.CommWidgets.event.StudentActionEvent;
import pact.CommWidgets.event.StudentActionListener;

public class HintPanel
extends JPanel
implements ActionListener,
StudentActionListener,
IncorrectActionListener,
ProblemDoneListener,
HintWindowInterface {
    private static final String PREVIOUS = " << ";
    private static final String NEXT = " >> ";
    public static final String DONE = "done";
    private HintMessagesManager messagesManager;
    JCommButton doneBtn;
    JCommButton hintBtn;
    Hints.HintJButton nextBtn;
    Hints.HintJButton prevBtn;
    JEditorPane messageTxt;
    String fontFamily = JCommWidget.getDefaultFont().getFamily();
    int fontSize = JCommWidget.getDefaultFont().getSize();
    Font bugFont = new Font(this.fontFamily, 1, 12);
    private boolean dfaPanel = false;
    boolean displayHint = true;
    private String originalQuestionMessage = "Let me try to break this problem down for you. Answer the following questions first";
    String pretestMessage = "No, but we will come back to this item later. Please click on the done button.";
    boolean pretest = false;
    private static String successMessage = "Good. That is correct. Click on the done button.";
    private Dimension minDimension = null;
    private boolean suppressFeedback = false;

    public HintPanel(TutorController controller, HintMessagesManager hintMessagesManager) {
        this.messagesManager = hintMessagesManager;
        this.setName("HintPanel");
        this.doneBtn = new JCommButton(){

            @Override
            public void sendValue() {
                if (this.getUniversalToolProxy() == null) {
                    HintPanel.this.messagesManager.requestDone();
                } else {
                    super.sendValue();
                }
            }
        };
        this.doneBtn.setCommName(DONE, controller);
        this.doneBtn.setText("Done");
        this.hintBtn = new JCommButton(){

            @Override
            public void sendValue() {
                if (this.getUniversalToolProxy() == null) {
                    HintPanel.this.messagesManager.requestHint();
                } else {
                    super.sendValue();
                }
            }
        };
        this.hintBtn.setCommName("hint", controller);
        this.hintBtn.setText("Help");
        this.nextBtn = new Hints.HintJButton(NEXT);
        this.nextBtn.addActionListener(this);
        this.prevBtn = new Hints.HintJButton(PREVIOUS);
        this.prevBtn.addActionListener(this);
        this.messageTxt = new MinSizeJEditorPane();
        this.messageTxt.setName("hintPanelMessageTxt");
        this.messageTxt.setContentType("text/html");
        this.messageTxt.setAutoscrolls(true);
        this.messageTxt.setEditable(false);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(1));
        btnPanel.add(this.doneBtn);
        btnPanel.add(this.hintBtn);
        btnPanel.add(this.prevBtn);
        btnPanel.add(this.nextBtn);
        JScrollPane sp = new JScrollPane(this.messageTxt);
        JLabel header = new JLabel("Messages");
        Font f = JCommWidget.getDefaultFont();
        header.setFont(new Font(f.getName(), 1, 12));
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new FlowLayout(1));
        headerPanel.add(header);
        HintPanel panel = this;
        panel.setLayout(new BorderLayout());
        panel.add((Component)sp, "Center");
        panel.add((Component)btnPanel, "South");
        panel.add((Component)headerPanel, "North");
        this.reset();
    }

    public HintPanel(HintMessagesManager hintMessagesManager) {
        this(null, hintMessagesManager);
    }

    public HintPanel(RemoteCommMessageHandler handler) {
        this(handler.messagesManager());
        handler.setHintInterface(this);
        this.doneBtn.setUniversalToolProxy(handler);
        this.hintBtn.setUniversalToolProxy(handler);
    }

    public HintPanel() {
        this(new HintMessagesManagerImpl(null));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        String message = null;
        if (source.equals(this.nextBtn)) {
            message = this.messagesManager.getNextMessage();
        } else if (source.equals(this.prevBtn)) {
            message = this.messagesManager.getPreviousMessage();
        }
        this.showMessage(message);
    }

    @Override
    public void showMessage(String message) {
        if (trace.getDebugCode("hint")) {
            trace.out("hint", "showMessage(" + message + ")");
        }
        if (message != null) {
            String msgType = this.messagesManager.getMessageType();
            if (msgType.equalsIgnoreCase("BuggyMessage") || msgType.equalsIgnoreCase("IncorrectAction")) {
                this.messageTxt.setFont(this.bugFont);
                this.messageTxt.setText("<b>" + message);
            } else {
                this.messageTxt.setFont(JCommWidget.getDefaultFont());
                this.messageTxt.setText(message);
            }
        }
        this.messageTxt.repaint();
        this.messagesManager.resetHighlightWidgets();
        this.checkButtons();
    }

    public void clearMessages() {
        this.messageTxt.setText("");
    }

    @Override
    public void reset() {
        this.clearMessages();
        this.prevBtn.setEnabled(false);
        this.nextBtn.setEnabled(false);
        this.messagesManager.reset();
        if (this.dfaPanel) {
            this.hintBtn.setEnabled(false);
        }
    }

    private void checkButtons() {
        String type = this.messagesManager.getMessageType();
        if (type.equals("BuggyMessage") || type.equals("SuccessMessage")) {
            this.prevBtn.setEnabled(false);
            this.nextBtn.setEnabled(false);
            this.repaint();
            return;
        }
        if (type.equals("ShowHintsMessage")) {
            if (this.messagesManager.hasNextMessage()) {
                this.nextBtn.setEnabled(true);
            } else {
                this.nextBtn.setEnabled(false);
            }
            if (this.messagesManager.hasPreviousMessage()) {
                this.prevBtn.setEnabled(true);
            } else {
                this.prevBtn.setEnabled(false);
            }
            this.hintBtn.reset(null);
        }
        this.repaint();
    }

    @Override
    public void studentActionPerformed(StudentActionEvent sae) {
        Object source;
        this.reset();
        if (this.dfaPanel) {
            this.hintBtn.setEnabled(false);
        }
        if ((source = sae.getSource()) instanceof JCommQuestion && ((JCommQuestion)source).isOriginalQuestion()) {
            this.displaySuccessMessage();
        }
        this.displayHint = true;
    }

    private void showNextMessage() {
        String message = "";
        if (!this.messagesManager.getMessageType().equals("SuccessMessage") && !this.displayHint) {
            if (!this.displayHint) {
                this.displayHint = true;
            }
            this.displayMessage(this.originalQuestionMessage, "BuggyMessage");
        }
        message = this.messagesManager.getNextMessage();
        this.showMessage(message);
    }

    @Override
    public void incorrectActionPerformed(IncorrectActionEvent e) {
        if (this.dfaPanel) {
            this.hintBtn.setEnabled(true);
        }
        this.showNextMessage();
    }

    @Override
    public synchronized void setDisplayHint(boolean displayHint) {
        this.displayHint = displayHint;
    }

    private void displayMessage(String message, String type) {
        Vector<String> v = new Vector<String>();
        v.add(message);
        this.messagesManager.setMessages(v);
        this.messagesManager.setMessageType(type);
    }

    @Override
    public void displaySuccessMessage() {
        this.displayMessage(successMessage, "SuccessMessage");
        this.showNextMessage();
    }

    @Override
    public void setSuppressFeedback(boolean suppressFeedback) {
        this.suppressFeedback = suppressFeedback;
        if (this.hintBtn != null) {
            this.hintBtn.setEnabled(!suppressFeedback);
        }
        if (this.nextBtn != null) {
            this.nextBtn.setEnabled(!suppressFeedback);
        }
        if (this.prevBtn != null) {
            this.prevBtn.setEnabled(!suppressFeedback);
        }
    }

    @Override
    public boolean getSuppressFeedback() {
        return this.suppressFeedback;
    }

    @Override
    public Component getDoneButton() {
        return this.doneBtn;
    }

    @Override
    public Component getHintButton() {
        return this.hintBtn;
    }

    @Override
    public JButton getPrevHintButton() {
        return this.prevBtn;
    }

    @Override
    public JButton getNextHintButton() {
        return this.nextBtn;
    }

    public HintMessagesManager getMessagesManager() {
        return this.messagesManager;
    }

    @Override
    public void problemDone(ProblemDoneEvent e) {
        this.displayBuggyMessage(this.pretestMessage);
    }

    @Override
    public void displayBuggyMessage(String buggyMessage) {
        this.displayMessage(buggyMessage, "BuggyMessage");
        this.showNextMessage();
    }

    public void handleMessageObject(MessageObject mo) {
        if (mo == null) {
            return;
        }
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "isCorrectOrIncorrect: " + MsgType.isCorrectOrIncorrect(mo));
        }
        if (MsgType.isCorrectOrIncorrect(mo)) {
            this.clearMessages();
        }
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "hasTextFeedback: " + MsgType.hasTextFeedback(mo));
        }
        if (MsgType.hasTextFeedback(mo)) {
            this.getMessagesManager().setMessageObject(mo);
            this.nextBtn.setEnabled(true);
        }
    }

    public class MinSizeJEditorPane
    extends JEditorPane {
        @Override
        public Dimension getMinimumSize() {
            if (HintPanel.this.minDimension == null) {
                FontMetrics bfm = HintPanel.this.messageTxt.getFontMetrics(HintPanel.this.bugFont);
                FontMetrics fm = HintPanel.this.messageTxt.getFontMetrics(JCommWidget.getDefaultFont());
                int height = Math.max(fm.getHeight(), bfm.getHeight());
                int width = 0;
                int[] widths = fm.getWidths();
                int[] bWidths = bfm.getWidths();
                for (int i = Math.min(widths.length, bWidths.length) - 1; 0 <= i; --i) {
                    if (width < widths[i]) {
                        width = widths[i];
                    }
                    if (width >= bWidths[i]) continue;
                    width = bWidths[i];
                }
                HintPanel.this.minDimension = new Dimension(20 * width, 2 * height);
            }
            return HintPanel.this.minDimension;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension md = this.getMinimumSize();
            try {
                Dimension pd = super.getPreferredSize();
                Dimension d = new Dimension(Math.max(pd.width, md.width), Math.max(pd.height, md.height));
                return d;
            }
            catch (Exception e) {
                trace.errStack("error from MinSizeJEditorPane.setPreferredSize(): " + e + (e.getCause() == null ? "" : "; cause " + e.getCause()), e);
                return md;
            }
        }
    }
}

