/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.Controller.RuleLabelHandler;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.View.BRPanel;
import edu.cmu.pact.BehaviorRecorder.View.BR_Label;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.MarathonElement;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.jdom.Content;
import org.jdom.Element;

public class RuleLabel
extends BR_Label
implements MarathonElement {
    private String ruleNameText = null;
    private boolean nameSet;
    private boolean mouseEntered;
    private BR_Controller controller;
    private RuleLabelHandler ruleLabelHandler;

    public void restoreTransients(BR_Controller controller) {
        this.controller = controller;
        if (this.ruleLabelHandler != null) {
            this.ruleLabelHandler.restoreTransients(controller);
        }
    }

    public RuleLabel(String ruleNameText, BR_Controller controller) {
        this.controller = controller;
        this.ruleNameText = ruleNameText;
        this.setText(ruleNameText);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                RuleLabel.this.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RuleLabel.this.mouseExited(e);
            }
        });
    }

    public RuleLabel(RuleLabel l) {
        this.controller = l.controller;
        if (this.controller == null) {
            throw new NullPointerException("BR_Controller == null");
        }
        this.ruleNameText = l.ruleNameText;
        this.setText(this.ruleNameText);
        this.nameSet = l.nameSet;
    }

    public String getRuleName() {
        return this.ruleNameText;
    }

    @Override
    public void setText(String ruleText) {
        super.setText(ruleText);
        this.ruleNameText = ruleText;
        this.nameSet = true;
    }

    public boolean isNameSet() {
        return this.nameSet;
    }

    public void update(ProblemNode startNode, ProblemNode endNode, int ruleNumber, int ruleCount) {
        NodeView startVertex = startNode.getNodeView();
        if (startVertex == null) {
            return;
        }
        NodeView endVertex = endNode.getNodeView();
        Point startPoint = new Point(startVertex.getOutgoingEdgePoint());
        Point endPoint = new Point(endVertex.getIncomingEdgePoint());
        Point location = new Point();
        this.resetSize();
        double factor = 0.75;
        startPoint.x = (int)((double)startPoint.x + (double)(endPoint.x - startPoint.x) * factor);
        startPoint.y = (int)((double)startPoint.y + (double)(endPoint.y - startPoint.y) * factor);
        location.x = startPoint.x + (endPoint.x - startPoint.x) / ruleCount * ruleNumber - this.getSize().width / 2;
        location.y = startPoint.y + (endPoint.y - startPoint.y) / ruleCount * ruleNumber - this.getSize().height / 2;
        this.setLocation(location);
        this.setVisible(this.controller.getShowRuleLabels());
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.mouseEntered) {
            this.setFont(null);
            this.mouseEntered = true;
            this.resetSize();
            this.controller.fireCtatModeEvent(CtatModeEvent.REPAINT);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.mouseEntered) {
            this.setFont(BRPanel.SMALL_FONT);
            this.mouseEntered = false;
            this.resetSize();
            this.controller.fireCtatModeEvent(CtatModeEvent.REPAINT);
        }
    }

    @Override
    public String toString() {
        return this.getRuleName();
    }

    public RuleLabelHandler getHandler() {
        return this.ruleLabelHandler;
    }

    public void setHandler(RuleLabelHandler handler) {
        this.ruleLabelHandler = handler;
    }

    @Override
    public String getMarathonIdentifier() {
        return "Edge" + this.ruleLabelHandler.getProblemEdge().getActionLabel().getUniqueID() + "::Rule::" + this.ruleNameText;
    }

    @Override
    public int getTextStyle() {
        try {
            return this.ruleLabelHandler.getProblemEdge().getActionLabel().getFont().getStyle();
        }
        catch (NullPointerException npe) {
            System.out.println("Marathon threw NPE getting text style for rule label");
            System.out.println("Couldn't get text style for " + this.getMarathonIdentifier() + "; return 0 instead");
            return 0;
        }
    }

    @Override
    public String getToolTipText() {
        return "";
    }

    public Element toElement() {
        Element elt = new Element("rule");
        String text = this.getText();
        if (text != null) {
            elt.addContent((Content)new Element("text").setText(text));
        }
        elt.addContent((Content)new Element("indicator").setText(Integer.toString(-1)));
        return elt;
    }
}

