/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.jgraphwindow;

import edu.cmu.pact.BehaviorRecorder.Controller.ActionLabelHandler;
import edu.cmu.pact.BehaviorRecorder.Controller.RuleLabelHandler;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.View.RuleLabel;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_EdgeRenderer;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraph;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphEdge;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.MarathonElement;
import edu.cmu.pact.Utilities.trace;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jgraph.JGraph;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;

public class BR_JGraphEdgeView
extends EdgeView {
    private static final long serialVersionUID = -7748053385117552070L;
    private static EdgeRenderer renderer = new BR_EdgeRenderer();
    private BR_JGraphEdge jgraphEdge;
    private ProblemEdge problemEdge;
    private Rectangle2D actionLabelBounds;
    private Rectangle2D LispCheckLabelBounds;
    private List<Rectangle2D> ruleBoundsList = new ArrayList<Rectangle2D>();

    public BR_JGraphEdgeView(Object cell) {
        super(cell);
        this.jgraphEdge = (BR_JGraphEdge)cell;
        this.problemEdge = this.jgraphEdge.getProblemEdge();
    }

    public boolean intersects(JGraph graph, Rectangle2D rect) {
        if (super.intersects(graph, rect)) {
            return true;
        }
        if (this.intersectsActionLabel(rect)) {
            return true;
        }
        int index = this.getRuleBoundsIndex(rect);
        return index != -1;
    }

    private int getRuleBoundsIndex(Rectangle2D rect) {
        if (!this.problemEdge.getController().getShowRuleLabels()) {
            return -1;
        }
        int index = -1;
        for (int i = 0; i < this.ruleBoundsList.size(); ++i) {
            Rectangle2D bound = this.ruleBoundsList.get(i);
            if (!bound.intersects(rect)) continue;
            index = i;
            break;
        }
        return index;
    }

    private boolean intersectsActionLabel(Rectangle2D rect) {
        return this.actionLabelBounds != null && this.problemEdge.getController().getShowActionLabels() && this.actionLabelBounds.intersects(rect);
    }

    private boolean intersectsCheckLispLabel(Rectangle2D rect) {
        return this.LispCheckLabelBounds != null && this.problemEdge.getController().isPreCheckLISPLabelsFlag() && this.LispCheckLabelBounds.intersects(rect);
    }

    private boolean intersectsLink(Rectangle2D rect) {
        Rectangle2D bounds = this.getBounds();
        return bounds != null && bounds.intersects(rect);
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public void update() {
        boolean preferred = this.problemEdge.isPreferredEdge();
        if (preferred) {
            GraphConstants.setLineWidth((Map)this.getAttributes(), (float)2.0f);
        } else {
            GraphConstants.setLineWidth((Map)this.getAttributes(), (float)1.0f);
        }
        super.update(this.problemEdge.getController().getJGraphWindow().getJGraph().getGraphLayoutCache());
    }

    public boolean isMouseOver() {
        return this.jgraphEdge.getController().getMouseOverCell() == this.jgraphEdge;
    }

    public ProblemEdge getProblemEdge() {
        return this.problemEdge;
    }

    public void setActionLabelBounds(Rectangle2D actionLabelBounds) {
        this.actionLabelBounds = actionLabelBounds;
    }

    public void doClick(MouseEvent e) {
        if (trace.getDebugCode("editstudentinput")) {
            trace.out("editstudentinput", String.format("BR_JGraphEdgeView.doClick(x=%d, y=%d, count=%d): edge %s", e.getX(), e.getY(), e.getClickCount(), this.problemEdge.getUniqueID()));
        }
        this.problemEdge.getController().comeIntoFocus();
        Rectangle2D.Float rect = new Rectangle2D.Float(e.getX(), e.getY(), 1.0f, 1.0f);
        if (this.intersectsActionLabel(rect)) {
            if (e.getClickCount() > 1) {
                ActionLabelHandler.doubleClick(e, this.problemEdge.getController(), this.problemEdge.getActionHandler());
            } else if (BR_JGraph.wasRightClick(e)) {
                ActionLabelHandler.evaluatePopup(e, this.problemEdge.getController(), this.problemEdge.getActionHandler());
            }
            return;
        }
        int index = this.getRuleBoundsIndex(rect);
        if (index == -1) {
            return;
        }
        RuleLabel label = this.problemEdge.getEdgeData().getRuleLabels().get(index);
        RuleLabelHandler.evaluatePopup(e, this.problemEdge.getController(), label.getHandler());
    }

    public void addRuleBound(Rectangle2D ruleLabelBounds) {
        this.ruleBoundsList.add(ruleLabelBounds);
    }

    public List<Rectangle2D> getRuleBoundsList() {
        return this.ruleBoundsList;
    }

    public void clearRuleBoundsList() {
        this.ruleBoundsList.clear();
    }

    public MarathonElement getMarathonElement(Point location) {
        Rectangle2D.Double rect = new Rectangle2D.Double(location.x, location.y, 1.0, 1.0);
        if (this.intersectsActionLabel(rect)) {
            return this.problemEdge.getActionLabel();
        }
        if (this.intersectsCheckLispLabel(rect)) {
            return this.problemEdge.getPreLispCheckLabel();
        }
        int index = this.getRuleBoundsIndex(rect);
        if (index != -1) {
            RuleLabel label = this.problemEdge.getEdgeData().getRuleLabels().get(index);
            return label;
        }
        if (this.intersectsLink(rect)) {
            return this.jgraphEdge;
        }
        return null;
    }

    public Rectangle2D getActionLabelBounds() {
        return this.actionLabelBounds;
    }

    public Rectangle2D getLispCheckLabelBounds() {
        return this.LispCheckLabelBounds;
    }

    public void setLispCheckLabelBounds(Rectangle2D lispCheckLabelBounds) {
        this.LispCheckLabelBounds = lispCheckLabelBounds;
    }
}

