/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log.LogDifferences.Content;

import edu.cmu.pact.Log.LogDifferences.Content.ColumnFormatter;
import edu.cmu.pact.Log.LogDifferences.Content.Content;
import edu.cmu.pact.Log.LogDifferences.Content.ContentCell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SkillContent
implements Content {
    private static final String SKILL = "skill";
    private final int index;
    private final String probability;
    private final String name;
    private final String category;
    private final List<String> model_names;
    private final Boolean buggy;

    public SkillContent(int index, String probability, String name, String category, List<String> model_names, Boolean buggy) {
        this.index = index;
        this.probability = probability;
        this.name = name;
        this.category = category;
        this.model_names = model_names;
        this.buggy = buggy;
    }

    @Override
    public Iterator<ContentCell> iterator() {
        ArrayList<ContentCell> skillList = new ArrayList<ContentCell>();
        this.addCell(skillList, SKILL, this.index, "probability", this.probability);
        this.addCell(skillList, SKILL, this.index, "name", this.name);
        this.addCell(skillList, SKILL, this.index, "category", this.category);
        if (this.model_names != null) {
            this.addCell(skillList, SKILL, this.index, "model_name", this.model_names.toString());
        }
        if (this.buggy != null) {
            this.addCell(skillList, SKILL, this.index, "buggy", this.buggy.toString());
        }
        return Collections.unmodifiableList(skillList).iterator();
    }

    private boolean addCell(ArrayList<ContentCell> skillList, String fieldType, int index, String property, String content) {
        if (content == null) {
            return false;
        }
        ContentCell cell = this.makeCell(fieldType, index, property, content);
        skillList.add(cell);
        return true;
    }

    private ContentCell makeCell(String fieldType, int index, String property, String content) {
        ContentCell.ContentCellBuilder builder = new ContentCell.ContentCellBuilder();
        builder.fieldType(fieldType).index(index).propertyName(property).content(content).formatter(new SkillColumnFormatter());
        return builder.buildCell();
    }

    public String getProbability() {
        return this.probability;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public List<String> getModel_names() {
        return this.model_names;
    }

    public Boolean getBuggy() {
        return this.buggy;
    }

    public static class SkillComparator
    implements Comparator<ContentCell> {
        @Override
        public int compare(ContentCell cell1, ContentCell cell2) {
            if (!cell1.getFieldType().equals(SkillContent.SKILL) || !cell2.getFieldType().equals(SkillContent.SKILL)) {
                throw new ClassCastException("Must compare two skill cells");
            }
            if (cell1.getIndex() != cell2.getIndex()) {
                return cell1.getIndex() - cell2.getIndex();
            }
            List<String> indicies = Collections.unmodifiableList(Arrays.asList("probability", "name", "category", "model_name", "buggy"));
            int index1 = indicies.indexOf(cell1.getPropertyName());
            int index2 = indicies.indexOf(cell2.getPropertyName());
            return index1 - index2;
        }
    }

    static class SkillColumnFormatter
    implements ColumnFormatter {
        SkillColumnFormatter() {
        }

        @Override
        public String makeColumnName(String fieldType, int index, String propertyName) {
            return fieldType + index + " " + propertyName;
        }
    }
}

