/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log;

import edu.cmu.oli.log.client.ActionLog;
import edu.cmu.pact.Log.TutorActionLogV4;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pslc.logging.ContextMessage;
import edu.cmu.pslc.logging.Message;
import edu.cmu.pslc.logging.PlainMessage;
import edu.cmu.pslc.logging.ToolMessage;
import edu.cmu.pslc.logging.TutorMessage;
import edu.cmu.pslc.logging.element.ActionEvaluationElement;
import edu.cmu.pslc.logging.element.EventElement;
import edu.cmu.pslc.logging.element.MetaElement;
import edu.cmu.pslc.logging.element.SemanticEventElement;
import edu.cmu.pslc.logging.util.DateTools;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.server.UID;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class TutorActionLog
extends ActionLog {
    public static final String USER_GUID_ATTR = "user_guid";
    public static final String SESSION_ID_ATTR = "session_id";
    public static final String DATE_TIME_ATTR = "date_time";
    public static final String TIMEZONE_ATTR = "timezone";
    public static final String DEFAULT_TIME_ZONE = "UTC";
    public static final String LOG_ACTION_ELEMENT = "log_action";
    public static final String MSG_SEQUENCE_ELEMENT = "tutor_related_message_sequence";
    public static final String VERSION_NUMBER_ATTR = "version_number";
    static final String VERSION_NUMBER = "2";
    public static final String TOOL_MSG_ELEMENT = "tool_message";
    public static final String TUTOR_MSG_ELEMENT = "tutor_message";
    public static final String CURRICULUM_MSG_ELEMENT = "curriculum_message";
    public static final String CONTEXT_MSG_ELEMENT = "context_message";
    public static final String MSG_ELEMENT = "message";
    public static final String PROBLEMNAME_ELEMENT = "problem_name";
    public static final String TUTOR_ADVICE_ELEMENT = "tutor_advice";
    public static final String DFA_ELEMENT = "dfa";
    public static final String PRODUCTION_ELEMENT = "production";
    public static final String SCHOOLNAME_ELEMENT = "school_name";
    public static final String COURSENAME_ELEMENT = "course_name";
    public static final String UNITNAME_ELEMENT = "unit_name";
    public static final String SECTIONNAME_ELEMENT = "section_name";
    public static final String PROPERTY_ELEMENT = "property";
    private static final String INFO_TYPE = "tutor_message.dtd";
    private static Iterator emptyIterator = new EmptyIterator();
    private static DateFormat dateFmtMS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    private static DateFormat dateFmtSS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private static DateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
    private static XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat().setIndent(" ").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator("\n"));
    protected String topElementType = null;
    protected Message msg;
    private String attemptId = null;
    private String problemName = null;
    private Map uiEvents = null;
    private Map semanticEvents = null;
    private Map eventDescriptors = null;
    private List actionEvaluations = null;
    private List tutorAdvices = null;
    private List dfas = null;
    protected List skills = null;
    private List productions = null;
    private String schoolName = null;
    private String courseName = null;
    private String unitName = null;
    private String sectionName = null;
    private List msgProperties = null;
    private static DateFormat dateFmtMSSSSS = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSSSS z");
    private static DateFormat dateFmtMSSS = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS z");

    public TutorActionLog(String topElementType) {
        this.setTopElementType(topElementType);
    }

    public TutorActionLog(Element elt, MetaElement meta) {
        this.setMetaData(meta);
        try {
            this.parseElement(elt);
        }
        catch (JDOMException de) {
            Throwable cause = de.getCause();
            if (cause != null) {
                cause.printStackTrace();
            } else {
                de.printStackTrace();
            }
            throw new RuntimeException("XML exception = " + de.toString() + (cause == null ? "" : "; cause " + cause));
        }
    }

    private void setMetaData(Element metaElt, Namespace ns) {
        String userGuid = metaElt.getChildTextTrim("user_id", ns);
        String sessionId = metaElt.getChildTextTrim(SESSION_ID_ATTR, ns);
        String time = metaElt.getChildTextTrim("time", ns);
        String timeZone = metaElt.getChildTextTrim("time_zone", ns);
        MetaElement meta = new MetaElement(userGuid, sessionId, time, timeZone);
        this.setMetaData(meta);
    }

    private void setMetaData(MetaElement meta) {
        if (meta == null) {
            return;
        }
        String s = meta.getUserId();
        if (s != null && s.length() > 0) {
            this.setUserGuid(s);
        }
        if ((s = meta.getSessionId()) != null && s.length() > 0) {
            this.setSessionId(s);
        }
        if ((s = meta.getTime()) != null && s.length() > 0) {
            this.setTimeStamp(TutorActionLog.getDate(s, meta.getTimeZone()));
        }
        if ((s = meta.getTimeZone()) != null && s.length() > 0) {
            this.setTimezone(s);
        }
    }

    public static Date getDate(String timeString, String timeZone) {
        ParsePosition pos;
        String twz;
        Date timeStamp;
        if (timeZone == null) {
            timeZone = "EST";
        }
        if ((timeStamp = dateFmtMSSSSS.parse(twz = timeString.trim() + " " + timeZone, pos = new ParsePosition(0))) != null) {
            return timeStamp;
        }
        timeStamp = dateFmtMSSS.parse(twz, pos);
        if (timeStamp != null) {
            return timeStamp;
        }
        return DateTools.getDate((String)timeString, (String)timeZone);
    }

    public static TutorActionLog factory(String xmlStr, String dtdVersion, MetaElement meta) {
        Iterator it = TutorActionLog.factoryIterator(new StringReader(xmlStr), dtdVersion, meta);
        return (TutorActionLog)((Object)it.next());
    }

    public static Iterator factoryIterator(Reader rdr, String dtdVersion, MetaElement meta) {
        try {
            return new Factory(rdr, dtdVersion, meta);
        }
        catch (JDOMException de) {
            Throwable cause = de.getCause();
            if (cause != null) {
                cause.printStackTrace();
            } else {
                de.printStackTrace();
            }
            throw new RuntimeException("XML exception = " + de.toString() + (cause == null ? "" : "; cause " + cause));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    public String toString() {
        return outputter.outputString(this.getDocument());
    }

    protected Document getDocument() {
        Element root = new Element(MSG_SEQUENCE_ELEMENT);
        root.setAttribute(VERSION_NUMBER_ATTR, this.getDTDVersionNumber());
        root.addContent((Content)this.getElement());
        return new Document(root);
    }

    public String getElementString() {
        return outputter.outputString(this.getElement());
    }

    protected Element getElement() {
        Element root = new Element(this.topElementType);
        if (this.attemptId != null) {
            root.setAttribute("attempt_id", this.attemptId);
        }
        if (CURRICULUM_MSG_ELEMENT.equals(this.topElementType)) {
            return this.getCurriculumElement(root);
        }
        if (MSG_ELEMENT.equals(this.topElementType)) {
            return this.getMsgElement(root);
        }
        if (this.problemName != null) {
            root.addContent((Content)TutorActionLog.stringToElement(PROBLEMNAME_ELEMENT, this.problemName));
        }
        Iterator it = this.uiEventsIterator();
        while (it.hasNext()) {
            root.addContent((Content)((UIEvent)it.next()).getElement());
        }
        it = this.semanticEventsIterator();
        while (it.hasNext()) {
            root.addContent((Content)((SemanticEvent)it.next()).getElement());
        }
        it = this.eventDescriptorsIterator();
        while (it.hasNext()) {
            root.addContent((Content)((EventDescriptor)it.next()).getElement());
        }
        it = this.actionEvaluationsIterator();
        while (it.hasNext()) {
            root.addContent((Content)((ActionEvaluation)it.next()).getElement());
        }
        it = this.tutorAdvicesIterator();
        while (it.hasNext()) {
            root.addContent((Content)TutorActionLog.stringToElement(TUTOR_ADVICE_ELEMENT, (String)it.next()));
        }
        it = this.skillsIterator();
        while (it.hasNext()) {
            root.addContent((Content)((Skill)it.next()).getElement());
        }
        it = this.productionsIterator();
        while (it.hasNext()) {
            root.addContent((Content)TutorActionLog.stringToElement(PRODUCTION_ELEMENT, (String)it.next()));
        }
        return root;
    }

    public String getTopElementType() {
        return this.topElementType;
    }

    protected Element getCurriculumElement(Element root) {
        if (this.schoolName != null) {
            root.addContent((Content)TutorActionLog.stringToElement(SCHOOLNAME_ELEMENT, this.schoolName));
        }
        if (this.courseName != null) {
            root.addContent((Content)TutorActionLog.stringToElement(COURSENAME_ELEMENT, this.courseName));
        }
        if (this.unitName != null) {
            root.addContent((Content)TutorActionLog.stringToElement(UNITNAME_ELEMENT, this.unitName));
        }
        if (this.sectionName != null) {
            root.addContent((Content)TutorActionLog.stringToElement(SECTIONNAME_ELEMENT, this.sectionName));
        }
        if (this.problemName != null) {
            root.addContent((Content)TutorActionLog.stringToElement(PROBLEMNAME_ELEMENT, this.problemName));
        }
        Iterator it = this.dfasIterator();
        while (it.hasNext()) {
            root.addContent((Content)TutorActionLog.stringToElement(DFA_ELEMENT, (String)it.next()));
        }
        it = this.skillsIterator();
        while (it.hasNext()) {
            root.addContent((Content)((Skill)it.next()).getElement());
        }
        it = this.productionsIterator();
        while (it.hasNext()) {
            root.addContent((Content)TutorActionLog.stringToElement(PRODUCTION_ELEMENT, (String)it.next()));
        }
        return root;
    }

    protected Element getMsgElement(Element root) {
        if (this.msgProperties == null) {
            return root;
        }
        Iterator it = this.msgProperties.iterator();
        while (it.hasNext()) {
            root.addContent((Content)((MsgProperty)it.next()).getElement());
        }
        return root;
    }

    protected void parseElement(Element elt) throws JDOMException {
        Namespace ns = elt.getNamespace();
        trace.out("log", "TutorActionLog.parseElement(" + outputter.outputString(elt) + ")");
        if (trace.getDebugCode("log")) {
            List children = elt.getChildren();
            trace.outNT("log", "nChildren " + children.size() + ", ns " + elt.getNamespace());
            for (Object child : children) {
                trace.outNT("log", (child instanceof Element ? ((Element)child).getName() : child).toString());
            }
        }
        this.setTopElementType(elt.getName());
        this.attemptId = elt.getAttributeValue("attempt_id", ns);
        Element metaElt = elt.getChild("meta", ns);
        if (metaElt != null) {
            trace.out("log", "meta TutorActionLog.parseElement(" + outputter.outputString(metaElt) + ")");
            this.setMetaData(metaElt, ns);
        }
        ContextMessage cmsg = this.createMinimalContextMsg(elt);
        if (TOOL_MSG_ELEMENT.equals(this.topElementType)) {
            this.msg = ToolMessage.create((ContextMessage)cmsg);
            this.parseCommonContent(elt, ns);
        } else if (TUTOR_MSG_ELEMENT.equals(this.topElementType)) {
            ToolMessage tmsg = ToolMessage.create((ContextMessage)cmsg);
            this.msg = TutorMessage.create((ToolMessage)tmsg);
            this.parseCommonContent(elt, ns);
            this.parseTutorMsgContent(elt, ns);
        } else if (CURRICULUM_MSG_ELEMENT.equals(this.topElementType)) {
            this.msg = cmsg;
            this.parseCurriculumContent(elt, ns);
        } else if (CONTEXT_MSG_ELEMENT.equals(this.topElementType)) {
            this.msg = cmsg;
            this.parseCurriculumContent(elt, ns);
        } else if (MSG_ELEMENT.equals(this.topElementType)) {
            this.msg = PlainMessage.create((ContextMessage)cmsg);
            this.parseMsgContent(elt, ns);
        } else {
            throw new JDOMException("Undefined message element tag: " + this.topElementType);
        }
    }

    private ContextMessage createMinimalContextMsg(Element elt) {
        ContextMessage cmsg = ContextMessage.createStartProblem((MetaElement)this.getMetaElement());
        String cid = elt.getAttributeValue("context_message_id");
        cmsg.setContextMessageId(cid == null ? "" : cid);
        return cmsg;
    }

    public MetaElement getMetaElement() {
        Date date = this.getTimeStamp();
        MetaElement meta = new MetaElement(this.getUserGuid(), this.getSessionId(), date == null ? "" : dateFmt.format(date), this.getTimezone());
        return meta;
    }

    protected void parseCommonContent(Element msgElt, Namespace ns) throws JDOMException {
        this.problemName = msgElt.getChildText(PROBLEMNAME_ELEMENT, ns);
        if (trace.getDebugCode("log")) {
            trace.out("log", "parseCommonContent problemName " + this.problemName + "\ninstance of " + (this.msg instanceof ToolMessage ? "ToolMessage" : "TutorMessage"));
        }
        if (this.msg instanceof ToolMessage) {
            ((ToolMessage)this.msg).setProblemName(this.problemName);
        } else if (this.msg instanceof TutorMessage) {
            ((TutorMessage)this.msg).setProblemName(this.problemName);
        }
        Iterator it = msgElt.getChildren("ui_event", ns).iterator();
        if (it.hasNext()) {
            this.uiEvents = new LinkedHashMap();
            do {
                UIEvent se = new UIEvent((Element)it.next());
                this.uiEvents.put(se.getId(), se);
            } while (it.hasNext());
        }
        List elts = msgElt.getChildren("semantic_event", ns);
        trace.out("log", "TutorActionLog.parseCommonContent(" + this.msg + "," + msgElt.getName() + ") " + "semantic_event" + " count " + elts.size());
        Iterator it2 = elts.iterator();
        if (it2.hasNext()) {
            this.semanticEvents = new LinkedHashMap();
            do {
                SemanticEvent se = new SemanticEvent((Element)it2.next());
                this.semanticEvents.put(se.getId(), se);
                if (trace.getDebugCode("log")) {
                    trace.out("log", "parseCommonContent semanticEvent " + se.getText() + "\ninstance of " + (this.msg instanceof ToolMessage ? "ToolMessage" : "TutorMessage"));
                }
                if (this.msg instanceof ToolMessage) {
                    ((ToolMessage)this.msg).setEventElement((EventElement)se.getEventElement());
                    continue;
                }
                if (!(this.msg instanceof TutorMessage)) continue;
                ((TutorMessage)this.msg).setEventElement((EventElement)se.getEventElement());
            } while (it2.hasNext());
        }
        elts = msgElt.getChildren("event_descriptor", ns);
        trace.out("log", "TutorActionLog.parseCommonContent(" + this.msg + "," + msgElt.getName() + ") " + "event_descriptor" + " count " + elts.size());
        it2 = elts.iterator();
        if (it2.hasNext()) {
            this.eventDescriptors = new LinkedHashMap();
            do {
                EventDescriptor ed = new EventDescriptor((Element)it2.next(), this.msg);
                this.eventDescriptors.put(ed.getLinkedEventId(), ed);
                if (!trace.getDebugCode("log")) continue;
                trace.out("log", "parseCommonContent eventDescriptors " + ed.getSelections() + ed.getActions() + ed.getInputs());
            } while (it2.hasNext());
        }
    }

    protected void parseTutorMsgContent(Element msgElt, Namespace ns) throws JDOMException {
        String text;
        Iterator it;
        if (trace.getDebugCode("log")) {
            trace.outln("log", "parseTutorMsgContent");
        }
        if ((it = msgElt.getChildren("action_evaluation", ns).iterator()).hasNext()) {
            this.actionEvaluations = new LinkedList();
            do {
                ActionEvaluation e = new ActionEvaluation((Element)it.next());
                this.actionEvaluations.add(e);
                if (trace.getDebugCode("log")) {
                    trace.out("log", "parseTutorMsgContent actionEvaluations " + e);
                }
                if (!(this.msg instanceof TutorMessage)) continue;
                ActionEvaluationElement aee = new ActionEvaluationElement(e.getCurrentHintNumber(), e.getTotalHintsAvailable(), null, null, e.getText());
                ((TutorMessage)this.msg).setActionEvaluationElement(aee);
                if (!trace.getDebugCode("log")) continue;
                trace.out("log", "actionEvaluation instanceOf TutorMessage. actionEvaluationElement is " + aee);
            } while (it.hasNext());
        }
        if ((it = msgElt.getChildren(TUTOR_ADVICE_ELEMENT, ns).iterator()).hasNext()) {
            this.tutorAdvices = new LinkedList();
            do {
                text = ((Element)it.next()).getTextTrim();
                if (trace.getDebugCode("log")) {
                    trace.out("log", "parseTutorMsgContent tutor Advice " + text);
                }
                this.tutorAdvices.add(text);
                if (!(this.msg instanceof TutorMessage)) continue;
                ((TutorMessage)this.msg).addTutorAdvice(text);
            } while (it.hasNext());
        }
        this.parseSkills(msgElt, ns);
        it = msgElt.getChildren(PRODUCTION_ELEMENT, ns).iterator();
        if (it.hasNext()) {
            this.productions = new LinkedList();
            do {
                text = ((Element)it.next()).getTextTrim();
                this.productions.add(text);
                if (!trace.getDebugCode("log")) continue;
                trace.out("log", "parseTutorMsgContent production values " + text);
            } while (it.hasNext());
        }
    }

    protected void parseSkills(Element msgElt, Namespace ns) throws JDOMException {
        Iterator it = msgElt.getChildren("skill", ns).iterator();
        if (it.hasNext()) {
            this.skills = new LinkedList();
            do {
                Skill s = new Skill((Element)it.next());
                this.skills.add(s);
                if (!trace.getDebugCode("log")) continue;
                trace.out("log", "parseTutorMsgContent->parseSKills " + s);
            } while (it.hasNext());
        }
    }

    protected void parseCurriculumContent(Element msgElt, Namespace ns) throws JDOMException {
        String text;
        this.schoolName = msgElt.getChildText(SCHOOLNAME_ELEMENT, ns);
        this.courseName = msgElt.getChildText(COURSENAME_ELEMENT, ns);
        this.unitName = msgElt.getChildText(UNITNAME_ELEMENT, ns);
        this.sectionName = msgElt.getChildText(SECTIONNAME_ELEMENT, ns);
        this.problemName = msgElt.getChildText(PROBLEMNAME_ELEMENT, ns);
        Iterator it = msgElt.getChildren(DFA_ELEMENT, ns).iterator();
        if (it.hasNext()) {
            this.dfas = new LinkedList();
            do {
                text = ((Element)it.next()).getTextTrim();
                this.dfas.add(text);
            } while (it.hasNext());
        }
        if ((it = msgElt.getChildren("skill", ns).iterator()).hasNext()) {
            this.skills = new LinkedList();
            do {
                Skill e = new Skill((Element)it.next());
                this.skills.add(e);
            } while (it.hasNext());
        }
        if ((it = msgElt.getChildren(PRODUCTION_ELEMENT, ns).iterator()).hasNext()) {
            this.productions = new LinkedList();
            do {
                text = ((Element)it.next()).getTextTrim();
                this.productions.add(text);
            } while (it.hasNext());
        }
    }

    protected void parseMsgContent(Element msgElt, Namespace ns) throws JDOMException {
        for (Element elt : msgElt.getChildren(PROPERTY_ELEMENT, ns)) {
            this.addMsgProperty(new MsgProperty(elt));
        }
    }

    public UIEvent getUIEvent(String id) {
        if (this.uiEvents == null) {
            return null;
        }
        return (UIEvent)this.uiEvents.get(id);
    }

    public Iterator uiEventsIterator() {
        if (this.uiEvents == null) {
            return emptyIterator;
        }
        return this.uiEvents.values().iterator();
    }

    public String addSemanticEvent(String name, String id, String linkedEventId) {
        SemanticEvent result = null;
        if (this.semanticEvents == null) {
            this.semanticEvents = new LinkedHashMap();
        }
        result = id == null || id.length() < 1 ? new SemanticEvent(name) : new SemanticEvent(id, name);
        result.setLinkedEventId(linkedEventId);
        this.semanticEvents.put(result.getId(), result);
        return result.getId();
    }

    public String addEventDescriptor(String id, String action, String selection, String input) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new Action(action, null));
        ArrayList<Selection> selections = new ArrayList<Selection>();
        selections.add(new Selection(selection, null, null));
        ArrayList<Input> inputs = new ArrayList<Input>();
        inputs.add(new Input(input, null));
        return this.addEventDescriptorInternal(id, actions, selections, inputs);
    }

    public String addEventDescriptorInternal(String id, List actions, List selections, List inputs) {
        if (this.eventDescriptors == null) {
            this.eventDescriptors = new LinkedHashMap();
        }
        EventDescriptor ed = new EventDescriptor(id, actions, selections, inputs);
        this.eventDescriptors.put(ed.getLinkedEventId(), ed);
        return ed.getLinkedEventId();
    }

    public void addActionEvaluation(String text) {
        this.addActionEvaluation(text, null, null);
    }

    public void addActionEvaluation(String text, int currentHintNumber, int totalHintsAvailable) {
        System.out.println("tutorActionLog addActionEvaluation");
        this.addActionEvaluation(text, Integer.toString(currentHintNumber), Integer.toString(totalHintsAvailable));
    }

    public void addActionEvaluation(String text, String currentHintNumber, String totalHintsAvailable) {
        if (this.actionEvaluations == null) {
            this.actionEvaluations = new LinkedList();
            System.out.println("instantiating actionEvaluations list");
        }
        ActionEvaluation e = new ActionEvaluation(text, currentHintNumber, totalHintsAvailable);
        System.out.println("addActionEvaluation");
        this.actionEvaluations.add(e);
    }

    public void addTutorAdvice(String text) {
        if (this.tutorAdvices == null) {
            this.tutorAdvices = new LinkedList();
        }
        this.tutorAdvices.add(text);
    }

    public void addDfa(String text) {
        if (this.dfas == null) {
            this.dfas = new LinkedList();
        }
        this.dfas.add(text);
    }

    public void addProduction(String text) {
        if (this.productions == null) {
            this.productions = new LinkedList();
        }
        this.productions.add(text);
    }

    public void addSkill(String text) {
        this.addSkill(text, null);
    }

    public void addSkill(String text, double probability) {
        this.addSkill(text, Double.toString(probability));
    }

    public void addSkill(String text, String probability) {
        if (this.skills == null) {
            this.skills = new LinkedList();
        }
        Skill e = new Skill(text, probability);
        this.skills.add(e);
    }

    private void addMsgProperty(MsgProperty e) {
        if (this.msgProperties == null) {
            this.msgProperties = new LinkedList();
        }
        this.msgProperties.add(e);
    }

    public void addMsgProperty(String text, String stringValue) {
        this.addMsgProperty(new MsgProperty(text, stringValue));
    }

    public void addMsgProperty(String text, List list) {
        this.addMsgProperty(new MsgProperty(text, list));
    }

    public String getProblemName() {
        return this.problemName != null ? this.problemName : "";
    }

    public void setProblemName(String name) {
        this.problemName = name != null ? name : "";
    }

    public SemanticEvent getSemanticEvent(String id) {
        if (this.semanticEvents == null) {
            return null;
        }
        if (id == null || id.length() < 1) {
            Iterator it = this.semanticEventsIterator();
            SemanticEvent result = it.hasNext() ? it.next() : null;
            if (trace.getDebugCode("log")) {
                trace.out("log", "empty id to getSemanticId(), returning first one found: " + result);
            }
            return result;
        }
        return (SemanticEvent)this.semanticEvents.get(id);
    }

    public Iterator semanticEventsIterator() {
        if (this.semanticEvents == null) {
            return emptyIterator;
        }
        return this.semanticEvents.values().iterator();
    }

    public Iterator eventDescriptorsIterator() {
        if (this.eventDescriptors == null) {
            return emptyIterator;
        }
        return this.eventDescriptors.values().iterator();
    }

    public List<String> getSelectionTexts() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = this.eventDescriptorsIterator();
        while (it.hasNext()) {
            EventDescriptor ed = (EventDescriptor)it.next();
            for (Selection s : ed.getSelections()) {
                result.add(s.text);
            }
        }
        return result;
    }

    public List<String> getActionTexts() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = this.eventDescriptorsIterator();
        while (it.hasNext()) {
            EventDescriptor ed = (EventDescriptor)it.next();
            for (Action a : ed.getActions()) {
                result.add(a.text);
            }
        }
        return result;
    }

    public List<String> getInputTexts() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = this.eventDescriptorsIterator();
        while (it.hasNext()) {
            EventDescriptor ed = (EventDescriptor)it.next();
            for (Input i : ed.getInputs()) {
                result.add(i.text);
            }
        }
        return result;
    }

    public String getSelectionText(int requestIdx) {
        int i;
        int nSelections;
        Iterator it = this.eventDescriptorsIterator();
        for (i = 0; it.hasNext() && i <= requestIdx; i += nSelections) {
            EventDescriptor ed = (EventDescriptor)it.next();
            nSelections = ed.getSelections().size();
            if (i + nSelections <= requestIdx) {
                continue;
            }
            Selection s = (Selection)ed.getSelections().get(requestIdx - i);
            return s.text;
        }
        try {
            throw new IndexOutOfBoundsException("requested index " + requestIdx + ", number of selections " + i);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public Iterator actionEvaluationsIterator() {
        if (this.actionEvaluations == null) {
            return emptyIterator;
        }
        return this.actionEvaluations.iterator();
    }

    public Iterator tutorAdvicesIterator() {
        if (this.tutorAdvices == null) {
            return emptyIterator;
        }
        return this.tutorAdvices.iterator();
    }

    public Iterator dfasIterator() {
        if (this.dfas == null) {
            return emptyIterator;
        }
        return this.dfas.iterator();
    }

    public Iterator productionsIterator() {
        if (this.productions == null) {
            return emptyIterator;
        }
        return this.productions.iterator();
    }

    public Iterator skillsIterator() {
        if (this.skills == null) {
            return emptyIterator;
        }
        return this.skills.iterator();
    }

    public String getSchoolName() {
        return this.schoolName != null ? this.schoolName : "";
    }

    public void setSchoolName(String name) {
        this.schoolName = name != null ? name : "";
    }

    public String getCourseName() {
        return this.courseName != null ? this.courseName : "";
    }

    public void setCourseName(String name) {
        this.courseName = name != null ? name : "";
    }

    public String getUnitName() {
        return this.unitName != null ? this.unitName : "";
    }

    public void setUnitName(String name) {
        this.unitName = name != null ? name : "";
    }

    public String getSectionName() {
        return this.sectionName != null ? this.sectionName : "";
    }

    public void setSectionName(String name) {
        this.sectionName = name != null ? name : "";
    }

    public Iterator msgPropertiesIterator() {
        if (this.msgProperties == null) {
            return emptyIterator;
        }
        return this.msgProperties.iterator();
    }

    protected void setTopElementType(String topElementType) {
        if (TOOL_MSG_ELEMENT.equalsIgnoreCase(topElementType)) {
            this.topElementType = TOOL_MSG_ELEMENT;
        } else if (TUTOR_MSG_ELEMENT.equalsIgnoreCase(topElementType)) {
            this.topElementType = TUTOR_MSG_ELEMENT;
        } else if (CURRICULUM_MSG_ELEMENT.equalsIgnoreCase(topElementType)) {
            this.topElementType = CURRICULUM_MSG_ELEMENT;
        } else if (MSG_ELEMENT.equalsIgnoreCase(topElementType)) {
            this.topElementType = MSG_ELEMENT;
        } else {
            throw new IllegalArgumentException("Undefined element type: " + topElementType);
        }
    }

    public String getInfo() {
        return this.toString();
    }

    public String getAttemptId() {
        return this.attemptId;
    }

    public void setAttemptId(String attemptId) {
        this.attemptId = attemptId;
    }

    public String getActionId() {
        return this.topElementType;
    }

    public String getInfoType() {
        return INFO_TYPE;
    }

    public static Element stringToElement(String tag, String text) {
        Element result = new Element(tag);
        String escText = outputter.escapeElementEntities(text);
        result.setText(escText);
        return result;
    }

    static String generateGUID() {
        UID uid = new UID();
        return "A" + uid.toString();
    }

    public String getDTDVersionNumber() {
        return VERSION_NUMBER;
    }

    public String getTransactionId() {
        EventElement ee = null;
        if (this.msg instanceof ToolMessage) {
            ee = ((ToolMessage)this.msg).getEventElement();
        } else if (this.msg instanceof TutorMessage) {
            ee = ((TutorMessage)this.msg).getEventElement();
        } else {
            return null;
        }
        if (ee == null) {
            return null;
        }
        return ee.getId();
    }

    public List getActionEvaluations() {
        System.out.println("getActionEvaluations " + this.actionEvaluations);
        return this.actionEvaluations;
    }

    protected static class Factory
    implements Iterator {
        private String dtdVersion = "2";
        private MetaElement meta;
        private Document doc = null;
        protected Iterator iterator;

        protected Factory(Reader rdr, String dtdVersion, MetaElement meta) throws JDOMException, IOException {
            if (dtdVersion != null) {
                this.dtdVersion = dtdVersion;
            }
            this.meta = meta;
            SAXBuilder builder = new SAXBuilder();
            this.doc = builder.build(rdr);
            Element root = this.doc.getRootElement();
            String name = root.getName();
            if (TutorActionLog.LOG_ACTION_ELEMENT.equals(name)) {
                this.meta = new MetaElement(root.getAttributeValue(TutorActionLog.USER_GUID_ATTR), root.getAttributeValue(TutorActionLog.SESSION_ID_ATTR), root.getAttributeValue(TutorActionLog.DATE_TIME_ATTR), root.getAttributeValue(TutorActionLog.TIMEZONE_ATTR));
                root = (Element)root.getChildren().get(0);
                name = root.getName();
            }
            if (TutorActionLog.MSG_SEQUENCE_ELEMENT.equals(name)) {
                String versionAttr = root.getAttributeValue(TutorActionLog.VERSION_NUMBER_ATTR);
                if (versionAttr != null) {
                    this.dtdVersion = versionAttr;
                }
                this.iterator = root.getChildren().iterator();
            } else if (TutorActionLog.TOOL_MSG_ELEMENT.equals(name) || TutorActionLog.TUTOR_MSG_ELEMENT.equals(name) || TutorActionLog.CONTEXT_MSG_ELEMENT.equals(name) || TutorActionLog.CURRICULUM_MSG_ELEMENT.equals(name) || TutorActionLog.MSG_ELEMENT.equals(name)) {
                LinkedList<Element> singleElt = new LinkedList<Element>();
                singleElt.add(root);
                this.iterator = singleElt.iterator();
            } else {
                throw new JDOMException("Bad root element: " + name);
            }
            trace.out("log", "TutorActionLog.Factory.Factory() root " + name + ", dtdVersion " + this.dtdVersion);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Element msgElt = (Element)this.iterator.next();
            if ("4".equals(this.getDtdVersion())) {
                return new TutorActionLogV4(msgElt, this.getMeta());
            }
            return new TutorActionLog(msgElt, this.getMeta());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove");
        }

        public MetaElement getMeta() {
            return this.meta;
        }

        protected String getDtdVersion() {
            return this.dtdVersion;
        }
    }

    public static class MsgProperty {
        public static final String ELEMENT = "property";
        public static final String ENTRY_ELEMENT = "entry";
        private String name = null;
        private String stringValue = null;
        private List entries = null;

        private MsgProperty(String name, String value) {
            this.name = name == null ? "" : name;
            this.stringValue = value == null ? "" : value;
        }

        private MsgProperty(String name, List entries) {
            String string = this.name = name == null ? "" : name;
            if (entries == null) {
                this.stringValue = "";
            } else {
                this.entries = new LinkedList(entries);
            }
        }

        private MsgProperty(Element elt) throws JDOMException {
            if (null == elt || !"property".equals(elt.getName())) {
                throw new JDOMException("wrong element type: " + (elt == null ? "(null)" : elt.getName()));
            }
            this.name = elt.getAttributeValue("name");
            Iterator it = elt.getChildren(ENTRY_ELEMENT).iterator();
            if (!it.hasNext()) {
                this.stringValue = elt.getText().trim();
            } else {
                this.entries = new LinkedList();
                do {
                    this.entries.add(((Element)it.next()).getText().trim());
                } while (it.hasNext());
            }
        }

        public Element getElement() {
            Element result = new Element("property");
            result.setAttribute("name", this.name);
            if (this.isList()) {
                Iterator it = this.entries.iterator();
                while (it.hasNext()) {
                    Element e = new Element(ENTRY_ELEMENT);
                    Object obj = it.next();
                    result.addContent((Content)e.setText(obj == null ? "" : obj.toString()));
                }
            } else {
                result.setText(this.stringValue);
            }
            return result;
        }

        public String getName() {
            return this.name;
        }

        public boolean isList() {
            return this.entries != null;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public List getList() {
            return this.entries;
        }
    }

    public static class Skill
    implements TextIsString {
        public static final String ELEMENT = "skill";
        public final String text;
        public final String probability;

        protected Skill(String text, String probability) {
            this.text = text == null ? "" : text;
            this.probability = probability;
        }

        private Skill(Element elt) throws JDOMException {
            if (null == elt || !ELEMENT.equals(elt.getName())) {
                throw new JDOMException("wrong element type: " + (elt == null ? "(null)" : elt.getName()));
            }
            this.text = elt.getTextTrim();
            this.probability = elt.getAttributeValue("probability");
        }

        public Element getElement() {
            Element result = new Element(ELEMENT);
            if (this.probability != null) {
                result.setAttribute("probability", this.probability);
            }
            result.setText(this.text);
            return result;
        }

        @Override
        public String toString() {
            return this.text;
        }
    }

    public static class ActionEvaluation
    implements TextIsString {
        public static final String ELEMENT = "action_evaluation";
        public final String text;
        public final String currentHintNumber;
        public final String totalHintsAvailable;

        private ActionEvaluation(String text, String currentHintNumber, String totalHintsAvailable) {
            if (trace.getDebugCode("log")) {
                trace.out("log", "ActionEvaluation(Stringx3) text is " + text);
            }
            this.text = text == null ? "" : text;
            this.currentHintNumber = currentHintNumber;
            this.totalHintsAvailable = totalHintsAvailable;
        }

        private ActionEvaluation(Element elt) throws JDOMException {
            if (null == elt || !ELEMENT.equals(elt.getName())) {
                throw new JDOMException("wrong element type: " + (elt == null ? "(null)" : elt.getName()));
            }
            this.text = elt.getTextTrim();
            if (trace.getDebugCode("log")) {
                trace.out("log", "ActionEvaluation(Element) text is " + this.text);
            }
            this.currentHintNumber = elt.getAttributeValue("current_hint_number");
            this.totalHintsAvailable = elt.getAttributeValue("total_hints_available");
        }

        public Element getElement() {
            Element result = new Element(ELEMENT);
            if (this.currentHintNumber != null) {
                result.setAttribute("current_hint_number", this.currentHintNumber);
            }
            if (this.totalHintsAvailable != null) {
                result.setAttribute("total_hints_available", this.totalHintsAvailable);
            }
            result.setText(this.text);
            return result;
        }

        @Override
        public String toString() {
            return this.text;
        }

        public String getText() {
            return this.text;
        }

        public String getCurrentHintNumber() {
            return this.currentHintNumber;
        }

        public String getTotalHintsAvailable() {
            return this.totalHintsAvailable;
        }
    }

    public static class EventDescriptor {
        public static final String ELEMENT = "event_descriptor";
        private final String linkedEventId;
        private final List actions;
        private final List selections;
        private final List inputs;

        private EventDescriptor(Element elt, Message msg) throws JDOMException {
            String text;
            Element iElt;
            Namespace ns = elt.getNamespace();
            if (null == elt || !ELEMENT.equals(elt.getName())) {
                throw new JDOMException("wrong element type: " + (elt == null ? "(null)" : elt.getName()));
            }
            String s = elt.getAttributeValue("event_id", ns);
            this.linkedEventId = s == null ? "" : s;
            List list = elt.getChildren("action", ns);
            Iterator it = list.iterator();
            if (it.hasNext()) {
                this.actions = new ArrayList();
                do {
                    iElt = (Element)it.next();
                    text = iElt.getTextTrim();
                    this.actions.add(new Action(text, iElt.getAttributeValue("id", ns)));
                    if (msg instanceof ToolMessage) {
                        ((ToolMessage)msg).addAction(text);
                        continue;
                    }
                    if (!(msg instanceof TutorMessage)) continue;
                    ((TutorMessage)msg).addAction(text);
                } while (it.hasNext());
            } else {
                this.actions = null;
            }
            list = elt.getChildren("selection", ns);
            it = list.iterator();
            if (it.hasNext()) {
                this.selections = new ArrayList();
                do {
                    Element sElt = (Element)it.next();
                    text = sElt.getTextTrim();
                    this.selections.add(new Selection(text, sElt.getAttributeValue("id", ns), sElt.getAttributeValue("type", ns)));
                    if (msg instanceof ToolMessage) {
                        ((ToolMessage)msg).addSelection(text);
                        continue;
                    }
                    if (!(msg instanceof TutorMessage)) continue;
                    ((TutorMessage)msg).addSelection(text);
                } while (it.hasNext());
            } else {
                this.selections = null;
            }
            list = elt.getChildren("input", ns);
            it = list.iterator();
            if (it.hasNext()) {
                this.inputs = new ArrayList();
                do {
                    iElt = (Element)it.next();
                    text = iElt.getTextTrim();
                    this.inputs.add(new Input(text, iElt.getAttributeValue("id", ns)));
                    if (msg instanceof ToolMessage) {
                        ((ToolMessage)msg).addInput(text);
                        continue;
                    }
                    if (!(msg instanceof TutorMessage)) continue;
                    ((TutorMessage)msg).addInput(text);
                } while (it.hasNext());
            } else {
                this.inputs = null;
            }
        }

        private EventDescriptor(String linkedEventId, List actions, List selections, List inputs) {
            this.linkedEventId = linkedEventId == null ? "" : linkedEventId;
            this.actions = actions;
            this.selections = selections;
            this.inputs = inputs;
        }

        public Element getElement() {
            Iterator it;
            Element result = new Element(ELEMENT);
            if (this.linkedEventId != null) {
                result.setAttribute("event_id", this.linkedEventId);
            }
            if (this.actions != null) {
                it = this.actions.iterator();
                while (it.hasNext()) {
                    result.addContent((Content)((Action)it.next()).getElement());
                }
            }
            if (this.selections != null) {
                it = this.selections.iterator();
                while (it.hasNext()) {
                    result.addContent((Content)((Selection)it.next()).getElement());
                }
            }
            if (this.inputs != null) {
                it = this.inputs.iterator();
                while (it.hasNext()) {
                    result.addContent((Content)((Input)it.next()).getElement());
                }
            }
            return result;
        }

        public String getLinkedEventId() {
            return this.linkedEventId;
        }

        public String getAction() {
            if (this.actions == null && this.actions.isEmpty()) {
                return "";
            }
            return ((Action)this.actions.get(0)).toString();
        }

        public List getActions() {
            return this.actions == null ? new ArrayList(0) : this.actions;
        }

        public List getSelections() {
            return this.selections == null ? new ArrayList(0) : this.selections;
        }

        public List getInputs() {
            return this.inputs == null ? new ArrayList(0) : this.inputs;
        }
    }

    public static class Input
    implements TextIsString {
        public static final String ELEMENT = "input";
        public final String text;
        public final String id;

        private Input(String text, String id) {
            this.text = text == null ? "" : text;
            this.id = id;
        }

        public Element getElement() {
            Element result = new Element(ELEMENT);
            if (this.id != null) {
                result.setAttribute("id", this.id);
            }
            result.setText(this.text);
            return result;
        }

        @Override
        public String toString() {
            return this.text;
        }
    }

    public static class Selection
    implements TextIsString {
        public static final String ELEMENT = "selection";
        public final String text;
        public final String id;
        public final String type;

        private Selection(String text, String id, String type) {
            this.text = text == null ? "" : text;
            this.id = id;
            this.type = type;
        }

        public Element getElement() {
            Element result = new Element(ELEMENT);
            if (this.id != null) {
                result.setAttribute("id", this.id);
            }
            if (this.type != null) {
                result.setAttribute("type", this.type);
            }
            result.setText(this.text);
            return result;
        }

        @Override
        public String toString() {
            return this.text;
        }
    }

    public static class Action
    implements TextIsString {
        public static final String ELEMENT = "action";
        public final String text;
        public final String id;

        private Action(String text, String id) {
            this.text = text == null ? "" : text;
            this.id = id;
        }

        public Element getElement() {
            Element result = new Element(ELEMENT);
            if (this.id != null) {
                result.setAttribute("id", this.id);
            }
            result.setText(this.text);
            return result;
        }

        @Override
        public String toString() {
            return this.text;
        }
    }

    public static class SemanticEvent
    implements MsgEvent {
        public static final String ELEMENT = "semantic_event";
        private String id;
        private String linkedEventId = "";
        private final String name;
        private String trigger = "DATA";
        private String text = "";
        private SemanticEventElement eventElement;

        protected SemanticEvent(Element elt) throws JDOMException {
            if (null == elt || !ELEMENT.equals(elt.getName())) {
                throw new JDOMException("wrong element type: " + (elt == null ? "(null)" : elt.getName()));
            }
            String s = elt.getAttributeValue("name");
            this.name = s == null ? "" : s;
            this.trigger = elt.getAttributeValue("trigger");
            s = elt.getAttributeValue("semantic_event_id");
            this.linkedEventId = s == null ? "" : s;
            this.text = elt.getTextTrim();
            s = elt.getAttributeValue("transaction_id");
            if (null == s) {
                s = elt.getAttributeValue("id");
            }
            if (null == s || s.length() < 1) {
                throw new JDOMException("missing or empty id: " + s);
            }
            this.setId(s);
            String subtype = elt.getAttributeValue("subtype");
            this.eventElement = new SemanticEventElement(s, this.getName(), this.getTrigger(), subtype);
        }

        private SemanticEvent(String name) {
            this(TutorActionLog.generateGUID(), name);
        }

        private SemanticEvent(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public Element getElement() {
            Element result = new Element(ELEMENT);
            if (this.id != null) {
                result.setAttribute("id", this.id);
            }
            if (this.linkedEventId != null && this.linkedEventId.length() > 0) {
                result.setAttribute("semantic_event_id", this.linkedEventId);
            }
            if (this.name != null) {
                result.setAttribute("name", this.name);
            }
            if (this.trigger != null) {
                result.setAttribute("trigger", this.trigger);
            }
            result.setText(this.text);
            return result;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public String getLinkedEventId() {
            return this.linkedEventId;
        }

        void setLinkedEventId(String linkedEventId) {
            this.linkedEventId = linkedEventId == null ? "" : linkedEventId;
        }

        public String getName() {
            return this.name;
        }

        public String getTrigger() {
            return this.trigger;
        }

        private void setTrigger(String trigger) {
            this.trigger = trigger;
        }

        public String getText() {
            return this.text;
        }

        private void setText(String text) {
            this.text = text;
        }

        protected void setId(String id) {
            this.id = id;
        }

        public String getTransactionId() {
            return this.getId();
        }

        protected SemanticEventElement getEventElement() {
            return this.eventElement;
        }
    }

    public static class UIEvent
    implements MsgEvent {
        public static final String ELEMENT = "ui_event";
        private final String id;

        public UIEvent(Element elt) throws JDOMException {
            if (null == elt || !ELEMENT.equals(elt.getName())) {
                throw new JDOMException("wrong element type: " + (elt == null ? "(null)" : elt.getName()));
            }
            this.id = elt.getAttributeValue("id");
        }

        @Override
        public String getId() {
            return this.id;
        }

        public Element getElement() {
            Element result = new Element(ELEMENT);
            if (this.id != null) {
                result.setAttribute("id", this.id);
            }
            return result;
        }
    }

    static interface MsgEvent {
        public String getId();
    }

    public static interface TextIsString {
        public String toString();
    }

    public static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("empty iterator");
        }

        @Override
        public void remove() {
            throw new IllegalStateException("empty iterator");
        }
    }
}

