/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat.model;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.model.ProblemSummary;

public class SCORM {
    public static final String LESSON_STATUS = "cmi.core.lesson_status";
    public static final String RAW_SCORE = "cmi.core.score.raw";
    public static final String MIN_SCORE = "cmi.core.score.min";
    public static final String MAX_SCORE = "cmi.core.score.max";
    public static final String SESSION_TIME = "cmi.core.session_time";
    public static final String EXIT = "cmi.core.exit";

    public static String getLessonStatus(ProblemSummary ps) {
        String result = ProblemSummary.CompletionValue.complete == ps.getCompletionStatus() ? LessonStatus.completed.toString() : LessonStatus.incomplete.toString();
        if (trace.getDebugCode("ps")) {
            trace.outNT("ps", "SCORM.getRawScore() returns " + result);
        }
        return result;
    }

    public static String getRawScore(ProblemSummary ps) {
        String result = ps.getUniqueSteps() == 0 ? "0" : String.format("%.0f", (double)ps.getUniqueCorrectUnassisted() * 100.0 / (double)ps.getUniqueSteps());
        if (trace.getDebugCode("ps")) {
            trace.outNT("ps", "SCORM.getRawScore() returns " + result);
        }
        return result;
    }

    public static String getMinScore(ProblemSummary ps) {
        return "0";
    }

    public static String getMaxScore(ProblemSummary ps) {
        return "100";
    }

    public static String getSessionTime(ProblemSummary ps) {
        long tms = ps.getTimeElapsed();
        long ms = tms % 1000L;
        long s = (tms - ms) / 1000L;
        long m = s / 60L;
        long h = m / 60L;
        s %= 60L;
        if (h > 9999L) {
            h = 9999L;
            s = 99L;
            m = 99L;
            ms = 990L;
        }
        String result = String.format("%04d:%02d:%02d.%02d", h, m, s, ms / 10L);
        if (trace.getDebugCode("ps")) {
            trace.outNT("ps", "SCORM.getSessionTime() given " + tms + " returns " + result);
        }
        return result;
    }

    public static String getExitReason(ProblemSummary ps) {
        return ExitReason.suspend.toString();
    }

    static enum LessonStatus {
        passed("passed"),
        completed("completed"),
        failed("failed"),
        incomplete("incomplete"),
        browsed("browsed"),
        notAttempted("not attempted");

        private final String outputValue;

        private LessonStatus(String outputValue) {
            this.outputValue = outputValue;
        }

        public String toString() {
            return this.outputValue;
        }
    }

    static enum ExitReason {
        timeout("time-out"),
        suspend("suspend"),
        logout("logout"),
        done(" ");

        private final String outputValue;

        private ExitReason(String outputValue) {
            this.outputValue = outputValue;
        }

        public String toString() {
            return this.outputValue;
        }
    }
}

