/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Utilities.trace;
import jess.Defquery;
import jess.Deftemplate;
import jess.Fact;
import jess.Funcall;
import jess.HasLHS;
import jess.JessException;
import jess.QueryResult;
import jess.Rete;
import jess.ValueVector;

public class HintFact {
    private HintFact() {
    }

    static void setHintFact(boolean hintRequest, Rete r) {
        Fact hFact;
        if (trace.getDebugCode("hints")) {
            trace.out("hints", "setHintFact(" + hintRequest + ")");
        }
        if ((hFact = HintFact.getFact(r)) == null) {
            HintFact.assertFact(hintRequest, r);
        } else {
            HintFact.modify(hFact, hintRequest, r);
        }
    }

    private static void modify(Fact hFact, boolean hintRequest, Rete r) {
        try {
            if (trace.getDebugCode("hints")) {
                trace.out("hints", "HintFact.modify(" + hintRequest + ") fact " + hFact.getFactId() + " before change: " + hFact);
            }
            r.modify(hFact, "now", hintRequest ? Funcall.TRUE : Funcall.FALSE);
        }
        catch (JessException je) {
            trace.err("Error modifying hint fact: " + (Object)((Object)je) + "; cause " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail());
        }
    }

    private static void assertFact(boolean hintRequest, Rete r) {
        try {
            Fact hFact = new Fact(HintFact.getDeftemplate(r));
            hFact.setSlotValue("now", hintRequest ? Funcall.TRUE : Funcall.FALSE);
            r.assertFact(hFact);
            if (trace.getDebugCode("hints")) {
                trace.out("hints", "HintFact.assertFact(" + hintRequest + ") new fact " + hFact.getFactId() + ": " + hFact);
            }
        }
        catch (JessException je) {
            trace.err("Error asserting hint fact: " + (Object)((Object)je) + "; cause " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Fact getFact(Rete r) {
        for (int trial = 0; trial < 2; ++trial) {
            try {
                QueryResult qr = r.runQueryStar("get-hint", new ValueVector(0));
                if (!qr.next()) {
                    return null;
                }
                Object result = qr.getObject("h");
                if (trace.getDebugCode("hints")) {
                    trace.out("hints", "HintFact.getFact() found object " + result + ", type " + (result == null ? null : result.getClass()));
                }
                if (result instanceof Fact) {
                    return (Fact)result;
                }
                return null;
            }
            catch (JessException je) {
                if (trial > 0) {
                    trace.err("Error running defquery get-hint: " + (Object)((Object)je) + "; cause " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail());
                    break;
                }
                Rete rete = r;
                synchronized (rete) {
                    HintFact.getDeftemplate(r);
                    try {
                        HasLHS q = r.findDefrule("get-hint");
                        if (!(q instanceof Defquery)) {
                            r.eval("(defquery get-hint \"Retrieve the fact holding the hint status.\"?h <- (hint))");
                        }
                    }
                    catch (JessException je2) {
                        trace.err("Error creating hint query: " + (Object)((Object)je2) + "; cause " + je2.getCause() + ".\n  " + je2.getProgramText() + "\n  " + je2.getDetail());
                    }
                    continue;
                }
            }
        }
        return null;
    }

    private static Deftemplate getDeftemplate(Rete r) {
        try {
            Deftemplate hTemplate = r.findDeftemplate("hint");
            if (hTemplate == null) {
                r.eval("(deftemplate hint (slot now))");
                hTemplate = r.findDeftemplate("hint");
            }
            return hTemplate;
        }
        catch (JessException je) {
            trace.err("Error finding or creating hint deftemplate: " + (Object)((Object)je) + "; cause " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail());
            return null;
        }
    }
}

