/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import edu.cmu.oli.log.client.DiskLogger;
import edu.cmu.oli.log.client.StreamLogger;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Log.TutorActionLogV4;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.LoggingSupport;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.PeerLearning.SimStHintLogAgent;
import edu.cmu.pact.miss.PeerLearning.SimStLoggingAgent;
import edu.cmu.pact.miss.ProblemAssessor;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.SimStInteractiveLearning;
import edu.cmu.pact.miss.WebStartFileDownloader;
import edu.cmu.pact.miss.storage.FileZipper;
import edu.cmu.pslc.logging.ContextMessage;
import edu.cmu.pslc.logging.Message;
import edu.cmu.pslc.logging.OliDatabaseLogger;
import edu.cmu.pslc.logging.OliDiskLogger;
import edu.cmu.pslc.logging.ToolMessage;
import edu.cmu.pslc.logging.TutorMessage;
import edu.cmu.pslc.logging.element.SkillElement;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class SimStLogger {
    private BR_Controller brController;
    static boolean loggingEnabled = false;
    protected static String userID = "";
    public static final String DEFAULT_LOG_DIR = "log";
    public static final String TEST_LOG_URL = "http://pslc-qa.andrew.cmu.edu/log/server";
    public static final String DEFAULT_LOG_URL = "http://learnlab.web.cmu.edu/log/server";
    public static String log_url = "http://learnlab.web.cmu.edu/log/server";
    public static final String SIM_STUDENT_DIALOGUE = "SIM_STUDENT_DIALOGUE";
    public static final String SIM_STUDENT_INFO_RECEIVED = "SIM_STUDENT_INFO_RECEIVED";
    public static final String SIM_STUDENT_LEARNING = "SIM_STUDENT_LEARNING";
    public static final String SIM_STUDENT_ERROR = "SIM_STUDENT_ERROR";
    public static final String SIM_STUDENT_PLE = "SIM_STUDENT_PLE";
    public static final String SIM_STUDENT_QUIZ = "SIM_STUDENT_QUIZ";
    public static final String SIM_STUDENT_ACTION_LISTENER = "SIM_STUDENT_ACTION_LISTENER";
    public static final String SIM_STUDENT_STEP = "SIM_STUDENT_STEP";
    public static final String SIM_STUDENT_PROBLEM = "SIM_STUDENT_PROBLEM";
    public static final String SIM_STUDENT_METATUTOR_AL = "SIM_STUDENT_METATUTOR_ACTION_LISTENER";
    public static final String SIM_STUDENT_METATUTOR = "SIM_STUDENT_METATUTOR";
    public static final String HINT_REQUEST_ACTION = "Sim Student Requesting Hint";
    public static final String ACTIVATION_RULES_ACTION = "Activation Rules Determined";
    public static final String ACTIVATION_RULE_ACTION = "Activation Rule Considered";
    public static final String LEARNING_PERFORMANCE_ACTION = "Learning Performance Determined";
    public static final String RULE_LEARN_PERFORMANCE_ACTION = "Rule Learned Performance";
    public static final String RHS_OPS_SEARCH_PERFORMANCE_ACTION = "RHS Ops Search Performance";
    public static final String WME_PATH_SEARCH_PERFORMANCE_ACTION = "WME Path Search Performance";
    public static final String CONFIRMATION_REQUEST_ACTION = "Sim Student Requesting Confirmation of Input";
    public static final String INPUT_VERIFY_ACTION = "Student Verified Correctness of Sim Student Input";
    public static final String CONFIRMATION_REQUEST_CL_ACTION = "ClAlgebra Tutor Verified Correctness of Sim Student Input";
    public static final String EXCEPTION_ACTION = "Sim Student has experienced an exception";
    public static final String POSITIVE_EXAMPLE_ACTION = "Positive Example Received";
    public static final String NEGATIVE_EXAMPLE_ACTION = "Negative Example Received";
    public static final String PLE_STARTED_ACTION = "Peer Learning Environment Started";
    public static final String PLE_CLOSED_ACTION = "Peer Learning Environment Closed";
    public static final String PROBLEM_REQUEST_ACTION = "New Problem Requested";
    public static final String PROBLEM_ENTERED_ACTION = "New Problem Entered";
    public static final String PROBLEM_RESTART_ACTION = "Problem Restarted";
    public static final String QUIZ_QUESTION_GIVEN_ACTION = "Sim Student Given Quiz Question";
    public static final String QUIZ_QUESTION_ANSWER_ACTION = "Sim Student Answers Quiz Question";
    public static final String QUIZ_COMPLETED_ACTION = "Quiz Completed";
    public static final String NEXT_PROBLEM_BUTTON_ACTION = "Next Problem Button Clicked";
    public static final String PROBLEM_ENTERED_BUTTON_ACTION = "Problem Entered Button Clicked";
    public static final String QUIZ_BUTTON_ACTION = "Quiz Button Clicked";
    public static final String CURRICULUM_BROWSER_BUTTON_ACTION = "Curriculum Browser Button Clicked";
    public static final String EXAMPLES_BUTTON_ACTION = "Examples Button Clicked";
    public static final String UNDO_BUTTON_ACTION = "Undo Button Clicked";
    public static final String RESTART_BUTTON_ACTION = "Restart Problem Button Clicked";
    public static final String TAB_SWITCH_ACTION = "Switched Tab";
    public static final String HINT_RECEIVED = "Hint Received";
    public static final String RETRY_RECEIVED = "Retry Received";
    public static final String STEP_STARTED_ACTION = "New Step Started";
    public static final String NOT_LEARN_ACTION = "Sim Student Did Not Learn On Input";
    public static final String NOT_LEARN_SKIP_ACTION = "Sim Student Gave Up Learning On Input";
    public static final String BAD_INPUT_RECEIVED = "Invalid Input Received";
    public static final String PROBLEM_COMPLETED_ACTION = "Problem Completed";
    public static final String PROBLEM_ANSWER_SUBMIT_ACTION = "Problem Answer Submitted";
    public static final String PROBLEM_DONE_ACTION = "Problem Reached Done State";
    public static final String PROBLEM_ABANDONED_ACTION = "Problem Abandoned";
    public static final String PROBLEM_LEFT_QUIZ_ACTION = "Incomplete Problem Left to Quiz";
    public static final String STEP_COMPLETED_ACTION = "Step Completed";
    public static final String TAB_LEFT_ACTION = "Left Tab";
    public static final String UNDO_ACTION = "Step Undone";
    public static final String AVATAR_CONFIGURE_BUTTON_ACTION = "Avatar Configure Button Clicked";
    public static final String AVATAR_SAVE_ACTION = "Avatar Image Saved";
    public static final String SKILLOMETER_UPDATE_ACTION = "Skillometer Updated";
    public static final String CHAT_DIALOG_ACTION = "Chat Dialog Entered";
    public static final String QUIZ_VIEW = "Quiz Solution Viewed";
    public static final String EXAMPLE_VIEW = "Example Solution Viewed";
    public static final String QUIZ_VIEW_END = "Finished Quiz Solution View";
    public static final String EXAMPLE_VIEW_END = "Finished Example Solution View";
    public static final String QUIZ_VIEW_END_TAB = "Finished Quiz Solution View by Leaving Tab";
    public static final String EXAMPLE_VIEW_END_TAB = "Finished Example Solution View by Leaving Tab";
    public static final String QUIZ_VIEW_TAB = "Quiz Solution Viewed on New Tab";
    public static final String EXAMPLE_VIEW_TAB = "Example Solution Viewed on New Tab";
    public static final String UNTAKEN_QUIZ_EXPAND_ACTION = "Student Tried to Expand Untaken Quiz";
    public static final String UNTAKEN_QUIZ_INITIATE_ACTION = "Student Initiated Quiz on Untaken Quiz Expand";
    public static final String INSTRUCTION_SIZE = "Instruction Vector Size";
    public static final String SSGAME = "SSGAME";
    public static final String SSGAME_MATCHUP = "SSGAME_MATCHUP";
    public static final String SSGAME_CONTEST = "SSGAME_CONTEST";
    public static final String SSGAME_REVIEW = "SSGAME_REVIEW";
    public static final String SSGAME_ERROR = "SSGAME_ERROR";
    public static final String GAMESHOW_STARTUP_ACTION = "Game Show Program Started";
    public static final String JOIN_MATCHUP_ACTION = "Joined Matchup Area";
    public static final String SUCCESSFUL_MATCHUP_ACTION = "Matchup Successful";
    public static final String VIEW_CONTESTANT_ACTION = "Contestant Details Viewed";
    public static final String CHALLENGE_CONTESTANT_ACTION = "Challenge Issued";
    public static final String CHALLENGED_ACTION = "Challenge Received";
    public static final String CHALLENGE_ACCEPT_ACTION = "Challenge Accepted";
    public static final String CHALLENGE_REFUSE_ACTION = "Challenge Refused";
    public static final String CHALLENGE_ACCEPTED_ACTION = "Challenge Acceptance Received";
    public static final String CHALLENGE_REFUSED_ACTION = "Challenge Refusal Received";
    public static final String CHAT_MESSAGE_GROUP_ACTION = "Group Chat Message Added";
    public static final String ANNOUNCE_MESSAGE_GROUP_ACTION = "Group Announcement Message Added";
    public static final String CONTEST_START_ACTION = "Contest Started";
    public static final String PROBLEM_START_ACTION = "New Problem Started";
    public static final String STEP_INPUT_ACTION = "Input for Step Attempted";
    public static final String ANSWER_SUBMIT_ACTION = "Answer Submitted";
    public static final String CHAT_MESSAGE_PRIVATE_ACTION = "Private Chat Message Added";
    public static final String ANNOUNCE_MESSAGE_PRIVATE_ACTION = "Private Announcement Message Added";
    public static final String GENERATE_PROBLEMS_BUTTON_ACTION = "Generate Problems Button Clicked";
    public static final String PROBLEM_INVALID_ACTION = "Invalid Problem Entered";
    public static final String OPPONENT_ANSWER_ACTION = "Opponent Answer Submitted";
    public static final String CONTEST_RESULT_ACTION = "Contest Problem Results Determined";
    public static final String CHALLENGE_TIMEOUT_ACTION = "Challenge Request Timed-Out";
    public static final String PROBLEM_REQUEST_TIMEOUT_ACTION = "Problem Request Timed-Out";
    public static final String PROBLEM_SUBMIT_TIMEOUT_ACTION = "Problem Submission Timed-Out";
    public static final String WIN_DECIDED_ACTION = "Winner Decided";
    public static final String WIN_STATISTICS_ACTION = "Winning Statistics Determined";
    public static final String PROBLEMS_CORRECT_STATISTIC = "Number of Problems Correct Determined";
    public static final String PROBLEM_LENGTH_STATISTIC = "Problem Lengths Determined";
    public static final String PERCENT_CORRECT_STATISTIC = "Percent of Steps Correct Determined";
    public static final String CONTINUE_BUTTON_ACTION = "Continue Button Clicked";
    public static final String RATING_CHANGED_ACTION = "Rating Changed";
    public static final String PROBLEM_SUBMIT_ACTION = "New Problem Submitted";
    public static final String GAMESHOW_CLOSED_ACTION = "Game Show Closed";
    public static final String RECONNECT_ACTION = "Reconnected to Game Show";
    public static final String OUTSTANDING_ACTION = "Challengee Already has Outstanding Challenge";
    public static final String LEADERBOARD_REQUEST_ACTION = "Leaderboard Update Requested";
    public static final String SIM_STUDENT_EXPLANATION = "SIM_STUDENT_EXPLANATION";
    public static final String HINT_EXPLAIN_ACTION = "Hint Explained";
    public static final String INPUT_WRONG_EXPLAIN_ACTION = "Non-Confirmed Input Explained";
    public static final String PROBLEM_ENTERED_EXPLAIN_ACTION = "New Problem Explained";
    public static final String NO_EXPLAIN_ACTION = "Explanation Not Given";
    public static final String EXPLANATION_CATEGORIZE_ACTION = "Categorize Explanation";
    public static final String PROBLEM_ENTERED_EXPLAIN_TYPE = "ProblemEntered";
    public static final String INPUT_WRONG_EXPLAIN_TYPE = "InputWrong";
    public static final String HINT_GIVEN_EXPLAIN_TYPE = "HintGiven";
    public static final String FOLLOW_UP_EXPLAIN_SUFFIX = "-FollowUp";
    public static final String STUDENT_ATTEMPT = "Student";
    public static final String SIMSTUDENT_ATTEMPT = "SimStudent";
    public static final String STUDENT_META_ATTEMPT = "Student Meta";
    public static final String OPPONENT_ATTEMPT = "Opponent";
    public static final String METATUTOR_ATTEMPT = "MetaTutor";
    public static final String QUIZ_RESULT = "Quiz";
    public static final String LOGGING_RESULT = "Logged Only";
    public static final String CONTEST_RESULT = "Contest";
    public static final String PROBLEM_RESULT = "Problem Logged Only";
    public static final String METATUTOR_CLICK_ACTION = "Clicked Metatutor";
    public static final String METATUTOR_QUESTION_ACTION = "Metatutor Question Asked";
    public static final String METATUTOR_NEXT_HINT_ACTION = "Next Metatutor Hint Selected";
    public static final String METATUTOR_PREVIOUS_HINT_ACTION = "Previous Metatutor Hint Selected";
    public static final String METATUTOR_CLOSE_HINT_ACTION = "Metatutor Hint Closed";
    public static final String METATUTOR_LEFT_HINT_ACTION = "Metatutor Hint Left";
    public static final String METATUTOR_HINT_ACTION = "Metatutor Hint Given";
    public static final String METATUTOR_MODEL_TRACING_ACTION = "Metatutor Model Traced";
    public static final String METATUTOR_HINT_REQUESTED = "Metatutor Hint Requested";
    public static final String CONTEXT_MENU_QUESTION_ACTION = "Context Menu Question Asked";
    public static final String HINT_FOLLOWED = "HINT_FOLLOWED";
    public static final String HINT_TYPE = "HINT_TYPE";
    public static final String UNPAIRED_LOG_ITEM = "UNPAIRED_LOG_ITEM";
    public static final String ACTION_TYPE_PROPERTY = "ACTION_TYPE";
    public static final String ACTION_PROPERTY = "ACTION";
    public static final String RESULT_PROPERTY = "RESULT";
    public static final String DETAILS_PROPERTY = "DETAILS";
    public static final String USERID_PROPERTY = "USERID";
    public static final String DURATION_PROPERTY = "DURATION";
    public static final String CORRECTNESS_ST_PROPERTY = "ST_CORRECTNESS";
    public static final String CORRECTNESS_SIMST_PROPERTY = "SIMST_CORRECTNESS";
    public static final String STEP_PROPERTY = "STEP";
    public static final String SAI_AGENT_PROPERTY = "SAI_AGENT";
    public static final String ACTUAL_SKILL_PROPERTY = "ACTUAL_SKILL";
    public static final String STUDENT_LOG_COUNT_PROPERTY = "STUDENT_LOG_COUNT";
    public static final String OPPONENT_PROPERTY = "OPPONENT";
    public static final String INFO_PROPERTY = "INFO";
    public static final String RATING_PROPERTY = "MY_RATING";
    public static final String STATUS_PROPERTY = "STATUS";
    public static final String TIME_PROPERTY = "tool_event_time";
    public static final String DATE_PROPERTY = "date";
    public static final String ABSTRACT_PROBLEM_PROPERTY = "ABSTRACT_PROBLEM";
    public static final String PROBLEM_TYPE_PROPERTY = "PROBLEM_TYPE";
    public static final String ABSTRACT_STEP_PROPERTY = "ABSTRACT_STEP";
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    public static final String NOT_CALCED = "NOT CALCULATED";
    public static final String SIMST_SAI = "SimStudent";
    public static final String SIMST_APPEND = "-simSt";
    public static final String STUDENT_APPEND = "-student";
    public static final String QUIZ_STATUS = "Quiz";
    public static final String TUTOR_STATUS = "Tutoring";
    public static final String START_STATUS = "Start";
    public static final String GAMESHOW_STATUS = "GameShow";
    public static final String PROBLEM_MODEL = "Problem";
    public static final String PROBLEM_SUBMIT_MODEL = "ProblemSubmit";
    public static final String STEP_MODEL = "Step";
    public static final String ACTUAL_MODEL = "ActualSkill";
    public static int studentLogCount = 0;
    private String datasetBasename;
    public static String status = "Start";
    private SimStLoggingAgent logAgent;
    private SimStHintLogAgent hintLogAgent;
    static ContextMessage simStContext;
    static ContextMessage studentContext;
    static ContextMessage flowContext;

    public String getCurrentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSS");
        return dateFormat.format(new GregorianCalendar().getTime());
    }

    public SimStLogger(BR_Controller br) {
        this.brController = br;
        this.datasetBasename = this.brController.getLoggingSupport().getDatasetName();
    }

    public SimStLoggingAgent getLogAgent() {
        SimStLogger simStLogger = this;
        return simStLogger.logAgent.getInstance();
    }

    public SimStHintLogAgent getHintLogAgent() {
        SimStLogger simStLogger = this;
        return simStLogger.hintLogAgent.getInstance();
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback, String opponent, String info, int myRating, boolean logBuffering, String hintType, String hintFollowed, String tool_event_time) {
        String problemName = this.brController.getProblemModel().getProblemName();
        if (!loggingEnabled) {
            if (trace.getDebugCode("ss")) {
                trace.out("ss", "Logging not enabled when trying to log.");
            }
            return;
        }
        if (logBuffering && this.brController.getMissController().getSimSt().isSsMetaTutorMode()) {
            boolean logEntryBuffered = SimStHintLogAgent.getInstance(this.brController).manageLogEntry(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, myRating, tool_event_time);
            if (logEntryBuffered) {
                if (trace.getDebugCode("ss")) {
                    trace.out("ss", "Hint log agent handled a log entry.");
                }
                return;
            }
        }
        SimStInteractiveLearning ssIL = this.brController.getMissController().getSimSt().getSsInteractiveLearning();
        if ((problemName == null || problemName.length() == 0) && ssIL != null && ssIL.getQuizGraph() != null && ssIL.getQuizGraph().getStartNode() != null) {
            problemName = ssIL.getQuizGraph().getStartNode().getName();
        }
        if (problemName != null) {
            problemName = SimSt.convertFromSafeProblemName(problemName);
        }
        if (step != null) {
            step = SimSt.convertFromSafeProblemName(step);
        }
        if (step == null) {
            step = this.brController.getMissController().getSimSt().getProblemStepString();
        }
        if (feedback != null && feedback.length() > 0 && feedback.contains("\n")) {
            feedback = feedback.replaceAll("\n", "");
        }
        correctness = this.checkCorrectness(action, sai, problemName, result, node, correctness);
        ContextMessage context = this.getContextMessage(action, problemName, resultDetails.toString());
        ToolMessage logMessage = ToolMessage.create((ContextMessage)context);
        TutorMessage responseMessage = TutorMessage.create((ToolMessage)logMessage);
        this.logExpected(action, correctness, result, sai, expSelection, expAction, expInput, step, resultDetails.toString(), logMessage, responseMessage);
        if (!(sai == null || action.equalsIgnoreCase(PROBLEM_ANSWER_SUBMIT_ACTION) || action.equalsIgnoreCase(SKILLOMETER_UPDATE_ACTION) || action.equalsIgnoreCase(CONTEXT_MENU_QUESTION_ACTION))) {
            String agent = this.getSkillAgent(action);
            String skill = "";
            if (action.equals(BAD_INPUT_RECEIVED) && result.length() > 0) {
                Sai correctedSai = new Sai(sai.getS(), sai.getA(), result);
                skill = this.determineSkill(correctedSai, step, resultDetails.toString(), action);
            } else {
                skill = this.determineSkill(sai, step, resultDetails.toString(), action);
            }
            SkillElement actualSkill = new SkillElement(skill + "-" + agent, skill);
            actualSkill.addModelName(ACTUAL_MODEL);
            responseMessage.addSkill(actualSkill);
        }
        this.addLogItem(ACTION_TYPE_PROPERTY, actionType, logMessage);
        this.addLogItem(ACTION_PROPERTY, action, logMessage);
        this.addLogItem(RESULT_PROPERTY, result, logMessage);
        if (duration > 0) {
            this.addLogItem(DURATION_PROPERTY, "" + duration, logMessage);
        }
        this.setLogAttemptType(action, sai, logMessage);
        this.logCorrectness(correctness, action, result, logMessage, responseMessage);
        this.logProblemSkill(action, problemName, step, logMessage, responseMessage);
        if (feedback != null && feedback.length() > 0) {
            responseMessage.addTutorAdvice(feedback);
        }
        if (opponent != null && opponent.length() > 0) {
            this.addLogItem(OPPONENT_PROPERTY, opponent, logMessage);
        }
        if (info != null && info.length() > 0) {
            this.addLogItem(INFO_PROPERTY, info, logMessage);
        }
        if (myRating != 0) {
            this.addLogItem(RATING_PROPERTY, "" + myRating, logMessage);
        }
        this.addLogItem(USERID_PROPERTY, userID, logMessage);
        this.addLogItem(STATUS_PROPERTY, status, logMessage);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSS");
        this.addLogItem(TIME_PROPERTY, dateFormat.format(new GregorianCalendar().getTime()), logMessage);
        dateFormat = new SimpleDateFormat("yyyy-MM-dd EEE");
        this.addLogItem(DATE_PROPERTY, dateFormat.format(new GregorianCalendar().getTime()), logMessage);
        this.addLogItem(STUDENT_LOG_COUNT_PROPERTY, "" + studentLogCount++, logMessage);
        if (sai != null) {
            logMessage.addSai(sai.getS(), sai.getA(), "'" + sai.getI());
        }
        TutorActionLogV4 toLog = new TutorActionLogV4(logMessage);
        toLog.setSourceId(SIM_STUDENT_PLE);
        this.brController.getLoggingSupport().oliLog(toLog);
        if (responseMessage.getActionEvaluationElement() != null && !responseMessage.getActionEvaluationElement().getEvaluation().equals("HINT") || responseMessage.getTutorAdviceList().size() > 0) {
            toLog = new TutorActionLogV4(responseMessage);
            toLog.setSourceId(SIM_STUDENT_PLE);
            this.brController.getLoggingSupport().oliLog(toLog);
        }
    }

    private void logThis(Message msg) {
        DiskLogger dl;
        StreamLogger sl = this.brController.getLoggingSupport().getOLILogger();
        if (sl != null) {
            OliDatabaseLogger odl = new OliDatabaseLogger(sl, "UTF-8");
            odl.log(msg);
        }
        if ((dl = this.brController.getLoggingSupport().getUpdatedDiskLogger()) != null) {
            OliDiskLogger odl = new OliDiskLogger(dl, "UTF-8");
            odl.log(msg);
        }
    }

    private void addLogItem(String field, String value, ToolMessage logMessage) {
        if (value != null && value.length() > 0 && !value.equals("'")) {
            logMessage.addCustomField(field, value);
        }
    }

    private String checkCorrectness(String action, Sai sai, String problemName, String result, ProblemNode node, String correctness) {
        if (sai != null && this.brController.isSimStudentMode() && (action.equals(CONFIRMATION_REQUEST_ACTION) || action.equals(HINT_RECEIVED) || action.equals(INPUT_VERIFY_ACTION) || action.equals(UNDO_ACTION)) || action.equals(RETRY_RECEIVED) || action.equals(ACTIVATION_RULE_ACTION)) {
            correctness = FALSE;
            if (node == null) {
                node = this.brController.getCurrentNode();
            }
            if (this.brController.getMissController().getSimSt().verifyStep(problemName, node, sai.getS(), sai.getA(), sai.getI()).equals("Correct Action")) {
                correctness = TRUE;
            }
            if (action.equals(INPUT_VERIFY_ACTION)) {
                boolean stAnswer;
                boolean simStCorrect = correctness.equals(TRUE);
                correctness = simStCorrect == (stAnswer = result.equals("Correct Action")) ? TRUE : FALSE;
            } else if (action.equals(UNDO_ACTION)) {
                correctness = correctness.equals(TRUE) ? FALSE : TRUE;
            }
        }
        return correctness;
    }

    private ContextMessage getContextMessage(String action, String problemName, String details) {
        ContextMessage context = null;
        if (PLE_STARTED_ACTION.equalsIgnoreCase(action) || GAMESHOW_STARTUP_ACTION.equalsIgnoreCase(action)) {
            this.brController.getLoggingSupport().setProblemName("START");
            status = START_STATUS;
            this.createContextMessages();
        } else if (PROBLEM_ENTERED_ACTION.equalsIgnoreCase(action) || PROBLEM_START_ACTION.equalsIgnoreCase(action)) {
            if (problemName != null && problemName.length() > 0) {
                this.brController.getLoggingSupport().setProblemName("'" + problemName);
            }
            status = TUTOR_STATUS;
            this.createContextMessages();
        } else if (QUIZ_QUESTION_GIVEN_ACTION.equalsIgnoreCase(action) || WIN_DECIDED_ACTION.equalsIgnoreCase(action) || PROBLEM_REQUEST_ACTION.equalsIgnoreCase(action) || CONTEST_START_ACTION.equalsIgnoreCase(action)) {
            status = QUIZ_QUESTION_GIVEN_ACTION.equalsIgnoreCase(action) ? "Quiz" : GAMESHOW_STATUS;
            if (problemName != null && problemName.length() > 0) {
                this.brController.getLoggingSupport().setProblemName("'" + problemName);
            } else if (details != null && details.length() > 0) {
                this.brController.getLoggingSupport().setProblemName("'" + details);
            }
            this.createContextMessages();
        } else if (JOIN_MATCHUP_ACTION.equalsIgnoreCase(action) || RECONNECT_ACTION.equalsIgnoreCase(action)) {
            status = GAMESHOW_STATUS;
            this.brController.getLoggingSupport().setProblemName("MATCHUP");
            this.createContextMessages();
        }
        context = HINT_REQUEST_ACTION.equalsIgnoreCase(action) || CONFIRMATION_REQUEST_ACTION.equalsIgnoreCase(action) || CONFIRMATION_REQUEST_CL_ACTION.equalsIgnoreCase(action) || STEP_INPUT_ACTION.equals(action) || QUIZ_QUESTION_ANSWER_ACTION.equals(action) ? simStContext : (HINT_RECEIVED.equalsIgnoreCase(action) || INPUT_VERIFY_ACTION.equalsIgnoreCase(action) || PROBLEM_ANSWER_SUBMIT_ACTION.equals(action) || RETRY_RECEIVED.equals(action) ? studentContext : flowContext);
        if (context == null) {
            context = this.brController.getLoggingSupport().getContextMessage();
        }
        return context;
    }

    private void createContextMessages() {
        LoggingSupport logging = this.brController.getLoggingSupport();
        logging.setDatasetName(this.datasetBasename + SIMST_APPEND);
        simStContext = logging.getContextMessage();
        this.logThis((Message)simStContext);
        logging.setDatasetName(this.datasetBasename + STUDENT_APPEND);
        studentContext = logging.getContextMessage();
        this.logThis((Message)studentContext);
        logging.setDatasetName(this.datasetBasename);
        flowContext = logging.getContextMessage();
        this.logThis((Message)flowContext);
    }

    private String determineSkill(Sai expectedSAI, String step, String details, String action) {
        String skill = "";
        skill = expectedSAI.getS().equalsIgnoreCase("DONE") ? "done" : (expectedSAI.getI().indexOf(32) > 0 ? expectedSAI.getI().substring(0, expectedSAI.getI().indexOf(32)) : (expectedSAI != null && expectedSAI.getA().equals("ButtonPressed") ? expectedSAI.getS() : (step != null && step.indexOf(91) + 1 > 0 && step.indexOf(32) > step.indexOf(91) + 1 ? step.substring(step.indexOf(91) + 1, step.indexOf(32)) + "-typein" : (details != null && details.length() > 0 && details.contains("Applying the rule ") ? details.substring("Applying the rule ".length(), details.indexOf(58)) : (step.equals("START") ? "problem-entry" : "UNKNOWN")))));
        return skill;
    }

    private void logCorrectness(String correctness, String action, String result, ToolMessage logMessage, TutorMessage responseMessage) {
        if (correctness.length() > 0) {
            if (action.equals(CONFIRMATION_REQUEST_CL_ACTION) || action.equals(QUIZ_QUESTION_ANSWER_ACTION)) {
                if (correctness.equalsIgnoreCase(TRUE)) {
                    responseMessage.setAsCorrectAttemptResponse("Quiz");
                } else {
                    responseMessage.setAsIncorrectAttemptResponse("Quiz");
                }
            } else if (action.equals(STEP_INPUT_ACTION) || action.equals(ANSWER_SUBMIT_ACTION) || action.equals(OPPONENT_ANSWER_ACTION)) {
                if (correctness.equalsIgnoreCase(TRUE)) {
                    responseMessage.setAsCorrectAttemptResponse(CONTEST_RESULT);
                } else {
                    responseMessage.setAsIncorrectAttemptResponse(CONTEST_RESULT);
                }
            } else if (correctness.equalsIgnoreCase(TRUE)) {
                responseMessage.setAsCorrectAttemptResponse(LOGGING_RESULT);
            } else {
                responseMessage.setAsIncorrectAttemptResponse(LOGGING_RESULT);
            }
        } else {
            responseMessage.setAsHintResponse();
            if (!(action.equals(METATUTOR_LEFT_HINT_ACTION) || action.equals(HINT_REQUEST_ACTION) || action.equals(CONTEXT_MENU_QUESTION_ACTION))) {
                responseMessage.getActionEvaluationElement().setEvaluation("UNGRADED");
            }
            if (action.equals(METATUTOR_LEFT_HINT_ACTION) || action.equals(METATUTOR_CLOSE_HINT_ACTION) || action.equals(METATUTOR_PREVIOUS_HINT_ACTION) || action.equals(METATUTOR_NEXT_HINT_ACTION)) {
                responseMessage.getActionEvaluationElement().setCurrentHintNumber(result);
            }
            if (action.equals(CONTEXT_MENU_QUESTION_ACTION)) {
                responseMessage.getActionEvaluationElement().setCurrentHintNumber("1");
            }
        }
    }

    private void logExpected(String action, String correctness, String result, Sai sai, String expSelection, String expAction, String expInput, String step, String details, ToolMessage logMessage, TutorMessage responseMessage) {
        if (correctness.length() <= 0 && expSelection != null && expAction != null && expInput != null && expSelection.length() > 0 && expAction.length() > 0 && expInput.length() > 0) {
            Sai expectedSAI = new Sai(expSelection, expAction, expInput);
            String skill = this.determineSkill(expectedSAI, step, details, action);
            String agent = this.getSkillAgent(action);
            responseMessage.addSkill(new SkillElement(skill + "-" + agent, skill));
        } else if (correctness.equals(FALSE) && expSelection != null && expAction != null && expInput != null) {
            if (expSelection.length() > 0 && expAction.length() > 0 && expInput.length() > 0) {
                Sai expectedSAI = new Sai(expSelection, expAction, expInput);
                String skill = this.determineSkill(expectedSAI, step, details, action);
                String agent = this.getSkillAgent(action);
                responseMessage.addSkill(new SkillElement(skill + "-" + agent, skill));
            }
        } else if (action.equals(INPUT_VERIFY_ACTION) && result != null && result.equals("Error Action") && correctness.equals(TRUE) && expSelection != null && expAction != null && expInput != null) {
            if (expSelection.length() > 0 && expAction.length() > 0 && expInput.length() > 0) {
                Sai expectedSAI = new Sai(expSelection, expAction, expInput);
                String skill = this.determineSkill(expectedSAI, step, details, action);
                String agent = this.getSkillAgent(action);
                responseMessage.addSkill(new SkillElement(skill + "-" + agent, skill));
            }
        } else if (correctness.equals(TRUE) && sai != null && !action.equalsIgnoreCase(PROBLEM_ANSWER_SUBMIT_ACTION) && sai.getS().length() > 0 && sai.getA().length() > 0 && sai.getI().length() > 0) {
            expInput = sai.getI();
            String skill = this.determineSkill(sai, step, details, action);
            String agent = this.getSkillAgent(action);
            responseMessage.addSkill(new SkillElement(skill + "-" + agent, skill));
        }
        if (step != null && step.length() > 0) {
            responseMessage.addSai("'" + step, "", expInput);
        } else {
            responseMessage.addSai("", "", "");
        }
    }

    private String getSkillAgent(String action) {
        if (action.equalsIgnoreCase(HINT_RECEIVED) || action.equalsIgnoreCase(BAD_INPUT_RECEIVED) || action.equals(INPUT_VERIFY_ACTION) || action.equals(NOT_LEARN_ACTION) || action.equals(UNDO_ACTION) || action.equals(VIEW_CONTESTANT_ACTION) || action.equals(PROBLEM_SUBMIT_ACTION) || action.equals(NOT_LEARN_SKIP_ACTION) || action.equals(RETRY_RECEIVED) || action.equals(METATUTOR_MODEL_TRACING_ACTION) || action.equals(CONTEXT_MENU_QUESTION_ACTION)) {
            return STUDENT_ATTEMPT;
        }
        if (action.equalsIgnoreCase(CONFIRMATION_REQUEST_ACTION) || action.equalsIgnoreCase(CONFIRMATION_REQUEST_CL_ACTION) || action.equalsIgnoreCase(HINT_REQUEST_ACTION)) {
            return "SimStudent";
        }
        if (action.equalsIgnoreCase(OPPONENT_ANSWER_ACTION)) {
            return OPPONENT_ATTEMPT;
        }
        if (action.equalsIgnoreCase(METATUTOR_HINT_ACTION)) {
            return METATUTOR_ATTEMPT;
        }
        return "SimStudent";
    }

    private void logProblemSkill(String action, String problem, String step, ToolMessage logMessage, TutorMessage responseMessage) {
        ProblemAssessor assess = this.brController.getMissController().getSimSt().getProblemAssessor();
        if (problem != null && problem.length() > 0 && !problem.equals("START")) {
            String problemPattern = assess.abstractProblem(problem);
            String problemType = assess.classifyProblem(problem);
            if (action.equals(PROBLEM_ANSWER_SUBMIT_ACTION) || action.equals(QUIZ_QUESTION_ANSWER_ACTION)) {
                SkillElement problemSkill = new SkillElement("'" + problemPattern, problemType);
                problemSkill.addModelName(PROBLEM_SUBMIT_MODEL);
                responseMessage.addSkill(problemSkill);
            }
            SkillElement problemModelSkill = new SkillElement("'" + problemPattern, problemType);
            problemModelSkill.addModelName(PROBLEM_MODEL);
            responseMessage.addSkill(problemModelSkill);
        }
        if (step != null & step.length() > 0 && !step.startsWith("Quiz") && !step.equals("START")) {
            String step1 = step.contains("[") ? step.substring(0, step.indexOf("[")) : step;
            String stepPattern = assess.abstractProblem(step1);
            String stepType = "Transformation";
            if (step.contains("[") && (step1 = step.substring(step.indexOf("[") + 1, step.indexOf("]"))).contains(" ")) {
                String operator = step1.substring(0, step1.indexOf(" "));
                String operand = step1.substring(step1.indexOf(" ") + 1);
                String operandPattern = assess.abstractProblem(operand);
                stepPattern = stepPattern + "[" + operator + " " + operandPattern + "]";
                stepType = "Typein";
            }
            SkillElement problemSkill = new SkillElement("'" + stepPattern, stepType);
            problemSkill.addModelName(STEP_MODEL);
            responseMessage.addSkill(problemSkill);
        }
    }

    private void setLogAttemptType(String action, Sai sai, ToolMessage logMessage) {
        if (sai != null && (action.equalsIgnoreCase(HINT_RECEIVED) || action.equals(RETRY_RECEIVED) || action.equals(PROBLEM_ANSWER_SUBMIT_ACTION) || action.equals(METATUTOR_MODEL_TRACING_ACTION))) {
            logMessage.setAsAttempt(STUDENT_ATTEMPT);
        } else if (sai != null && (action.equalsIgnoreCase(CONFIRMATION_REQUEST_ACTION) || action.equalsIgnoreCase(CONFIRMATION_REQUEST_CL_ACTION)) || action.equals(STEP_INPUT_ACTION) || action.equals(ANSWER_SUBMIT_ACTION) || action.equals(QUIZ_QUESTION_ANSWER_ACTION) || action.equals(ACTIVATION_RULE_ACTION)) {
            logMessage.setAsAttempt("SimStudent");
        } else if (action.equals(OPPONENT_ANSWER_ACTION)) {
            logMessage.setAsAttempt(OPPONENT_ATTEMPT);
        } else if (sai != null && (action.equals(INPUT_VERIFY_ACTION) || action.equals(UNDO_ACTION))) {
            logMessage.setAsAttempt(STUDENT_META_ATTEMPT);
        } else if (action.equals(NOT_LEARN_ACTION) || action.equals(BAD_INPUT_RECEIVED) || action.startsWith(HINT_EXPLAIN_ACTION) || action.startsWith(PROBLEM_ENTERED_EXPLAIN_ACTION) || action.startsWith(INPUT_WRONG_EXPLAIN_ACTION) || action.equals(NO_EXPLAIN_ACTION) || action.equals(PROBLEM_INVALID_ACTION) || action.equals(PROBLEM_REQUEST_TIMEOUT_ACTION) || action.equals(CHALLENGE_TIMEOUT_ACTION) || action.equals(OUTSTANDING_ACTION) || action.equals(SKILLOMETER_UPDATE_ACTION) || action.equals(NOT_LEARN_SKIP_ACTION) || action.equals(CONTEXT_MENU_QUESTION_ACTION)) {
            logMessage.setAsHintRequest(STUDENT_ATTEMPT);
        } else if (action.equals(HINT_REQUEST_ACTION) || action.equals(WIN_DECIDED_ACTION) || action.equals(EXPLANATION_CATEGORIZE_ACTION)) {
            logMessage.setAsHintRequest("SimStudent");
        } else if (action.equals(METATUTOR_HINT_ACTION)) {
            logMessage.setAsHintRequest(METATUTOR_ATTEMPT);
        } else {
            logMessage.setAsHintRequest();
        }
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback, String opponent, String info) {
        this.simStLog(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, info, 0, true, null, null, this.getCurrentTime());
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback, String opponent) {
        this.simStLog(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, "");
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback, String opponent, int rating) {
        this.simStLog(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, opponent, "", rating, true, null, null, this.getCurrentTime());
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String correctness, String expSelection, String expAction, String expInput, int duration, String feedback) {
        this.simStLog(actionType, action, step, result, resultDetails, sai, node, correctness, expSelection, expAction, expInput, duration, feedback, "");
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai) {
        this.simStLog(actionType, action, step, result, resultDetails, sai, null, "", "", "", "", 0, "");
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, int duration) {
        this.simStLog(actionType, action, step, result, resultDetails, sai, null, "", "", "", "", duration, "");
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, int duration, String feedback) {
        this.simStLog(actionType, action, step, result, resultDetails, sai, null, "", "", "", "", duration, feedback);
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, int duration, String feedback, String opponent) {
        this.simStLog(actionType, action, step, result, resultDetails, sai, null, "", "", "", "", duration, feedback, opponent);
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, int duration, String feedback, String opponent, int rating) {
        this.simStLog(actionType, action, step, result, resultDetails, sai, null, "", "", "", "", duration, feedback, opponent, "", rating, true, null, null, this.getCurrentTime());
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String expSelection, String expAction, String expInput) {
        this.simStLog(actionType, action, step, result, resultDetails, sai, node, "", expSelection, expAction, expInput, 0, "");
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, ProblemNode node, String expSelection, String expAction, String expInput, int duration, String feedback) {
        this.simStLog(actionType, action, step, result, resultDetails, sai, node, "", expSelection, expAction, expInput, duration, feedback);
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, boolean correctness, String expSelection, String expAction, String expInput) {
        String correct = "";
        if (correctness) {
            correct = TRUE;
            this.simStLog(actionType, action, step, result, resultDetails, sai, null, correct, "", "", "", 0, "");
        } else {
            correct = FALSE;
            this.simStLog(actionType, action, step, result, resultDetails, sai, null, correct, expSelection, expAction, expInput, 0, "");
        }
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, boolean correctness, String expSelection, String expAction, String expInput, int rating) {
        String correct = "";
        if (correctness) {
            correct = TRUE;
            this.simStLog(actionType, action, step, result, resultDetails, sai, null, correct, "", "", "", 0, "", "", "", rating, true, null, null, this.getCurrentTime());
        } else {
            correct = FALSE;
            this.simStLog(actionType, action, step, result, resultDetails, sai, null, correct, expSelection, expAction, expInput, 0, "", "", "", rating, true, null, null, this.getCurrentTime());
        }
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails) {
        this.simStLog(actionType, action, step, result, resultDetails, null);
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, int duration, String feedback) {
        this.simStLog(actionType, action, step, result, resultDetails, null, null, "", "", "", "", duration, feedback);
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, int duration, String feedback, int rating) {
        this.simStLog(actionType, action, step, result, resultDetails, null, null, "", "", "", "", duration, feedback, "", "", rating, true, null, null, this.getCurrentTime());
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, int duration, String feedback, String opponent) {
        this.simStLog(actionType, action, step, result, resultDetails, null, null, "", "", "", "", duration, feedback, opponent);
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, int duration, String feedback, String opponent, int rating) {
        this.simStLog(actionType, action, step, result, resultDetails, null, null, "", "", "", "", duration, feedback, opponent, "", rating, true, null, null, this.getCurrentTime());
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, int duration) {
        this.simStLog(actionType, action, step, result, resultDetails, null, duration);
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, int duration, int myRating) {
        this.simStLog(actionType, action, step, result, resultDetails, null, null, "", "", "", "", duration, "", "", "", myRating, true, null, null, this.getCurrentTime());
    }

    public void simStLog(String actionType, String action, String result, Object resultDetails) {
        this.simStLog(actionType, action, "", result, resultDetails, null);
    }

    public void simStLog(String actionType, String action, String result, Object resultDetails, boolean correctness) {
        this.simStLog(actionType, action, "", result, resultDetails, null, correctness, "", "", "");
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, boolean correctness, int duration) {
        String correct = "";
        correct = correctness ? TRUE : FALSE;
        this.simStLog(actionType, action, step, result, resultDetails, null, null, correct, "", "", "", duration, "");
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, boolean correctness, int duration, int rating) {
        String correct = "";
        correct = correctness ? TRUE : FALSE;
        this.simStLog(actionType, action, step, result, resultDetails, null, null, correct, "", "", "", duration, "", "", "", rating, true, null, null, this.getCurrentTime());
    }

    public void simStLog(String actionType, String action, String result, Object resultDetails, Sai sai, boolean correctness) {
        this.simStLog(actionType, action, "", result, resultDetails, sai, correctness, "", "", "");
    }

    public void simStLog(String actionType, String action, String step, String result, Object resultDetails, Sai sai, boolean correctness) {
        this.simStLog(actionType, action, step, result, resultDetails, sai, correctness, "", "", "");
    }

    public void simStLog(String actionType, String action, Sai sai, boolean correctness) {
        this.simStLog(actionType, action, "", (Object)"", sai, correctness);
    }

    public void simStLog(String actionType, String action, String result) {
        this.simStLog(actionType, action, result, "");
    }

    public void simStLog(String actionType, String action, String result, int rating) {
        this.simStLog(actionType, action, "", result, "", null, null, "", "", "", "", 0, "", "", "", rating, true, null, null, this.getCurrentTime());
    }

    public void simStLog(String actionType, String action, String result, boolean correctness) {
        this.simStLog(actionType, action, result, (Object)"", correctness);
    }

    public void simStShortLog(String actionType, String action, String result, String info) {
        this.simStLog(actionType, action, "", result, (Object)"", null, null, "", "", "", "", 0, "", "", info);
    }

    public void simStShortLog(String actionType, String action, String result, String info, int duration) {
        this.simStLog(actionType, action, "", result, (Object)"", null, null, "", "", "", "", duration, "", "", info);
    }

    public void simStShortLog(String actionType, String action, String result, String info, int duration, int rating) {
        this.simStLog(actionType, action, "", result, "", null, null, "", "", "", "", duration, "", "", info, rating, true, null, null, this.getCurrentTime());
    }

    public void simStShortLog(String actionType, String action, String result, String info, String opponent) {
        this.simStLog(actionType, action, "", result, (Object)"", null, null, "", "", "", "", 0, "", opponent, info);
    }

    public void simStShortLog(String actionType, String action, String result, String info, String opponent, int rating) {
        this.simStLog(actionType, action, "", result, "", null, null, "", "", "", "", 0, "", opponent, info, rating, true, null, null, this.getCurrentTime());
    }

    public void simStInfoLog(String actionType, String action, String step, String result, String info) {
        this.simStLog(actionType, action, step, result, (Object)"", null, null, "", "", "", "", 0, "", "", info);
    }

    public void simStLogException(Exception e) {
        StackTraceElement[] stack = e.getStackTrace();
        String stackTrace = "";
        for (StackTraceElement ste : stack) {
            stackTrace = stackTrace + ste + "\n";
        }
        this.simStLog(SIM_STUDENT_ERROR, EXCEPTION_ACTION, e.getMessage() + ":" + e.getCause(), stackTrace);
    }

    public void simStLogException(Exception e, String message) {
        StackTraceElement[] stack = e.getStackTrace();
        String stackTrace = "";
        for (StackTraceElement ste : stack) {
            stackTrace = stackTrace + ste + ";";
        }
        this.simStLog(SIM_STUDENT_ERROR, EXCEPTION_ACTION, message + "-" + e.getMessage() + ":" + e.getCause(), stackTrace);
    }

    public void ssGameShowException(Exception e, String message) {
        StackTraceElement[] stack = e.getStackTrace();
        String stackTrace = "";
        for (StackTraceElement ste : stack) {
            stackTrace = stackTrace + ste + ";";
        }
        this.simStLog(SSGAME_ERROR, EXCEPTION_ACTION, message + "-" + e.getMessage() + ":" + e.getCause(), stackTrace);
    }

    public void enableLogging(boolean logRemote, boolean logLocal, String userID) {
        SimStLogger.userID = userID;
        PreferencesModel pm = this.brController.getPreferencesModel();
        if (!logRemote && !logLocal) {
            if (trace.getDebugCode("ss")) {
                trace.out("ss", "Logging not enabled.");
            }
            if (pm != null) {
                pm.setBooleanValue("Use OLI Logging", false);
                pm.setBooleanValue("Use Disk Logging", false);
            }
            return;
        }
        if (pm != null) {
            pm.setBooleanValue("Use OLI Logging", logRemote);
            pm.setStringValue("OLI Logging URL", log_url);
            pm.setBooleanValue("Use Disk Logging", logLocal);
            if (this.brController.getMissController().getSimSt().isWebStartMode()) {
                pm.setStringValue("Disk Logging Directory", WebStartFileDownloader.SimStWebStartDir + DEFAULT_LOG_DIR + "_" + userID + "_" + FileZipper.formattedDate());
            } else {
                pm.setStringValue("Disk Logging Directory", DEFAULT_LOG_DIR);
            }
        }
        this.brController.getLogger().setAnonymizedStudentName(userID);
        if (this.brController.getMissController().getSimSt() != null) {
            String condition = this.brController.getMissController().getSimSt().getSsCondition();
            int value = condition.contains("control") ? 0 : 1;
            this.brController.getLogger().addStudyConditionName(condition, value);
        }
        loggingEnabled = true;
    }

    public boolean getLoggingEnabled() {
        return loggingEnabled;
    }
}

