/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning.TutorialBuilderUtility;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DOMNode
extends DefaultMutableTreeNode
implements TreeNode {
    private static final long serialVersionUID = 1L;
    private Object contents;
    private ArrayList<DOMNode> children;
    private DOMNode parent;
    private String dimensionString;
    private int IDTag = -1;
    private int[] dimensions = new int[4];

    public int getIDTag() {
        return this.IDTag;
    }

    public void setIDTag(int iDTag) {
        this.IDTag = iDTag;
    }

    protected String get3DigitIDString() {
        String str = "000" + this.getIDTag();
        return str.substring(str.length() - 3);
    }

    public String getDimensions() {
        if (this.dimensions == null || this.dimensionString == null || this.dimensions[2] == 0 || this.dimensions[3] == 0) {
            Component c = (Component)this.getContents();
            this.dimensions[0] = c.getX();
            this.dimensions[1] = c.getY();
            this.dimensions[2] = c.getWidth();
            this.dimensions[3] = c.getHeight();
            this.dimensionString = "(" + Integer.toString(this.dimensions[0]) + ", " + Integer.toString(this.dimensions[1]) + ", " + Integer.toString(this.dimensions[0] + this.dimensions[2]) + ", " + Integer.toString(this.dimensions[1] + this.dimensions[3]) + ")";
        }
        return this.dimensionString;
    }

    public Object getContents() {
        return this.contents;
    }

    protected void setContents(Object contents) {
        this.contents = contents;
    }

    protected ArrayList<DOMNode> getChildren() {
        return this.children;
    }

    protected void setChildren(ArrayList<DOMNode> arrayList) {
        this.children = arrayList;
    }

    protected void setParent(DOMNode parent) {
        this.parent = parent;
    }

    protected DOMNode(Object contents, ArrayList<DOMNode> children, DOMNode parent) {
        this.contents = contents;
        this.children = children;
        this.parent = parent;
    }

    protected DOMNode(Object contents, DOMNode parent) {
        this.contents = contents;
        this.children = new ArrayList();
        this.parent = parent;
    }

    protected DOMNode(DOMNode d) {
        super(d);
        this.IDTag = d.getIDTag();
    }

    protected void addChildren(DOMNode d) {
        this.children.add(d);
        d.setParent(this);
    }

    protected void addChildren(Object child) {
        this.children.add(new DOMNode(child, this));
    }

    protected void addChildren(ArrayList<Object> children) {
        for (Object o : children) {
            this.children.add(new DOMNode(o, new ArrayList<DOMNode>(), this));
        }
    }

    protected void remove(DOMNode d) {
        for (int x = 0; x < this.children.size(); ++x) {
            if (!this.children.get(x).equals(d)) continue;
            this.children.remove(x);
            break;
        }
    }

    protected boolean contains(Object toFind) {
        return this.contents.equals(toFind);
    }

    @Override
    public String toString() {
        try {
            String ret = this.contents.toString();
            Pattern p = Pattern.compile("\\w+\\[");
            Matcher m = p.matcher(ret);
            m.find();
            ret = ret.substring(m.start(), m.end() - 1);
            return ret + this.get3DigitIDString() + " " + this.getDimensions();
        }
        catch (IllegalStateException e) {
            return this.contents.toString();
        }
    }

    protected String verboseToString() {
        return super.toString() + " : " + this.contents + ", Parent: " + this.parent;
    }

    public Enumeration<DOMNode> children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public DOMNode getChildAt(int arg0) {
        return this.children.get(arg0);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode arg0) {
        for (int x = 0; x < this.children.size(); ++x) {
            if (!this.children.get(x).equals(arg0)) continue;
            return x;
        }
        return -1;
    }

    @Override
    public DOMNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.children.size() == 0;
    }
}

