/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.jess;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.jess.APlusModelTracing;
import edu.cmu.pact.miss.userDef.algebra.Denominator;
import edu.cmu.pact.miss.userDef.algebra.Numerator;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import jess.Context;
import jess.JessException;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import pact.CommWidgets.JCommComboBox;
import pact.CommWidgets.JCommTable;
import pact.CommWidgets.JCommTextField;

public class ConstructCLHintMessage
implements Userfunction,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CONSTRUCT_CL_HINT_MESSAGE = "construct-cl-hint-message";
    private static final String HINT_REQUEST = "hint-request";
    private static final String FEEDBACK_REQUEST = "feedback-request";
    protected transient APlusModelTracing amt;
    protected transient Context context;

    public ConstructCLHintMessage() {
        this(null);
    }

    public ConstructCLHintMessage(APlusModelTracing amt) {
        this.amt = amt;
    }

    public Value call(ValueVector vv, Context context) throws JessException {
        Value returnValue;
        String returnString = "";
        ValueVector returnVV = new ValueVector();
        if (!vv.get(0).stringValue(context).equals(CONSTRUCT_CL_HINT_MESSAGE)) {
            throw new JessException(CONSTRUCT_CL_HINT_MESSAGE, "called but ValueVector head differs", vv.get(0).stringValue(context));
        }
        for (int i = 1; i < vv.size(); ++i) {
            String tempString;
            Value v;
            block14: {
                v = vv.get(i);
                try {
                    tempString = v.resolveValue(context).stringValue(context);
                }
                catch (JessException ex) {
                    trace.out("Exception handled: " + ex.getMessage());
                    trace.out(ex.getProgramText());
                    trace.out(ex.getLineNumber());
                    tempString = v.toString();
                    if (!tempString.endsWith("]")) break block14;
                    tempString = tempString.substring(0, tempString.length() - 1);
                    returnString = returnString + tempString;
                    returnValue = new Value(returnString, 2);
                    returnVV.add(returnValue);
                    returnString = "";
                    continue;
                }
            }
            tempString = tempString.replaceAll("\n", " ");
            tempString = tempString.replaceAll("\t", " ");
            tempString = tempString.replaceAll("\\s+", " ");
            if (tempString.length() <= 0) continue;
            char c = tempString.charAt(0);
            char e = tempString.charAt(tempString.length() - 1);
            if (c == '[') {
                if (!returnString.trim().equals("")) {
                    returnValue = new Value(returnString, 2);
                    returnVV.add(returnValue);
                    returnString = "";
                }
                if ((tempString = tempString.substring(1)).length() <= 0) continue;
                c = tempString.charAt(0);
            }
            if (e == ']') {
                tempString = tempString.substring(0, tempString.length() - 1);
                returnString = returnString + tempString;
                returnValue = new Value(returnString, 2);
                returnVV.add(returnValue);
                returnString = "";
                continue;
            }
            if (c == '?' || c == '$') {
                try {
                    v = v.resolveValue(context);
                    returnString = returnString + v.stringValue(context) + " ";
                }
                catch (JessException je) {
                    returnString = returnString + v.stringValue(context) + " ";
                }
                continue;
            }
            returnString = returnString + tempString + " ";
        }
        returnValue = new Value(returnString, 2);
        returnVV.add(returnValue);
        if (context.getEngine().getThisRuleName().contains(HINT_REQUEST)) {
            String msg = returnVV.get(0).stringValue(context);
            returnVV = this.constructHintMessage(msg);
        } else if (context.getEngine().getThisRuleName().contains(FEEDBACK_REQUEST)) {
            String msg = returnVV.get(0).stringValue(context);
            returnVV = this.constructFeedBackMessage(msg);
        }
        if (this.amt == null || returnVV == null) {
            return null;
        }
        this.amt.setFiringNodeCLHintMessages(returnVV, context);
        return new Value(returnVV, 512);
    }

    private ValueVector constructFeedBackMessage(String msg) throws JessException {
        ProblemNode currentNode;
        List<ProblemEdge> edges;
        ValueVector returnVV = new ValueVector();
        StringBuilder sb = new StringBuilder();
        if (this.amt != null && (edges = (currentNode = ((BR_Controller)this.amt.getController()).getCurrentNode()).getIncomingEdges()).size() >= 1) {
            ProblemEdge edge = edges.get(0);
            Sai sai = edge.getSai();
            if (msg.trim().equals("TRUE")) {
                if (sai.getS().equalsIgnoreCase("done")) {
                    returnVV.add("Saying the problem is solved is correct here.");
                } else {
                    returnVV.add("Yes, " + sai.getI() + " would be correct here.");
                }
            } else if (msg.trim().equals("FALSE")) {
                if (sai.getS().equalsIgnoreCase("done")) {
                    returnVV.add("Saying the problem is solved would not be correct here.");
                } else {
                    returnVV.add("No, " + sai.getI() + " would not be the right thing to do.");
                }
            }
            return returnVV;
        }
        return null;
    }

    private ValueVector constructHintMessage(String msg) throws JessException {
        ValueVector returnVV = new ValueVector();
        String[] token = (msg = this.applyTransformationFilter(msg)).split(":");
        if (token.length == 2) {
            String[] hintMsg = token[1].split(";");
            for (int i = 0; i < hintMsg.length; ++i) {
                returnVV.add(hintMsg[i]);
            }
        } else {
            String[] hintMsg = msg.split(",");
            Vector focusOfAttn = null;
            if (this.amt != null) {
                focusOfAttn = ((BR_Controller)this.amt.getController()).getMissController().getSimSt().getFoaGetter().foaGetter((BR_Controller)this.amt.getController(), hintMsg[0].trim(), hintMsg[1].trim(), hintMsg[2], null);
            }
            if (hintMsg.length == 3) {
                String side = "";
                String message = "";
                if (hintMsg[0].contains("dorminTable1")) {
                    if (focusOfAttn != null) {
                        message = "What do you get when you apply the transformation " + ((JCommTable.TableExpressionCell)focusOfAttn.elementAt(1)).getText() + " to " + ((JCommTable.TableExpressionCell)focusOfAttn.elementAt(0)).getText() + "?";
                        returnVV.add(message);
                    }
                    side = "left";
                    message = "You need to enter " + hintMsg[2] + " on the " + side + " side.";
                    returnVV.add(message);
                } else if (hintMsg[0].contains("dorminTable2")) {
                    if (focusOfAttn != null) {
                        message = "What do you get when you apply the transformation " + ((JCommTable.TableExpressionCell)focusOfAttn.elementAt(1)).getText() + " to " + ((JCommTable.TableExpressionCell)focusOfAttn.elementAt(0)).getText() + "?";
                        returnVV.add(message);
                    }
                    side = "right";
                    message = "You need to enter " + hintMsg[2] + " on the " + side + " side.";
                    returnVV.add(message);
                } else if (hintMsg[0].contains("done")) {
                    message = "There is no more work left on the problem. Click on the Problem is Solved button.";
                    returnVV.add(message);
                }
            }
        }
        return returnVV;
    }

    private String applyTransformationFilter(String msg) {
        StringBuilder sb = new StringBuilder();
        String[] token = msg.split(":");
        if (token.length == 2) {
            String[] sai = token[0].split(",");
            sb.append(sai[0] + ",");
            sb.append(sai[1] + ",");
            if (sai.length == 3) {
                String skill = sai[2];
                String foa1 = "";
                String foa2 = "";
                Vector focusOfAttn = null;
                if (this.amt != null) {
                    focusOfAttn = ((BR_Controller)this.amt.getController()).getMissController().getSimSt().getFoaGetter().foaGetter((BR_Controller)this.amt.getController(), sai[0].trim(), sai[1].trim(), sai[2], null);
                }
                if (focusOfAttn != null) {
                    foa1 = focusOfAttn.elementAt(0) instanceof JCommComboBox ? (String)((JCommComboBox)focusOfAttn.elementAt(0)).getValue() : (focusOfAttn.elementAt(0) instanceof JCommTextField ? ((JCommTextField)focusOfAttn.elementAt(0)).getText() : ((JCommTable.TableExpressionCell)focusOfAttn.elementAt(0)).getText());
                    foa2 = focusOfAttn.elementAt(1) instanceof JCommComboBox ? (String)((JCommComboBox)focusOfAttn.elementAt(1)).getValue() : (focusOfAttn.elementAt(1) instanceof JCommTextField ? ((JCommTextField)focusOfAttn.elementAt(1)).getText() : ((JCommTable.TableExpressionCell)focusOfAttn.elementAt(1)).getText());
                }
                if (skill.contains("cm") && foa1.length() > 0 && foa2.length() > 0) {
                    Numerator n = new Numerator();
                    String num = n.numerator(foa1);
                    Denominator d = new Denominator();
                    String denom = d.denominator(foa1);
                    sb.append("multiply " + denom + ":");
                    sb.append("What can you do to both sides to get " + num + " by itself?;");
                    sb.append("In " + foa1 + " , " + num + " is divided by " + denom + ". How do you undo division?;");
                    sb.append("Multiply both sides by " + denom + ".");
                    return sb.toString();
                }
                if (skill.contains("rf") && foa1.length() > 0 && foa2.length() > 0) {
                    if (trace.getDebugCode("rr")) {
                        trace.out("rr", sai[0] + " " + sai[1] + " " + sai[2]);
                    }
                    sb.append(sai[2] + ":");
                    sb.append(token[1] + ";");
                    sb.append("Type in " + sai[2] + ".");
                    return sb.toString();
                }
            }
        }
        return msg;
    }

    public String getName() {
        return CONSTRUCT_CL_HINT_MESSAGE;
    }
}

