/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.jess;

import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.RuleActivationNode;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.jess.APlusModelTracing;
import edu.cmu.pact.miss.jess.SAIHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ProdSysSAIHandler
extends SAIHandler {
    private Vector messages = new Vector();

    public ProdSysSAIHandler(String sel, String act, String inp, APlusModelTracing amt, CTAT_Controller controller) {
        super(sel, act, inp, amt, controller);
    }

    @Override
    public String processSAI() {
        try {
            if (APlusModelTracing.isSAIToBeModelTraced(this.selection, this.action)) {
                this.result = this.amt.runModelTrace(false, false, this.selection, this.action, this.input, this.messages);
            } else if (this.action.equalsIgnoreCase("MetaTutorClicked") && (this.selection.equalsIgnoreCase("hint") || this.selection.equalsIgnoreCase("activations"))) {
                this.result = this.amt.runModelTrace(true, false, this.selection, "", "", this.messages);
                if (this.messages.size() < 1) {
                    this.messages.add("I'm sorry, no hint is available at this step");
                }
                String message = "";
                if (this.messages != null && this.messages.size() >= 1) {
                    for (int i = 0; i < this.messages.size(); ++i) {
                        if (this.returnMessage == null) {
                            this.returnMessage = new ArrayList();
                        }
                        message = message + ProdSysSAIHandler.cleanMessage((String)this.messages.get(i)) + ";";
                        this.returnMessage.add(ProdSysSAIHandler.cleanMessage((String)this.messages.get(i)));
                    }
                }
                if (!this.selection.equalsIgnoreCase("activations")) {
                    RuleActivationNode hint = this.amt.getMatchedNode();
                    Sai sai = new Sai(hint.getActualSelection(), hint.getActualAction(), hint.getActualInput());
                    String step = this.getController().getMissController().getSimSt().getProblemStepString();
                    this.amt.getLogger().simStLog("SIM_STUDENT_METATUTOR", "Metatutor Hint Given", step, hint.getName(), (Object)"", sai, 0, message);
                    this.sendResult();
                }
            } else if (this.action.equalsIgnoreCase("MetaTutorClicked") && this.selection.equalsIgnoreCase("CLHint")) {
                this.result = this.amt.runModelTrace(false, true, this.selection, "", "", this.messages);
                if (this.messages.size() < 1) {
                    this.messages.add("I'm sorry, no hint is available at this step");
                }
                String message = "";
                if (this.messages != null && this.messages.size() >= 1) {
                    for (int i = 0; i < this.messages.size(); ++i) {
                        if (this.returnMessage == null) {
                            this.returnMessage = new ArrayList();
                        }
                        message = message + ProdSysSAIHandler.cleanMessage((String)this.messages.get(i)) + ";";
                        this.returnMessage.add(ProdSysSAIHandler.cleanMessage((String)this.messages.get(i)));
                    }
                }
                if (!this.selection.equalsIgnoreCase("activations")) {
                    RuleActivationNode hint = this.amt.getMatchedNode();
                    Sai sai = new Sai(hint.getActualSelection(), hint.getActualAction(), hint.getActualInput());
                    String step = this.getController().getMissController().getSimSt().getProblemStepString();
                    this.amt.getLogger().simStLog("SIM_STUDENT_METATUTOR", "Metatutor Hint Given", step, hint.getName(), (Object)"", sai, 0, message);
                    this.sendResult();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String cleanMessage(String message) {
        String returnMessage = message.replace("[", "");
        returnMessage = returnMessage.replace("]", "");
        returnMessage = returnMessage.replace(";", "");
        return returnMessage;
    }

    @Override
    public void sendResult() {
        CTAT_Controller ctlr = this.getController();
        if (ctlr == null) {
            trace.err("null CTAT_Controller in ProdSysSAIHandler.sendResult()");
            return;
        }
        if (this.returnMessage == null) {
            trace.err("null returnMessage in ProdSysSAIHandler.sendResult()");
        } else {
            ctlr.getMissController().getAPlusHintMessagesManager().setMessages(this.returnMessage);
            String message = ctlr.getMissController().getAPlusHintMessagesManager().getFirstMessage();
            if (ctlr.getMissController() != null && ctlr.getMissController().getSimStPLE() != null && ctlr.getMissController().getSimStPLE().getSimStPeerTutoringPlatform() != null) {
                ctlr.getMissController().getSimStPLE().getSimStPeerTutoringPlatform().getAPlusHintDialogInterface().showMessage(message);
            }
        }
    }

    static class Queue
    implements Runnable {
        private java.util.Queue<ExecuteInstance> queue = new LinkedList<ExecuteInstance>();
        private static final int MAX_THREAD_COUNT = 1;
        private static ExecutorService saiThreadPool = Executors.newFixedThreadPool(1);
        private volatile boolean isActive = false;

        Queue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Queue queue = this;
                synchronized (queue) {
                    this.isActive = true;
                    if (this.queue.peek() == null) {
                        this.isActive = false;
                        return;
                    }
                    ExecuteInstance ei = this.queue.remove();
                    ei.execute();
                }
            }
        }

        int add(String sel, String act, String inp, APlusModelTracing amt, CTAT_Controller controller) {
            return this.add(new ExecuteInstance(sel, act, inp, amt, controller));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int add(ExecuteInstance ei) {
            Queue queue = this;
            synchronized (queue) {
                this.queue.add(ei);
                if (!this.isActive) {
                    Thread t = new Thread(this);
                    t.start();
                }
                return this.queue.size();
            }
        }
    }

    private static class ExecuteInstance {
        final String selection;
        final String action;
        final String input;
        final APlusModelTracing amt;
        final CTAT_Controller controller;

        public ExecuteInstance(String sel, String act, String inp, APlusModelTracing mt, CTAT_Controller controller) {
            this.selection = sel;
            this.action = act;
            this.input = inp;
            this.amt = mt;
            this.controller = controller;
        }

        void execute() {
            ProdSysSAIHandler handler = null;
            handler = new ProdSysSAIHandler(this.selection, this.action, this.input, this.amt, this.controller);
            handler.processSAI();
        }
    }
}

