/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra.expression;

import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.ConstantFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.DoubleConst;
import edu.cmu.pact.miss.userDef.algebra.expression.IntConst;
import edu.cmu.pact.miss.userDef.algebra.expression.Polynomial;
import edu.cmu.pact.miss.userDef.algebra.expression.SimpleTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.Variable;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class ComplexTerm
extends AlgExp {
    protected AlgExp firstTerm;
    protected AlgExp secondTerm;

    public ComplexTerm(AlgExp e1, AlgExp e2) {
        this.firstTerm = e1;
        this.secondTerm = e2;
        this.isTerm = true;
        this.hasVariable = this.firstTerm.hasVariable() || this.secondTerm.hasVariable();
        this.isMonomial = this.firstTerm.isMonomial() && this.secondTerm.isMonomial();
        this.isNegative = this.firstTerm.isNegative() ^ this.secondTerm.isNegative();
    }

    public AlgExp getFirstTerm() {
        return this.firstTerm;
    }

    public AlgExp getSecondTerm() {
        return this.secondTerm;
    }

    @Override
    public AlgExp commute() {
        return new ComplexTerm(this.secondTerm, this.firstTerm);
    }

    @Override
    public AlgExp add(IntConst c) {
        return new Polynomial(this, c);
    }

    @Override
    public AlgExp add(DoubleConst c) {
        return new Polynomial(this, c);
    }

    @Override
    public AlgExp add(Variable v) {
        return new Polynomial(this, v);
    }

    @Override
    public AlgExp add(ConstantFraction f) {
        return new Polynomial(this, f);
    }

    @Override
    public AlgExp add(SimpleTerm t) {
        return new Polynomial(this, t);
    }

    @Override
    public AlgExp add(Polynomial e) {
        if (e.equals(this.firstTerm) && this.secondTerm.isConstant()) {
            if (this.secondTerm.equals(AlgExp.NEGONE)) {
                return AlgExp.ZERO;
            }
            return new ComplexTerm(this.firstTerm, this.secondTerm.add(AlgExp.ONE));
        }
        if (e.equals(this.secondTerm) && this.firstTerm.isConstant()) {
            if (this.firstTerm.equals(AlgExp.NEGONE)) {
                return AlgExp.ZERO;
            }
            return new ComplexTerm(this.firstTerm.add(AlgExp.ONE), this.secondTerm);
        }
        return e.add(this);
    }

    @Override
    public AlgExp add(ComplexTerm ct) {
        if (this.firstTerm.equals(ct.getFirstTerm())) {
            return new ComplexTerm(this.secondTerm.add(ct.getSecondTerm()), this.firstTerm);
        }
        if (this.firstTerm.equals(ct.getSecondTerm())) {
            return new ComplexTerm(this.secondTerm.add(ct.getFirstTerm()), this.firstTerm);
        }
        if (this.secondTerm.equals(ct.getFirstTerm())) {
            return new ComplexTerm(this.firstTerm.add(ct.getSecondTerm()), this.secondTerm);
        }
        if (this.secondTerm.equals(ct.getSecondTerm())) {
            return new ComplexTerm(this.firstTerm.add(ct.getFirstTerm()), this.secondTerm);
        }
        return new Polynomial(this, ct);
    }

    @Override
    public AlgExp mul(IntConst c) {
        return this.doMul(c);
    }

    @Override
    public AlgExp mul(DoubleConst c) {
        return this.doMul(c);
    }

    @Override
    public AlgExp mul(Variable v) {
        return this.doMul(v);
    }

    @Override
    public AlgExp mul(ConstantFraction f) {
        return this.doMul(f);
    }

    @Override
    public AlgExp mul(SimpleTerm t) {
        return this.doMul(t);
    }

    @Override
    public AlgExp mul(Polynomial e) {
        return new ComplexTerm(this, e);
    }

    @Override
    public AlgExp mul(ComplexTerm ct) {
        return new ComplexTerm(this, ct);
    }

    @Override
    public AlgExp div(IntConst c) {
        return this.mul(c.invert());
    }

    @Override
    public AlgExp div(DoubleConst c) {
        return this.mul(c.invert());
    }

    @Override
    public AlgExp div(Variable v) {
        return new ComplexFraction(this, v);
    }

    @Override
    public AlgExp div(ConstantFraction f) {
        return this.mul(f.invert());
    }

    @Override
    public AlgExp div(SimpleTerm t) {
        return new ComplexFraction(this, t);
    }

    @Override
    public AlgExp div(Polynomial e) {
        return e.div(this.invert());
    }

    @Override
    public AlgExp div(ComplexTerm ct) {
        return this.mul(ct.invert());
    }

    @Override
    public AlgExp add(ComplexFraction cf) {
        return cf.add(this);
    }

    @Override
    public AlgExp mul(ComplexFraction cf) {
        return cf.mul(this);
    }

    @Override
    public AlgExp div(ComplexFraction cf) {
        return this.mul(cf.invert());
    }

    @Override
    public AlgExp invert() {
        return new ComplexTerm(AlgExp.ONE, this);
    }

    @Override
    public String parseRep() {
        return "(" + this.firstTerm.parseRep() + ")(" + this.secondTerm.parseRep() + ")";
    }

    public String toString() {
        if (this.firstTerm.isConstant() && this.secondTerm.isConstant()) {
            return this.firstTerm + "*" + this.secondTerm;
        }
        String firstTermRep = !this.firstTerm.isPolynomial() ? (this.firstTerm.equals(AlgExp.NEGONE) ? "-" : this.firstTerm.toString()) : "(" + this.firstTerm.toString() + ")";
        String secondTermRep = !this.secondTerm.isPolynomial() ? (this.secondTerm.equals(AlgExp.NEGONE) ? "-" : this.secondTerm.toString()) : "(" + this.secondTerm.toString() + ")";
        return firstTermRep.concat(secondTermRep);
    }

    @Override
    public boolean equals(IntConst c) {
        if (this.firstTerm.equals(AlgExp.ONE) && this.secondTerm.equals(c)) {
            return true;
        }
        return this.secondTerm.equals(AlgExp.ONE) && this.firstTerm.equals(c);
    }

    @Override
    public boolean equals(DoubleConst c) {
        if (this.firstTerm.equals(AlgExp.ONE) && this.secondTerm.equals(c)) {
            return true;
        }
        return this.secondTerm.equals(AlgExp.ONE) && this.firstTerm.equals(c);
    }

    @Override
    public boolean equals(Variable v) {
        if (this.firstTerm.equals(AlgExp.ONE) && this.secondTerm.equals(v)) {
            return true;
        }
        return this.secondTerm.equals(AlgExp.ONE) && this.firstTerm.equals(v);
    }

    @Override
    public boolean equals(ConstantFraction f) {
        if (this.firstTerm.equals(AlgExp.ONE) && this.secondTerm.equals(f)) {
            return true;
        }
        return this.secondTerm.equals(AlgExp.ONE) && this.firstTerm.equals(f);
    }

    @Override
    public boolean equals(SimpleTerm t) {
        if (this.firstTerm.equals(AlgExp.ONE) && this.secondTerm.equals(t)) {
            return true;
        }
        return this.secondTerm.equals(AlgExp.ONE) && this.firstTerm.equals(t);
    }

    @Override
    public boolean equals(Polynomial e) {
        if (this.firstTerm.equals(AlgExp.ONE) && this.secondTerm.equals(e)) {
            return true;
        }
        return this.secondTerm.equals(AlgExp.ONE) && this.firstTerm.equals(e);
    }

    @Override
    public boolean equals(ComplexTerm ct) {
        return this.firstTerm.equals(ct.firstTerm) && this.secondTerm.equals(ct.secondTerm);
    }

    @Override
    public boolean equals(ComplexFraction cf) {
        return this.equals(cf.getNumerator()) && cf.getDenominator().equals(AlgExp.ONE);
    }

    private AlgExp doMul(AlgExp e) {
        if (this.firstTerm.isPolynomial()) {
            return new ComplexTerm(this.firstTerm.mul(e), this.secondTerm);
        }
        if (this.secondTerm.isPolynomial()) {
            return new ComplexTerm(this.firstTerm, this.secondTerm.mul(e));
        }
        if (this.firstTerm.isSimple()) {
            return new ComplexTerm(this.firstTerm.mul(e), this.secondTerm);
        }
        if (this.secondTerm.isSimple()) {
            return new ComplexTerm(this.firstTerm, this.secondTerm.mul(e));
        }
        return new ComplexTerm(this.firstTerm.mul(e), this.secondTerm);
    }

    @Override
    public AlgExp eval() {
        AlgExp result;
        AlgExp lastResult = this;
        while (!(result = this.firstTerm.eval().mul(this.secondTerm.eval())).equals(lastResult = result)) {
        }
        return result;
    }

    public AlgExp evalMul() {
        AlgExp newFirst = this.firstTerm.isTerm() && !this.firstTerm.isSimple() ? ((ComplexTerm)this.firstTerm).evalMul() : this.firstTerm;
        AlgExp newSecond = this.secondTerm.isTerm() && !this.secondTerm.isSimple() ? ((ComplexTerm)this.secondTerm).evalMul() : this.secondTerm;
        return newFirst.mul(newSecond);
    }

    @Override
    public AlgExp negate() {
        if (this.firstTerm.equals(AlgExp.NEGONE)) {
            return this.secondTerm;
        }
        if (this.secondTerm.equals(AlgExp.NEGONE)) {
            return this.firstTerm;
        }
        if (this.isNegative()) {
            if (this.firstTerm.isNegative()) {
                return new ComplexTerm(this.firstTerm.negate(), this.secondTerm);
            }
            if (this.secondTerm.isNegative()) {
                return new ComplexTerm(this.firstTerm, this.secondTerm.negate());
            }
        }
        if (this.firstTerm.isNegative() && this.secondTerm.isNegative()) {
            return new ComplexTerm(this.firstTerm, this.secondTerm.negate());
        }
        return new ComplexTerm(this.firstTerm.negate(), this.secondTerm);
    }

    @Override
    public boolean hasVariable(String varName) {
        return this.firstTerm.hasVariable(varName) || this.secondTerm.hasVariable(varName);
    }

    @Override
    public Set getAllVars() {
        HashSet vars = new HashSet();
        Set s = this.firstTerm.getAllVars();
        if (!s.isEmpty()) {
            vars.addAll(s);
        }
        if (!(s = this.secondTerm.getAllVars()).isEmpty()) {
            vars.addAll(s);
        }
        return vars;
    }

    public Vector getFactors() {
        SimpleTerm t;
        Vector<AlgExp> factors = new Vector<AlgExp>();
        if (this.firstTerm.isTerm()) {
            if (this.firstTerm.isSimpleTerm()) {
                t = (SimpleTerm)this.firstTerm;
                factors.add(t.getConstant());
                factors.add(t.getVariable());
            } else {
                factors.addAll(((ComplexTerm)this.firstTerm).getFactors());
            }
        } else {
            factors.add(this.firstTerm);
        }
        if (this.secondTerm.isTerm()) {
            if (this.secondTerm.isSimpleTerm()) {
                t = (SimpleTerm)this.secondTerm;
                factors.add(t.getConstant());
                factors.add(t.getVariable());
            } else {
                factors.addAll(((ComplexTerm)this.secondTerm).getFactors());
            }
        } else {
            factors.add(this.secondTerm);
        }
        return factors;
    }

    public boolean containsFactor(AlgExp factor) {
        SimpleTerm t;
        if (this.firstTerm.equals(factor)) {
            return true;
        }
        if (this.secondTerm.equals(factor)) {
            return true;
        }
        if (this.firstTerm.isSimpleTerm() ? (t = (SimpleTerm)this.firstTerm).getConstant().equals(factor) || t.getVariable().equals(factor) : this.firstTerm.isTerm() && ((ComplexTerm)this.firstTerm).containsFactor(factor)) {
            return true;
        }
        return this.secondTerm.isSimpleTerm() ? (t = (SimpleTerm)this.secondTerm).getConstant().equals(factor) || t.getVariable().equals(factor) : this.secondTerm.isTerm() && ((ComplexTerm)this.secondTerm).containsFactor(factor);
    }

    @Override
    public AlgExp divDecimal(IntConst c) {
        new Exception().printStackTrace();
        return null;
    }
}

