/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.stoichiometry;

import edu.cmu.pact.miss.FeaturePredicate;
import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;
import edu.cmu.pact.miss.userDef.stoichiometry.SFNumber;
import edu.cmu.pact.miss.userDef.stoichiometry.StoSubstance;
import java.util.Vector;

public abstract class StoFeatPredicate
extends FeaturePredicate {
    public static String[] massUnits = new String[]{"g", "lbs", "kg", "mg"};
    public static String[] volUnits = new String[]{"gals", "L", "mL", "kL"};
    public static final SFNumber AVOGADRO = new SFNumber("6.0221415E23", true);
    private static final float ALLOWANCE = 0.01f;

    public Vector parseExpression(String expression) {
        String[] parsedArray = expression.split(" ");
        String unit = null;
        String number = parsedArray[0];
        unit = parsedArray[1];
        String substance = parsedArray[2];
        SFNumber sfNum = new SFNumber(number.trim());
        StoSubstance stoSub = new StoSubstance(substance);
        Vector<Object> parsed = new Vector<Object>();
        parsed.add(sfNum);
        parsed.add(unit);
        parsed.add(stoSub);
        return parsed;
    }

    public String matchUnit(String firstExp, String secondExp) {
        Vector first = this.parseExpression(firstExp);
        Vector second = this.parseExpression(secondExp);
        try {
            String firstUnit = (String)first.get(1);
            String secondUnit = (String)second.get(1);
            return this.matchUnitFlash(firstUnit, secondUnit);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String matchUnitFlash(String firstUnit, String secondUnit) {
        try {
            if (firstUnit.equals(secondUnit)) {
                return "T";
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String matchSubstance(String firstExp, String secondExp) {
        Vector first = this.parseExpression(firstExp);
        Vector second = this.parseExpression(secondExp);
        try {
            StoSubstance firstSub = (StoSubstance)first.get(2);
            StoSubstance secondSub = (StoSubstance)second.get(2);
            return this.matchSubstanceFlash(firstSub.toString(), secondSub.toString());
        }
        catch (ClassCastException E) {
            return null;
        }
    }

    public String matchObject(String firstStr, String secondStr) {
        try {
            if (firstStr.equals(secondStr)) {
                return "T";
            }
            return null;
        }
        catch (ClassCastException E) {
            return null;
        }
    }

    public String matchSubstanceFlash(String firstSubStr, String secondSubStr) {
        try {
            if (firstSubStr.equals(secondSubStr)) {
                return "T";
            }
            return null;
        }
        catch (ClassCastException E) {
            return null;
        }
    }

    public String matchTopUnit(String givenVal, String input) {
        if (givenVal.equals(input)) {
            return null;
        }
        Vector givenVec = this.parseExpression(givenVal);
        Vector inputVec = this.parseExpression(input);
        try {
            String givenUnit = (String)givenVec.get(1);
            String inputUnit = (String)inputVec.get(1);
            return this.matchTopUnitFlash(givenUnit, inputUnit);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String matchTopUnitFlash(String givenUnit, String inputUnit) {
        try {
            String[] splitUnits = givenUnit.split("/");
            if (splitUnits.length != 2) {
                return null;
            }
            if (splitUnits[0].equals(inputUnit)) {
                return "T";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String matchBottomUnit(String givenVal, String input) {
        if (givenVal.equals(input)) {
            return null;
        }
        Vector givenVec = this.parseExpression(givenVal);
        Vector inputVec = this.parseExpression(input);
        try {
            String givenUnit = (String)givenVec.get(1);
            String inputUnit = (String)inputVec.get(1);
            return this.matchBottomUnitFlash(givenUnit, inputUnit);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String matchBottomUnitFlash(String givenUnit, String inputUnit) {
        try {
            String[] splitUnits = givenUnit.split("/");
            if (splitUnits.length != 2) {
                return null;
            }
            if (splitUnits[1].equals(inputUnit)) {
                return "T";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String matchReason(String input, String givenReason) {
        if (input.equals(givenReason)) {
            return "T";
        }
        return null;
    }

    public String containsSubstance(String firstExp, String secondExp) {
        Vector firstVec = this.parseExpression(firstExp);
        Vector secondVec = this.parseExpression(secondExp);
        try {
            StoSubstance larger = (StoSubstance)firstVec.get(2);
            StoSubstance smaller = (StoSubstance)secondVec.get(2);
            String largerString = larger.toString();
            String smallerString = smaller.toString();
            return this.containsSubstanceFlash(largerString, smallerString);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String containsSubstanceFlash(String largerString, String smallerString) {
        try {
            if (!largerString.equals(smallerString) && largerString.indexOf(smallerString) != -1) {
                return "T";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String hasCorrectSigFigs(String numSigFigs, String exp) {
        Vector sfVec = this.parseExpression(numSigFigs);
        Vector expVec = this.parseExpression(exp);
        try {
            SFNumber numSF = (SFNumber)sfVec.get(0);
            SFNumber inputNum = (SFNumber)expVec.get(0);
            return this.hasCorrectSigFigsFlash(numSF.toString(), inputNum.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String hasCorrectSigFigsFlash(String numSFStr, String inputNumStr) {
        try {
            SFNumber numSF = new SFNumber(numSFStr);
            SFNumber inputNum = new SFNumber(inputNumStr);
            int SFint = Integer.parseInt(numSF.getDecimalPart());
            if (numSF.getExponent().equals("0") && SFint > 0 && inputNum.getSigFigs() == SFint) {
                return "T";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String canBeConverted(String first, String second) {
        if (first.equals(second)) {
            return null;
        }
        Vector firstVec = this.parseExpression(first);
        Vector secondVec = this.parseExpression(second);
        try {
            String firstUnit = (String)firstVec.get(1);
            String secondUnit = (String)secondVec.get(1);
            return this.canBeConvertedFlash(firstUnit, secondUnit);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String canBeConvertedFlash(String firstUnit, String secondUnit) {
        try {
            boolean hasFirst = false;
            boolean hasSecond = false;
            if (firstUnit.equals(secondUnit)) {
                return null;
            }
            for (int i = 0; i < massUnits.length; ++i) {
                if (massUnits[i].equals(firstUnit)) {
                    hasFirst = true;
                    continue;
                }
                if (!massUnits[i].equals(secondUnit)) continue;
                hasSecond = true;
            }
            if (hasFirst && hasSecond) {
                return "T";
            }
            hasSecond = false;
            hasFirst = false;
            for (int j = 0; j < volUnits.length; ++j) {
                if (volUnits[j].equals(firstUnit)) {
                    hasFirst = true;
                    continue;
                }
                if (!volUnits[j].equals(secondUnit)) continue;
                hasSecond = true;
            }
            if (hasFirst && hasSecond) {
                return "T";
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String multExact(String firstExpression, String secondExpression) {
        try {
            SFNumber num1 = new SFNumber(firstExpression.trim());
            SFNumber num2 = new SFNumber(secondExpression.trim());
            Vector<SFNumber> res = new Vector<SFNumber>();
            res.add(this.multExactFlash(num1, num2));
            return res.get(0).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public SFNumber multExactFlash(SFNumber num1, SFNumber num2) {
        try {
            SFNumber product = num1.multiplyBy(num2, true);
            return product;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String multTwoTerms(String firstExpression, String secondExpression) {
        Vector firstVec = this.parseExpression(firstExpression);
        Vector secondVec = this.parseExpression(secondExpression);
        try {
            SFNumber num1 = (SFNumber)firstVec.get(0);
            SFNumber num2 = (SFNumber)secondVec.get(0);
            firstVec.setElementAt(this.multTwoTermsFlash(num1, num2), 0);
            return this.outputToString(firstVec);
        }
        catch (Exception e) {
            return null;
        }
    }

    public SFNumber multTwoTermsFlash(SFNumber num1, SFNumber num2) {
        try {
            SFNumber product = num1.multiplyBy(num2, false);
            System.out.println("num1=" + num1 + "  num2 = " + num2 + "    product = " + product);
            return product;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String multThreeTerms(String firstExpression, String secondExpression, String thirdExpression) {
        Vector firstVec = this.parseExpression(firstExpression);
        Vector secondVec = this.parseExpression(secondExpression);
        Vector thirdVec = this.parseExpression(thirdExpression);
        try {
            SFNumber num1 = (SFNumber)firstVec.get(0);
            SFNumber num2 = (SFNumber)secondVec.get(0);
            SFNumber num3 = (SFNumber)thirdVec.get(0);
            SFNumber product1 = num1.multiplyBy(num2, false);
            SFNumber product2 = product1.multiplyBy(num3, false);
            firstVec.setElementAt(this.multThreeTermsFlash(num1, num2, num3), 0);
            return this.outputToString(firstVec);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Object multThreeTermsFlash(SFNumber num1, SFNumber num2, SFNumber num3) {
        try {
            SFNumber product1 = num1.multiplyBy(num2, false);
            SFNumber product2 = product1.multiplyBy(num3, false);
            return product2;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String multFourTerms(String firstExpression, String secondExpression, String thirdExpression, String fourthExpression) {
        Vector firstVec = this.parseExpression(firstExpression);
        Vector secondVec = this.parseExpression(secondExpression);
        Vector thirdVec = this.parseExpression(thirdExpression);
        Vector fourthVec = this.parseExpression(fourthExpression);
        try {
            SFNumber num1 = (SFNumber)firstVec.get(0);
            SFNumber num2 = (SFNumber)secondVec.get(0);
            SFNumber num3 = (SFNumber)thirdVec.get(0);
            SFNumber num4 = (SFNumber)fourthVec.get(0);
            SFNumber product1 = num1.multiplyBy(num2, false);
            SFNumber product2 = product1.multiplyBy(num3, false);
            SFNumber product3 = product2.multiplyBy(num4, false);
            firstVec.setElementAt(product3, 0);
            return this.outputToString(firstVec);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String divideExact(String firstExp, String secondExp) {
        try {
            SFNumber num1 = new SFNumber(firstExp.trim());
            SFNumber num2 = new SFNumber(secondExp.trim());
            Vector<SFNumber> res = new Vector<SFNumber>();
            res.add(this.divideExactFlash(num1, num2));
            return res.get(0).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public SFNumber divideExactFlash(SFNumber num1, SFNumber num2) {
        try {
            SFNumber result = num1.divideBy(num2, true);
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String round(String firstExp, String secondExp) {
        try {
            SFNumber num1 = new SFNumber(firstExp.trim());
            int sf = Integer.parseInt(secondExp.trim());
            Vector<SFNumber> res = new Vector<SFNumber>();
            res.add(num1.round(sf));
            return res.get(0).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String divideTerms(String firstExp, String secondExp) {
        Vector firstVec = this.parseExpression(firstExp);
        Vector secondVec = this.parseExpression(secondExp);
        try {
            SFNumber num1 = (SFNumber)firstVec.get(0);
            SFNumber num2 = (SFNumber)secondVec.get(0);
            SFNumber result = num1.divideBy(num2, false);
            firstVec.setElementAt(result, 0);
            return this.outputToString(firstVec);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String setUnit(String input, String expected, String reason) {
        Vector inputVec = this.parseExpression(input);
        Vector expectedVec = this.parseExpression(expected);
        try {
            String unit = (String)inputVec.get(1);
            expectedVec.setElementAt(unit, 1);
            return this.outputToString(expectedVec);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public String setUnitFlash(String unit) {
        return unit;
    }

    public String convertUnit(String input, String expectedUnit, String unit, String number, String reason) {
        Vector inputVec = this.parseExpression(input);
        try {
            if (((String)inputVec.get(1)).equals(expectedUnit)) {
                inputVec.setElementAt(unit, 1);
                inputVec.setElementAt(new SFNumber(number, true), 0);
                return this.outputToString(inputVec);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String takeTopUnit(String givenVal, String input, String reason) {
        Vector givenVec = this.parseExpression(givenVal);
        Vector inputVec = this.parseExpression(input);
        try {
            String givenUnit = (String)givenVec.get(1);
            String[] splitUnits = givenUnit.split("/");
            inputVec.setElementAt(splitUnits[0], 1);
            return this.outputToString(inputVec);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String takeBottomUnit(String givenVal, String input, String reason) {
        Vector givenVec = this.parseExpression(givenVal);
        Vector inputVec = this.parseExpression(input);
        try {
            String givenUnit = (String)givenVec.get(1);
            String[] splitUnits = givenUnit.split("/");
            inputVec.setElementAt(splitUnits[1], 1);
            return this.outputToString(inputVec);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String setNumberToOne(String input, String reason) {
        Vector inputVec = this.parseExpression(input);
        try {
            inputVec.setElementAt(new SFNumber("1", true), 0);
            return this.outputToString(inputVec);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String oneFlash() {
        return "1";
    }

    public String setSubstance(String input, String expected, String reason) {
        Vector inputVec = this.parseExpression(input);
        Vector expectedVec = this.parseExpression(expected);
        try {
            String substance = (String)inputVec.get(2);
            expectedVec.setElementAt(this.setSubstanceFlash(substance), 2);
            return this.outputToString(expectedVec);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public String setSubstanceFlash(String substance) {
        return substance;
    }

    public String setNumber(String input, String expected, String reason) {
        Vector inputVec = this.parseExpression(input);
        Vector expectedVec = this.parseExpression(expected);
        try {
            SFNumber number = (SFNumber)inputVec.get(0);
            expectedVec.setElementAt(number, 2);
            return this.outputToString(expectedVec);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public String molarRatio(String input, String goal, String reason) {
        Vector inputVec = this.parseExpression(input);
        Vector goalVec = this.parseExpression(goal);
        StoSubstance goalSubstance = (StoSubstance)goalVec.get(2);
        StoSubstance inputSubstance = (StoSubstance)inputVec.get(2);
        Vector components = inputSubstance.getComponents();
        for (int i = 0; i < components.size(); ++i) {
            try {
                String[] curComp = (String[])components.get(i);
                if (!curComp[0].equals(goalSubstance.toString())) continue;
                Vector<Object> output = new Vector<Object>();
                output.add(new SFNumber(curComp[1], true));
                output.add(new String("mol"));
                output.add(goalSubstance);
                return this.outputToString(output);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    public String ucValueNumerator(String reason, String unit1, String unit2) {
        if (reason.equalsIgnoreCase("Unit Conversion")) {
            return this.ucValue(unit1, unit2)[0];
        }
        return null;
    }

    public String ucValueNumerator(String unit1, String unit2) {
        return this.ucValue(unit1, unit2)[0];
    }

    public String ucValueDenominator(String reason, String unit1, String unit2) {
        if (reason.equalsIgnoreCase("Unit Conversion")) {
            return this.ucValue(unit1, unit2)[1];
        }
        return null;
    }

    public String ucValueDenominator(String unit1, String unit2) {
        return this.ucValue(unit1, unit2)[1];
    }

    public String[] ucValue(String unit1, String unit2) {
        String[][] conversions = new String[][]{{"g", "mg", "1000", "1"}, {"kL", "L", "1000", "1"}, {"L", "mL", "1000", "1"}, {"kg", "g", "1000", "1"}, {"kL", "mL", "1000000", "1"}, {"lb", "g", "453.6", "1"}};
        String[] result = new String[2];
        for (int i = 0; i < conversions.length; ++i) {
            String[] conv = conversions[i];
            String u1 = conv[0];
            String u2 = conv[1];
            String v1 = conv[2];
            String v2 = conv[3];
            if (u1.equalsIgnoreCase(unit1) && u2.equalsIgnoreCase(unit2)) {
                result[0] = v1;
                result[1] = v2;
                continue;
            }
            if (!u1.equalsIgnoreCase(unit2) || !u2.equalsIgnoreCase(unit1)) continue;
            result[0] = v2;
            result[1] = v1;
        }
        return result;
    }

    public String interUnit(String unit1, String unit2) {
        String[][] conversions = new String[][]{{"kg", "mg", "g"}, {"kL", "mL", "L"}, {"mm", "m", "cm"}, {"cm", "km", "m"}};
        String result = null;
        for (int i = 0; i < conversions.length; ++i) {
            String[] conv = conversions[i];
            String u1 = conv[0];
            String u2 = conv[1];
            String v1 = conv[2];
            if (u1.equalsIgnoreCase(unit1) && u2.equalsIgnoreCase(unit2)) {
                result = v1;
                continue;
            }
            if (!u1.equalsIgnoreCase(unit2) || !u2.equalsIgnoreCase(unit1)) continue;
            result = v1;
        }
        return result;
    }

    public String avogadro(String expected) {
        Vector expectedVec = this.parseExpression(expected);
        expectedVec.setElementAt(AVOGADRO, 0);
        return this.outputToString(expectedVec);
    }

    @Override
    public String inputMatcher(String s1, String s2) {
        String result = this.convertBoolean(this.stoichInputMatcher(s1, s2));
        return result;
    }

    public static boolean isNumber(String s) {
        return EqFeaturePredicate.isFloatingPointNumber(s);
    }

    public boolean stoichInputMatcher(String s1, String s2) {
        if (s1.equalsIgnoreCase(s2)) {
            return true;
        }
        if (StoFeatPredicate.isNumber(s1) && StoFeatPredicate.isNumber(s2)) {
            SFNumber num1 = new SFNumber(s1);
            SFNumber num2 = new SFNumber(s2);
            boolean decimalMatch = this.doesDecimalMatch(Double.valueOf(num1.getDecimalPart()), Double.valueOf(num2.getDecimalPart()), 0.01f);
            boolean exponentMatch = Integer.valueOf(num1.getExponent()).equals(Integer.valueOf(num2.getExponent()));
            return decimalMatch && exponentMatch;
        }
        return false;
    }

    private boolean doesDecimalMatch(Double d1, Double d2, float allowance) {
        double e2;
        double e1 = d1;
        boolean result = Math.abs(e1 - (e2 = d2.doubleValue())) < (double)allowance;
        return result;
    }

    public String molWeightValue(String subs) {
        String result = null;
        if (subs.equals("AsO2-")) {
            result = "106.9";
        }
        if (subs.equals("COH4")) {
            result = "32.04";
        }
        if (subs.equals("KCl")) {
            result = "74.551";
        }
        if (subs.equals("CCl4")) {
            result = "152";
        }
        if (subs.equals("Fe")) {
            result = "55.845";
        }
        if (subs.equals("hemoglobin")) {
            result = "66627.97";
        }
        if (subs.equals("MgSO4")) {
            result = "120.37";
        }
        if (subs.equals("")) {
            result = "";
        }
        return result;
    }

    public String outputToString(Vector output) {
        String outputStr = output.get(0) + " " + output.get(1) + " " + output.get(2);
        return outputStr;
    }
}

