/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.Dialogs.EditListItemDialog;
import edu.cmu.pact.Utilities.ComponentDescription;
import edu.cmu.pact.Utilities.StringTokenizerItemValues;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import pact.CommWidgets.JCommWidget;

public class JCommComposer
extends JCommWidget
implements ActionListener,
ItemListener,
MouseListener {
    protected String newValue;
    protected JList sentenceJList;
    protected int sizeOfSentenceJList = 0;
    protected JScrollPane listScrollPane;
    protected Vector sentenceJListColors;
    protected JComboBox[] composeJComboBox;
    protected int comboBoxesWidth = 0;
    protected String comboBoxesWidths = "0";
    protected int comboBoxesWidths_Number = 0;
    protected int[] comboBoxWidthsArray;
    protected int maxRowItemsView = 40;
    protected int sentencePanelHeight = 60;
    protected int comboBoxesNumber = 4;
    protected String itemValues = "";
    protected String[] values;
    protected boolean enableItemToolTips = false;
    protected JButton addJButton = new JButton("  Add  ");
    protected JButton deleteJButton = new JButton("  Delete  ");
    protected JPanel selectsPanel = new JPanel();
    protected JPanel comboBoxesPanel = new JPanel();
    protected JPanel buttonsPanel = new JPanel();
    protected Font startFont;
    protected boolean locked;
    protected boolean setValueDone = true;
    protected boolean allowDeletes = false;

    public JCommComposer() {
        this.sentenceJList = new JList();
        this.listScrollPane = new JScrollPane(this.sentenceJList);
        this.sentenceJListColors = new Vector();
        this.comboBoxesPanel.setLayout(new FlowLayout(1));
        this.setLayout(new BorderLayout());
        this.add((Component)this.listScrollPane, "North");
        this.add((Component)this.comboBoxesPanel, "Center");
        this.setSize(new Dimension(500, 120));
        this.createButtonPanel();
        this.createComboBoxes();
        this.sentenceJList.setCellRenderer(new MyCellRenderer());
        this.backgroundNormalColor = this.sentenceJList.getBackground();
        DefaultListModel lm = new DefaultListModel();
        this.sentenceJList.setModel(lm);
        this.addJButton.addActionListener(this);
        this.deleteJButton.addActionListener(this);
        this.locked = false;
        this.setSentencePanelHeight(this.sentencePanelHeight);
        this.addFocusListener(this);
    }

    @Override
    public void setSize(Dimension d) {
        this.setPreferredSize(d);
    }

    public void setEnableItemToolTips(boolean enableItemToolTips) {
        this.enableItemToolTips = enableItemToolTips;
    }

    public boolean getEnableItemToolTips() {
        return this.enableItemToolTips;
    }

    protected void createButtonPanel() {
        if (this.buttonsPanel != null) {
            this.buttonsPanel.removeAll();
        }
        this.buttonsPanel.setLayout(new FlowLayout(2));
        this.add((Component)this.buttonsPanel, "South");
        if (this.allowDeletes) {
            this.buttonsPanel.add(this.deleteJButton);
            if (this.enableItemToolTips) {
                this.deleteJButton.setToolTipText("Remove the selected line");
            }
        }
        this.buttonsPanel.add(this.addJButton);
    }

    protected void createComboBoxes() {
        if (this.comboBoxesPanel != null) {
            this.comboBoxesPanel.removeAll();
        }
        this.composeJComboBox = new JComboBox[this.comboBoxesNumber];
        this.values = new String[this.comboBoxesNumber];
        for (int i = 0; i < this.comboBoxesNumber; ++i) {
            this.values[i] = "";
            this.composeJComboBox[i] = new JComboBox();
            this.composeJComboBox[i].addItemListener(this);
            if (this.enableItemToolTips) {
                this.composeJComboBox[i].setRenderer(new MyComboBoxRenderer());
            }
            this.composeJComboBox[i].setMaximumRowCount(this.maxRowItemsView);
            if (this.comboBoxWidthsArray != null && i < this.comboBoxWidthsArray.length && this.comboBoxWidthsArray[i] != 0) {
                this.composeJComboBox[i].setPreferredSize(new Dimension(this.comboBoxWidthsArray[i], 20));
            }
            this.composeJComboBox[i].setEditable(true);
            this.composeJComboBox[i].addActionListener(this);
            this.composeJComboBox[i].addMouseListener(this);
            this.composeJComboBox[i].setName("ComboBox" + i);
            this.composeJComboBox[i].getComponent(0).addMouseListener(this);
            this.composeJComboBox[i].getComponent(0).setName("Button" + i);
            this.comboBoxesPanel.add(this.composeJComboBox[i]);
        }
    }

    public void setComboBoxesWidths(String comboBoxesWidths) {
        this.comboBoxesWidths = comboBoxesWidths;
        StringTokenizer st = new StringTokenizer(comboBoxesWidths, ",");
        this.comboBoxesWidths_Number = st.countTokens();
        this.comboBoxWidthsArray = new int[this.comboBoxesWidths_Number];
        int n = 0;
        while (st.hasMoreElements()) {
            String widthString = (String)st.nextElement();
            if ((widthString = widthString.trim()).length() != 0) {
                this.comboBoxWidthsArray[n] = Integer.parseInt(widthString);
            }
            ++n;
        }
        if (this.comboBoxesWidths_Number == 1 && this.comboBoxWidthsArray[0] != 0) {
            int tempWidth = this.comboBoxWidthsArray[0];
            this.comboBoxWidthsArray = new int[this.composeJComboBox.length];
            for (int i = 0; i < this.composeJComboBox.length; ++i) {
                this.comboBoxWidthsArray[i] = tempWidth;
            }
        }
        this.createComboBoxes();
    }

    public String getComboBoxesWidths() {
        return this.comboBoxesWidths;
    }

    public void setMaxRowItemsView(int maxRowItemsView) {
        this.maxRowItemsView = maxRowItemsView;
        if (this.composeJComboBox != null) {
            for (int i = 0; i < this.comboBoxesNumber; ++i) {
                this.composeJComboBox[i].setMaximumRowCount(maxRowItemsView);
            }
        }
    }

    public int getMaxRowItemsView() {
        return this.maxRowItemsView;
    }

    public void setSentencePanelHeight(int sentencePanelHeight) {
        this.sentencePanelHeight = sentencePanelHeight;
        Dimension d = this.getSize();
        this.repaint();
        this.listScrollPane.setPreferredSize(new Dimension(d.width, sentencePanelHeight));
    }

    public int getSentencePanelHeight() {
        return this.sentencePanelHeight;
    }

    public void setItemValues(String itemValues) {
        this.itemValues = itemValues;
        this.values = new String[this.comboBoxesNumber];
        this.setComboBoxesNumber(this.comboBoxesNumber);
        int i = 0;
        StringTokenizerItemValues st = new StringTokenizerItemValues(itemValues, ';', '/');
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            this.setValues(str, i);
            ++i;
        }
    }

    public void setValue1(String valueItem) {
        if ((valueItem = valueItem.trim()).length() > 0) {
            this.setValues(valueItem, 0);
        }
    }

    public void setValue2(String valueItem) {
        if ((valueItem = valueItem.trim()).length() > 0) {
            this.setValues(valueItem, 1);
        }
    }

    public void setValue3(String valueItem) {
        if ((valueItem = valueItem.trim()).length() > 0) {
            this.setValues(valueItem, 2);
        }
    }

    public void setValue4(String valueItem) {
        if ((valueItem = valueItem.trim()).length() > 0) {
            this.setValues(valueItem, 3);
        }
    }

    public void setComboBoxesNumber(int comboBoxesNumber) {
        this.comboBoxesNumber = comboBoxesNumber;
        this.createComboBoxes();
    }

    public String getItemValues() {
        return this.itemValues;
    }

    public int getComboBoxesNumber() {
        return this.comboBoxesNumber;
    }

    @Override
    public void setEditable(boolean setFlag) {
        if (this.composeJComboBox == null) {
            return;
        }
        for (int i = 0; i < this.comboBoxesNumber; ++i) {
            this.composeJComboBox[i].setEditable(setFlag);
            if (setFlag) {
                this.composeJComboBox[i].addActionListener(this);
                continue;
            }
            this.composeJComboBox[i].removeActionListener(this);
        }
    }

    public boolean getallowDeletes() {
        return this.allowDeletes;
    }

    public void setallowDeletes(boolean allowDeletes) {
        this.allowDeletes = allowDeletes;
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "set allowDeletes to" + allowDeletes);
        }
        this.createButtonPanel();
    }

    void addItem(int index, String addedItem) {
        String comboBoxValues = "";
        if (addedItem == null || addedItem.equals("")) {
            return;
        }
        if (!this.testInValues(this.values[index], addedItem)) {
            this.composeJComboBox[index].addItem(addedItem);
            if (this.values[index].equals("")) {
                this.values[index] = addedItem;
            } else {
                this.values[index] = this.values[index] + "," + addedItem;
                this.composeJComboBox[index].setSelectedIndex(0);
            }
            MessageObject mo = this.getDescriptionMessage();
            this.getUniversalToolProxy().sendMessage(mo);
        }
    }

    boolean testInValues(String comboBoxValues, String testString) {
        if (comboBoxValues.equals("")) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(comboBoxValues, ",");
        while (st.hasMoreElements()) {
            String tempItem = (String)st.nextElement();
            if (!testString.equals(tempItem = tempItem.trim())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unlockWidget() {
        this.locked = false;
    }

    public boolean existingItem(String NewString) {
        for (int i = 0; i < this.sizeOfSentenceJList; ++i) {
            String itemString = (String)((DefaultListModel)this.sentenceJList.getModel()).elementAt(i);
            if (!itemString.equals(NewString)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.removeHighlight(this.commName);
        if (e.getSource() == this.deleteJButton) {
            String selectedItem;
            if (trace.getDebugCode("dw")) {
                trace.out("dw", "Delete Button clicked");
            }
            if ((selectedItem = (String)this.sentenceJList.getSelectedValue()) == null) {
                return;
            }
            this.doInterfaceAction("", "UpdateDeleteLines", selectedItem);
            this.dirty = true;
            this.sendValue();
        } else if (e.getSource() == this.addJButton) {
            String itemString;
            if (trace.getDebugCode("dw")) {
                trace.out("dw", "Add Button clicked");
            }
            String tempString = "";
            for (int i = 0; i < this.comboBoxesNumber - 1; ++i) {
                itemString = (String)this.composeJComboBox[i].getSelectedItem();
                if (itemString == null) continue;
                tempString = tempString + itemString.trim() + " ";
            }
            itemString = (String)this.composeJComboBox[this.comboBoxesNumber - 1].getSelectedItem();
            if (itemString != null) {
                tempString = tempString + itemString.trim();
            }
            this.doInterfaceAction("", "UpdateComposer", tempString);
            this.dirty = true;
            this.sendValue();
        } else {
            for (int i = 0; i < this.comboBoxesNumber; ++i) {
                if (trace.getDebugCode("dw")) {
                    trace.out("dw", "JCComposer.actionPerformed(" + e.paramString() + "): ctlr.isDefiningStartState() " + this.getController().isDefiningStartState());
                }
                if (e.getSource() != this.composeJComboBox[i] || !this.setValueDone || !this.getController().isDefiningStartState()) continue;
                String itemString = (String)this.composeJComboBox[i].getSelectedItem();
                this.addItem(i, itemString);
                return;
            }
        }
    }

    @Override
    public void highlight(String subElement, Border highlightBorder) {
        this.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.setBorder(this.originalBorder);
    }

    @Override
    public void setFocus(String subWidgetName) {
        this.addJButton.requestFocus();
    }

    private void setValues(String valuesString, int comboIndex) {
        if (comboIndex < 0 || comboIndex >= this.comboBoxesNumber) {
            trace.out(5, this, "invalid comboIndex value: " + comboIndex);
            return;
        }
        this.setValueDone = false;
        this.values[comboIndex] = valuesString = valuesString.trim();
        if (this.composeJComboBox[comboIndex].getItemCount() != 0) {
            this.composeJComboBox[comboIndex].removeAllItems();
        }
        if (valuesString.length() == 0) {
            this.setValueDone = true;
            return;
        }
        StringTokenizerItemValues st = new StringTokenizerItemValues(valuesString, ',', '/');
        while (st.hasMoreElements()) {
            String tempItem = (String)st.nextElement();
            if ((tempItem = tempItem.trim()).equals("")) continue;
            ((DefaultComboBoxModel)this.composeJComboBox[comboIndex].getModel()).addElement(tempItem);
        }
        this.composeJComboBox[comboIndex].setSelectedIndex(0);
        this.setValueDone = true;
    }

    @Override
    public void setFont(Font f) {
        if (f != null) {
            this.startFont = f;
            super.setFont(f);
        } else {
            this.startFont = super.getFont();
        }
    }

    @Override
    public void doInterfaceDescription(MessageObject messageObject) {
        ComponentDescription cd = new ComponentDescription(this);
        cd.executeGraphicalProperties(messageObject);
        Object obj = messageObject.getProperty("ComboBoxesNumber");
        if (obj instanceof Integer) {
            this.comboBoxesNumber = (Integer)obj;
            this.setComboBoxesNumber(this.comboBoxesNumber);
        } else if (obj instanceof String) {
            this.comboBoxesNumber = Integer.parseInt((String)obj);
            this.setComboBoxesNumber(this.comboBoxesNumber);
        } else {
            System.out.println("Unexpected TYPE of comboBoxesNumber");
        }
        obj = messageObject.getProperty("ComboBoxesWidths");
        if (obj instanceof Integer) {
            this.setComboBoxesWidths(obj.toString());
        } else if (obj instanceof String) {
            this.setComboBoxesWidths((String)obj);
        } else {
            System.out.println("Unexpected TYPE of comboBoxesWidths");
        }
        for (int i = 0; i < this.comboBoxesNumber; ++i) {
            String valuesString = "Values" + (i + 1);
            String comboBoxItems = (String)messageObject.getProperty(valuesString);
            if (comboBoxItems != null && comboBoxItems.length() > 0) {
                this.setValues(comboBoxItems, i);
                continue;
            }
            this.setValues("", i);
        }
        this.setEditable(false);
        this.repaint();
    }

    @Override
    public MessageObject getDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        if (this.getUniversalToolProxy() == null) {
            return mo;
        }
        if (!this.initialize(this.getController())) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        mo = this.formDescriptionMessage();
        return mo;
    }

    public MessageObject formDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        Vector<String> pNames = new Vector<String>();
        Vector<String> pValues = new Vector<String>();
        pValues.addElement(Integer.toString(this.comboBoxesNumber));
        pNames.addElement("ComboBoxesWidths");
        pValues.addElement(this.getComboBoxesWidths());
        mo.setProperty("WidgetType", "JCommComposer");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        mo.setProperty("ComboBoxesNumber", Integer.toString(this.comboBoxesNumber));
        mo.setProperty("ComboBoxesWidths", this.getComboBoxesWidths());
        for (int i = 0; i < this.comboBoxesNumber; ++i) {
            mo.setProperty("Values" + (i + 1), this.getValues(i));
        }
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate composer (slot name) (slot current-input)";
        for (int i = 0; i < this.comboBoxesNumber; ++i) {
            deftemplateStr = deftemplateStr + " (multislot list" + (i + 1) + ")";
        }
        deftemplateStr = deftemplateStr + ")";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String instanceStr = "(assert (composer (name " + this.commName + ")";
        for (int i = 0; i < this.comboBoxesNumber; ++i) {
            instanceStr = instanceStr + " (list" + (i + 1) + " " + this.getValues(i) + ")";
        }
        instanceStr = instanceStr + "))";
        instances.add(instanceStr);
        return instances;
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "doCorrectAction [ " + selection + " , " + action + " , " + input + "]");
        }
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else {
            this.doInterfaceAction(selection, action, input);
            this.setValueColor(input, this.correctColor);
            if (this.getUniversalToolProxy().lockWidget()) {
                this.locked = true;
            }
        }
    }

    @Override
    public void doLISPCheckAction(String selection, String action, String input) {
        trace.out("doLISPCheckAction [ " + selection + " , " + action + " , " + input + "]");
        this.doInterfaceAction(selection, action, input);
        this.setValueColor(input, this.LISPCheckColor);
        if (this.getUniversalToolProxy().lockWidget()) {
            this.locked = true;
        }
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        trace.out("doInCorrectAction [ " + selection + " , " + input + "]");
        this.undoInterfaceAction(selection, this.actionName, input);
        this.setValueColor(input, this.incorrectColor);
        this.locked = false;
    }

    @Override
    public void doIncorrectAction(String selection, String action, String input) {
        trace.out("doInCorrectAction [ " + selection + " , " + action + " , " + input + "]");
        this.undoInterfaceAction(selection, action, input);
        this.setValueColor(input, this.incorrectColor);
        this.locked = false;
    }

    private void setValueColor(String value, Color setColor) {
        for (int i = 0; i < this.sizeOfSentenceJList; ++i) {
            String tempItem = (String)((DefaultListModel)this.sentenceJList.getModel()).elementAt(i);
            if (!tempItem.equals(value)) continue;
            this.sentenceJListColors.setElementAt(setColor, i);
            break;
        }
        this.sentenceJList.repaint();
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        String tempItem = "";
        int size = this.sizeOfSentenceJList;
        this.newValue = input;
        this.actionName = action;
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "doInterfaceAction with " + action + " [ " + input + " ]");
        }
        if (action.equals("UpdateDeleteLines")) {
            for (int i = 0; i < size; ++i) {
                tempItem = (String)((DefaultListModel)this.sentenceJList.getModel()).getElementAt(i);
                if (!tempItem.equals(input)) continue;
                ((DefaultListModel)this.sentenceJList.getModel()).removeElementAt(i);
                --this.sizeOfSentenceJList;
                break;
            }
        } else if (action.equals("UpdateComposer")) {
            int index = this.sentenceJList.getSelectedIndex();
            if (!this.existingItem(input)) {
                if (index == -1 || index + 1 == size) {
                    ((DefaultListModel)this.sentenceJList.getModel()).addElement(input);
                    this.sentenceJList.setSelectedIndex(size);
                } else {
                    ((DefaultListModel)this.sentenceJList.getModel()).insertElementAt(input, index + 1);
                    this.sentenceJList.setSelectedIndex(index + 1);
                }
                ++this.sizeOfSentenceJList;
                this.sentenceJListColors.addElement(this.startColor);
            }
        } else {
            if (action.equalsIgnoreCase("UpdateInVisible")) {
                if (trace.getDebugCode("inter")) {
                    trace.out("inter", "Set InVisible: " + input);
                }
                if (input.equalsIgnoreCase("true")) {
                    this.setInvisible(true);
                } else {
                    this.setInvisible(false);
                }
                this.setVisible(!this.isInvisible());
                return;
            }
            if ("SetVisible".equalsIgnoreCase(action)) {
                if (trace.getDebugCode("inter")) {
                    trace.out("inter", "SetVisible: " + input);
                }
                this.setVisible(input);
                return;
            }
        }
        this.sentenceJList.repaint();
        if (this.getController().isStartStateInterface()) {
            this.locked = true;
        }
    }

    public void undoInterfaceAction(String selection, String action, String input) {
        this.newValue = input;
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "undoInterfaceAction with " + action + " [ " + input + " ]");
        }
        int index = this.sentenceJList.getSelectedIndex();
        int size = this.sizeOfSentenceJList;
        this.newValue = input;
        if (action.equals("UpdateDeleteLines")) {
            if (index == -1 || index + 1 == size) {
                ((DefaultListModel)this.sentenceJList.getModel()).addElement(this.newValue);
                this.sentenceJList.setSelectedIndex(size);
            } else {
                ((DefaultListModel)this.sentenceJList.getModel()).insertElementAt(this.newValue, index + 1);
                this.sentenceJList.setSelectedIndex(index + 1);
            }
            ++this.sizeOfSentenceJList;
            this.sentenceJListColors.addElement(this.startColor);
        }
        this.sentenceJList.repaint();
        if (this.getController().isStartStateInterface()) {
            this.locked = true;
        }
    }

    public void setProperty(MessageObject o) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
    }

    @Override
    public Object getValue() {
        return this.newValue;
    }

    protected String getValues(int comboIndex) {
        return this.values[comboIndex];
    }

    public Vector getCurrentState() {
        Vector<MessageObject> v = new Vector<MessageObject>();
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "getCurrentState");
        }
        for (int i = 0; i < this.sizeOfSentenceJList; ++i) {
            this.newValue = (String)((DefaultListModel)this.sentenceJList.getModel()).elementAt(i);
            v.addElement(this.getCurrentStateMessage());
        }
        return v;
    }

    @Override
    public boolean isChangedFromResetState() {
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "isChangedFromResetState: size = " + this.sizeOfSentenceJList);
        }
        return this.sizeOfSentenceJList > 0;
    }

    public boolean hasValidValue() {
        DefaultListModel model = (DefaultListModel)this.sentenceJList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String value = (String)model.elementAt(i);
            if (value == null || value.contains("--")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset(TutorController controller) {
        if (this.sizeOfSentenceJList > 0) {
            ((DefaultListModel)this.sentenceJList.getModel()).removeAllElements();
            this.sizeOfSentenceJList = 0;
            this.sentenceJListColors = new Vector();
        }
        this.locked = false;
    }

    @Override
    public boolean getLock(String selection) {
        return this.locked;
    }

    @Override
    public void setBackground(Color c) {
        if (this.sentenceJList != null) {
            this.sentenceJList.setBackground(c);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fireItemStateChanged(e);
    }

    protected void fireItemStateChanged(ItemEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ItemListener.class) continue;
            ((ItemListener)listeners[i + 1]).itemStateChanged(e);
        }
    }

    public void addItemListener(ItemListener aListener) {
        this.listenerList.add(ItemListener.class, aListener);
    }

    public void removeItemListener(ItemListener aListener) {
        this.listenerList.remove(ItemListener.class, aListener);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "Enter ModifyListsListener mousePressed");
        }
        if (e.isControlDown() && this.getController().isDefiningStartState()) {
            JComponent eventSource = (JComponent)e.getSource();
            int selectedComboBoxIndex = 0;
            for (int i = 0; i < this.comboBoxesNumber; ++i) {
                if (eventSource.getName().equals("Button" + i)) {
                    selectedComboBoxIndex = i;
                }
                if (!eventSource.getName().equals("ComboBox" + i)) continue;
                selectedComboBoxIndex = i;
            }
            JComboBox comboBox = this.composeJComboBox[selectedComboBoxIndex];
            JFrame frame = new JFrame("Modify List Items");
            String[] items = new String[comboBox.getItemCount()];
            for (int i = 0; i < comboBox.getItemCount(); ++i) {
                items[i] = (String)comboBox.getItemAt(i);
            }
            String title = "Please set the Values for widget " + this.commName + " : ";
            EditListItemDialog t = new EditListItemDialog(frame, title, true, items, this.isInvisible());
            this.composeJComboBox[selectedComboBoxIndex].removeAllItems();
            this.values[selectedComboBoxIndex] = "";
            String tempItem = "";
            String tempValues = "";
            for (int i = 0; i < t.getList().getModel().getSize(); ++i) {
                tempItem = (String)t.getList().getModel().getElementAt(i);
                if (!(tempItem = tempItem.trim()).equals("")) {
                    tempValues = this.values.equals("") ? tempItem : tempValues + "," + tempItem;
                }
                comboBox.addItem(tempItem);
            }
            this.dirty = true;
            this.setValues(tempValues, selectedComboBoxIndex);
            this.sendValue();
            comboBox.setEditable(false);
            if (this.isInvisible() != t.isInvisible()) {
                this.setInvisible(t.isInvisible());
                this.setVisible(!this.isInvisible());
                this.dirty = true;
                this.setActionName("UpdateInVisible");
                this.sendValue();
            }
            this.setActionName("UpdateComposer");
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (trace.getDebugCode("dw")) {
            trace.out("dw", "Enter ModifyListsListener mouseClicked");
        }
        boolean editable = false;
        if (this.getController().isDefiningStartState()) {
            editable = true;
        }
        for (int i = 0; i < this.comboBoxesNumber; ++i) {
            this.composeJComboBox[i].setEditable(editable);
            this.composeJComboBox[i].addActionListener(this);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String valueString = value.toString();
            this.setText(valueString);
            if (JCommComposer.this.allowDeletes) {
                this.setBackground(isSelected ? Color.lightGray : Color.white);
            }
            for (int i = 0; i < JCommComposer.this.sizeOfSentenceJList; ++i) {
                String tempItem;
                if (!JCommComposer.this.allowDeletes) {
                    if (valueString.equals(JCommComposer.this.newValue)) {
                        this.setBackground(Color.lightGray);
                    } else {
                        this.setBackground(Color.white);
                    }
                }
                if (!(tempItem = (String)((DefaultListModel)JCommComposer.this.sentenceJList.getModel()).elementAt(i)).equals(valueString)) continue;
                Color cellColor = (Color)JCommComposer.this.sentenceJListColors.elementAt(i);
                if (cellColor == JCommComposer.this.startColor) {
                    this.setFont(JCommComposer.this.startFont);
                } else if (cellColor == JCommComposer.this.correctColor) {
                    if (JCommComposer.this.correctFont != null) {
                        this.setFont(JCommComposer.this.correctFont);
                    } else {
                        this.setFont(JCommComposer.this.startFont);
                    }
                } else if (JCommComposer.this.correctFont != null) {
                    this.setFont(JCommComposer.this.incorrectFont);
                } else {
                    this.setFont(JCommComposer.this.startFont);
                }
                this.setForeground(cellColor);
                break;
            }
            return this;
        }
    }

    class MyComboBoxRenderer
    extends BasicComboBoxRenderer {
        MyComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    list.setToolTipText(value == null ? "" : value.toString());
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

