/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.hcii.ctat.CTATHTTPServer;
import edu.cmu.pact.Utilities.trace;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class CTATHTTPSServer
extends CTATHTTPServer {
    public static final String defaultKeystore = "lib" + File.separator + "localhost.jks";
    private String keystore = defaultKeystore;
    private SSLServerSocket serverSocket = null;

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        if (keystore != null && keystore.trim().length() > 0) {
            this.keystore = keystore;
        }
    }

    public CTATHTTPSServer(int port, String pathToRoot, String logFileName, CTATHTTPHandlerInterface aHandler) {
        super(port, pathToRoot, logFileName, aHandler);
        if (trace.getDebugCode("http")) {
            trace.out("http", String.format("CTATHTTPSServer.<init>(%d, %s, %s, %s)", port, pathToRoot, logFileName, trace.nh(aHandler)));
        }
    }

    @Override
    public void run() {
        if (trace.getDebugCode("http")) {
            trace.out("http", "CTATHTTPSServer.run() socket " + this.socket);
        }
        if (this.socket == null) {
            char[] ksPass = "pact123".toCharArray();
            char[] ctPass = "pact123".toCharArray();
            Thread.currentThread().setName("HTTPServer_" + ++threadCount);
            try {
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(new FileInputStream(this.keystore), ksPass);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, ctPass);
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(kmf.getKeyManagers(), null, null);
                SSLServerSocketFactory ssf = sc.getServerSocketFactory();
                this.serverSocket = (SSLServerSocket)ssf.createServerSocket(this.port);
                if (trace.getDebugCode("http")) {
                    trace.out("http", "CTATHTTPSServer.run() serverSocket " + this.serverSocket);
                    CTATHTTPSServer.printServerSocketInfo(this.serverSocket);
                }
                while (!this.nowExiting) {
                    if (trace.getDebugCode("http")) {
                        trace.out("http", "CTATHTTPSServer.run() top of loop: to block on accept(); serverSocket " + this.serverSocket);
                    }
                    this.socket = this.serverSocket.accept();
                    if (trace.getDebugCode("http")) {
                        trace.out("http", "CTATHTTPSServer.run() top of loop: accept() returns socket " + this.socket);
                    }
                    if (this.socket == null) continue;
                    new Thread(new CTATHTTPServer(this.socket, this.getHandler())).start();
                }
            }
            catch (Exception uhe) {
                trace.err("Failed to open HTTPSserver on localhost port " + this.port + ", error " + uhe + "; cause " + uhe.getCause());
                uhe.printStackTrace(System.out);
            }
            this.debug("run(): nowExiting " + this.nowExiting + ", shutdownTime " + this.shutdownTime);
        } else {
            super.run();
        }
    }

    private static void printServerSocketInfo(SSLServerSocket s) {
        System.out.println("Server socket class: " + s.getClass());
        System.out.println("   Socker address = " + s.getInetAddress().toString());
        System.out.println("   Socker port = " + s.getLocalPort());
        System.out.println("   Need client authentication = " + s.getNeedClientAuth());
        System.out.println("   Want client authentication = " + s.getWantClientAuth());
        System.out.println("   Use client mode = " + s.getUseClientMode());
    }
}

