/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATTutorUpdater;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.tiling.scheduling.Scheduler;
import org.tiling.scheduling.SchedulerTask;
import org.tiling.scheduling.examples.iterators.DailyIterator;

public class CTATScheduler
extends CTATBase {
    private final Scheduler scheduler = new Scheduler();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss.SSS");
    private final int hourOfDay;
    private final int minute;
    private final int second;
    private CTATTutorUpdater updater = null;

    public CTATScheduler(CTATTutorUpdater anUpdater, int hourOfDay, int minute, int second) {
        this.setClassName("CTATScheduler");
        this.debug("CTATScheduler ()");
        this.hourOfDay = hourOfDay;
        this.minute = minute;
        this.second = second;
        this.updater = anUpdater;
    }

    public boolean runUpdate() {
        this.debug("update ()");
        if (this.updater != null) {
            return this.updater.runUpdate();
        }
        return false;
    }

    public void start() {
        this.scheduler.schedule(new SchedulerTask(){

            @Override
            public void run() {
                this.soundAlarm();
            }

            private void soundAlarm() {
                System.out.println("Starting update cycle, on: " + CTATScheduler.this.dateFormat.format(new Date()));
                CTATScheduler.this.runUpdate();
            }
        }, new DailyIterator(this.hourOfDay, this.minute, this.second));
    }
}

