/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class CTATWebTools
extends CTATBase {
    public static final DateFormat headerDateFmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    private ArrayList<String> entries = null;

    public CTATWebTools() {
        this.setClassName("CTATWebTools");
        this.debug("CTATWebTools ()");
        this.setEntries(new ArrayList<String>());
    }

    public Map<String, String> parseQuery(String aQuery) {
        this.debug("parseQuery (" + aQuery + ")");
        String cleaned = "";
        try {
            cleaned = URLDecoder.decode(aQuery, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        this.debug("Cleaned: " + cleaned);
        return this.getQueryMap(cleaned);
    }

    public Map<String, String> getQueryMap(String query) {
        this.debug("getQueryMap ()");
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String value;
            String name;
            int index = param.indexOf("=");
            if (index >= 0) {
                name = param.substring(0, index);
                value = param.substring(index + 1);
            } else {
                name = param;
                value = "";
            }
            map.put(name, value);
        }
        this.debug("getQueryMap () map: " + map);
        return map;
    }

    public void showURI(URI aURI) {
        this.debug("showURI ()");
        this.debug("URI (host):" + aURI.getHost());
        this.debug("URI (port):" + aURI.getPort());
        this.debug("URI (fragment):" + aURI.getFragment());
        this.debug("URI (path):" + aURI.getPath());
        this.debug("URI (query):" + aURI.getRawQuery());
        this.debug("URI (scheme):" + aURI.getScheme());
    }

    public void setEntries(ArrayList<String> entries) {
        this.entries = entries;
    }

    public ArrayList<String> getEntries() {
        return this.entries;
    }

    static {
        headerDateFmt.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

