/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.collections.StoredSortedMap;
import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.monitor.CTATBerkeleyDB;
import edu.cmu.hcii.ctat.monitor.CTATBerkeleyDBInstance;
import edu.cmu.hcii.ctat.monitor.CTATTSMemory;
import edu.cmu.hcii.ctat.monitor.CTATTSSession;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;

public class CTATBerkeleyDBDataGenerator
extends CTATBase {
    private CTATBerkeleyDB driver = null;
    private Long nrEntries = 100000L;
    private Long nrDatabases = 3L;
    private Long nrTimeDelta = 300000L;
    private String startDate = "Undefined";
    private CTATBerkeleyDBInstance sessionDB = null;
    private CTATBerkeleyDBInstance memoryDB = null;
    private CTATBerkeleyDBInstance dailySessionDB = null;
    private CTATBerkeleyDBInstance hourlySessionDB = null;
    private CTATBerkeleyDBInstance weeklySessionDB = null;
    private CTATBerkeleyDBInstance monthlySessionDB = null;
    private CTATBerkeleyDBInstance hourlyMemoryDB = null;
    private CTATBerkeleyDBInstance dailyMemoryDB = null;
    private CTATBerkeleyDBInstance weeklyMemoryDB = null;
    private CTATBerkeleyDBInstance monthlyMemoryDB = null;
    private StoredSortedMap<Long, CTATTSSession> sessionMap = null;
    private StoredSortedMap<Long, CTATTSMemory> memoryMap = null;
    private StoredSortedMap<Long, CTATTSSession> hourlySessionMap = null;
    private StoredSortedMap<Long, CTATTSSession> dailySessionMap = null;
    private StoredSortedMap<Long, CTATTSSession> weeklySessionMap = null;
    private StoredSortedMap<Long, CTATTSSession> monthlySessionMap = null;
    private StoredSortedMap<Long, CTATTSMemory> hourlyMemoryMap = null;
    private StoredSortedMap<Long, CTATTSMemory> dailyMemoryMap = null;
    private StoredSortedMap<Long, CTATTSMemory> weeklyMemoryMap = null;
    private StoredSortedMap<Long, CTATTSMemory> monthlyMemoryMap = null;
    Long hourStart = 0L;
    Long hourEnd = 0L;
    Long dayStart = 0L;
    Long dayEnd = 0L;
    Long weekStart = 0L;
    Long weekEnd = 0L;
    Long monthStart = 0L;
    Long monthEnd = 0L;

    public CTATBerkeleyDBDataGenerator() {
        this.setClassName("CTATBerkeleyDBDataGenerator");
        this.debug("CTATBerkeleyDBDataGenerator ()");
        this.driver = new CTATBerkeleyDB();
        this.driver.startDBService();
    }

    public void execute() {
        this.debug("execute (entries: " + this.nrEntries + ", databases: " + this.nrDatabases + ", delta: " + this.nrTimeDelta + ")");
        int i = 0;
        while ((long)i < this.nrDatabases) {
            LongBinding keyBinding;
            try {
                UUID seessionUUID = UUID.randomUUID();
                this.sessionDB = this.driver.accessDB(seessionUUID + "-TSSession/All");
                this.hourlySessionDB = this.driver.accessDB(seessionUUID + "-TSSession/Hour");
                this.dailySessionDB = this.driver.accessDB(seessionUUID + "-TSSession/Day");
                this.weeklySessionDB = this.driver.accessDB(seessionUUID + "-TSSession/Week");
                this.monthlySessionDB = this.driver.accessDB(seessionUUID + "-TSSession/Month");
            }
            catch (Exception e) {
                this.debug("Error: unable to access or create db: " + UUID.randomUUID() + "-TSSession");
                e.printStackTrace();
            }
            if (this.sessionDB != null) {
                keyBinding = new LongBinding();
                SerialBinding sessionBinding = new SerialBinding((ClassCatalog)this.driver.getClassCatalog(), CTATTSSession.class);
                this.sessionMap = new StoredSortedMap(this.sessionDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)sessionBinding, true);
                this.hourlySessionMap = new StoredSortedMap(this.hourlySessionDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)sessionBinding, true);
                this.dailySessionMap = new StoredSortedMap(this.dailySessionDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)sessionBinding, true);
                this.weeklySessionMap = new StoredSortedMap(this.weeklySessionDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)sessionBinding, true);
                this.monthlySessionMap = new StoredSortedMap(this.monthlySessionDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)sessionBinding, true);
            }
            try {
                UUID memoryUUID = UUID.randomUUID();
                this.memoryDB = this.driver.accessDB(memoryUUID + "-TSMemory/All");
                this.hourlyMemoryDB = this.driver.accessDB(memoryUUID + "-TSMemory/Hour");
                this.dailyMemoryDB = this.driver.accessDB(memoryUUID + "-TSMemory/Day");
                this.weeklyMemoryDB = this.driver.accessDB(memoryUUID + "-TSMemory/Week");
                this.monthlyMemoryDB = this.driver.accessDB(memoryUUID + "-TSMemory/Month");
            }
            catch (Exception e) {
                this.debug("Error: unable to access or create db: " + UUID.randomUUID() + "-TSMemory");
                e.printStackTrace();
            }
            if (this.memoryDB != null) {
                keyBinding = new LongBinding();
                SerialBinding memoryBinding = new SerialBinding((ClassCatalog)this.driver.getClassCatalog(), CTATTSMemory.class);
                this.memoryMap = new StoredSortedMap(this.memoryDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)memoryBinding, true);
                this.hourlyMemoryMap = new StoredSortedMap(this.hourlyMemoryDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)memoryBinding, true);
                this.dailyMemoryMap = new StoredSortedMap(this.dailyMemoryDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)memoryBinding, true);
                this.weeklyMemoryMap = new StoredSortedMap(this.weeklyMemoryDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)memoryBinding, true);
                this.monthlyMemoryMap = new StoredSortedMap(this.monthlyMemoryDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)memoryBinding, true);
            }
            DateTime currentTime = new DateTime();
            Long converter = currentTime.getMillis();
            this.debug("converter is " + currentTime);
            int year = currentTime.getYear();
            int month = currentTime.getMonthOfYear();
            int day = currentTime.getDayOfMonth();
            int hour = currentTime.getHourOfDay();
            DateTime hourTime = new DateTime(year, month, day, hour, 0, 0);
            this.debug("hourStart is:" + hourTime);
            this.hourStart = hourTime.toInstant().getMillis();
            this.debug("hourStart is " + this.hourStart);
            this.hourEnd = hourTime.plusHours(1).getMillis();
            this.debug("hourEnd is: " + this.hourEnd);
            this.debug("hourStart is:" + this.hourStart);
            this.debug("the difference is: " + (this.hourStart - this.hourEnd));
            DateTime dayTime = new DateTime(year, month, day, 0, 0, 0);
            this.dayStart = dayTime.getMillis();
            this.dayEnd = dayTime.plusDays(1).getMillis();
            DateTime weekTime = new DateTime(year, month, day, 0, 0, 0);
            this.weekStart = weekTime.getMillis();
            this.weekEnd = weekTime.plusWeeks(1).getMillis();
            DateTime monthTime = new DateTime(year, month, 1, 0, 0, 0);
            this.monthStart = monthTime.getMillis();
            this.monthEnd = monthTime.plusMonths(1).getMillis();
            int seconds = (int)(this.nrTimeDelta / 1000L);
            this.debug("Simulating " + this.nrEntries + " with a time delta of " + seconds + " seconds, spanning a total of " + this.nrEntries * (long)seconds + " seconds, or " + this.nrEntries * (long)seconds / 60L + " minutes, or " + this.nrEntries * (long)seconds / 3600L + " hours , or " + this.nrEntries * (long)seconds / 86400L + " days");
            this.debug("Adding entries, this might take a while ...");
            this.debug("converter is:" + converter);
            this.generate(converter);
            this.debug("Checking integrity ...");
            this.sessionDB.close();
            this.memoryDB.close();
            this.debug("Add done");
            ++i;
        }
        try {
            this.driver.close();
        }
        catch (Exception e) {
            this.debug("Error closing databases");
            e.printStackTrace();
        }
    }

    private void generateData(Long converter, StoredSortedMap<Long, CTATTSSession> dataSessionMap, StoredSortedMap<Long, CTATTSMemory> dataMemoryMap, Long msper) {
        Long counter = 0L;
        Long total = 0L;
        Long totalentries = this.nrEntries * this.nrTimeDelta / msper;
        this.debug("now creating " + totalentries + " entries");
        Long j = 0L;
        while (j < totalentries) {
            CTATTSSession sessionProbe = new CTATTSSession();
            dataSessionMap.put((Object)converter, (Object)sessionProbe);
            CTATTSMemory memoryProbe = new CTATTSMemory();
            dataMemoryMap.put((Object)converter, (Object)memoryProbe);
            converter = converter + msper;
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
            if (counter > 100L) {
                counter = 0L;
                total = total + 100L;
                this.debug("Generated " + total + " entries out of " + totalentries);
            }
            Long l3 = j;
            Long l4 = j = Long.valueOf(j + 1L);
        }
    }

    private void usage() {
        System.out.println("Usage: ");
        System.out.println(" java -cp \".;..;lib\\je-5.0.34.jar;TutorMonitor.jar;..\\java\\lib\\ctat.jar\\\" CTATBerkeleyDBDataGenerator <options>");
        System.out.println("");
        System.out.println("Example:");
        System.out.println(" java -cp \".;..;lib\\je-5.0.34.jar;TutorMonitor.jar;..\\java\\lib\\ctat.jar\\\" CTATBerkeleyDBDataGenerator -entries 100000 -databases 3 -delta 5");
        System.out.println("");
        System.out.println("Options:");
        System.out.println(" -entries <value>");
        System.out.println(" -databases <value>");
        System.out.println(" -delta <value>");
        System.out.println(" -startdate <value> (Please enter a date in the format: MM dd yyyy)");
    }

    public void parseArgs(String[] args) {
        this.debug("parseArgs ()");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-help")) {
                this.usage();
                System.exit(0);
            }
            if (args[i].equals("-entries")) {
                this.nrEntries = Long.parseLong(args[i + 1]);
            }
            if (args[i].equals("-databases")) {
                this.nrDatabases = Long.parseLong(args[i + 1]);
            }
            if (args[i].equals("-delta")) {
                this.nrTimeDelta = Long.parseLong(args[i + 1]);
            }
            if (!args[i].equals("-startdate")) continue;
            this.startDate = args[i + 1];
        }
    }

    private void generate(Long startTime) {
        int i = 0;
        while ((long)i < this.nrEntries) {
            CTATTSSession sessionProbe = new CTATTSSession();
            this.sessionMap.put((Object)startTime, (Object)sessionProbe);
            CTATTSMemory memoryProbe = new CTATTSMemory();
            this.memoryMap.put((Object)startTime, (Object)memoryProbe);
            this.debug("Start Time is: " + startTime);
            if (startTime >= this.hourEnd) {
                this.debug("the difference is: " + (this.hourStart - this.hourEnd));
                this.hourlyMemoryMap.put((Object)this.hourStart, (Object)this.avgMemoryMap(this.memoryMap.subMap((Object)this.hourStart, (Object)this.hourEnd)));
                this.hourlySessionMap.put((Object)this.hourStart, (Object)this.avgSessionMap(this.sessionMap.subMap((Object)this.hourStart, (Object)this.hourEnd)));
                this.hourStart = this.hourEnd;
                DateTime dtHourEnd = new DateTime((Object)this.hourEnd);
                this.hourEnd = dtHourEnd.plusHours(1).toInstant().getMillis();
            }
            if (startTime >= this.dayEnd) {
                this.dailyMemoryMap.put((Object)this.dayStart, (Object)this.avgMemoryMap(this.hourlyMemoryMap.subMap((Object)this.dayStart, (Object)this.dayEnd)));
                this.dailySessionMap.put((Object)this.dayStart, (Object)this.avgSessionMap(this.hourlySessionMap.subMap((Object)this.dayStart, (Object)this.dayEnd)));
                this.hourlyMemoryMap.put((Object)this.hourStart, (Object)this.avgMemoryMap(this.memoryMap.subMap((Object)this.hourStart, (Object)this.hourEnd)));
                this.dayStart = this.dayEnd;
                DateTime dtDayEnd = new DateTime((Object)this.dayEnd);
                this.dayEnd = dtDayEnd.plusDays(1).toInstant().getMillis();
            }
            if (startTime >= this.weekEnd) {
                this.weeklyMemoryMap.put((Object)this.weekStart, (Object)this.avgMemoryMap(this.weeklyMemoryMap.subMap((Object)this.weekStart, (Object)this.weekEnd)));
                this.weeklySessionMap.put((Object)this.weekStart, (Object)this.avgSessionMap(this.weeklySessionMap.subMap((Object)this.weekStart, (Object)this.weekEnd)));
                this.weekStart = this.weekEnd;
                DateTime dtWeekEnd = new DateTime((Object)this.weekEnd);
                this.weekEnd = dtWeekEnd.plusWeeks(1).toInstant().getMillis();
            }
            if (startTime >= this.monthEnd) {
                this.monthlyMemoryMap.put((Object)this.monthStart, (Object)this.avgMemoryMap(this.monthlyMemoryMap.subMap((Object)this.monthStart, (Object)this.monthEnd)));
                this.monthlySessionMap.put((Object)this.monthStart, (Object)this.avgSessionMap(this.monthlySessionMap.subMap((Object)this.monthStart, (Object)this.monthEnd)));
                this.monthStart = this.monthEnd;
                DateTime dtMonthEnd = new DateTime((Object)this.monthEnd);
                this.dayEnd = dtMonthEnd.plusMonths(1).toInstant().getMillis();
            }
            startTime = startTime + this.nrTimeDelta;
            ++i;
        }
    }

    private CTATTSMemory avgMemoryMap(Map<Long, CTATTSMemory> aMap) {
        this.debug("avgMemoryMap (" + aMap.entrySet().size() + ")");
        Iterator<Map.Entry<Long, CTATTSMemory>> iter = aMap.entrySet().iterator();
        Long counter = 0L;
        Long memUsed = 0L;
        Long memMax = 0L;
        Long memTotal = 0L;
        this.debug("Transforming data ...");
        while (iter.hasNext()) {
            Map.Entry<Long, CTATTSMemory> entry = iter.next();
            if (entry != null) {
                memUsed = memUsed + entry.getValue().getMemUsed();
                memMax = memMax + entry.getValue().getMemMax();
                memTotal = memTotal + entry.getValue().getMemTotal();
            } else {
                this.debug("Error, unable to get memory entry from map");
            }
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
        }
        this.debug("memoryMapToTable () Done");
        CTATTSMemory thisMemory = new CTATTSMemory();
        if (counter > 0L) {
            thisMemory.setMemUsed(memUsed / counter);
            thisMemory.setMemMax(memMax / counter);
            thisMemory.setMemTotal(memTotal / counter);
        }
        return thisMemory;
    }

    private CTATTSSession avgSessionMap(Map<Long, CTATTSSession> aMap) {
        this.debug("avgMemoryMap (" + aMap.entrySet().size() + ")");
        Iterator<Map.Entry<Long, CTATTSSession>> iter = aMap.entrySet().iterator();
        Long counter = 0L;
        Long totalTransactionMs = 0L;
        Long transactionCount = 0L;
        Long firstTransactionTime = 0L;
        Long longestTransactionMs = 0L;
        Long longestTransactionStartTime = 0L;
        Long diskLogEntries = 0L;
        Long forwardLogEntries = 0L;
        Long diskLogErrors = 0L;
        Long forwardLogErrors = 0L;
        this.debug("Transforming data ...");
        while (iter.hasNext()) {
            Map.Entry<Long, CTATTSSession> entry = iter.next();
            if (entry != null) {
                totalTransactionMs = totalTransactionMs + entry.getValue().getTotalTransactionMs();
                transactionCount = transactionCount + entry.getValue().getTransactionCount();
                firstTransactionTime = firstTransactionTime + entry.getValue().getFirstTransactionTime();
                longestTransactionMs = longestTransactionMs + entry.getValue().getLongestTransactionMs();
                longestTransactionStartTime = longestTransactionStartTime + entry.getValue().getLongestTransactionStartTime();
                diskLogEntries = diskLogEntries + entry.getValue().getDiskLogEntries();
                forwardLogEntries = forwardLogEntries + entry.getValue().getForwardLogEntries();
                diskLogErrors = diskLogErrors + entry.getValue().getDiskLogErrors();
                forwardLogErrors = forwardLogErrors + entry.getValue().getForwardLogErrors();
            } else {
                this.debug("Error, unable to get memory entry from map");
            }
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
        }
        this.debug("memoryMapToTable () Done");
        CTATTSSession thisSession = new CTATTSSession();
        thisSession.setActive(true);
        thisSession.setTotalTransactionMs(totalTransactionMs);
        thisSession.setTransactionCount(transactionCount);
        thisSession.setFirstTransactionTime(firstTransactionTime);
        thisSession.setLongestTransactionMs(longestTransactionMs);
        thisSession.setLongestTransactionStartTime(longestTransactionStartTime);
        return thisSession;
    }

    public static void main(String[] args) {
        CTATLink link = new CTATLink(new CTATDesktopFileManager());
        CTATLink.printDebugMessages = true;
        CTATBerkeleyDBDataGenerator runner = new CTATBerkeleyDBDataGenerator();
        runner.parseArgs(args);
        runner.execute();
    }
}

