/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.hcii.ctat.CTATLink;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CTATHTTPUploadHandler
extends CTATBase
implements CTATHTTPHandlerInterface {
    private String uploadPath = ".";

    public String getUploadPath() {
        return this.uploadPath;
    }

    public void setUploadPath(String uploadPath) {
        this.uploadPath = uploadPath;
    }

    @Override
    public boolean handle(CTATHTTPExchange arg0, String requestBody) {
        this.debug("handle ()");
        String requestMethod = arg0.getRequestMethod();
        this.debug("Request method: " + requestMethod + ", Request URI: " + arg0.getRequestURI());
        String fileURI = arg0.getRequestURI().toString();
        if (requestMethod.equalsIgnoreCase("post")) {
            this.debug("Processing POST ...");
            InputStream din = arg0.getRequestBody();
            if (din == null) {
                this.debug("Error POST input stream is null");
                return false;
            }
            try {
                if (din.available() <= 0) {
                    this.debug("Error: no data available on input stream, aborting ...");
                    return false;
                }
                this.debug("We've got data [" + din.available() + "] available, reading ...");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                int len;
                File f = new File(this.getUploadPath() + "/ctat.jar");
                FileOutputStream out = new FileOutputStream(f);
                byte[] buf = new byte[1024];
                while ((len = din.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                din.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.debug("Creating MD5 checksum from: " + this.getUploadPath() + "/ctat.jar");
            CTATDesktopFileManager fManager = new CTATDesktopFileManager();
            if (!fManager.doesFileExist(this.getUploadPath() + "/ctat.jar")) {
                CTATBase.debug("CTATDesktopFileManager", "Error: input file does not exist: " + this.getUploadPath() + "/ctat.jar");
                return false;
            }
            fManager.saveFileChecksum(this.getUploadPath() + "/ctat.jar", this.getUploadPath() + "/ctat.jar.crc", false);
        }
        if (requestMethod.equalsIgnoreCase("get")) {
            this.debug("Processing GET request ...");
            if (fileURI.equalsIgnoreCase("/crossdomain.xml")) {
                this.debug("Processing crossdomain request ...");
                this.debug("Writing back the crossdomain policy...");
                try {
                    arg0.addResponseHeader("Content-Type", "application/xml");
                    arg0.sendResponseHeaders(200, CTATLink.crossDomainPolicy.getBytes().length);
                    arg0.writeBytesString(CTATLink.crossDomainPolicy, false);
                    this.debug("Wrote back Crossdomain.xml..");
                    arg0.close();
                }
                catch (Exception e) {
                    this.debug("Exception in trying to write back crossdomain.xml");
                }
            }
        }
        return true;
    }

    @Override
    public boolean getOutputJSON() {
        return false;
    }
}

