/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATLink;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class CTATNetworkTools
extends CTATBase {
    public CTATNetworkTools() {
        this.setClassName("CTATNetworkTools");
    }

    public void showAddresses() {
        this.debug("showAddresses ()");
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            this.debug("Obtaining network interfaces ...");
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        InetAddress ip = null;
        this.debug("Finding proper host info in network interfaces ...");
        Boolean found = false;
        while (netInterfaces.hasMoreElements() && !found.booleanValue()) {
            NetworkInterface ni = netInterfaces.nextElement();
            try {
                if (ni.isVirtual() || !ni.isUp()) continue;
                this.debug("Examining interface: " + ni.getName());
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements() && !found.booleanValue()) {
                    ip = ips.nextElement();
                    this.debug("isSiteLocalAddress: " + ip.isSiteLocalAddress() + ", isLoopbackAddress: " + ip.isLoopbackAddress() + "," + ip.getHostAddress());
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
    }

    public String getHostname() {
        this.debug("getHostname ()");
        if (!CTATLink.hostName.equals("localhost")) {
            this.debug("Hostname already configured");
            return CTATLink.hostName;
        }
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            this.debug("Obtaining network interfaces ...");
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        InetAddress ip = null;
        this.debug("Finding proper host info in network interfaces ...");
        Boolean found = false;
        while (netInterfaces.hasMoreElements() && !found.booleanValue()) {
            NetworkInterface ni = netInterfaces.nextElement();
            try {
                if (ni.isVirtual() || !ni.isUp()) continue;
                this.debug("Examining interface: " + ni.getName());
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements() && !found.booleanValue()) {
                    ip = ips.nextElement();
                    this.debug(ip.isSiteLocalAddress() + "," + ip.isLoopbackAddress() + "," + ip.getHostAddress());
                    if (ip.isLinkLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    if (ip.isSiteLocalAddress()) {
                        if (ip.getHostAddress().equals("127.0.0.1")) continue;
                        this.debug("Interface " + ni.getName() + " seems to be the proper InternetInterface. I'll take it...");
                        found = true;
                        continue;
                    }
                    this.debug("Interface " + ni.getName() + " seems to be the proper InternetInterface. I'll take it...");
                    found = true;
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
        if (ip != null && (CTATLink.hostName.equals("localhost") || CTATLink.hostName.equals("localhost.localdomain") || CTATLink.hostName.equals("127.0.0.1"))) {
            this.debug("Detected that the hostname is a local or loopback address, reverting to canonical name ...");
            if (ip.getCanonicalHostName().equals("localhost") || ip.getCanonicalHostName().equals("localhost.localdomain") || ip.getCanonicalHostName().equals("127.0.0.1")) {
                this.debug("Detected that the canonical name is a local or loopback address, reverting to ip address ...");
                CTATLink.hostName = ip.getHostAddress();
            } else {
                CTATLink.hostName = ip.getCanonicalHostName();
            }
            this.debug("hostname: " + CTATLink.hostName);
        }
        return CTATLink.hostName;
    }
}

