/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.monitor.CTATSocketServerBase;
import edu.cmu.hcii.ctat.monitor.CTATStreamedSocket;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketAddress;

public class CTATTutorMonitorServerThread
extends Thread {
    private CTATSocketServerBase server = null;
    private CTATStreamedSocket helper = null;
    private Socket socket = null;
    private int ID = -1;
    private DataInputStream streamIn = null;
    private PrintWriter outWriter = null;
    private Boolean threadStopped = false;
    private String ip = "127.0.0.1";
    private Long msgCount = 0L;

    public CTATTutorMonitorServerThread(CTATSocketServerBase _server, Socket _socket) {
        this.debug("CTATTutorMonitorServerThread ()");
        this.server = _server;
        this.socket = _socket;
        this.ID = this.socket.getPort();
        SocketAddress addr = this.socket.getRemoteSocketAddress();
        this.ip = addr.toString().replaceAll("/", "");
        this.helper = new CTATStreamedSocket();
    }

    private void debug(String aMessage) {
        CTATBase.debug("CTATTutorMonitorServerThread", aMessage);
    }

    public String getIp() {
        return this.ip;
    }

    public void send(String msg) {
        this.debug("send () >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> ");
        this.debug(msg);
        if (this.outWriter == null) {
            this.debug("Error: no open output stream available");
            return;
        }
        this.outWriter.print(msg);
        if (this.outWriter.checkError()) {
            this.debug("Error printing message to socket");
            return;
        }
        this.outWriter.write(0);
        if (this.outWriter.checkError()) {
            this.debug("Error writing message to socket");
            return;
        }
        this.outWriter.flush();
        if (this.outWriter.checkError()) {
            this.debug("Error flushing socket");
            return;
        }
    }

    public void stopThread() {
        this.debug("stopThread ()");
        this.threadStopped = true;
    }

    public int getID() {
        return this.ID;
    }

    @Override
    public void run() {
        this.debug("Server Thread " + this.ID + " running.");
        while (!this.threadStopped.booleanValue()) {
            try {
                String data = this.helper.readToEom(this.streamIn, 0);
                if (data == null) {
                    this.debug("Null data received from readToEom, closing socket");
                    this.stopThread();
                    this.server.remove(this.ID);
                    continue;
                }
                Long l = this.msgCount;
                Long l2 = this.msgCount = Long.valueOf(this.msgCount + 1L);
                this.debug("Received " + this.msgCount + " for this thread so far");
                this.server.handle(this.ID, data);
            }
            catch (IOException ioe) {
                this.debug(this.ID + " ERROR reading: " + ioe.getMessage());
                this.stopThread();
                this.server.remove(this.ID);
            }
        }
    }

    public void open() throws IOException {
        this.debug("open ()");
        this.streamIn = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.outWriter = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
    }

    public void close() throws IOException {
        this.debug("close ()");
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.streamIn != null) {
            this.streamIn.close();
        }
        if (this.outWriter != null) {
            this.outWriter.close();
        }
    }
}

