/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.wizard;

import edu.cmu.hcii.ctat.CTATFileFilter;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.widgets.CTATIconJList;
import edu.cmu.hcii.ctat.wizard.CTATLMSPackageWizardBase;
import edu.cmu.hcii.ctat.wizard.CTATOLIPackageGenerator;
import edu.cmu.hcii.ctat.wizard.CTATPackageGeneratorBase;
import edu.cmu.hcii.ctat.wizard.CTATSCORMFlashPackageGenerator;
import edu.cmu.hcii.ctat.wizard.CTATSCORMHTML5PackageGenerator;
import edu.cmu.hcii.ctat.wizard.CTATWizardFinishPage;
import edu.cmu.hcii.ctat.wizard.CTATWizardPanelDescription;
import edu.cmu.hcii.ctat.wizard.CTATXBlockPackageGenerator;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.Dialogs.SaveFileDialog;
import edu.cmu.pact.Utilities.trace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class CTATLMSPackageWizard
extends CTATLMSPackageWizardBase
implements ActionListener {
    private static final String TS_HOSTNAME = "tutorshop.web.cmu.edu";
    private int TARGET_SCORM = 0;
    private int TARGET_XBLOCK = 1;
    private int TARGET_OLI = 2;
    private int targetPlatform = this.TARGET_SCORM;
    private JPanel welcomePanel = null;
    private JRadioButton flashButtonSingle = null;
    private JRadioButton html5ButtonSingle = null;
    private JCheckBox logButton = null;
    private JButton aBrowseSWF = null;
    private JButton aBrowseBRD = null;
    private JTextField swfLocation = null;
    private JTextField brdLocation = null;
    private JTextField packageDescription = null;
    private JTextField zipLocation = null;
    private JLabel interfaceLabel = null;
    private JTextField anInput = null;
    private JComboBox<String> engineList = null;
    private JTextField tsHostSingle = null;
    private JTextField tsPortSingle = null;
    private JTextField datashopURLSingle = null;
    private JTextField datasetNameSingle = null;
    private CTATWizardPanelDescription targetPoint = null;
    private JPanel singlePanel = null;
    private JPanel tutorAssetPanel = null;
    private CTATWizardPanelDescription tutorAssetPanelDescription = null;
    private JLabel baseLabel = null;
    private CTATIconJList assetListWidget = null;
    private JPanel targetPlatformPanel = null;
    private CTATWizardPanelDescription targetPlatformPanelDescription = null;
    private BR_Controller controller;
    private static String lastChosenDir = null;

    public CTATLMSPackageWizard(BR_Controller controller) {
        this.setClassName("CTATLMSPackageWizard");
        this.debug("CTATLMSPackageWizard ()");
        this.controller = controller;
    }

    @Override
    public void init() {
        this.debug("init ()");
        this.setTitle("LMS Package Wizard");
        this.welcomePanel = this.createWizardJPanel();
        this.generateWelcomePanel(this.welcomePanel);
        this.addPage("Start", this.welcomePanel);
        this.singlePanel = this.createWizardJPanel();
        this.generateSingleConfigPanel(this.singlePanel);
        this.targetPoint = this.addPage("Configure", this.singlePanel);
        this.tutorAssetPanel = this.createWizardJPanel();
        this.generateTutorAssetPanel(this.tutorAssetPanel);
        this.tutorAssetPanelDescription = this.addPage("Tutor Assets", this.tutorAssetPanel);
        this.targetPlatformPanel = this.createWizardJPanel();
        this.generateTargetPlatformPage(this.targetPlatformPanel);
        this.targetPlatformPanelDescription = this.addPage("Target Platform", this.targetPlatformPanel);
        CTATWizardFinishPage finishPage = new CTATWizardFinishPage();
        this.generateFinishPage(finishPage);
        this.addPage("Generate", finishPage);
    }

    private void selectHTMLTutor(Boolean aValue) {
        this.debug("selectHTMLTutor ()");
        if (aValue.booleanValue()) {
            this.html5ButtonSingle.setSelected(true);
            this.interfaceLabel.setText("Choose an HTML file: ");
            this.outputSWF = false;
        } else {
            this.html5ButtonSingle.setSelected(false);
            this.interfaceLabel.setText("Choose a SWF file: ");
            this.outputSWF = true;
        }
    }

    private void generateWelcomePanel(JPanel aPanel) {
        this.debug("generateWelcomePanel ()");
        JLabel logo = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource("pact/TemplateIcons/CTAT-ToLMSLogo.png")));
        JLabel welcomeMessage = new JLabel();
        welcomeMessage.setText("<html>This wizard will help you generate a package from your existing tutors that <br>can be incorporated into a number of platforms including those supporting <br>SCORM. To use this wizard you will need:<br></html>");
        JLabel explanationMessage = new JLabel();
        explanationMessage.setText("<html><ul><li>One or more html files (if you want to use html tutors)<li>One or more Flash files (if you want to show Flash tutors)<li>One or more BRD files</ul></html>");
        aPanel.add(logo);
        aPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        aPanel.add(new JSeparator(0));
        aPanel.add(welcomeMessage);
        aPanel.add(explanationMessage);
    }

    private void generateSingleConfigPanel(JPanel aPanel) {
        this.debug("generateSingleConfigPanel ()");
        this.flashButtonSingle = new JRadioButton("Flash Tutor");
        this.flashButtonSingle.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.flashButtonSingle.setSelected(true);
        this.flashButtonSingle.setEnabled(false);
        this.flashButtonSingle.setActionCommand("flashButtonSingle");
        this.flashButtonSingle.addActionListener(this);
        this.html5ButtonSingle = new JRadioButton("HTML5 Tutor");
        this.html5ButtonSingle.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.html5ButtonSingle.setActionCommand("html5ButtonSingle");
        this.html5ButtonSingle.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.flashButtonSingle);
        group.add(this.html5ButtonSingle);
        Box radioBox = new Box(0);
        radioBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel radioLabel = new JLabel();
        radioLabel.setText("Tutor Type: ");
        radioLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        radioBox.add(radioLabel);
        radioBox.add(this.flashButtonSingle);
        radioBox.add(this.html5ButtonSingle);
        radioBox.add(Box.createHorizontalGlue());
        aPanel.add(radioBox);
        Box brdButtonBox = new Box(0);
        brdButtonBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel aLabelBRD = new JLabel();
        aLabelBRD.setText("Choose a BRD file: ");
        aLabelBRD.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        brdButtonBox.add(aLabelBRD);
        this.brdLocation = new JTextField();
        this.brdLocation.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.brdLocation.setMinimumSize(new Dimension(50, 20));
        this.brdLocation.setMaximumSize(new Dimension(600, 20));
        this.brdLocation.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CTATLMSPackageWizard.this.LMSConfiguration.setBrdLocationString(CTATLMSPackageWizard.this.brdLocation.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CTATLMSPackageWizard.this.LMSConfiguration.setBrdLocationString(CTATLMSPackageWizard.this.brdLocation.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CTATLMSPackageWizard.this.LMSConfiguration.setBrdLocationString(CTATLMSPackageWizard.this.brdLocation.getText());
            }
        });
        brdButtonBox.add(this.brdLocation);
        this.aBrowseBRD = new JButton();
        this.aBrowseBRD.setText("Browse...");
        this.aBrowseBRD.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.aBrowseBRD.setPreferredSize(new Dimension(85, 20));
        this.aBrowseBRD.setActionCommand("aBrowseBRD");
        this.aBrowseBRD.addActionListener(this);
        brdButtonBox.add(this.aBrowseBRD);
        aPanel.add(brdButtonBox);
        Box swfButtonBox = new Box(0);
        swfButtonBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.interfaceLabel = new JLabel();
        this.interfaceLabel.setText("Choose a SWF file: ");
        this.interfaceLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        swfButtonBox.add(this.interfaceLabel);
        this.swfLocation = new JTextField();
        this.swfLocation.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.swfLocation.setMinimumSize(new Dimension(50, 20));
        this.swfLocation.setMaximumSize(new Dimension(600, 20));
        this.swfLocation.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CTATLMSPackageWizard.this.LMSConfiguration.setSwfLocationString(CTATLMSPackageWizard.this.swfLocation.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CTATLMSPackageWizard.this.LMSConfiguration.setSwfLocationString(CTATLMSPackageWizard.this.swfLocation.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CTATLMSPackageWizard.this.LMSConfiguration.setSwfLocationString(CTATLMSPackageWizard.this.swfLocation.getText());
            }
        });
        swfButtonBox.add(this.swfLocation);
        this.aBrowseSWF = new JButton();
        this.aBrowseSWF.setText("Browse...");
        this.aBrowseSWF.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.aBrowseSWF.setPreferredSize(new Dimension(85, 20));
        this.aBrowseSWF.setActionCommand("aBrowseSWF");
        this.aBrowseSWF.addActionListener(this);
        swfButtonBox.add(this.aBrowseSWF);
        aPanel.add(swfButtonBox);
        Box xBox = this.generateHorizontalBox();
        JLabel xLabel = new JLabel();
        xLabel.setText("Tutor Engine:");
        xLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        String[] engineStrings = new String[]{"Built-in Javascript Tracer", "Server-based Tutoring Service"};
        this.engineList = new JComboBox<String>(engineStrings);
        this.engineList.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.engineList.setSelectedIndex(0);
        this.engineList.addActionListener(this);
        xBox.add(xLabel);
        xBox.add(this.engineList);
        xBox.add(Box.createHorizontalGlue());
        aPanel.add(xBox);
        Box aBox = this.generateHorizontalBox();
        JLabel tLabel = new JLabel();
        tLabel.setText("Tutoring Service Host:");
        tLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.tsHostSingle = new JTextField();
        this.tsHostSingle.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.tsHostSingle.setText(CTATLink.hostName);
        this.tsHostSingle.setEnabled(false);
        aBox.add(tLabel);
        aBox.add(this.tsHostSingle);
        aBox.add(Box.createHorizontalGlue());
        aPanel.add(aBox);
        Box bBox = this.generateHorizontalBox();
        JLabel wLabel = new JLabel();
        wLabel.setText("Tutoring Service Port:");
        wLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.tsPortSingle = new JTextField();
        this.tsPortSingle.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.tsPortSingle.setText(Integer.toString(CTATLink.tsPort));
        this.tsPortSingle.setEnabled(false);
        bBox.add(wLabel);
        bBox.add(this.tsPortSingle);
        bBox.add(Box.createHorizontalGlue());
        aPanel.add(bBox);
        Box eBox = this.generateHorizontalBox();
        this.logButton = new JCheckBox("Use DataShop Logging");
        this.logButton.addActionListener(this);
        eBox.add(this.logButton);
        eBox.add(Box.createHorizontalGlue());
        aPanel.add(eBox);
        Box cBox = this.generateHorizontalBox();
        JLabel yLabel = new JLabel();
        yLabel.setText("DataShop URL:");
        yLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.datashopURLSingle = new JTextField();
        this.datashopURLSingle.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.datashopURLSingle.setText(CTATLink.datashopURL);
        this.datashopURLSingle.setEnabled(false);
        cBox.add(yLabel);
        cBox.add(this.datashopURLSingle);
        cBox.add(Box.createHorizontalGlue());
        aPanel.add(cBox);
        Box dBox = this.generateHorizontalBox();
        JLabel zLabel = new JLabel();
        zLabel.setText("Dataset Name:");
        zLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.datasetNameSingle = new JTextField();
        this.datasetNameSingle.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.datasetNameSingle.setText(CTATLink.datasetName);
        this.datasetNameSingle.setEnabled(false);
        dBox.add(zLabel);
        dBox.add(this.datasetNameSingle);
        dBox.add(Box.createHorizontalGlue());
        aPanel.add(dBox);
        this.selectHTMLTutor(true);
    }

    private void generateTutorAssetPanel(JPanel htmlAssetPanel) {
        this.debug("generateTutorAssetPanel ()");
        Box labelBox = new Box(0);
        labelBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel aLabel = new JLabel();
        aLabel.setText("Please add assets relative to: ");
        aLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        aLabel.setMinimumSize(new Dimension(440, 20));
        aLabel.setMaximumSize(new Dimension(440, 20));
        labelBox.add(aLabel);
        htmlAssetPanel.add(labelBox);
        Box fieldBox = new Box(0);
        fieldBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.baseLabel = new JLabel();
        this.baseLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.baseLabel.setMinimumSize(new Dimension(440, 20));
        this.baseLabel.setMaximumSize(new Dimension(440, 20));
        this.baseLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        fieldBox.add(this.baseLabel);
        htmlAssetPanel.add(fieldBox);
        Box totalBox = new Box(0);
        totalBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.assetListWidget = new CTATIconJList(this.LMSConfiguration.getAssetValues());
        this.assetListWidget.setPreferredSize(new Dimension(280, 200));
        totalBox.add(this.assetListWidget);
        Box buttonBox = new Box(1);
        buttonBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JButton aBrowseFile = new JButton();
        aBrowseFile.setText("Add File ...");
        aBrowseFile.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        aBrowseFile.setPreferredSize(new Dimension(110, 20));
        aBrowseFile.setMinimumSize(new Dimension(110, 20));
        aBrowseFile.setMaximumSize(new Dimension(110, 20));
        aBrowseFile.setActionCommand("aBrowseFile");
        aBrowseFile.addActionListener(this);
        buttonBox.add(aBrowseFile);
        buttonBox.add(Box.createRigidArea(new Dimension(0, 2)));
        JButton aBrowseDirectory = new JButton();
        aBrowseDirectory.setText("Add Directory ...");
        aBrowseDirectory.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        aBrowseDirectory.setPreferredSize(new Dimension(110, 20));
        aBrowseDirectory.setMinimumSize(new Dimension(110, 20));
        aBrowseDirectory.setMaximumSize(new Dimension(110, 20));
        aBrowseDirectory.setActionCommand("aBrowseDirectory");
        aBrowseDirectory.addActionListener(this);
        buttonBox.add(aBrowseDirectory);
        buttonBox.add(Box.createRigidArea(new Dimension(0, 2)));
        JButton aDeleteEntry = new JButton();
        aDeleteEntry.setText("Remove ...");
        aDeleteEntry.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        aDeleteEntry.setSize(100, 20);
        aDeleteEntry.setPreferredSize(new Dimension(110, 20));
        aDeleteEntry.setMinimumSize(new Dimension(110, 20));
        aDeleteEntry.setMaximumSize(new Dimension(110, 20));
        aDeleteEntry.setActionCommand("aDeleteEntry");
        aDeleteEntry.addActionListener(this);
        buttonBox.add(aDeleteEntry);
        buttonBox.add(Box.createRigidArea(new Dimension(0, 2)));
        buttonBox.add(Box.createVerticalGlue());
        totalBox.add(buttonBox);
        htmlAssetPanel.add(totalBox);
    }

    private void generateTargetPlatformPage(JPanel aPanel) {
        JLabel explMessage = new JLabel();
        explMessage.setText("<html>Now that you've decided what you would like to package you can choose where you will deploy your tutor. Below are the Learner Management Systems (LMSs) we support.</html>");
        aPanel.add(explMessage);
        aPanel.add(new JSeparator(0));
        JRadioButton SCORMChoice = new JRadioButton("Generate a SCORM Package. Compatible with Moodle, Blackboard, etc.");
        SCORMChoice.setActionCommand("SCORMChoice");
        SCORMChoice.setSelected(true);
        SCORMChoice.addActionListener(this);
        JRadioButton OLIChoice = new JRadioButton("Create an OLI content package");
        OLIChoice.setActionCommand("OLIChoice");
        OLIChoice.addActionListener(this);
        JRadioButton XBlockChoice = new JRadioButton("Generate an OpenEdX XBlock");
        XBlockChoice.setActionCommand("XBlockChoice");
        XBlockChoice.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(SCORMChoice);
        group.add(OLIChoice);
        group.add(XBlockChoice);
        aPanel.add(SCORMChoice);
        aPanel.add(OLIChoice);
        aPanel.add(XBlockChoice);
    }

    private void generateFinishPage(JPanel aPanel) {
        this.debug("generateFinishPage ()");
        Box descButtonBox = new Box(0);
        descButtonBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel aDescLabel = new JLabel();
        aDescLabel.setText("Optional Description: ");
        aDescLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        descButtonBox.add(aDescLabel);
        this.packageDescription = new JTextField();
        this.packageDescription.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.packageDescription.setMinimumSize(new Dimension(50, 20));
        this.packageDescription.setMaximumSize(new Dimension(600, 20));
        this.packageDescription.setText("CTAT Tutor Package");
        descButtonBox.add(this.packageDescription);
        Box zipButtonBox = new Box(0);
        zipButtonBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel aLabelZIP = new JLabel();
        aLabelZIP.setText("Choose a ZIP file: ");
        aLabelZIP.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        zipButtonBox.add(aLabelZIP);
        this.zipLocation = new JTextField();
        this.zipLocation.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.zipLocation.setMinimumSize(new Dimension(50, 20));
        this.zipLocation.setMaximumSize(new Dimension(600, 20));
        zipButtonBox.add(this.zipLocation);
        JButton aBrowseZIP = new JButton();
        aBrowseZIP.setText("Browse...");
        aBrowseZIP.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        aBrowseZIP.setPreferredSize(new Dimension(85, 20));
        aBrowseZIP.setActionCommand("aBrowseZIP");
        aBrowseZIP.addActionListener(this);
        zipButtonBox.add(aBrowseZIP);
        aPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        aPanel.add(descButtonBox);
        aPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        aPanel.add(zipButtonBox);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.debug("actionPerformed ()");
        super.actionPerformed(arg0);
        Component comp = (Component)arg0.getSource();
        this.debug("comp: " + comp.getClass());
        if (comp == this.logButton) {
            if (this.logButton.isSelected()) {
                this.LMSConfiguration.setUseLogging(true);
                this.datashopURLSingle.setEnabled(true);
                this.datasetNameSingle.setEnabled(true);
            } else {
                this.LMSConfiguration.setUseLogging(false);
                this.datashopURLSingle.setEnabled(false);
                this.datasetNameSingle.setEnabled(false);
            }
        }
        if (comp == this.engineList) {
            String chosenEngine = (String)this.engineList.getSelectedItem();
            this.debug("Changing engine target: " + chosenEngine);
            if (chosenEngine.equals("Built-in Javascript Tracer")) {
                this.debug("Setting target to javascript");
                this.tsHostSingle.setEnabled(false);
                this.tsPortSingle.setEnabled(false);
                this.LMSConfiguration.setEngineTarget("javascript");
            } else {
                this.debug("Setting target to http");
                this.tsHostSingle.setEnabled(true);
                this.tsPortSingle.setEnabled(true);
                this.LMSConfiguration.setEngineTarget("http");
            }
            return;
        }
        if (arg0.getActionCommand().equalsIgnoreCase("aBrowseFile")) {
            File file = DialogUtilities.chooseFile(this.LMSConfiguration.getAssetBasePath(), null, null, "Asset file chooser", "Open", 0, (Component)arg0.getSource());
            if (file != null) {
                try {
                    if (!file.getCanonicalPath().startsWith(this.LMSConfiguration.getAssetBasePath())) {
                        this.alert("Error: please specify a file from below the location of your interface file");
                    } else {
                        this.assetListWidget.addEntry(file);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.alert("Error: please specify a file from below the location of your interface file");
                }
            }
            return;
        }
        if (arg0.getActionCommand().equalsIgnoreCase("aBrowseDirectory")) {
            File file = DialogUtilities.chooseFile(this.LMSConfiguration.getAssetBasePath(), null, null, "Asset directory chooser", "Open", 1, (Component)arg0.getSource());
            if (file != null) {
                try {
                    if (!file.getCanonicalPath().startsWith(this.LMSConfiguration.getAssetBasePath())) {
                        this.alert("Error: please specify a file from below the location of your interface file");
                    } else {
                        this.assetListWidget.addEntry(file);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.alert("Error: please specify a file from below the location of your interface file");
                }
            }
            return;
        }
        if (arg0.getActionCommand().equalsIgnoreCase("aDeleteEntry")) {
            this.assetListWidget.deletEntry();
            return;
        }
        if (arg0.getActionCommand().equalsIgnoreCase("flashButtonSingle")) {
            this.debug("(comp==flashButtonSingle)");
            this.selectHTMLTutor(false);
            return;
        }
        if (arg0.getActionCommand().equalsIgnoreCase("html5ButtonSingle")) {
            this.debug("(comp==html5ButtonSingle)");
            this.selectHTMLTutor(true);
            return;
        }
        if (arg0.getActionCommand().equalsIgnoreCase("aBrowseSWF")) {
            this.debug("(comp==aBrowseSWF)");
            if (this.outputSWF.booleanValue()) {
                CTATFileFilter filter1 = new CTATFileFilter("SWF", new String[]{"SWF"});
                File f = DialogUtilities.chooseFile(this.getTargetDir(), filter1, "Choose Student Interface", "Open", this.controller);
                if (f != null) {
                    this.assetListWidget.addExclusion(f.getAbsolutePath());
                    this.swfLocation.setText(f.getAbsolutePath());
                    lastChosenDir = f.getParent();
                }
            } else {
                CTATFileFilter filter1 = new CTATFileFilter("HTML Files", new String[]{"HTML", "HTM"});
                File f = DialogUtilities.chooseFile(this.getTargetDir(), filter1, "Select a Student Interface", "Open", this.controller);
                if (f != null) {
                    this.assetListWidget.addExclusion(f.getAbsolutePath());
                    this.swfLocation.setText(f.getAbsolutePath());
                    lastChosenDir = f.getParent();
                }
            }
            return;
        }
        if (arg0.getActionCommand().equalsIgnoreCase("aBrowseBRD")) {
            this.debug("(comp==aBrowseBRD)");
            CTATFileFilter filter2 = new CTATFileFilter("BRD", new String[]{"BRD"});
            File f = DialogUtilities.chooseFile(this.getTargetDir(), filter2, "Choose Behavior Graph", "Open", this.controller);
            if (f != null) {
                this.assetListWidget.addExclusion(f.getAbsolutePath());
                this.brdLocation.setText(f.getAbsolutePath());
                lastChosenDir = f.getParent();
            }
            return;
        }
        if (arg0.getActionCommand().equalsIgnoreCase("aBrowse")) {
            this.debug("(comp==aBrowse)");
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            Integer opt = fc.showSaveDialog(this.frame);
            switch (opt) {
                case 1: {
                    break;
                }
                case 0: {
                    File f = fc.getSelectedFile();
                    this.anInput.setText(f.getAbsolutePath());
                    break;
                }
            }
            return;
        }
        if (arg0.getActionCommand().equalsIgnoreCase("aBrowseZIP")) {
            CTATFileFilter filter = new CTATFileFilter("Zip Files", new String[]{"ZIP"});
            File f = DialogUtilities.chooseFile(this.getTargetDir(), filter, "Save SCORM package", "Save", this.controller);
            if (f == null) {
                return;
            }
            String filePath = f.getPath();
            if (!filePath.toLowerCase().endsWith(".zip")) {
                f = new File(filePath + ".zip");
            }
            if (f.exists()) {
                Object[] options = new Object[]{"Yes", "No", "Cancel"};
                int n = JOptionPane.showOptionDialog(null, "The file " + f.getName() + " already exists, would you like to overwrite it?", "CTAT Info Panel", 1, 3, null, options, options[2]);
                if (n != 0) {
                    f = null;
                }
            }
            if (f == null) {
                return;
            }
            this.zipLocation.setText(f.getAbsolutePath());
        }
        if (arg0.getActionCommand().equalsIgnoreCase("SCORMChoice")) {
            this.debug("(comp==SCORMChoice)");
            this.targetPlatform = this.TARGET_SCORM;
            return;
        }
        if (arg0.getActionCommand().equalsIgnoreCase("OLIChoice")) {
            this.debug("(comp==OLIChoice)");
            this.targetPlatform = this.TARGET_OLI;
            return;
        }
        if (arg0.getActionCommand().equalsIgnoreCase("XBlockChoice")) {
            this.debug("(comp==XBlockChoice)");
            this.targetPlatform = this.TARGET_XBLOCK;
            return;
        }
    }

    @Override
    protected Boolean processFinish() {
        JProgressBar progress;
        this.debug("processFinish ()");
        if (this.zipLocation.getText().isEmpty()) {
            this.alert("Error: please provide the name or full path to a zip file");
            return false;
        }
        if (!this.validateHTML().booleanValue()) {
            return false;
        }
        this.LMSConfiguration.setDescription(this.packageDescription.getText());
        File f = new File(this.zipLocation.getText());
        CTATPackageGeneratorBase generator = new CTATPackageGeneratorBase(this.LMSConfiguration);
        if (this.targetPlatform == this.TARGET_SCORM) {
            if (this.outputSWF.booleanValue()) {
                generator = new CTATSCORMFlashPackageGenerator(this.LMSConfiguration);
            }
            if (!this.outputSWF.booleanValue()) {
                generator = new CTATSCORMHTML5PackageGenerator(this.LMSConfiguration);
            }
        }
        if (this.targetPlatform == this.TARGET_XBLOCK) {
            generator = new CTATXBlockPackageGenerator(this.LMSConfiguration);
        }
        if (this.targetPlatform == this.TARGET_OLI) {
            generator = new CTATOLIPackageGenerator(this.LMSConfiguration);
        }
        if (!generator.generatePackage(f).booleanValue()) {
            this.alert("Error generating package " + f.getName());
        } else {
            this.alert("Successfully generated package " + f.getName());
        }
        CTATWizardFinishPage finishPage = (CTATWizardFinishPage)this.getCurrentPanel();
        if (finishPage != null && (progress = finishPage.getProgressBar()) != null) {
            progress.setMaximum(100);
            progress.setValue(100);
        }
        return true;
    }

    private Boolean validateHTML() {
        Document doc;
        this.debug("validateHTML ()");
        File input = new File(this.LMSConfiguration.getInterfaceLocationString());
        try {
            doc = Jsoup.parse((File)input, (String)"UTF-8", (String)"");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        Elements css = doc.select("link[href]");
        Elements js = doc.select("script[src]");
        this.debug("CSS: " + css.size());
        for (Element impCSS : css) {
            this.debug("CSS: " + impCSS.attr("href"));
        }
        this.debug("JS: " + js.size());
        for (Element impJs : js) {
            this.debug("JS: " + impJs.attr("src"));
        }
        return true;
    }

    private String getTargetDir() {
        if (lastChosenDir != null) {
            return lastChosenDir;
        }
        if (this.controller != null) {
            return SaveFileDialog.getBrdFileOtherLocation(this.controller);
        }
        return System.getProperty("user.dir");
    }

    @Override
    protected Boolean checkNextOK() {
        this.debug("checkNextOK (" + this.getCurrentIndex() + ")");
        if (this.getCurrentIndex() == 1) {
            CTATLink.hostName = this.tsHostSingle.getText();
            CTATLink.tsPort = Integer.parseInt(this.tsPortSingle.getText());
            if (this.brdLocation.getText().isEmpty()) {
                this.alert("Please provide a valid BRD file");
                return false;
            }
            this.LMSConfiguration.setBrdLocationString(this.brdLocation.getText());
            if (this.swfLocation.getText().isEmpty()) {
                this.alert("Please provide a valid SWF or HTML file");
                return false;
            }
            this.LMSConfiguration.setSwfLocationString(this.swfLocation.getText());
            CTATLink.datashopURL = this.datashopURLSingle.getText();
            CTATLink.datasetName = this.datasetNameSingle.getText();
            File assetBasePathFile = new File(this.swfLocation.getText());
            if (assetBasePathFile.exists()) {
                try {
                    this.LMSConfiguration.setAssetBasePath(assetBasePathFile.getParentFile().getCanonicalPath());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    this.alert("Error finding parent folder for student interface file");
                    return false;
                }
            } else {
                this.alert("Error student interface file does not exist");
                return false;
            }
            this.debug("Asset base path: " + this.LMSConfiguration.getAssetBasePath());
            this.baseLabel.setText(this.LMSConfiguration.getAssetBasePath());
        }
        return true;
    }

    @Override
    protected Boolean checkReadyToFinish() {
        this.debug("checkReadyToFinish ()");
        return true;
    }

    public static void main(String[] args) {
        new CTATLink(null);
        trace.addDebugCode("ll");
        CTATLMSPackageWizard t = new CTATLMSPackageWizard(null);
        t.init();
        t.show();
    }
}

