/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.wizard;

import edu.cmu.hcii.ctat.env.CTATFileEntry;
import edu.cmu.hcii.ctat.wizard.CTATLMSConfiguration;
import edu.cmu.hcii.ctat.wizard.CTATWizardBase;
import java.io.File;
import java.io.IOException;

public class CTATLMSPackageWizardBase
extends CTATWizardBase {
    protected Boolean outputSWF = true;
    protected String flashTutorBasePath = "";
    protected CTATLMSConfiguration LMSConfiguration = null;

    public CTATLMSPackageWizardBase() {
        this.setClassName("CTATLMSPackageWizardBase");
        this.debug("CTATLMSPackageWizardBase ()");
        this.LMSConfiguration = new CTATLMSConfiguration();
    }

    public void generateFileList(File node) {
        this.debug("generateFileList ()");
        if (node.isFile()) {
            String totalPath = node.getAbsolutePath();
            int index = totalPath.indexOf(this.flashTutorBasePath);
            if (index != -1) {
                CTATFileEntry entry = new CTATFileEntry();
                entry.basePath = this.flashTutorBasePath;
                entry.filePath = totalPath.substring(this.flashTutorBasePath.length() + 1);
                this.debug("Adding " + entry.basePath + " at (" + index + "): " + entry.filePath);
                this.LMSConfiguration.getFileList().add(entry);
            } else {
                this.debug("Unable to find: " + this.flashTutorBasePath + " in: " + totalPath);
            }
        }
        if (node.isDirectory()) {
            String[] subNote;
            for (String filename : subNote = node.list()) {
                this.generateFileList(new File(node, filename));
            }
        }
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }
}

