/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.wizard;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.view.AbstractCtatWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class CTATWorkspaceConfigureDialog
extends CTATBase
implements ActionListener {
    protected JDialog frame;
    protected JTextField anInput = null;
    private String workspacePath = "";
    private PreferencesModel brPrefs = null;

    public CTATWorkspaceConfigureDialog(PreferencesModel aPrefs, Boolean disableCancel) {
        this.setClassName("CTATWorkspaceConfigureDialog");
        this.debug("CTATWorkspaceConfigureDialog ()");
        File workspaceFormatter = new File(System.getProperty("user.home") + File.separator + CTATLink.workspaceLocation);
        this.workspacePath = workspaceFormatter.getAbsolutePath();
        this.setBrPrefs(aPrefs);
        this.initPrefs();
        JPanel mainPane = new JPanel();
        mainPane.setLayout(new BoxLayout(mainPane, 1));
        mainPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        Box stretchBox = new Box(0);
        Box labelBox = new Box(1);
        labelBox.setOpaque(true);
        labelBox.setMinimumSize(new Dimension(50, 80));
        labelBox.setMaximumSize(new Dimension(600, 120));
        labelBox.setBackground(new Color(255, 255, 255));
        labelBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel title = new JLabel("Select a workspace");
        title.setFont(new Font("Dialog", 1, 12));
        labelBox.add(title);
        JLabel desc = new JLabel("<html>The workspace folder is the default top-level directory for your tutor projects. CTAT uses this folder as the default location for opening and saving files created while authoring. You can set your workspace to an existing project folder or to a new project folder.<br><br>Please choose a workspace folder to use.</html>");
        desc.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        desc.setBorder(new EmptyBorder(3, 13, 3, 3));
        labelBox.add(desc);
        stretchBox.add(labelBox);
        mainPane.add(stretchBox);
        mainPane.add(new JSeparator(0));
        Box browseBox = new Box(0);
        browseBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel aLabel = new JLabel();
        aLabel.setText("Workspace: ");
        aLabel.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        browseBox.add(aLabel);
        this.anInput = new JTextField();
        this.anInput.setName("workspacePath");
        this.anInput.setText(this.workspacePath);
        this.anInput.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        this.anInput.setMinimumSize(new Dimension(50, 20));
        this.anInput.setMaximumSize(new Dimension(600, 20));
        browseBox.add(this.anInput);
        JButton aBrowse = new JButton();
        aBrowse.setText("Browse...");
        aBrowse.setFont(new Font("Dialog", 1, CTATLink.dialogFontSize));
        aBrowse.setPreferredSize(new Dimension(85, 20));
        aBrowse.setActionCommand("Browse");
        aBrowse.addActionListener(this);
        browseBox.add(aBrowse);
        mainPane.add(browseBox);
        mainPane.add(Box.createRigidArea(new Dimension(0, 40)));
        Box buttonBox = new Box(0);
        browseBox.setBorder(new EmptyBorder(3, 3, 3, 3));
        buttonBox.add(Box.createHorizontalGlue());
        JButton okButton = new JButton("Ok");
        okButton.setActionCommand("OK");
        okButton.addActionListener(this);
        buttonBox.add(okButton);
        buttonBox.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("Cancel");
        if (disableCancel.booleanValue()) {
            cancelButton.setEnabled(false);
        }
        cancelButton.addActionListener(this);
        buttonBox.add(cancelButton);
        mainPane.add(buttonBox);
        this.frame = new JDialog(AbstractCtatWindow.mainFrame, "Configure Workspace", true);
        this.frame.setSize(438, 274);
        this.frame.setContentPane(mainPane);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setLocationRelativeTo(AbstractCtatWindow.mainFrame);
        this.frame.setResizable(false);
    }

    private void initPrefs() {
        String workspacePreference = this.brPrefs.getStringValue("workspace");
        if (workspacePreference == null) {
            File workspaceFormatter = new File(System.getProperty("user.home") + File.separator + CTATLink.workspaceLocation);
            this.brPrefs.setStringValue("workspace", workspaceFormatter.getAbsolutePath());
            this.brPrefs.saveToDisk();
        } else {
            this.workspacePath = workspacePreference;
        }
    }

    public PreferencesModel getBrPrefs() {
        return this.brPrefs;
    }

    public void setBrPrefs(PreferencesModel brPrefs) {
        this.brPrefs = brPrefs;
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public void setWorkspacePath(String aPath) {
        this.workspacePath = aPath;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("Browse")) {
            File file;
            if (trace.getDebugCode("ws")) {
                trace.out("ws", "Opening dialog to: " + System.getProperty("user.home"));
            }
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            fc.setDialogTitle("Workspace Folder");
            fc.setCurrentDirectory(new File(System.getProperty("user.home")));
            int returnVal = fc.showOpenDialog(null);
            if (returnVal == 0 && (file = fc.getSelectedFile()) != null) {
                this.anInput.setText(file.getAbsolutePath());
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("OK")) {
            String tempFileName = "wstemp.txt";
            File file = new File(this.anInput.getText());
            File temp = new File(file.getAbsolutePath() + File.separator + tempFileName);
            try {
                if (!file.exists()) {
                    file.mkdir();
                }
                temp.createNewFile();
                if (trace.getDebugCode("ws")) {
                    trace.out("ws", "Created " + tempFileName);
                }
                this.workspacePath = this.anInput.getText();
                this.brPrefs.setStringValue("workspace", file.getAbsolutePath());
                this.brPrefs.saveToDisk();
                this.frame.setVisible(false);
                this.frame.dispose();
                if (trace.getDebugCode("ws")) {
                    trace.out("ws", "OK: workspace=" + this.workspacePath);
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "The directory you have chosen is read-only. Please choose a different location.");
            }
            finally {
                if (temp.exists()) {
                    temp.delete();
                    if (trace.getDebugCode("ws")) {
                        trace.out("ws", "Deleted " + tempFileName);
                    }
                }
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("Cancel")) {
            if (trace.getDebugCode("ws")) {
                trace.out("ws", "Cancel: workspace=" + this.workspacePath);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }

    public static void main(String[] args) {
        PreferencesModel prefs = new PreferencesModel();
        CTATWorkspaceConfigureDialog t = new CTATWorkspaceConfigureDialog(prefs, false);
        t.show();
    }
}

