/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.pact.BehaviorRecorder.Controller.AuthorLauncherServer;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTab;
import edu.cmu.pact.SocketProxy.HTTPActionHandler;
import edu.cmu.pact.SocketProxy.HTTPToolProxy;
import edu.cmu.pact.TutoringService.HTTPSession;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.util.Date;
import pact.CommWidgets.RemoteProxy;
import pact.CommWidgets.RemoteToolProxy;
import pact.CommWidgets.StudentInterfaceConnectionStatus;

public class AuthorHTTPSession
extends HTTPSession
implements RemoteProxy {
    private CTATHTTPExchange exch = null;
    private HTTPToolProxy httpToolProxy;
    private String tracer = "";

    public AuthorHTTPSession(TSLauncherServer launcherServer, String guid, String requestBody, CTATHTTPExchange exch) {
        super(launcherServer, guid);
        this.exch = exch;
        if (requestBody != null) {
            this.msgFormat = RemoteToolProxy.deriveMsgFormat(requestBody);
        }
        if ("SetPreferences".equalsIgnoreCase(MessageObject.getPropertyFromXML(requestBody, "MessageType"))) {
            this.setUserGuid(MessageObject.getPropertyFromXML(requestBody, "user_guid"));
        }
        this.setTimeStamp(new Date());
        this.setIPAddr(exch.getIPAddress());
        String tsc = MessageObject.getPropertyFromXML(requestBody, "tutoring_service_communication");
        String string = this.tracer = tsc == null ? "" : tsc.toString().toLowerCase();
        if (trace.getDebugCode("http")) {
            trace.out("http", "AuthorHTTPSession.<init> tracer " + this.tracer + "; this " + this);
        }
    }

    public boolean hasRemoteTracer() {
        if (trace.getDebugCode("http")) {
            trace.out("http", "AuthorHTTPSession.hasRemoteTracer() tracer " + this.tracer + "; this " + this);
        }
        return this.tracer.contains("javascript");
    }

    @Override
    public void start() {
    }

    public void finishInitialization(MessageObject setPrefsMsg) {
        this.getLauncher().setSessionId(this.guid);
        this.setSetPreferencesMsg(setPrefsMsg);
        this.setLoggingProperties(this.getSetPreferencesMsg());
        this.getSetPreferencesMsg().setTransactionInfo(this.getTxInfo().create());
        this.setupLogServlet(this.getSetPreferencesMsg());
        this.startActionHandler();
        ((HTTPActionHandler)this.getActionHandler()).enqueue(this.getSetPreferencesMsg());
        this.setTimeStamp(new Date());
        this.setIPAddr(this.exch.getIPAddress());
    }

    public void close() {
        if (trace.getDebugCode("http")) {
            trace.out("http", "AuthorHTTPSession to call processWSClose() on exch " + this.exch);
        }
        this.exch.processWSClose();
        if (this.getToolProxy() != null) {
            this.getToolProxy().setStudentInterfaceConnectionStatus(StudentInterfaceConnectionStatus.Disconnected);
        }
        if (this.getActionHandler() != null) {
            ((HTTPActionHandler)this.getActionHandler()).enqueue(MessageObject.makeQuitMessage());
            if (this.getLauncherServer() instanceof AuthorLauncherServer) {
                ((AuthorLauncherServer)this.getLauncherServer()).fireChangeEvent(this);
            }
            this.setActionHandler(null);
        }
        if (this.getLogServlet() != null) {
            this.getLogServlet().exit();
            this.setLogServlet(null);
        }
        this.setIPAddr(null);
        this.setToolProxy(null);
        if (this.hasRemoteTracer()) {
            this.getLauncherServer().removeSession(this.guid);
        }
    }

    @Override
    public HTTPToolProxy getToolProxy() {
        return this.httpToolProxy;
    }

    void setToolProxy(HTTPToolProxy httpToolProxy) {
        this.httpToolProxy = httpToolProxy;
    }

    @Override
    public void extCloseConnection(boolean preserveSession) {
        CTATTab tab;
        if (!Utils.isRuntime() && this.controller != null && (tab = this.getLauncher().getTabManager().getTabByNumber(this.controller.getTabNumber())) != null) {
            tab.setTargetHTMLFile(null);
        }
        this.close();
        if (!preserveSession) {
            this.getLauncherServer().removeSession(this.getGuid());
        }
        if (this.controller != null) {
            this.controller.setRemoteProxy(null);
        }
    }
}

