/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.EditSkillNameDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.HelpSuccessPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.RuleProduction;
import edu.cmu.pact.BehaviorRecorder.View.BRPanel;
import edu.cmu.pact.BehaviorRecorder.View.RuleLabel;
import edu.cmu.pact.Utilities.trace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;

public class RuleLabelHandler
extends MouseInputAdapter
implements ActionListener {
    public BRPanel brPanel;
    ProblemEdge problemEdge;
    public EdgeData edgeData;
    public RuleLabel ruleLabel;
    static final String COPY_SKILL_NAME = "Copy Skill Name";
    static final String EDIT_SKILL_NAME = "Edit Skill Name";
    static final String ADD_RULE = "Add New Skill Name to Link";
    static final String DELETE_SKILL_NAME = "Delete Skill Name from Link";
    public BR_Controller controller;

    public void restoreTransients(BR_Controller controller) {
        this.controller = controller;
    }

    public RuleLabelHandler(RuleLabel ruleLabel, ProblemEdge problemEdge, BR_Controller controller) {
        this.controller = controller;
        this.problemEdge = problemEdge;
        this.edgeData = this.problemEdge.getEdgeData();
        this.ruleLabel = ruleLabel;
        ruleLabel.setHandler(this);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        RuleLabelHandler.evaluatePopup(e, this.controller, this);
    }

    public void deleteSkillName() {
        int result = JOptionPane.showConfirmDialog(this.controller.getActiveWindow(), "<html>Do you want to delete this skill name from this link?</html>", "Delete skill name?", 0, 2);
        if (result != 0) {
            return;
        }
        if (this.edgeData.getRuleLabels().size() > 1) {
            this.edgeData.removeRuleName(this.ruleLabel.getText());
            this.edgeData.getRuleLabels().remove(this.ruleLabel);
            this.edgeData.updateMovedFromEdgeView();
        } else {
            this.controller.checkAddRuleName("unnamed", "");
            this.ruleLabel.setText("unnamed");
        }
        trace.out("ruleLabel deleted...");
        ActionEvent ae = new ActionEvent(this, 0, DELETE_SKILL_NAME);
        this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
        if (trace.getDebugCode("undo")) {
            trace.out("undo", "Checkpoint: Deleting (1)");
        }
    }

    public static void evaluatePopup(MouseEvent e, BR_Controller controller, RuleLabelHandler handler) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setName("ruleLabelPopupMenu");
        JMenuItem menuItem = new JMenuItem(COPY_SKILL_NAME);
        if (controller.getRuleProductionCatalog().size() == 0) {
            menuItem.setEnabled(false);
        } else {
            menuItem.addActionListener(handler);
        }
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(EDIT_SKILL_NAME);
        menuItem.setEnabled(true);
        menuItem.addActionListener(handler);
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(ADD_RULE);
        menuItem.addActionListener(handler);
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(DELETE_SKILL_NAME);
        menuItem.addActionListener(handler);
        popupMenu.add(menuItem);
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (trace.getDebugCode("undo")) {
            trace.out("undo", "RuleLabelHandler.actionPerformed(" + action + ")");
        }
        this.controller.getLoggingSupport().authorActionLog("BEHAVIOR_RECORDER", action, this.edgeData.getName(), "", (Object)"");
        Vector<RuleLabel> ruleLabels = this.edgeData.getRuleLabels();
        if (action.equals(EDIT_SKILL_NAME)) {
            new EditSkillNameDialog(this, this.ruleLabel.getText());
            return;
        }
        if (action.equals(DELETE_SKILL_NAME)) {
            this.deleteSkillName();
            return;
        }
        if (action.equals(COPY_SKILL_NAME)) {
            String message2;
            String message1;
            String[] message;
            int result;
            List<String> ruleProductions = this.controller.getRuleProductionCatalog().getRuleDisplayNames(true);
            if (ruleProductions.size() < 1) {
                JOptionPane.showMessageDialog(this.controller.getActiveWindow(), "No skills to copy!", "Skills to Copy", 2);
                return;
            }
            Object[] rulesStrings = ruleProductions.toArray(new String[ruleProductions.size()]);
            String s = (String)JOptionPane.showInputDialog(this.ruleLabel, "Please select your ruleName", "RuleName Selection Dialog", 3, null, rulesStrings, rulesStrings[0]);
            if (s == null) {
                return;
            }
            RuleProduction selectedRule = this.controller.getRuleProduction(s);
            if (selectedRule == null) {
                trace.err("Copy Skill Name: rule \"+s+\" not found by controller.getRuleProduction()");
                return;
            }
            String originalRule = this.ruleLabel.getText();
            this.ruleLabel.setText(selectedRule.getDisplayName());
            this.edgeData.replaceRuleName(originalRule, selectedRule.getDisplayName());
            if (selectedRule.getHints().size() > 0 && (result = JOptionPane.showConfirmDialog(this.ruleLabel, message = new String[]{message1 = "The rule [" + s + "] has hints.", message2 = this.edgeData.getHints().size() == 0 ? "Do you want to copy the rule hints to the link hints?" : "Do you want to override the link hints with the rule hints?"}, "", 0, 2)) == 0) {
                this.edgeData.setHints(selectedRule.getHints());
                new HelpSuccessPanel(this.controller, this.edgeData, true);
            }
            this.ruleLabel.repaint();
            ActionEvent ae = new ActionEvent(this, 0, COPY_SKILL_NAME);
            this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            if (trace.getDebugCode("undo")) {
                trace.out("undo", "Checkpoint: Copy Skill Name");
            }
            return;
        }
        if (action.equals(ADD_RULE)) {
            Object[] options = new Object[]{"Before", "After", "Cancel"};
            int selectedValue = JOptionPane.showOptionDialog(this.controller.getActiveWindow(), "Would you like to add a skill name before or after the skill name you selected?", "Add New Skill Name", -1, 2, null, options, options[0]);
            if (selectedValue != 2) {
                RuleLabel newRuleLabel = new RuleLabel("r" + ruleLabels.size(), this.controller);
                this.controller.checkAddRuleName(newRuleLabel.getText(), "");
                int currLabelIndex = ruleLabels.indexOf(this.ruleLabel);
                if (selectedValue == 0) {
                    ruleLabels.insertElementAt(newRuleLabel, currLabelIndex);
                } else if (selectedValue == 1) {
                    ruleLabels.insertElementAt(newRuleLabel, currLabelIndex + 1);
                }
                newRuleLabel.addMouseListener(new RuleLabelHandler(newRuleLabel, this.problemEdge, this.controller));
                this.problemEdge.getEdgeData().updateMovedFromEdgeView();
                ActionEvent ae = new ActionEvent(this, 0, ADD_RULE);
                this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
                if (trace.getDebugCode("undo")) {
                    trace.out("undo", "Checkpoint: Add New Skill Name to Link");
                }
            }
            return;
        }
    }

    public void getAllExamplesSAI(Vector selectionList, Vector actionList, Vector inputList, Vector ruleNamesList, Vector edgeList, RuleLabel ruleName, Vector associatedElementsList, Vector associatedElementsValuesList, Vector negativeExamplesList, Vector negativeExamplesValuesList) {
        this.getAllEdges(this.controller.getProblemModel().getStartNode(), edgeList, ruleName);
        this.getSAIForAllEdges(edgeList, selectionList, actionList, inputList, ruleNamesList);
        int size = edgeList.size();
        for (int i = 0; i < size; ++i) {
            EdgeData myEdge = ((ProblemEdge)edgeList.get(i)).getEdgeData();
            if (myEdge.getActionType().equals("Correct Action")) {
                associatedElementsList.add(myEdge.getAssociatedElements());
                associatedElementsValuesList.add(myEdge.getAssociatedElementsValues());
                continue;
            }
            negativeExamplesList.add(myEdge.getAssociatedElements());
            negativeExamplesValuesList.add(myEdge.getAssociatedElementsValues());
        }
    }

    public void getSAIForAllEdges(Vector edgeList, Vector selectionList, Vector actionList, Vector inputList, Vector ruleNamesList) {
        Enumeration enumeration = edgeList.elements();
        while (enumeration.hasMoreElements()) {
            Vector selection = new Vector();
            Vector action = new Vector();
            Vector input = new Vector();
            Vector ruleNames = new Vector();
            ProblemEdge edge = (ProblemEdge)enumeration.nextElement();
            this.getSAIForEdge(this.controller.getProblemModel().getStartNode(), selection, action, input, ruleNames, edge);
            selectionList.addElement(selection);
            actionList.addElement(action);
            inputList.addElement(input);
            ruleNamesList.addElement(ruleNames);
        }
    }

    public int getSAIForEdge(ProblemNode atNode, Vector selectionList, Vector actionList, Vector inputList, Vector ruleNames, ProblemEdge edge) {
        Enumeration<ProblemEdge> iterOutEdge = this.controller.getProblemModel().getProblemGraph().getOutgoingEdges(atNode);
        while (iterOutEdge.hasMoreElements()) {
            ProblemEdge edgeTemp = iterOutEdge.nextElement();
            if (edgeTemp.equals(edge)) {
                EdgeData myCurrEdge = edgeTemp.getEdgeData();
                selectionList.add(0, myCurrEdge.getSelection());
                actionList.add(0, myCurrEdge.getAction());
                inputList.add(0, myCurrEdge.getInput());
                Vector<String> rules = new Vector<String>();
                for (int i = 0; i < myCurrEdge.getRuleLabels().size(); ++i) {
                    RuleLabel tempLabel = myCurrEdge.getRuleLabels().elementAt(i);
                    rules.addElement(tempLabel.getText());
                }
                ruleNames.add(0, rules);
                return -1;
            }
            ProblemNode childTemp = edgeTemp.getNodes()[1];
            int i = this.getSAIForEdge(childTemp, selectionList, actionList, inputList, ruleNames, edge);
            if (i != -1) continue;
            EdgeData myCurrEdge = edgeTemp.getEdgeData();
            selectionList.add(0, myCurrEdge.getSelection());
            actionList.add(0, myCurrEdge.getAction());
            inputList.add(0, myCurrEdge.getInput());
            Vector<String> rules = new Vector<String>();
            for (int j = 0; j < myCurrEdge.getRuleLabels().size(); ++j) {
                RuleLabel tempLabel = myCurrEdge.getRuleLabels().elementAt(j);
                rules.addElement(tempLabel.getText());
            }
            ruleNames.add(0, rules);
            return -1;
        }
        return 0;
    }

    public void getAllEdges(ProblemNode atNode, Vector edgeList, RuleLabel ruleName) {
        Enumeration<ProblemEdge> iterOutEdge = this.controller.getProblemModel().getProblemGraph().getOutgoingEdges(atNode);
        while (iterOutEdge.hasMoreElements()) {
            ProblemEdge edgeTemp = iterOutEdge.nextElement();
            ProblemNode childTemp = edgeTemp.getNodes()[1];
            EdgeData myCurrEdge = edgeTemp.getEdgeData();
            String str1 = ruleName.getText();
            str1 = str1.replaceAll("\\s+", " ");
            for (int i = 0; i < myCurrEdge.getRuleLabels().size(); ++i) {
                RuleLabel tempLabel = myCurrEdge.getRuleLabels().elementAt(i);
                String str = tempLabel.getText();
                if (!(str = str.replaceAll("\\s+", " ")).equals(str1) || ProblemModel.containsEdge(edgeList, edgeTemp)) continue;
                edgeList.add(edgeTemp);
                break;
            }
            this.getAllEdges(childTemp, edgeList, ruleName);
        }
    }

    public ProblemEdge getProblemEdge() {
        return this.problemEdge;
    }
}

