/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.Controller.MessageTank;
import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageBuilder;
import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageHandler;
import edu.cmu.pact.BehaviorRecorder.Controller.TankMessageHandler;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.DialogueSystemInfo;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerSAI;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.SolutionStateModel.ProcessTraversedLinks;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.BehaviorRecorder.View.RuleLabel;
import edu.cmu.pact.SocketProxy.HTTPToolProxy;
import edu.cmu.pact.Utilities.LoggingSupport;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.ProblemSummary;
import edu.cmu.pact.ctat.model.Skill;
import edu.cmu.pact.miss.Rule;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.jdom.Content;
import org.jdom.Element;
import pact.CommWidgets.UniversalToolProxy;

public class TutorMessageHandler
extends TankMessageHandler {
    private BR_Controller controller;
    private static final Pattern WhiteSpacePattern = Pattern.compile("\\s+");

    private boolean disableLispCheckActionMsgs() {
        if (Utils.isRuntime()) {
            return true;
        }
        if (this.controller != null) {
            UniversalToolProxy utp = this.controller.getUniversalToolProxy();
            return utp == null || utp instanceof HTTPToolProxy;
        }
        String commShellVersion = this.controller.getCommShellVersion();
        if (commShellVersion == null) {
            return false;
        }
        return "3.0".compareTo(commShellVersion) >= 0;
    }

    public TutorMessageHandler(BR_Controller controller) {
        this.controller = controller;
        this.messageTank = new MessageTank(controller);
    }

    void processTutorInterfaceAction(Vector selection, Vector action, Vector input, String actor, MessageObject currInterfaceActionTutor) {
        Vector<String> ruleNames = new Vector<String>();
        int uniqueID = -1;
        if (this.controller != null) {
            if (this.controller.getProblemModel() != null) {
                this.controller.getProblemModel().startSkillTransaction();
            }
            this.controller.openTransaction(currInterfaceActionTutor);
        }
        this.setRequestMessage(currInterfaceActionTutor, null);
        uniqueID = this.handleInterfaceActionNonHelpMessage(selection, action, input, actor, currInterfaceActionTutor, ruleNames);
        this.messageTank.editSelectionAndAction("InterfaceAction", selection, action);
        this.resetMessageTank(this.controller);
        if (ruleNames.size() < 1) {
            ruleNames.addElement("dummy");
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "processTutorInterfaceAction() uniqueID=" + uniqueID + ", ruleNames(0)=" + ruleNames.get(0));
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "controller.brPanel.isDialogueMsgSent()= null");
        }
        this.sendLISPCheckMsg(selection, action, input, ruleNames, new Integer(uniqueID), currInterfaceActionTutor);
        this.messageTank.flushMessageTank(this.controller.getProblemSummary(), this.endTransaction(false));
    }

    void sendLISPCheckMsg(Vector selectionP, Vector actionP, Vector inputP, Vector ruleNamesP, Integer actionLabelTagIDP, MessageObject msg) {
        String transactionId;
        MessageObject newMessage = MessageObject.create("LISPCheck", "SendNoteProperty");
        newMessage.setSelection(selectionP);
        newMessage.setAction(actionP);
        newMessage.setInput(inputP);
        newMessage.setProperty("RuleNames", ruleNamesP);
        newMessage.setProperty("ActionLabelTagID", actionLabelTagIDP);
        String string = transactionId = msg == null ? null : msg.getTransactionId();
        if (transactionId != null) {
            newMessage.setTransactionId(transactionId);
        }
        this.controller.sendProperty(newMessage);
    }

    private int handleInterfaceActionNonHelpMessage(Vector selection, Vector action, Vector input, String actor, MessageObject currInterfaceActionTutor, Vector ruleNames) {
        int uniqueID = -1;
        this.sendLISPCheckActionMsg(selection, input);
        if (Utils.isRuntime()) {
            return uniqueID;
        }
        EdgeData myEdge = null;
        if (PseudoTutorMessageHandler.USE_NEW_EXAMPLE_TRACER) {
            this.controller.getExampleTracer().evaluate(selection, action, input, actor);
            ExampleTracerEvent result = this.controller.getExampleTracer().getLastResult();
            if ("NO-MODEL".equals(result.getResult())) {
                uniqueID = -1;
            } else {
                ProblemEdge reportableLink = result.getReportableLink().getEdge().getEdge();
                myEdge = reportableLink.getEdgeData();
                if (trace.getDebugCode("mt")) {
                    trace.out("mt", "reportableLink from new Ex-tracer " + myEdge);
                }
            }
        } else {
            myEdge = this.doOldExampleTraceLookup(selection, action, input);
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "reportableLink from old Ex-tracer " + myEdge);
            }
        }
        if (myEdge != null) {
            uniqueID = myEdge.getUniqueID();
        }
        if (uniqueID != -1) {
            for (int i = 0; i < myEdge.getRuleLabels().size(); ++i) {
                RuleLabel tempLabel = myEdge.getRuleLabels().elementAt(i);
                ruleNames.addElement(tempLabel.getText());
            }
        } else {
            ruleNames.addElement("dummy");
            uniqueID = this.controller.index_interfaceActions_NoneState_Tutor--;
            this.controller.getInterfaceActions_NoneState_Tutor().put(new Integer(uniqueID), currInterfaceActionTutor);
        }
        return uniqueID;
    }

    private void sendLISPCheckActionMsg(Vector selectionP, Vector inputP) {
        if (this.disableLispCheckActionMsgs()) {
            return;
        }
        MessageObject newMessage = MessageObject.create("LISPCheckAction", "SendNoteProperty");
        newMessage.setSelection(selectionP);
        newMessage.setInput(inputP);
        newMessage.setTransactionId(this.controller.getSemanticEventId());
        if (trace.getDebugCode("br")) {
            trace.out("br", "sendLISPCheckActionMsg: " + newMessage.toString());
        }
        this.messageTank.addToMessageTank(newMessage);
    }

    private EdgeData doOldExampleTraceLookup(Vector selection, Vector action, Vector input) {
        ProblemEdge tempEdge;
        int uniqueID = -1;
        EdgeData myEdge = null;
        Enumeration<ProblemEdge> iter = this.controller.getProblemModel().getProblemGraph().getConnectingEdges(this.controller.getSolutionState().getCurrentNode());
        while (iter.hasMoreElements()) {
            tempEdge = iter.nextElement();
            if (tempEdge.getNodes()[1] != this.controller.getSolutionState().getCurrentNode()) continue;
            myEdge = tempEdge.getEdgeData();
            if (!this.controller.getProblemModel().matchStates(myEdge, selection, action, input)) continue;
            trace.out("it's not a new state");
            uniqueID = myEdge.getUniqueID();
            break;
        }
        if (uniqueID == -1) {
            Enumeration<ProblemEdge> iterEdges = this.controller.getProblemModel().getProblemGraph().getOutgoingEdges(this.controller.getSolutionState().getCurrentNode());
            while (iterEdges.hasMoreElements()) {
                tempEdge = iterEdges.nextElement();
                myEdge = tempEdge.getEdgeData();
                if (!this.controller.getProblemModel().matchStates(myEdge, selection, action, input)) continue;
                uniqueID = myEdge.getUniqueID();
                break;
            }
        }
        return myEdge;
    }

    public synchronized void handleLispCheckResultMessage(MessageObject o, ProblemModel problemModel2, LoggingSupport loggingSupport2, BR_Controller controller) {
        if (trace.getDebugCode("popup")) {
            trace.out("popup", "entered handleLispCheckResultMessage");
        }
        if (trace.getDebugCode("lispcheckresult")) {
            trace.out("lispcheckresult", "BR.handleCommMessage(LispCheckResult) " + o);
        }
        String transactionId = o.getTransactionId();
        try {
            ProblemEdge thisEdge;
            Integer actionLabelTagID;
            String checkResult = (String)o.getProperty("Result");
            if (trace.getDebugCode("popup")) {
                trace.out("popup", "checkResult = " + checkResult);
            }
            if ((actionLabelTagID = o.getPropertyAsInteger("actionLabelTagID")) == null) {
                actionLabelTagID = -2;
            }
            if ((thisEdge = problemModel2.getEdge(actionLabelTagID)) != null) {
                String edgeInfoString = "Edge from ";
                ProblemNode tempNode = thisEdge.getNodes()[0];
                edgeInfoString = edgeInfoString + tempNode.toString() + " to ";
                tempNode = thisEdge.getNodes()[1];
                edgeInfoString = edgeInfoString + tempNode.toString();
                loggingSupport2.programActionLog("BEHAVIOR_RECORDER", "TEST_MODEL_1_STEP_RESULT", edgeInfoString, checkResult, "");
            }
            if (controller.getCtatModeModel().isSimStudentMode()) {
                TutorMessageHandler.processLispCheckResultSimStMode(o, controller);
            } else if (controller.getCtatModeModel().isRuleEngineTracing()) {
                this.processLispCheckResultTutorMode(o, controller);
            } else {
                try {
                    throw new IllegalStateException("handling LispCheckResult msg but mode indicates no rule engine");
                }
                catch (IllegalStateException ise) {
                    ise.printStackTrace();
                }
            }
            this.messageTank.setTransaction_id(transactionId);
            ProblemSummary ps = controller.getProblemSummary();
            this.messageTank.flushMessageTank(ps, this.endTransaction(true));
            controller.getModelTracer().updateProblemSummaryFacts(ps);
        }
        catch (Exception e) {
            trace.errStack("TutorMessageHandler.handleLispCheckResultMessage(): error " + e + "\n  processing\n  " + o + "\n", e);
            MessageObject errorResponse = MessageObject.create("TutoringServiceError", "SendNoteProperty");
            errorResponse.setProperty("ErrorType", "Model Tracing Failure");
            errorResponse.setProperty("Details", "Error processing response from rules engine: " + e);
            controller.handleMessageUTP(errorResponse);
        }
    }

    void processLispCheckResultActionLabelGTM1(BR_Controller controller, String checkResult, Integer actionLabelTagID, Vector selection, Vector input, Vector action) {
        if (trace.getDebugCode("lispcheckresult")) {
            trace.out("lispcheckresult", "process lisp check result action: checkResult = " + checkResult + " selection = " + selection + " input = " + input);
        }
        ProblemEdge matchedEdge = controller.getProblemModel().getEdge(actionLabelTagID);
        EdgeData matchedEdgeData = matchedEdge.getEdgeData();
        matchedEdgeData.getPreLispCheckLabel().resetAll(actionLabelTagID, matchedEdgeData.getCheckedStatus());
        matchedEdgeData.setCheckedStatus(checkResult);
        if (checkResult.equalsIgnoreCase("SUCCESS") || checkResult.equalsIgnoreCase("FIREABLE-BUG")) {
            this.handleSuccessOrFireableBugActionType(controller, checkResult, selection, input, action, matchedEdge);
        } else {
            MessageObject mo = PseudoTutorMessageBuilder.buildCommIncorrectMessage(selection, action, input, controller);
            this.messageTank.addToMessageTank(mo);
        }
        if (DialogueSystemInfo.getUseDialogSystem(controller)) {
            controller.processEdgeSuccessBuggyMessage(matchedEdge);
        }
        String actionType = "";
        actionType = TutorMessageHandler.getActionType(checkResult);
        if (!controller.getIsReducedMode() && !actionType.equalsIgnoreCase(matchedEdgeData.getActionType())) {
            TutorMessageHandler.handleUnmatchedActionTypeAndActionResult(controller, checkResult, matchedEdgeData);
        }
    }

    private static void handleUnmatchedActionTypeAndActionResult(BR_Controller controller, String checkResult, EdgeData myEdge) {
        if (trace.getDebugCode("rr")) {
            trace.out("rr", "handleUnmatchedActionTypeAndActionResult() Utils.isRuntime() " + Utils.isRuntime());
        }
        if (Utils.isRuntime()) {
            return;
        }
        if (checkResult.equalsIgnoreCase("No-Applicable")) {
            TutorMessageHandler.showCantYetBeTestedMessage(controller);
        } else {
            TutorMessageHandler.showDoesNotWorkAsSpecifiedMessage(controller, checkResult, myEdge);
        }
    }

    private static void showDoesNotWorkAsSpecifiedMessage(BR_Controller controller, String checkResult, EdgeData myEdge) {
        if (trace.getDebugCode("lispcheckresult")) {
            trace.out("lispcheckresult", "  ***  this is where it notifies the user");
        }
        String[] message = new String[]{"On this step the production rule model", "does not work as specified in the Behavior Graph.", "The Behavior Graph indicates " + myEdge.getActionType() + ",", "the model-tracing algorithm returned " + checkResult};
        JOptionPane.showMessageDialog(controller.getActiveWindow(), message, "Warning", 2);
    }

    private static void showCantYetBeTestedMessage(BR_Controller controller) {
        String[] message = new String[]{"The production rule model cannot be", "tested yet on this step."};
        JOptionPane.showMessageDialog(controller.getActiveWindow(), message, "Prod. System Check Message", 2);
    }

    private static String getActionType(String checkResult) {
        String actionType = checkResult.equalsIgnoreCase("SUCCESS") ? "Correct Action" : (checkResult.equalsIgnoreCase("BUG") ? "Buggy Action" : (checkResult.equalsIgnoreCase("FIREABLE-BUG") ? "Fireable Buggy Action" : "Untraceable Error"));
        return actionType;
    }

    public void handleSuccessOrFireableBugActionType(BR_Controller controller, String checkResult, Vector selection, Vector input, Vector action, ProblemEdge edge) {
        controller.setCurrentNode(edge.getNodes()[1]);
        if (controller.getProcessTraversedLinks() != null) {
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "add traversed link to DOM");
            }
            controller.getProcessTraversedLinks().addLinkNode(edge.getUniqueID(), selection, action, input, EdgeData.checkResultToActionType(checkResult));
        } else {
            trace.err("LispResultCheck(" + selection + "," + action + "," + input + "): ProcessTraversedLinks object is null");
        }
        MessageObject mo = checkResult.equalsIgnoreCase("SUCCESS") ? PseudoTutorMessageBuilder.buildCommCorrectMessage(selection, action, input, controller) : PseudoTutorMessageBuilder.buildCommIncorrectMessage(selection, action, input, controller);
        this.messageTank.addToMessageTank(mo);
    }

    boolean processLispCheckResultActionLabelLTEQM1(BR_Controller controller, String checkResult, Integer actionLabelTagID, Vector selection, Vector action, Vector input) {
        String actionType = EdgeData.checkResultToActionType(checkResult);
        if (checkResult.equalsIgnoreCase("SUCCESS")) {
            String firstSelection = (String)selection.get(0);
            trace.out("First Selection: " + firstSelection);
            if (firstSelection.equalsIgnoreCase("Done")) {
                controller.getCTAT_LMS().advanceProblem();
                if (controller.getStudentInterface() != null) {
                    controller.getStudentInterface().getHintInterface().reset();
                }
            }
        }
        if (actionType.length() > 0) {
            MessageObject newStateInterfaceObject = null;
            if (actionLabelTagID < -2) {
                newStateInterfaceObject = (MessageObject)controller.getInterfaceActions_NoneState_Tutor().get(actionLabelTagID);
                if (newStateInterfaceObject == null) {
                    trace.err("no MessageObject is in HashTable interfaceActions_NoneState_Tutor for actionLabelTagID = " + actionLabelTagID.toString());
                    return false;
                }
                controller.getInterfaceActions_NoneState_Tutor().remove(actionLabelTagID);
                action = newStateInterfaceObject.getAction();
                selection = newStateInterfaceObject.getSelection();
                input = newStateInterfaceObject.getInput();
            } else if (actionLabelTagID == -2) {
                ProcessTraversedLinks ptl = controller.getProcessTraversedLinks();
                if (action == null) {
                    action = new Vector();
                }
                if (ptl != null) {
                    newStateInterfaceObject = ptl.createInterfaceAction(selection, action, input);
                } else {
                    trace.err("LispResultCheck(" + selection + "," + action + "," + input + "): ProcessTraversedLinks object is null");
                }
            }
            controller.demonstrateModeMessageHandler.processDemonstrateInterfaceAction(selection, action, input, newStateInterfaceObject, actionType);
            Enumeration<ProblemEdge> iterEdges = controller.getProblemModel().getProblemGraph().edges();
            if (iterEdges.hasMoreElements()) {
                ProblemEdge edge = iterEdges.nextElement();
                EdgeData myEdge = edge.getEdgeData();
                myEdge.getPreLispCheckLabel().resetAll(myEdge.getUniqueID(), myEdge.getCheckedStatus());
                myEdge.setCheckedStatus(checkResult);
            }
        } else {
            MessageObject mo = PseudoTutorMessageBuilder.buildCommIncorrectMessage(selection, action, input, controller);
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "result from LispCheckResult actionLabelTagID " + actionLabelTagID + ": \n  " + mo);
            }
            this.messageTank.addToMessageTank(mo);
        }
        return true;
    }

    void processLispCheckResultTutorMode(MessageObject mo, BR_Controller controller) {
        Element knowledgeTraceElt;
        String checkResultMessageResultValue = (String)mo.getProperty("Result");
        String actionLabelTagID = (String)mo.getProperty("actionLabelTagID");
        Vector<String> selection = mo.getSelection();
        Vector<String> action = mo.getAction();
        Vector<String> input = mo.getInput();
        Vector studentSelection = (Vector)mo.getProperty("StudentSelection");
        Vector studentAction = (Vector)mo.getProperty("StudentAction");
        Vector studentInput = (Vector)mo.getProperty("StudentInput");
        Vector<String> hintMsgs = (Vector<String>)mo.getProperty("HintMessages");
        String buggyMsg = (String)mo.getProperty("BuggyMsg");
        String successMsg = (String)mo.getProperty("SuccessMsg");
        Vector ruleNames = (Vector)mo.getProperty("ProductionList");
        Vector<String> skillNames = (Vector<String>)mo.getProperty("Skills");
        Vector wmImages = (Vector)mo.getProperty("WMImages");
        if (trace.getDebugCode("lispcheckresult")) {
            trace.out("lispcheckresult", "processLispCheckResultTutorMode " + checkResultMessageResultValue + " " + actionLabelTagID + " " + selection + " " + action + " " + input + " BuggyMsg=" + buggyMsg + " SuccessMsg=" + successMsg + " WMImages length " + (wmImages == null ? 0 : wmImages.size()));
        }
        MessageObject resultMsg = null;
        Vector<String> tutorAdvice = null;
        ExampleTracerSAI studentSAI = null;
        if (hintMsgs != null && hintMsgs.size() > 0) {
            resultMsg = PseudoTutorMessageBuilder.buildHintsMsg(hintMsgs, selection, action, input, actionLabelTagID, ruleNames, null, controller);
            tutorAdvice = hintMsgs;
        } else {
            studentSAI = new ExampleTracerSAI(studentSelection, studentAction, studentInput, null);
            if (Utils.isRuntime()) {
                resultMsg = checkResultMessageResultValue.equalsIgnoreCase("SUCCESS") ? PseudoTutorMessageBuilder.buildCommCorrectMessage(studentSelection, studentAction, studentInput, controller) : PseudoTutorMessageBuilder.buildCommIncorrectMessage(studentSelection, studentAction, studentInput, controller);
                this.messageTank.addToMessageTank(resultMsg);
            } else if (Integer.valueOf(actionLabelTagID) > -1) {
                this.processLispCheckResultActionLabelGTM1(controller, checkResultMessageResultValue, Integer.valueOf(actionLabelTagID), studentSelection, studentInput, studentAction);
            } else {
                boolean keepGoing = this.processLispCheckResultActionLabelLTEQM1(controller, checkResultMessageResultValue, Integer.valueOf(actionLabelTagID), studentSelection, studentAction, studentInput);
                if (!keepGoing) {
                    return;
                }
            }
        }
        if (buggyMsg != null && buggyMsg.length() > 0) {
            resultMsg = PseudoTutorMessageBuilder.buildCommBuggyMessage(buggyMsg, selection, action, controller);
            tutorAdvice = new Vector<String>();
            tutorAdvice.add(buggyMsg);
        } else if (successMsg != null && successMsg.length() > 0) {
            resultMsg = PseudoTutorMessageBuilder.buildCommSuccessMessage(successMsg, controller);
            tutorAdvice = new Vector<String>();
            tutorAdvice.add(successMsg);
        }
        this.messageTank.addToMessageTank(resultMsg);
        String stepID = Skill.makeStepID(selection, action);
        List<Skill> modifiedSkills = null;
        ProblemModel pm = controller.getProblemModel();
        Vector<String> skillBarVector = null;
        String skillBarDelimiter = null;
        if (skillNames == null || skillNames.isEmpty()) {
            skillNames = this.ruleNamesToSkillNames(ruleNames);
        }
        if (pm != null) {
            if (skillNames.size() > 0) {
                String result = PseudoTutorMessageBuilder.fixIndicator(checkResultMessageResultValue);
                modifiedSkills = pm.updateSkills(result, skillNames, stepID);
            }
            skillBarVector = pm.getSkillBarVector();
            skillBarDelimiter = pm.getSkillBarDelimiter();
        }
        String toolSelection = studentSelection == null || studentSelection.size() < 1 ? null : (String)studentSelection.get(0);
        String actor = "Student";
        resultMsg = PseudoTutorMessageBuilder.buildAssociatedRulesMsg(checkResultMessageResultValue, selection, action, input, studentSAI, ruleNames, skillBarVector, skillBarDelimiter, stepID, actor, controller, toolSelection, tutorAdvice);
        if (wmImages != null && wmImages.size() > 0) {
            resultMsg.setProperty("WMImages", wmImages);
        }
        ArrayList<Element> customFields = new ArrayList<Element>();
        Object customFieldsFromRules = mo.getProperty("custom_fields");
        if (customFieldsFromRules instanceof List) {
            customFields.addAll((List)customFieldsFromRules);
        }
        if ((knowledgeTraceElt = this.skillsToKnowledgeTrace(modifiedSkills)) != null) {
            customFields.add(knowledgeTraceElt);
        }
        if (!customFields.isEmpty()) {
            resultMsg.setProperty("custom_fields", customFields, true);
        }
        this.messageTank.addToMessageTank(resultMsg);
        controller.fireCtatModeEvent(CtatModeEvent.REPAINT);
    }

    private Element skillsToKnowledgeTrace(List<Skill> skills) {
        if (skills == null || skills.isEmpty()) {
            return null;
        }
        Element nameElt = new Element("name");
        nameElt.addContent("knowledge-trace");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int nDelimiters = skills.size() - 1;
        for (Skill sk : skills) {
            String name = sk.getName();
            if (name.length() > 25) {
                StringBuilder nb = new StringBuilder();
                nb.append(name.substring(0, 11)).append("...").append(name.substring(name.length() - 11));
                name = nb.toString();
            }
            String pKnown = String.format("%.2f", sk.getPKnown());
            sb.append(name).append(',').append(sk.getCategory()).append(',').append(pKnown);
            if (i++ >= nDelimiters) continue;
            sb.append(';');
        }
        Element valueElt = new Element("value");
        valueElt.addContent(sb.toString());
        Element elt = new Element("custom_field");
        elt.addContent((Content)nameElt).addContent((Content)valueElt);
        return elt;
    }

    Vector<String> ruleNamesToSkillNames(List<String> ruleNames) {
        Vector<String> skillNames = new Vector<String>();
        if (ruleNames == null || ruleNames.size() < 1) {
            return skillNames;
        }
        for (String ruleName : ruleNames) {
            int delimiter;
            String skillName = ruleName.trim();
            String category = "";
            Matcher m = WhiteSpacePattern.matcher(skillName);
            int n = delimiter = m.matches() ? m.start() : -1;
            if (delimiter > 0) {
                category = skillName.substring(0, delimiter);
                skillName = skillName.substring(m.end());
            } else {
                delimiter = skillName.indexOf("::");
                if (delimiter > 0) {
                    category = skillName.substring(0, delimiter);
                    skillName = skillName.substring(delimiter + 2);
                }
            }
            if (skillName.length() < 1 && category.length() > 0) {
                skillName = category;
                category = "";
            }
            StringBuffer sb = new StringBuffer(WhiteSpacePattern.matcher(skillName).replaceAll("_"));
            if (category.length() > 0) {
                sb.append(' ').append(category);
            }
            skillNames.add(sb.toString());
        }
        return skillNames;
    }

    static void processLispCheckResultSimStMode(MessageObject mo, BR_Controller controller) {
        String checkResult = (String)mo.getProperty("Result");
        Integer actionLabelTagID = mo.getPropertyAsInteger("actionLabelTagID");
        ProblemNode bottomNode = controller.getCurrentNode();
        ProblemNode bottomNodeParent = bottomNode.getParents() == null ? bottomNode : (ProblemNode)bottomNode.getParents().get(0);
        ProblemEdge edge = controller.getMissController().getSimSt().lookupProblemEdge(bottomNodeParent, bottomNode);
        if (trace.getDebugCode("rr")) {
            trace.out("rr", "controller.getMissController.getSimSt.isInteractiveLearning:" + controller.getMissController().getSimSt().isInteractiveLearning());
        }
        if (edge == null || controller.getCtatModeModel().isSimStudentMode()) {
            if (trace.getDebugCode("ss")) {
                trace.out("ss", "Returing from processLispCheckResultSimStMode() as InteractiveLearning is True");
            }
            return;
        }
        EdgeData myEdge = edge.getEdgeData();
        String oldCheckedText = myEdge.getCheckedStatus();
        myEdge.getPreLispCheckLabel().resetAll(actionLabelTagID, myEdge.getCheckedStatus());
        myEdge.setCheckedStatus(checkResult);
        if (checkResult.equalsIgnoreCase("SUCCESS")) {
            myEdge.setCheckedStatus("SUCCESS");
            ProblemNode childTemp = edge.getNodes()[1];
            controller.setCurrentNode(childTemp);
            NodeView currVertex = controller.getSolutionState().getCurrentNode().getNodeView();
            controller.sendCommMsgs(childTemp, controller.getProblemModel().getStartNode());
        }
        controller.fireCtatModeEvent(CtatModeEvent.REPAINT);
        if (checkResult.equalsIgnoreCase("SUCCESS")) {
            Vector skillNameVector = (Vector)mo.getProperty("ProductionList");
            String skillName = Rule.getRuleBaseName((String)skillNameVector.get(0)).replaceAll("MAIN::", "");
            String newProductionSet = "SimSt";
            edge.getEdgeData().getRuleLabels().get(0).setText(skillName + " " + newProductionSet);
            String message = "The production rule model seems to \ntrace the selected step correctly.";
            JOptionPane.showMessageDialog(controller.getActiveWindow(), message, "Prod. System Check Message", 1);
        } else {
            if (trace.getDebugCode("rr")) {
                trace.out("rr", "processLispCheckResultSimStMode()" + checkResult.equalsIgnoreCase("SUCCESS"));
            }
            TutorMessageHandler.showCantYetBeTestedMessage(controller);
        }
        myEdge.setOldActionType(myEdge.getActionType());
    }

    public void handleChangeWMStateMessage(MessageObject mo, BR_Controller controller) {
        Vector arcsTraversedList;
        int arcsTraversedNumber;
        controller.setCurrentNode(controller.getProblemModel().getStartNode());
        ProblemEdge edge = null;
        Object tempObject = mo.getProperty("checkLinksList");
        if (tempObject instanceof Vector && (arcsTraversedNumber = (arcsTraversedList = (Vector)tempObject).size()) > 0) {
            for (int i = 0; i < arcsTraversedNumber; ++i) {
                Vector singleCheckedlink = (Vector)arcsTraversedList.elementAt(i);
                Integer uniqueID = (Integer)singleCheckedlink.elementAt(0);
                String checkedResult = (String)singleCheckedlink.elementAt(1);
                edge = controller.getProblemModel().getEdge(uniqueID);
                EdgeData myEdge = edge.getEdgeData();
                String authorIntent = myEdge.getActionType();
                myEdge.setCheckedStatus(checkedResult);
                if (checkedResult.equalsIgnoreCase("SUCCESS") && authorIntent.equalsIgnoreCase("Correct Action") || checkedResult.equalsIgnoreCase("FIREABLE-BUG") && authorIntent.equalsIgnoreCase("Fireable Buggy Action")) {
                    boolean exTraceResult;
                    if (PseudoTutorMessageHandler.USE_NEW_EXAMPLE_TRACER && controller.getExampleTracer() != null && !(exTraceResult = controller.getExampleTracer().evaluate(myEdge)) && !controller.getCtatModeModel().isSimStudentMode()) {
                        trace.err("ChangeWMStateMessage: example trace fails while rule engine succeeds");
                    }
                    this.handleSuccessOrFireableBugActionType(controller, checkedResult, myEdge.getSelection(), myEdge.getInput(), myEdge.getAction(), edge);
                    controller.fireCtatModeEvent(CtatModeEvent.REPAINT);
                    continue;
                }
                MessageObject response = PseudoTutorMessageBuilder.buildCommIncorrectMessage(myEdge.getSelection(), myEdge.getInput(), myEdge.getAction(), controller);
                this.messageTank.addToMessageTank(response);
            }
        }
        this.messageTank.flushMessageTank(controller.getProblemSummary(), this.endTransaction(true));
        controller.fireCtatModeEvent(CtatModeEvent.REPAINT);
    }
}

