/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.BrdFilter;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.XMLSpecialCharsTransform;
import edu.cmu.pact.Utilities.trace;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class CreateProblemsTableDialog
extends JDialog {
    private ArrayList variables = new ArrayList();
    private JLabel brdTemplateLabel = new JLabel("Select the BRD template:");
    private JTextField brdTemplateTextField = new JTextField();
    private JButton brdTemplateBrowseButton;
    private JButton createButton;
    private JButton cancelButton;
    private Container contentPane;
    private String instructions;
    private BR_Controller controller;
    private File problemTableFile;
    public static final String PROBLEMS_TABLE_LOCATION = "Problems Table Location";
    static final String BRD_TEMPLATE_PATH = "BRD Template Path";

    public CreateProblemsTableDialog(BR_Controller controller) {
        super((Frame)controller.getActiveWindow(), true);
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.brdTemplateTextField);
        this.brdTemplateBrowseButton = new JButton("Browse...");
        this.createButton = new JButton("Create");
        this.cancelButton = new JButton("Cancel");
        this.contentPane = this.getContentPane();
        this.instructions = "<html>Use this window to create a problems table for mass production.  Mass production allows you to easily produce many Behavior Recorder graphs that use a single student interface. The BRD template is a normal BRD file with variable names in place of constant values in the student input, hints, etc. ";
        this.controller = controller;
        this.setTitle("Create Problems Table for Mass Production");
        this.initUI();
    }

    private void initUI() {
        int headerHeight = 100;
        int leftAlign = 20;
        int rowSpace = 30;
        int broweSpace = 15;
        int labelWidth = 400;
        int textFiledWidth = 400;
        int buttonWidth = 100;
        int fieldHeight = 20;
        int buttonLeft = 320;
        Font labelFont = new Font("", 1, 12);
        int dialogWidth = 555;
        int dialogHeight = 230;
        this.contentPane.setLayout(null);
        JLabel instructionslabel = new JLabel(this.instructions);
        instructionslabel.setBounds(leftAlign, 0, 450, 90);
        this.contentPane.add(instructionslabel);
        this.brdTemplateLabel.setLocation(leftAlign, headerHeight);
        this.brdTemplateLabel.setFont(labelFont);
        this.brdTemplateLabel.setSize(labelWidth, fieldHeight);
        this.contentPane.add(this.brdTemplateLabel);
        this.brdTemplateTextField.setLocation(leftAlign, headerHeight + rowSpace);
        this.brdTemplateTextField.setSize(textFiledWidth, fieldHeight);
        this.brdTemplateTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateProblemsTableDialog.this.selectTemplateFileTextFieldActionPerformed();
            }
        });
        this.contentPane.add(this.brdTemplateTextField);
        this.brdTemplateTextField.setText(this.controller.getProblemModel().getProblemFullName());
        this.brdTemplateBrowseButton.setLocation(leftAlign + this.brdTemplateTextField.getWidth() + broweSpace, headerHeight + rowSpace);
        this.brdTemplateBrowseButton.setSize(buttonWidth, fieldHeight);
        this.contentPane.add(this.brdTemplateBrowseButton);
        this.brdTemplateBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateProblemsTableDialog.this.selectProblemTemplateActionPerformed();
            }
        });
        this.createButton.setLocation(buttonLeft, headerHeight + 2 * rowSpace + 10);
        this.createButton.setSize(buttonWidth, fieldHeight);
        this.contentPane.add(this.createButton);
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateProblemsTableDialog.this.createButtonActionPerformed();
            }
        });
        this.cancelButton.setLocation(leftAlign + this.brdTemplateTextField.getWidth() + broweSpace, headerHeight + 2 * rowSpace + 10);
        this.cancelButton.setSize(buttonWidth, fieldHeight);
        this.contentPane.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateProblemsTableDialog.this.close();
            }
        });
        this.setSize(dialogWidth, dialogHeight);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void createButtonActionPerformed() {
        String DefaultSelectedTextFileName;
        String brdTemplateFilename = this.brdTemplateTextField.getText();
        boolean keepGoing = CreateProblemsTableDialog.promptToSaveBRDSilently(brdTemplateFilename, this.controller, this, "Next please specify the name of your new problems table file.");
        if (!keepGoing) {
            return;
        }
        if (!this.processProblemTemplateData(brdTemplateFilename)) {
            return;
        }
        if (!this.checkVariablesNotEmpty()) {
            return;
        }
        String targetDir = this.controller.getPreferredBRDLocation();
        File f = DialogUtilities.chooseFile(targetDir, DefaultSelectedTextFileName = brdTemplateFilename.replaceAll(".brd", ".txt"), null, "Select Problem Table Filename", "Save", this.controller);
        if (f == null) {
            return;
        }
        this.problemTableFile = f;
        String name = this.problemTableFile.getAbsolutePath();
        if (!name.endsWith(".txt")) {
            name = name + ".txt";
            this.problemTableFile = new File(name);
        }
        trace.out("name = " + this.problemTableFile);
        try {
            this.writeProblemsTableFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            String title = "Error reading file";
            String message = "<html>The system was unable to write to the selected file.<br>Please check to make sure it is not open in another program.";
            JOptionPane.showMessageDialog(this, message, title, 2);
            this.close();
            return;
        }
        this.controller.getPreferencesModel().setStringValue(PROBLEMS_TABLE_LOCATION, this.problemTableFile.getAbsolutePath());
        this.close();
    }

    private void writeProblemsTableFile() throws FileNotFoundException, IOException {
        FileOutputStream fout = new FileOutputStream(this.problemTableFile);
        String tempStr = "Problem Name";
        ((OutputStream)fout).write(tempStr.getBytes());
        for (int i = 0; i < this.variables.size(); ++i) {
            tempStr = (String)this.variables.get(i);
            tempStr = XMLSpecialCharsTransform.transformBackSpecialChars(tempStr);
            tempStr = "\n" + tempStr;
            ((OutputStream)fout).write(tempStr.getBytes());
        }
        ((OutputStream)fout).close();
    }

    public static boolean promptToSaveBRDSilently(String brdTemplateFilename, BR_Controller controller2, Component parent, String userMessage) {
        File testTemplate = new File(brdTemplateFilename);
        File testCurrentBRD = new File(controller2.getProblemModel().getProblemFullName());
        if (!testTemplate.equals(testCurrentBRD)) {
            return true;
        }
        String message = "Save the current BRD file?";
        String title = "Save File";
        int i = JOptionPane.showConfirmDialog(parent, message, title, 2);
        if (i != 0) {
            return false;
        }
        String filename = controller2.saveBRDSilently();
        if (filename == null) {
            return false;
        }
        JOptionPane.showMessageDialog(parent, "<html>The BRD file has been saved.<br><br>" + userMessage);
        return true;
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void selectProblemTemplateActionPerformed() {
        File selectedFile = DialogUtilities.chooseFile(this.controller.getPreferredBRDLocation(), new BrdFilter(), "Select BRD Template File", "Select", this.controller);
        if (selectedFile != null) {
            this.brdTemplateTextField.setText(selectedFile.getPath());
            this.processProblemTemplateData(selectedFile.getPath());
            String folder = selectedFile.getParent();
            this.controller.getPreferencesModel().setStringValue(BRD_TEMPLATE_PATH, selectedFile.getAbsolutePath());
            this.controller.setPreferredBRDLocation(folder);
        }
    }

    private boolean processProblemTemplateData(String templatFilePath) {
        if (templatFilePath == null || templatFilePath.length() == 0) {
            String[] message = new String[]{"You must select the BRD template file."};
            this.displayWarningMsg(message);
            return false;
        }
        if (!templatFilePath.endsWith(".brd")) {
            trace.out(5, this, "You selected file:\n" + templatFilePath);
            String[] message = new String[]{"The BRD template file type should be \".brd\".", "Please reselect your file."};
            this.displayWarningMsg(message);
            return false;
        }
        File templateFile = new File(templatFilePath);
        if (!templateFile.exists()) {
            trace.out(5, this, "You selected file:\n" + templatFilePath);
            String[] message = new String[]{"Your selected BRD template file does not exist.", "Please reselect your file."};
            this.displayWarningMsg(message);
            return false;
        }
        if (templateFile.isDirectory()) {
            trace.out(5, this, "You selected folder:\n" + templatFilePath);
            String[] message = new String[]{"You selected a folder not a file.", "Please reselect your file."};
            this.displayWarningMsg(message);
            return false;
        }
        this.variables.clear();
        this.parsingAllVariables(templatFilePath);
        return this.checkVariablesNotEmpty();
    }

    private boolean checkVariablesNotEmpty() {
        if (this.variables.size() == 0) {
            String[] message = new String[]{"No valid variables were found in your", "selected mass production file.", "Please select a new file."};
            this.displayWarningMsg(message);
            return false;
        }
        return true;
    }

    private void displayWarningMsg(String[] messageText) {
        if (messageText == null) {
            return;
        }
        JOptionPane.showMessageDialog(this, messageText, "Warning", 1);
    }

    private void parsingAllVariables(String filePath) {
        try {
            FileReader fr = new FileReader(filePath);
            BufferedReader br = new BufferedReader(fr);
            String strLine = br.readLine();
            while (strLine != null) {
                this.addToVariables(this.fetchVariabls(strLine));
                strLine = br.readLine();
            }
            br.close();
            fr.close();
            for (int i = 0; i < this.variables.size(); ++i) {
                trace.out(5, this, "variable = " + this.variables.get(i));
            }
        }
        catch (FileNotFoundException fe) {
            trace.out(5, this, "FileNotFoundException: " + fe.toString());
        }
        catch (IOException ie) {
            this.variables = new ArrayList();
            trace.out(5, this, "IOException: " + ie.toString());
        }
    }

    public ArrayList fetchVariabls(String strLine) {
        ArrayList<String> variableList = new ArrayList<String>();
        Pattern varPattern = Pattern.compile("%([^ ]*?)%");
        Matcher varMatcher = varPattern.matcher(strLine);
        while (varMatcher.find()) {
            if (varMatcher.group(0) == null) continue;
            String tempStr = varMatcher.group(0);
            int index = tempStr.lastIndexOf("%(");
            if (index == 0 && (index = tempStr.indexOf(")%")) == tempStr.length() - 2) {
                variableList.add(tempStr);
            }
            strLine = varMatcher.replaceFirst(" ");
            varMatcher = varPattern.matcher(strLine);
        }
        return variableList;
    }

    private void addToVariables(ArrayList variableList) {
        if (variableList == null) {
            return;
        }
        for (int i = 0; i < variableList.size(); ++i) {
            String tempStr = (String)variableList.get(i);
            if (this.isInArrayList(this.variables, tempStr)) continue;
            this.variables.add(tempStr);
        }
    }

    public boolean isInArrayList(ArrayList strList, String str) {
        if (strList == null) {
            return false;
        }
        for (int i = 0; i < strList.size(); ++i) {
            String tempStr = (String)strList.get(i);
            if (!tempStr.equals(str)) continue;
            return true;
        }
        return false;
    }

    private void selectTemplateFileTextFieldActionPerformed() {
        this.processProblemTemplateData(this.brdTemplateTextField.getText().trim());
    }
}

