/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.RuleLabelHandler;
import edu.cmu.pact.BehaviorRecorder.Dialogs.HelpSuccessPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.RuleProduction;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Log.AuthorLogListener;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.view.ViewUtils;
import edu.cmu.pact.miss.AskHintHumanOracle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class EditSkillNameDialog
extends JDialog
implements ActionListener,
ItemListener,
ComponentListener {
    private final RuleLabelHandler handler;
    private String originalRule;
    private JLabel skillNameLabel = new JLabel("Please edit or select the skill name (no spaces):");
    private JLabel skillSetLabel = new JLabel("Please edit or select the skill set name (no spaces):");
    private JPanel contentPanel = new JPanel();
    private JPanel optionPanel = new JPanel();
    private JPanel okCancelPanel = new JPanel();
    private JComboBox skillSetComboBox = new JComboBox();
    private JComboBox skillNamesComboBox = new JComboBox();
    private JLabel skillLabelLabel = new JLabel("Please enter a label for the skillometer:");
    private JTextField skillLabelTextField = new JTextField(16);
    private JLabel skillDescriptionLabel;
    private JTextArea skillDescriptionTextArea;
    private JScrollPane skillDescriptionScrollPane;
    private JCheckBox copyLinkHints;
    private JCheckBox copyRuleHints;
    JButton okJButton;
    JButton cancelJButton;
    private final String serializedBeforeEdit;
    private BR_Controller controller;
    private EdgeData edgeData;

    @Override
    public void componentHidden(ComponentEvent arg) {
    }

    @Override
    public void componentShown(ComponentEvent arg) {
    }

    @Override
    public void componentResized(ComponentEvent arg) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.storeLocation();
    }

    @Override
    public void addWindowListener(WindowListener wl) {
        super.addWindowListener(wl);
    }

    public static void main(String[] args) {
        JFrame jframe = new JFrame();
        jframe.setDefaultCloseOperation(3);
        jframe.setSize(150, 150);
        jframe.setVisible(true);
        if (args.length > 0) {
            List<String> argList = Arrays.asList(args);
            new LabelDialog(jframe, argList);
        } else {
            EditSkillNameDialog editSkillNameDialog = new EditSkillNameDialog(jframe, "write-carry Addition");
        }
    }

    private EditSkillNameDialog(JFrame frame, String originalRuleP) {
        super(frame);
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.skillLabelTextField);
        this.skillDescriptionLabel = new JLabel("Enter a skill description (optional):");
        this.skillDescriptionTextArea = new JTextArea();
        jTextUndoPacket = JUndo.makeTextUndoable(this.skillDescriptionTextArea);
        this.skillDescriptionScrollPane = new JScrollPane(this.skillDescriptionTextArea);
        this.copyLinkHints = new JCheckBox("Copy this link's hints to the Production Rule corresponding to this link.");
        this.copyRuleHints = new JCheckBox("Copy the corresponding Production Rule's hints to this link.");
        this.okJButton = new JButton("    OK    ");
        this.cancelJButton = new JButton("Cancel");
        this.serializedBeforeEdit = "";
        this.controller = null;
        this.edgeData = null;
        this.handler = null;
        this.init(originalRuleP);
    }

    public EditSkillNameDialog(RuleLabelHandler handler, String originalRuleP) {
        super(handler.controller.getActiveWindow());
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.skillLabelTextField);
        this.skillDescriptionLabel = new JLabel("Enter a skill description (optional):");
        this.skillDescriptionTextArea = new JTextArea();
        jTextUndoPacket = JUndo.makeTextUndoable(this.skillDescriptionTextArea);
        this.skillDescriptionScrollPane = new JScrollPane(this.skillDescriptionTextArea);
        this.copyLinkHints = new JCheckBox("Copy this link's hints to the Production Rule corresponding to this link.");
        this.copyRuleHints = new JCheckBox("Copy the corresponding Production Rule's hints to this link.");
        this.okJButton = new JButton("    OK    ");
        this.cancelJButton = new JButton("Cancel");
        this.serializedBeforeEdit = handler.edgeData.getEdge().toXMLString();
        this.controller = handler.controller;
        this.edgeData = handler.edgeData;
        this.handler = handler;
        this.init(originalRuleP);
    }

    private void init(String originalRuleP) {
        String skillName;
        this.addComponentListener(this);
        if (this.handler != null && this.handler.controller.getLoggingSupport() != null) {
            this.addWindowListener(new AuthorLogListener(this.handler.controller.getLoggingSupport()));
        }
        this.originalRule = originalRuleP;
        int firstSpace = this.originalRule.indexOf(" ");
        String skillSetName = "";
        if (firstSpace > 0) {
            skillName = this.originalRule.substring(0, firstSpace);
            skillSetName = this.originalRule.substring(firstSpace + 1);
        } else {
            skillName = this.originalRule;
        }
        RuleProduction.Catalog rpc = null;
        if (this.handler != null) {
            rpc = this.handler.controller.getRuleProductionCatalog();
        } else {
            rpc = new RuleProduction.Catalog();
            rpc.addRuleProduction(new RuleProduction(skillName, skillSetName));
        }
        RuleProduction thisRP = rpc.getRuleProduction(skillName, skillSetName);
        if (thisRP == null) {
            thisRP = new RuleProduction(skillName, skillSetName);
        }
        this.setTitle("Edit skill name \"" + skillName + "\"");
        int rulesSize = rpc.size();
        this.skillSetComboBox = new JComboBox();
        this.skillSetComboBox.setName("skillSetComboBox");
        this.skillNamesComboBox.setName("skillNamesComboBox");
        this.skillLabelTextField.setName("skillLabelTextField");
        this.skillDescriptionTextArea.setName("skillDescriptionTextArea");
        if (this.handler != null && this.handler.controller.getCtatModeModel().isSimStudentMode()) {
            String setName = this.handler.controller.getMissController().getDefaultRuleSetName();
            this.skillSetComboBox.addItem(setName);
        }
        TreeSet<String> skillNameSet = new TreeSet<String>();
        TreeSet<String> skillSetSet = new TreeSet<String>();
        if (rulesSize == 0) {
            skillNameSet.add("No production Rules Defined");
            skillSetSet.add("No production Rule set Defined");
        } else {
            Collection ruleProductions = rpc.values();
            for (RuleProduction rp : ruleProductions) {
                if (rp.isUnnamed()) continue;
                skillNameSet.add(rp.getRuleName());
                if (rp.getProductionSet() == null || rp.getProductionSet().trim().length() <= 0) continue;
                skillSetSet.add(rp.getProductionSet());
            }
        }
        Iterator m = skillNameSet.iterator();
        while (m.hasNext()) {
            this.skillNamesComboBox.addItem(m.next());
        }
        this.skillDescriptionTextArea.setFont(this.skillLabelTextField.getFont());
        this.skillDescriptionTextArea.setLineWrap(true);
        this.skillDescriptionTextArea.setWrapStyleWord(true);
        this.skillDescriptionScrollPane.setVerticalScrollBarPolicy(20);
        this.skillDescriptionScrollPane.setPreferredSize(new Dimension(150, 50));
        m = skillSetSet.iterator();
        while (m.hasNext()) {
            this.skillSetComboBox.addItem(m.next());
        }
        this.contentPanel.setLayout(new BorderLayout());
        ViewUtils.setStandardBorder(this.contentPanel);
        BoxLayout boxLayout = new BoxLayout(this.optionPanel, 1);
        this.optionPanel.setLayout(boxLayout);
        this.skillNamesComboBox.addActionListener(this);
        this.skillNamesComboBox.addItemListener(this);
        this.optionPanel.add(this.skillNameLabel);
        this.optionPanel.add(this.skillNamesComboBox);
        this.skillSetComboBox.addActionListener(this);
        this.skillSetComboBox.addItemListener(this);
        this.optionPanel.add(this.skillSetLabel);
        this.optionPanel.add(this.skillSetComboBox);
        this.skillLabelTextField.setText(thisRP.getLabel());
        this.skillDescriptionTextArea.setText(thisRP.getDescription());
        this.optionPanel.add(this.skillLabelLabel);
        this.optionPanel.add(this.skillLabelTextField);
        this.optionPanel.add(this.skillDescriptionLabel);
        this.optionPanel.add(this.skillDescriptionScrollPane);
        this.optionPanel.add(this.copyLinkHints);
        this.optionPanel.add(this.copyRuleHints);
        this.resetCopyHints(skillName, skillSetName);
        this.contentPanel.add((Component)this.optionPanel, "Center");
        this.okCancelPanel.setLayout(new FlowLayout(1));
        this.okJButton.setSize(this.cancelJButton.getSize());
        this.okCancelPanel.add(this.okJButton);
        this.okCancelPanel.add(this.cancelJButton);
        this.contentPanel.add((Component)this.okCancelPanel, "South");
        this.getContentPane().add(this.contentPanel);
        this.okJButton.addActionListener(this);
        this.cancelJButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okJButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditSkillNameDialog.this.setVisible(false);
                EditSkillNameDialog.this.dispose();
            }
        });
        this.skillNamesComboBox.setEditable(true);
        this.skillSetComboBox.setEditable(true);
        this.skillNamesComboBox.setSelectedItem(skillName);
        if (skillSetName.length() > 0) {
            this.skillSetComboBox.setSelectedItem(skillSetName);
        }
        this.pack();
        Dimension thisSize = this.getSize();
        this.applyPreferences();
        this.setVisible(true);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.skillSetComboBox || e.getSource() == this.skillNamesComboBox) {
            String newRuleName = (String)this.skillNamesComboBox.getSelectedItem();
            String newSetName = (String)this.skillSetComboBox.getSelectedItem();
            this.resetCopyHints(newRuleName, newSetName);
        }
    }

    void resetCopyHints(String newRuleName, String newSetName) {
        this.copyRuleHints.setEnabled(false);
        this.copyLinkHints.setEnabled(false);
        if (newRuleName == null) {
            return;
        }
        if (newRuleName.length() <= 0) {
            return;
        }
        if (newSetName == null) {
            return;
        }
        if (newSetName.length() <= 0) {
            return;
        }
        if (this.handler == null) {
            return;
        }
        RuleProduction tempESE_RuleProduction = this.handler.controller.getRuleProduction(newRuleName, newSetName);
        if (tempESE_RuleProduction != null) {
            if (tempESE_RuleProduction.getHints().size() > 0) {
                this.copyRuleHints.setEnabled(true);
            } else {
                this.copyRuleHints.setEnabled(false);
            }
            if (this.handler.edgeData.getHints().size() > 0) {
                this.copyLinkHints.setEnabled(true);
                if (tempESE_RuleProduction.getHints().size() > 0) {
                    this.copyLinkHints.setSelected(false);
                }
            } else {
                this.copyLinkHints.setSelected(false);
                this.copyLinkHints.setEnabled(false);
            }
        } else if (this.handler.edgeData.getHints().size() > 0) {
            this.copyLinkHints.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.skillSetComboBox || ae.getSource() == this.skillNamesComboBox) {
            String newRuleName = (String)this.skillNamesComboBox.getSelectedItem();
            String newSetName = (String)this.skillSetComboBox.getSelectedItem();
            this.resetCopyHints(newRuleName, newSetName);
        } else if (ae.getSource() == this.okJButton) {
            BR_Controller brController;
            String s;
            String newRuleName = (String)this.skillNamesComboBox.getSelectedItem();
            if (newRuleName.length() <= 0) {
                JOptionPane.showMessageDialog(this, "Skill name may not be empty.", "", 2);
                return;
            }
            if (newRuleName.indexOf(" ") >= 0) {
                JOptionPane.showMessageDialog(this, "Skill names may not have spaces", "", 2);
                return;
            }
            if (newRuleName.equalsIgnoreCase("unnamed")) {
                JOptionPane.showMessageDialog(this, "Skill names can't use unnamed", "", 2);
                return;
            }
            String newProductionSet = (String)this.skillSetComboBox.getSelectedItem();
            if (newProductionSet == null || newProductionSet.length() <= 0) {
                JOptionPane.showMessageDialog(this, "Please provide a skill set name.", "", 2);
                return;
            }
            if (newProductionSet.indexOf(" ") >= 0) {
                JOptionPane.showMessageDialog(this, "Skill set names may not have spaces", "", 2);
                return;
            }
            RuleProduction rp = this.handler.controller.checkAddRuleName(newRuleName, newProductionSet);
            this.handler.ruleLabel.setText(rp.getDisplayName());
            this.handler.edgeData.replaceRuleName(this.originalRule, rp.getDisplayName());
            if (this.handler.controller.getCtatModeModel().isSimStudentMode()) {
                this.handler.controller.getMissController().getSimSt().setProductionSetName(newProductionSet);
            }
            if (rp != null) {
                if (this.copyLinkHints.isSelected()) {
                    rp.setHints(this.handler.edgeData.getAllHints());
                }
                if (this.copyRuleHints.isSelected()) {
                    this.handler.edgeData.setHints(rp.getHints());
                }
            }
            if ((s = this.skillLabelTextField.getText()) != null && s.length() > 0) {
                rp.setLabel(s);
            }
            if ((s = this.skillDescriptionTextArea.getText()) != null && s.length() > 0) {
                rp.setDescription(s);
            }
            if (trace.getDebugCode("skills")) {
                trace.out("skills", "RuleProduction " + rp + ", label " + rp.getLabel() + ", description " + rp.getDescription());
            }
            if ((brController = this.handler.controller).getCtatModeModel().isSimStudentMode()) {
                String oldRuleName;
                int spacePos = this.originalRule.indexOf(32);
                String string = oldRuleName = spacePos > 0 ? this.originalRule.substring(0, spacePos) : this.originalRule;
                if (!oldRuleName.equals(newRuleName)) {
                    if (trace.getDebugCode("miss")) {
                        trace.out("miss", "EditSkillName.actionPerformed: originalRule -> " + oldRuleName);
                    }
                    if (trace.getDebugCode("miss")) {
                        trace.out("miss", "EditSkillName.actionPerformed:  newRuleName -> " + newRuleName);
                    }
                    if (!AskHintHumanOracle.isWaitingForSkillName) {
                        ProblemNode actionState = this.handler.edgeData.getEndProblemNode();
                        brController.getMissController().skillNameSet(newRuleName, actionState);
                    } else {
                        AskHintHumanOracle.hereIsTheSkillName(newRuleName);
                    }
                } else if (trace.getDebugCode("miss")) {
                    trace.out("miss", "EditSkillName: skill name has not been changed. Action ignored");
                }
            }
            this.setVisible(false);
            this.dispose();
            if (this.copyRuleHints.isSelected()) {
                HelpSuccessPanel helpSuccessPanel = new HelpSuccessPanel(this.handler.controller, this.handler.edgeData, true);
                helpSuccessPanel.setVisible(true);
            }
            brController.getJGraphWindow().getJGraph().repaint();
            String serializedAfterEdit = this.edgeData.getEdge().toXMLString();
            if (!this.serializedBeforeEdit.equals(serializedAfterEdit)) {
                if (trace.getDebugCode("undo")) {
                    trace.out("undo", "EditSkillNameDialog.close() XML before:\n" + this.serializedBeforeEdit + "\nXML after:\n" + serializedAfterEdit);
                }
                ActionEvent evt = new ActionEvent(this, 0, "Edit skill name");
                this.controller.getUndoPacket().getCheckpointAction().actionPerformed(evt);
                if (trace.getDebugCode("undo")) {
                    trace.out("undo", "Checkpoint: Editing Skill Names (1)");
                }
            }
            return;
        }
        if (ae.getSource() == this.cancelJButton) {
            this.setVisible(false);
            this.dispose();
            return;
        }
    }

    public void applyPreferences() {
        if (this.handler == null) {
            return;
        }
        PreferencesModel model = this.handler.controller.getPreferencesModel();
        String loc_x = "EditSkillNameDialogLocationX";
        String loc_y = "EditSkillNameDialogLocationY";
        Integer X = model.getIntegerValue(loc_x);
        Integer Y = model.getIntegerValue(loc_y);
        if (X == null) {
            model.setIntegerValue(loc_x, 100);
            X = new Integer(100);
        }
        if (Y == null) {
            model.setIntegerValue(loc_y, 100);
            Y = new Integer(100);
        }
        this.setLocation(X, Y);
        trace.out("wh", "size = " + this.getSize() + " location = " + this.getLocation());
    }

    public void storeLocation() {
        if (this.handler == null) {
            return;
        }
        String loc_x = "EditSkillNameDialogLocationX";
        String loc_y = "EditSkillNameDialogLocationY";
        Point p = this.getLocation();
        this.handler.controller.getPreferencesModel().setIntegerValue(loc_x, p.x);
        this.handler.controller.getPreferencesModel().setIntegerValue(loc_y, p.y);
    }

    private static class LabelDialog
    extends JDialog {
        private JPanel contentPane = (JPanel)this.getContentPane();
        private JPanel optionPanel = new JPanel();
        private JLabel skillLabelLabel = new JLabel("Please enter a label for the skillometer:");
        private JTextField skillLabelTextField = new JTextField(16);
        private JLabel skillNameLabel;
        private JComboBox skillNamesComboBox;
        private JButton okJButton;
        private JButton cancelJButton;
        private JPanel okCancelPanel;

        LabelDialog(JFrame frame, List<String> args) {
            super(frame);
            JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.skillLabelTextField);
            this.skillNameLabel = new JLabel("Please edit or select the skill name:");
            this.skillNamesComboBox = new JComboBox();
            this.okJButton = new JButton("    OK    ");
            this.cancelJButton = new JButton("Cancel");
            this.okCancelPanel = new JPanel();
            this.contentPane.setLayout(new BorderLayout());
            ViewUtils.setStandardBorder(this.contentPane);
            BoxLayout boxLayout = new BoxLayout(this.optionPanel, 1);
            this.optionPanel.setLayout(boxLayout);
            this.optionPanel.add(this.skillLabelLabel);
            if (args.contains("textfield")) {
                this.optionPanel.add(this.skillLabelTextField);
            }
            if (args.contains("combobox")) {
                this.optionPanel.add(this.skillNameLabel);
                this.optionPanel.add(this.skillNamesComboBox);
            }
            if (args.contains("buttons")) {
                this.okCancelPanel.setLayout(new FlowLayout(1));
                this.okJButton.setSize(this.cancelJButton.getSize());
                this.okCancelPanel.add(this.okJButton);
                this.okCancelPanel.add(this.cancelJButton);
                this.contentPane.add((Component)this.okCancelPanel, "South");
                this.getRootPane().setDefaultButton(this.okJButton);
            }
            this.contentPane.add((Component)this.optionPanel, "Center");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    LabelDialog.this.setVisible(false);
                    LabelDialog.this.dispose();
                }
            });
            this.pack();
            this.setVisible(true);
        }
    }
}

