/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.hcii.ctat.CTATFileItem;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.Dialogs.BrdFilter;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilitiesMultiple;
import edu.cmu.pact.BehaviorRecorder.Dialogs.SaveFileDialog;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTabManager;
import edu.cmu.pact.TutoringService.Monitor;
import edu.cmu.pact.TutoringService.RequestHandler;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctatview.CtatMenuBar;
import java.awt.event.ActionEvent;
import java.io.File;
import org.jdom.Element;
import pact.CommWidgets.UniversalToolProxy;

public class LoadFileDialog
extends RequestHandler {
    public static final String RESULT_ATTR = "result";
    public static final String FILE_ATTR = "file";
    public static final String NAME = "loadFileDialog";
    public static final String PROBLEM_FILE_LOCATION = "ProblemFileLocation";
    public static final String PROBLEM_FILE_URL = "ProblemFileURL";
    private BR_Controller controller;
    private CTAT_Launcher server;

    public static CTATFileItem doDialog(BR_Controller controller, boolean loadIntoMainWindow, boolean allowMultiple) {
        return LoadFileDialog.doDialog(controller.getServer(), loadIntoMainWindow, allowMultiple);
    }

    public static CTATFileItem doDialog(CTAT_Launcher server, boolean loadIntoMainWindow, boolean allowMultiple) {
        LoadFileDialog lfd = new LoadFileDialog(server);
        if (allowMultiple) {
            return lfd.doOkButtonOtherLocations();
        }
        return lfd.doOkButtonOtherLocation();
    }

    public LoadFileDialog(CTAT_Launcher server) {
        this(server, server.getTabManager().getFocusedTab().getController());
    }

    public LoadFileDialog(CTAT_Launcher server, BR_Controller controller) {
        this.server = server;
        this.controller = controller;
    }

    private File getBRDOtherLocation() {
        String targetDir = SaveFileDialog.getBrdFileOtherLocation(this.controller);
        return DialogUtilities.chooseFile(targetDir, new BrdFilter(), "Open Behavior Graph", "Open", this.controller);
    }

    private File[] getBRDOtherLocations() {
        String targetDir = SaveFileDialog.getBrdFileOtherLocation(this.controller);
        return DialogUtilitiesMultiple.chooseFile(targetDir, new BrdFilter(), "Open Behavior Graph", "Open", this.controller);
    }

    private CTATFileItem doOkButtonOtherLocation() {
        File fd = this.getBRDOtherLocation();
        if (fd == null) {
            return null;
        }
        String directory = fd.getParent();
        if (directory == null) {
            directory = "";
        } else if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        LoadFileDialog.doLoadBRDFile(this.getServer(), fd.getName(), directory, true);
        this.saveBRDDirectory(directory);
        CTATFileItem anItem = new CTATFileItem();
        anItem.setDirectory(directory);
        anItem.setFileName(fd.getName());
        return anItem;
    }

    private CTATFileItem doOkButtonOtherLocations() {
        File[] fd = this.getBRDOtherLocations();
        if (fd == null) {
            return null;
        }
        if (fd.length == 0) {
            return null;
        }
        String directory = fd[0].getParent();
        if (directory == null) {
            directory = "";
        } else if (!directory.endsWith(File.separator)) {
            directory = directory + File.separator;
        }
        for (int j = 0; j < fd.length; ++j) {
            LoadFileDialog.doLoadBRDFile(this.getServer(), fd[j].getName(), directory, true);
        }
        this.saveBRDDirectory(directory);
        CTATFileItem anItem = new CTATFileItem();
        anItem.setDirectory(directory);
        for (int i = 0; i < fd.length; ++i) {
            anItem.addFileName(fd[i].getName());
        }
        return anItem;
    }

    private void saveBRDDirectory(String directory) {
        String prefDir = this.controller.getPreferencesModel().getStringValue("BRD File other location");
        if (directory != null && !directory.equals(prefDir)) {
            this.controller.getPreferencesModel().setStringValue("BRD File other location", directory);
            this.controller.getPreferencesModel().saveToDisk();
        }
    }

    @Deprecated
    public static boolean doLoadBRDFile(BR_Controller controller, String problemName, String directory, boolean loadIntoMain) {
        return LoadFileDialog.doLoadBRDFile(controller.getServer(), problemName, directory, loadIntoMain);
    }

    public static boolean doLoadBRDFile(CTAT_Launcher server, String problemName, String directory, boolean loadIntoMain) {
        trace.out("loadfile", "(doLoadBRDFile): problemName=" + problemName + " directory=" + directory);
        int tabNumber = 0;
        CTATTabManager tabManager = server.getTabManager();
        tabNumber = tabManager.hasLoadedFile(directory + problemName) ? tabManager.getFocusedTab().getTabNumber() : server.getDockManager().newGraphTab();
        if (tabNumber > 0) {
            BR_Controller controller = tabManager.getTabByNumber(tabNumber).getController();
            if (!controller.getProblemModel().isEmpty() && controller.saveCurrentProblemWithUserPrompt(true) == 2) {
                return false;
            }
            tabManager.setFocusedTab(tabManager.getTabByNumber(tabNumber), true);
            boolean result = LoadFileDialog.doLoadBRDFile(server, controller, problemName, directory, loadIntoMain);
            server.getDockManager().showGraphWindow(tabNumber);
            UniversalToolProxy utp = controller.getUniversalToolProxy();
            if (utp != null) {
                utp.initUnmatchedSelectionsDialog();
            }
            return result;
        }
        return false;
    }

    public static boolean doLoadBRDFile(CTAT_Launcher server, BR_Controller controller, String problemName, String directory, boolean loadIntoMain) {
        ProblemModel newProblemModel = controller.getProblemModel();
        newProblemModel.setProblemName(problemName);
        newProblemModel.setCourseName("");
        newProblemModel.setUnitName("");
        newProblemModel.setSectionName("");
        newProblemModel.setProblemFullName(directory + problemName);
        if (server != null && server.getMissController() != null && server.getMissController().getSimSt() != null && loadIntoMain) {
            server.getMissController().getSimSt().setCurrentBrdPath(newProblemModel.getProblemFullName());
        }
        boolean openedBRD = false;
        try {
            ProblemModel pm = newProblemModel;
            openedBRD = controller.openBRDFileAndSendStartState(pm.getProblemFullName(), null, null);
            ActionEvent ae = new ActionEvent(controller, 0, "Loaded problem " + pm.getProblemFullName());
            controller.getUndoPacket().getInitializeAction().actionPerformed(ae);
            controller.clearUnmatchedComponentsAndReviseConnectionStatus();
            if (!Utils.isRuntime()) {
                File converter = new File(controller.getProblemModel().getProblemFullName());
                controller.getCtatFrameController().getDockedFrame().getCtatMenuBar().addRecentfile(converter.getParent(), converter.getName());
                LoadFileDialog.getInterfaceDescriptionsIfNeeded(controller.getUniversalToolProxy());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = "<html>The file could not be found or the format of the file is not recognized. <br>Please check the file and try again.";
            String title = "Error loading file";
            Utils.showExceptionOccuredDialog(e, message, title);
        }
        server.getLoggingSupport().authorActionLog("BEHAVIOR_RECORDER", "OPEN_GRAPH", newProblemModel.getProblemFullName());
        return openedBRD;
    }

    private static void getInterfaceDescriptionsIfNeeded(UniversalToolProxy utp) {
        if (utp == null || utp.hasInterfaceDescriptions()) {
            return;
        }
        utp.getAllInterfaceDescriptions();
    }

    @Override
    public Element handleRequest(Element req) {
        this.controller = this.server.getFocusedController();
        Element resp = new Element(NAME);
        String path = req.getAttributeValue(FILE_ATTR);
        resp.setAttribute(RESULT_ATTR, "Request received");
        new Load(path).start();
        if (trace.getDebugCode("loadfile")) {
            trace.out("loadfile", "Load(\"" + path + "\") started");
        }
        return resp;
    }

    public static boolean passFileNameToOtherInstance(String testArg, String[] argv) {
        String response;
        block14: {
            boolean hasTestArg = false;
            int fileNameArg = -1;
            testArg = testArg.toLowerCase();
            String problem_file_location = PROBLEM_FILE_LOCATION.toLowerCase();
            String problem_file_url = PROBLEM_FILE_URL.toLowerCase();
            if (argv == null) {
                return false;
            }
            int i = 0;
            for (i = 0; i < argv.length; ++i) {
                String arg = argv[i].toLowerCase();
                if (arg.contains(testArg)) {
                    hasTestArg = true;
                    continue;
                }
                if (arg.contains(problem_file_location)) {
                    fileNameArg = i;
                    continue;
                }
                if (!arg.contains(problem_file_url)) continue;
                fileNameArg = i;
            }
            if (!hasTestArg) {
                return false;
            }
            if (fileNameArg < 0) {
                return false;
            }
            String filename = null;
            int eq = argv[fileNameArg].indexOf(61);
            if (eq >= 0) {
                filename = argv[fileNameArg].substring(eq + 1);
            } else if (++fileNameArg < argv.length) {
                filename = argv[fileNameArg];
            }
            if (filename == null || filename.length() < 1) {
                return false;
            }
            response = null;
            String msg = "<loadFileDialog file=\"" + filename + "\"/>";
            try {
                if (trace.getDebugCode("loadfile")) {
                    trace.out("loadfile", "to send to monitor: " + msg);
                }
                response = Monitor.request(msg);
            }
            catch (Exception e) {
                if (!trace.getDebugCode("loadfile")) break block14;
                trace.errStack("Error sending \"" + msg + "\" to remote:\n  " + e + "; cause " + e.getCause(), e);
            }
        }
        if (trace.getDebugCode("loadfile")) {
            trace.out("loadfile", "response from monitor: " + response);
        }
        return response != null;
    }

    public void handleLoadFileRequest(String path) {
        String dir = "";
        String file = null;
        try {
            File absFile = new File(path);
            if (absFile.getParent() != null) {
                dir = absFile.getParent() + File.separator;
            }
            file = absFile.getName();
            if (!absFile.canRead()) {
                throw new Exception("File not found or not readable");
            }
        }
        catch (Exception e) {
            String errMsg = "Error on request to load " + path + ":\n" + e + (e.getCause() == null ? "" : "; cause " + e.getCause());
            trace.errStack(errMsg, e);
            Utils.showExceptionOccuredDialog(e, errMsg, "Error loading file");
            return;
        }
        try {
            CTATTabManager tabManager = this.server.getTabManager();
            if (tabManager.hasLoadedFile(dir + file)) {
                return;
            }
            boolean loaded = LoadFileDialog.doLoadBRDFile(this.getServer(), file, dir, true);
            if (trace.getDebugCode("loadfile")) {
                trace.out("loadfile", "doLoadBRDFile(ctlr, " + file + ", " + dir + ") loaded " + loaded);
            }
            this.saveBRDDirectory(dir);
            if (loaded) {
                CtatMenuBar mb = this.server.getCtatMenuBar();
                mb.enableCreateStartStateMenus(false);
                mb.enableGotoStartStateMenus(true);
                mb.enablePrintGraphMenus(true);
                mb.enableSaveGraphMenus(true);
            }
        }
        catch (Exception e) {
            String errMsg = "Error on request to load file " + file + " from " + dir + ":\n" + e + (e.getCause() == null ? "" : "; cause " + e.getCause());
            trace.errStack(errMsg, e);
            Utils.showExceptionOccuredDialog(e, errMsg, "Error loading file");
        }
    }

    private CTAT_Launcher getServer() {
        return this.server;
    }

    public class Load
    extends Thread {
        final String path;

        public Load(String path) {
            this.path = path;
        }

        @Override
        public void run() {
            LoadFileDialog.this.handleLoadFileRequest(this.path);
        }
    }
}

