/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.EventLogger;
import edu.cmu.pact.Utilities.TextOutput;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.ProblemSummary;
import edu.cmu.pact.ctat.model.Skill;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class SkillsConsoleDialog
extends JPanel {
    private static final long serialVersionUID = 7118394287684359356L;
    public static final String CLEAR = "CLEAR";
    private static final String CLEAR_WINDOW = "Clear Window";
    private static int MAXSIZE = 32768;
    private BR_Controller controller;
    private CTAT_Launcher server;
    private JTextArea textArea;
    private int caretPosition;
    private StringWriter sw = null;
    private PrintWriter pw = null;
    JFrame ownerFrame = this.controller != null ? this.controller.getDockedFrame() : null;
    private StringBuffer lastTextOutputData = new StringBuffer();

    public static SkillsConsoleDialog create(CTAT_Launcher server) {
        SkillsConsoleDialog scd = new SkillsConsoleDialog(server);
        return scd;
    }

    private SkillsConsoleDialog(CTAT_Launcher server) {
        this.setName("Skills Console");
        this.server = server;
        this.refresh();
    }

    public void refresh() {
        this.controller = this.server.getFocusedController();
        this.textArea = new JTextArea(10, 40);
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.textArea);
        this.textArea.setName("Skills Console Output");
        this.textArea.setOpaque(false);
        this.textArea.setFont(new Font("SansSerif", 0, 12));
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
        this.textArea.setEditable(false);
        JButton bClear = new JButton(CLEAR_WINDOW);
        bClear.setActionCommand(CLEAR_WINDOW);
        bClear.setPreferredSize(new Dimension(60, 25));
        this.setLayout(new BorderLayout());
        this.add("Center", scrollPane);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.setBorder(new EmptyBorder(4, 2, 2, 2));
        p.add("Center", bClear);
        this.add("South", p);
        bClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SkillsConsoleDialog.this.textArea.setText("");
                SkillsConsoleDialog.this.caretPosition = 0;
                EventLogger eventLogger = new EventLogger(SkillsConsoleDialog.this.getController().getLoggingSupport());
                eventLogger.log(true, "SKILLS_CONSOLE", SkillsConsoleDialog.CLEAR, SkillsConsoleDialog.CLEAR_WINDOW, "", "");
            }
        });
        this.addListener();
        this.validate();
        this.setVisible(true);
    }

    private void addListener() {
        if (this.controller != null) {
            this.controller.addSkillsConsole(this);
        }
    }

    private synchronized void addLastTextOutputData(String s) {
        this.lastTextOutputData.append(s);
    }

    public void textValueChanged(TextEvent arg0) {
        trace.out("mps", "event = " + arg0);
        this.update();
    }

    void clearOutputArea() {
        this.textArea.setText("");
        this.caretPosition = 0;
    }

    public void update() {
        int newCaretPosition = this.textArea.getText().length();
        if (newCaretPosition <= this.caretPosition) {
            return;
        }
        trace.out("mps", "old pos = " + this.caretPosition + " new pos = " + newCaretPosition);
        this.textArea.setSelectionStart(this.caretPosition);
        this.textArea.setSelectionEnd(newCaretPosition);
        this.caretPosition = newCaretPosition;
    }

    JTextArea getTextArea() {
        return this.textArea;
    }

    public void outputOccurred(TextOutput.OutputEvent e) {
        this.addLastTextOutputData(e.getOutput());
    }

    public String append(MessageObject assocRulesResp) {
        if (assocRulesResp == null) {
            return null;
        }
        Vector s = (Vector)assocRulesResp.getProperty("Selection");
        Vector a = (Vector)assocRulesResp.getProperty("Action");
        Vector i = (Vector)assocRulesResp.getProperty("Input");
        Vector skillBars = (Vector)assocRulesResp.getProperty("Skills");
        this.sw.getBuffer().setLength(0);
        this.pw.printf("\n%s %s %s\n", s == null ? "[]" : s, a == null ? "[]" : a, i == null ? "[]" : i);
        if (skillBars == null) {
            this.pw.println();
        } else {
            ProblemSummary ps = this.controller == null ? null : this.controller.getProblemSummary();
            String delimiter = ps == null || ps.getSkills() == null ? null : ps.getSkills().getSkillBarDelimiter();
            for (String skillBarStr : skillBars) {
                Skill.SkillBar sb = Skill.parseSkillBarString(skillBarStr, delimiter);
                this.pw.printf("%-15s %-35s %5.2f%%\n", sb.getCategory(), sb.getName(), Float.valueOf(sb.getPKnown() == null ? 0.0f : sb.getPKnown().floatValue() * 100.0f));
            }
        }
        String result = this.sw.toString();
        this.append(result);
        return result;
    }

    protected void append(String s) {
        int len = this.textArea.getText().length() + s.length();
        if (len > MAXSIZE * 2) {
            this.textArea.replaceRange("", 0, MAXSIZE);
        }
        this.textArea.append(s);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    public void dispose() {
        this.removeListener();
    }

    private void removeListener() {
        if (this.controller != null) {
            this.controller.removeSkillsConsole();
        }
    }

    private BR_Controller getController() {
        return this.controller;
    }
}

