/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ExpressionMatcher;

import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.CTATExpressionSemantic;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTree.ExpressionTreeNode;
import edu.cmu.pact.BehaviorRecorder.ExpressionMatcher.ExpressionTreeProperties;
import edu.cmu.pact.Utilities.trace;

public class CTATExpressionParser {
    ExpressionTreeProperties properties = null;
    CTATExpressionSemantic semantic;

    public CTATExpressionParser(ExpressionTreeProperties props) {
        this.properties = props;
        if (this.semantic == null) {
            this.semantic = new CTATExpressionSemantic(this.properties, null);
        }
    }

    public ExpressionTreeNode stringToExpressionTreeNode(String expression) {
        Boolean result;
        Exception parseError = null;
        try {
            result = this.semantic.evaluate(expression);
        }
        catch (Exception e) {
            trace.errStack("Error from semantic.evaluate(" + expression + "): ", e);
            result = false;
            parseError = e;
        }
        if (trace.getDebugCode("expr")) {
            trace.out("expr", "CTATExprParser() stringToExprTN(" + expression + ") parse result " + result + "; parseError " + parseError);
        }
        if (result.booleanValue()) {
            return this.semantic.generateExpressionTree();
        }
        return null;
    }

    public Boolean twoExpressionsEqualBasicSameOrder(String a, String b) {
        return this.simplifyBasicTermsUnsorted(a).equals(this.simplifyBasicTermsUnsorted(b));
    }

    public Boolean twoExpressionsEqualBasic(String a, String b) {
        return this.simplifyBasicTerms(a).equals(this.simplifyBasicTerms(b));
    }

    public Boolean twoExpressionsEqualComplex(String a, String b) {
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "EP.twoExpressionsEqualComplex() before simplifyComplex(): a=" + a + "; b=" + b + ";");
        }
        String a0 = this.simplifyComplexExpr(a);
        String b0 = this.simplifyComplexExpr(b);
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "EP.twoExpressionsEqualComplex() after simplifyComplex(): a0=" + a0 + "; b0=" + b0 + ";");
        }
        String a1 = this.simplifyBasicTerms(a0);
        String b1 = this.simplifyBasicTerms(b0);
        if (trace.getDebugCode("functions")) {
            trace.out("functions", "EP.twoExpressionsEqualComplex() after simplifyBasicTerms(): a1=" + a1 + "; b1=" + b1 + ";");
        }
        return a1.equals(b1);
    }

    public CTATExpressionSemantic getSemantic() {
        return this.semantic;
    }

    public Double evaluate(String expression) {
        ExpressionTreeNode node = this.stringToExpressionTreeNode(expression);
        if (node == null) {
            return Double.NaN;
        }
        Boolean result = node.evaluate();
        if (!result.booleanValue()) {
            return Double.NaN;
        }
        if (trace.getDebugCode("functions")) {
            trace.out("functions", expression + " evals to " + node.getEvalValue());
        }
        return node.getEvalValue();
    }

    public String simplifyBasicTermsUnsorted(String expression) {
        ExpressionTreeNode node = this.stringToExpressionTreeNode(expression);
        if (node == null) {
            return expression;
        }
        String result = node.makeCanonicalWithoutCombining(false);
        if (trace.getDebugCode("functions")) {
            trace.out("functions", expression + " simplifies to " + result);
        }
        return result;
    }

    public String strictBasicTermsUnsorted(String expression) {
        ExpressionTreeNode node = this.stringToExpressionTreeNode(expression);
        if (node == null) {
            return expression;
        }
        String result = node.simplifyWithoutCanonicalWithoutCombining(false);
        if (trace.getDebugCode("functions")) {
            trace.out("functions", expression + " simplifies to " + result);
        }
        return result;
    }

    public String simplifyComplexExpr(String expression) {
        ExpressionTreeNode node = this.stringToExpressionTreeNode(expression);
        if (node == null) {
            return expression;
        }
        String result = node.makeCanonical(true);
        if (trace.getDebugCode("functions")) {
            trace.out("functions", expression + " simplifies to " + result);
        }
        return result;
    }

    public String simplifyBasicTerms(String expression) {
        ExpressionTreeNode node = this.stringToExpressionTreeNode(expression);
        if (node == null) {
            return expression;
        }
        String result = node.makeCanonicalWithoutCombining(true);
        if (trace.getDebugCode("functions")) {
            trace.out("functions", expression + " simplifies to " + result);
        }
        return result;
    }

    public String strictBasicTerms(String expression) {
        ExpressionTreeNode node = this.stringToExpressionTreeNode(expression);
        if (node == null) {
            return expression;
        }
        String result = node.simplifyWithoutCanonicalWithoutCombining(true);
        if (trace.getDebugCode("functions")) {
            trace.out("functions", expression + " simplifies to " + result);
        }
        return result;
    }

    public String simplifyBasic(String expression) {
        ExpressionTreeNode node = this.stringToExpressionTreeNode(expression);
        if (node == null) {
            return expression;
        }
        node.performBasicSimplification(true);
        if (trace.getDebugCode("functions")) {
            trace.out("functions", expression + " simplifies to " + node.getNegatedString());
        }
        return node.getNegatedString();
    }

    public String simplifyComplex(String expression) {
        ExpressionTreeNode node = this.stringToExpressionTreeNode(expression);
        if (node == null) {
            return expression;
        }
        node = node.performComplexSimplification();
        if (trace.getDebugCode("functions")) {
            trace.out("functions", expression + " simplifies to " + node.getNegatedString());
        }
        return node.getNegatedString();
    }
}

